<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $title = trim($_POST['title']);
    $calendar_id = $_POST['calendar_id'];
    $date = $_POST['date'];
    $start_time = $_POST['start_time'];
    $end_time = $_POST['end_time'];

    $start_datetime = $date . ' ' . $start_time;
    $end_datetime = $date . ' ' . $end_time;

    if (!empty($title) && !empty($calendar_id)) {
        $stmt = $pdo->prepare("INSERT INTO tasks (calendar_id, title, start_datetime, end_datetime) VALUES (?, ?, ?, ?)");
        $stmt->execute([$calendar_id, $title, $start_datetime, $end_datetime]);
    }

    // Atgriežamies uz izvēlēto datumu
    $year = date('Y', strtotime($date));
    $month = date('m', strtotime($date));
    $day = date('d', strtotime($date));
    header("Location: calendar.php?view=day&year=$year&month=$month&day=$day");
    exit();
}
?>
