<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$error_message = "";
$success_message = "";

// Pievienot draugu
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['friend_email'])) {
    $friend_email = $_POST['friend_email'];

    // Pārbaudīt, vai lietotājs ar šādu e-pastu eksistē
    $stmt = $pdo->prepare("SELECT id, name FROM users WHERE email = ?");
    $stmt->execute([$friend_email]);
    $friend = $stmt->fetch();

    if ($friend) {
        $friend_id = $friend['id'];

        // Pārbaudīt, vai draugs jau pievienots
        $stmt = $pdo->prepare("SELECT * FROM friends WHERE user_id = ? AND friend_id = ?");
        $stmt->execute([$user_id, $friend_id]);
        if ($stmt->rowCount() > 0) {
            $error_message = "This user is already your friend!";
        } else {
            // Pievienot draudzību
            $stmt = $pdo->prepare("INSERT INTO friends (user_id, friend_id) VALUES (?, ?)");
            $stmt->execute([$user_id, $friend_id]);
            $success_message = "Friend added successfully!";
        }
    } else {
        $error_message = "User with this e-mail is not found.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Friend</title>
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
<nav>
    <ul>
        <li><a href="../dashboard.php">Dashboard</a></li>
        <li><a href="../calendar/calendar.php">Calendar</a></li>
        <li><a href="../tasks/tasks.php">All Tasks</a></li>
        <li><a href="../teams/teams.php">Teams</a></li>
        <li><a href="../friends/add_friend.php">Friends</a></li>
        <li><a href="../profile/profile.php">Profile</a></li>
        <li><a href="../users/logout.php">Logout</a></li>
    </ul>
</nav>

<main>
    <h2>Add Friend</h2>
    
    <form method="post">
        <label for="friend_email">Friend's e-mail:</label>
        <input type="email" name="friend_email" id="friend_email" required>
        <button type="submit">Add</button>
    </form>

    <?php if (!empty($error_message)) : ?>
        <p class="error"><?= htmlspecialchars($error_message) ?></p>
    <?php endif; ?>

    <?php if (!empty($success_message)) : ?>
        <p class="success"><?= htmlspecialchars($success_message) ?></p>
    <?php endif; ?>

    <a href="../dashboard.php" class="back-btn">Go back</a>
</main>

</body>
</html>
