<?php
session_start();
include 'database/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../users/login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

// Iegūt lietotāja kalendārus
$calendars = $pdo->prepare("SELECT * FROM calendars WHERE user_id = ?");
$calendars->execute([$user_id]);

$notes = $pdo->prepare("SELECT * FROM notes WHERE user_id = ?");
$notes->execute([$user_id]);

// Iegūt visus uzdevumus lietotāja kalendāros
$tasks = $pdo->prepare("SELECT t.*, c.name as calendar_name FROM tasks t JOIN calendars c ON t.calendar_id = c.id WHERE c.user_id = ?");
$tasks->execute([$user_id]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Work Planner</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
<nav>
    <ul>
        <li><a href="dashboard.php">Dashboard</a></li>
        <li><a href="calendar/calendar.php">Calendar</a></li>
        <li><a href="tasks/tasks.php">All Tasks</a></li>
        <li><a href="teams/teams.php">Teams</a></li>
        <li><a href="friends/add_friend.php">Friends</a></li>
        <li><a href="profile/profile.php">Profile</a></li>
        <li><a href="users/logout.php">Logout</a></li>
    </ul>
</nav>
<main> 
    <h2>Welcome, <?= isset($_SESSION['name']) ? htmlspecialchars($_SESSION['name']) : 'User' ?>!</h2>

    <h3>Your Notes</h3>
    <ul>
        <?php while ($note = $notes->fetch()) : ?>
            <li style="color: <?= htmlspecialchars($note['color']) ?>">
                <?= htmlspecialchars($note['name']) ?>
                <a href="calendar.php?delete_note=<?= $note['id'] ?>" onclick="return confirm('Vai tiešām dzēst šo piezīmi?');">Delete</a>
            </li>
        <?php endwhile; ?>
    </ul>

    <h3>Your Tasks</h3>
    <ul>
        <?php while ($task = $tasks->fetch()) : ?>
            <?php
                $is_expired = strtotime($task['end_datetime']) < time();
                $task_color = $is_expired ? 'red' : 'black';
            ?>
            <li style="color: <?= $task_color ?>">
                <strong><?= htmlspecialchars($task['title']) ?></strong>
                (<?= $task['start_datetime'] ?> - <?= $task['end_datetime'] ?>)
            </li>
        <?php endwhile; ?>
    </ul>
</main>
</body>
</html>
