<?php
session_start();
include '../database/db.php';

if (!isset($_SESSION['user_id'])) {
header("Location: ../users/login.php");
exit();
}

$user_id = $_SESSION['user_id'];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['name'])) {
    $note_name = trim($_POST['name']);
    $note_color = isset($_POST['color']) ? $_POST['color'] : "#000000"; // Noklusējuma krāsa

    if (!empty($note_name)) {
        $stmt = $pdo->prepare("INSERT INTO notes (user_id, name, color) VALUES (?, ?, ?)");
        $stmt->execute([$user_id, $note_name, $note_color]);
        header("Location: calendar.php");
        exit();
    }
}

if (isset($_GET['delete_note'])) {
    $delete_id = $_GET['delete_note'];
    $stmt = $pdo->prepare("DELETE FROM notes WHERE id = ? AND user_id = ?");
    $stmt->execute([$delete_id, $user_id]);
    header("Location: calendar.php");
    exit();
}

// Iegūt visus kalendārus
$calendars = $pdo->prepare("SELECT * FROM calendars WHERE user_id = ?");
$calendars->execute([$user_id]);

// Iegūt visus uzdevumus lietotāja kalendāros
$tasks = $pdo->prepare("SELECT t.*, c.name as calendar_name, c.color FROM tasks t JOIN calendars c ON t.calendar_id = c.id WHERE c.user_id = ? ORDER BY t.start_datetime ASC");
$tasks->execute([$user_id]);
$task_list = $tasks->fetchAll(PDO::FETCH_ASSOC);

$notes = $pdo->prepare("SELECT * FROM notes WHERE user_id = ?");
$notes->execute([$user_id]);

// Gada skats
$view = isset($_GET['view']) ? $_GET['view'] : 'month'; // Noklusētais skats ir mēnesis
$current_date = new DateTime();
if (isset($_GET['year'])) $current_date->setDate($_GET['year'], $current_date->format('m'), 1);
if (isset($_GET['month'])) $current_date->setDate($current_date->format('Y'), $_GET['month'], 1);
if (isset($_GET['day'])) $current_date->setDate($current_date->format('Y'), $current_date->format('m'), $_GET['day']);

// Gada skata izvēle
if (isset($_GET['year_change'])) {
$current_date->setDate($_GET['year_change'], $current_date->format('m'), 1);
}

// Dzēst kalendāru
if (isset($_GET['delete_id'])) {
$delete_id = $_GET['delete_id'];
$stmt = $pdo->prepare("DELETE FROM calendars WHERE id = ? AND user_id = ?");
$stmt->execute([$delete_id, $user_id]);
header("Location: calendar.php");
exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Calendar</title>
<link rel="stylesheet" href="../css/calendar.css">
<script src="../js/calendar.js"></script>
<nav>
        <ul>
            <li><a href="../dashboard.php">Dashboard</a></li>
            <li><a href="../calendar/calendar.php">Calendar</a></li>
            <li><a href="../tasks/tasks.php">All Tasks</a></li>
            <li><a href="../teams/teams.php">Teams</a></li>
            <li><a href="../friends/add_friend.php">Friends</a></li>
            <li><a href="../profile/profile.php">Profile</a></li>
            <li><a href="../users/logout.php">Logout</a></li>
        </ul>
    </nav>
</head>
<body>
<div class="container">
<aside class="sidebar">
<h2>Notes</h2>
<form method="post">
<input type="text" name="name" placeholder="Notes name" required>
<input type="color" name="color">
<button type="submit">Add</button>
</form>
<ul>
            <?php while ($note = $notes->fetch()) : ?>
                <li style="color: <?= htmlspecialchars($note['color']) ?>">
                    <?= htmlspecialchars($note['name']) ?>
                    <a href="calendar.php?delete_note=<?= $note['id'] ?>" onclick="return confirm('Are you sure you want to delete a note?');">Delete</a>
                </li>
            <?php endwhile; ?>
        </ul>
</aside>
<main class="content">
<header>
<h2>Calendar</h2>
</header>

<!-- Skata izvēles pogas -->
<div class="view-buttons">
<a href="calendar.php?view=year&year=<?= $current_date->format('Y') ?>">Year View</a>
<a href="calendar.php?view=month&year=<?= $current_date->format('Y') ?>&month=<?= $current_date->format('m') ?>">Month View</a>
<a href="calendar.php?view=day&year=<?= $current_date->format('Y') ?>&month=<?= $current_date->format('m') ?>&day=<?= $current_date->format('d') ?>">Day View</a>
</div>

<!-- Gada skats ar bultām -->
<?php if ($view == 'year'): ?>
<div class="year-view">
<form method="get" action="calendar.php">
<input type="hidden" name="view" value="year">
<button type="submit" name="year_change" value="<?= $current_date->format('Y') - 1 ?>">←</button>
<span><?= $current_date->format('Y') ?></span>
<button type="submit" name="year_change" value="<?= $current_date->format('Y') + 1 ?>">→</button>
</form>
<?php for ($month = 1; $month <= 12; $month++): ?>
<?php $current_date->setDate($current_date->format('Y'), $month, 1); ?>
<a href="calendar.php?view=month&year=<?= $current_date->format('Y') ?>&month=<?= $month ?>">
<?= $current_date->format('F') ?>
</a><br>
<?php endfor; ?>
</div>
<?php endif; ?>

<!-- Mēneša skats -->
<?php if ($view == 'month'): ?>
<div class="month-view">
<div class="month-nav">
<form method="get" action="calendar.php">
<input type="hidden" name="view" value="month">
<button type="submit" name="month" value="<?= $current_date->format('m') - 1 ?>">←</button>
<span><?= $current_date->format('F Y') ?></span>
<button type="submit" name="month" value="<?= $current_date->format('m') + 1 ?>">→</button>
</form>
</div>
<?php
// Aprēķinām mēneša sākuma dienu
$days_in_month = $current_date->format('t'); // dienu skaits mēnesī
$start_day = $current_date->format('w'); // mēneša pirmās dienas nedēļas diena (0=svētdiena, 6=sestdiena)
// Pārliekam tā, lai pirmdiena būtu 0
$start_day = ($start_day == 0) ? 6 : $start_day - 1;

// Kalendāra attēlošana
?>
<div class="calendar">
<?php for ($i = 0; $i < $start_day; $i++): ?>
<div class="empty"></div>
<?php endfor; ?>
<?php for ($day = 1; $day <= $days_in_month; $day++): ?>
<?php
$current_date->setDate($current_date->format('Y'), $current_date->format('m'), $day);
// Sestdiena (6) vai svētdiena (0) kļūst par brīvdienām
$is_weekend = $start_day == 5 || $start_day == 6;
?>
<div class="<?= $is_weekend ? 'weekend' : '' ?>">
<a href="calendar.php?view=day&year=<?= $current_date->format('Y') ?>&month=<?= $current_date->format('m') ?>&day=<?= $day ?>">
<?= $day ?>
</a>
</div>
<?php $start_day = ($start_day + 1) % 7; ?>
<?php endfor; ?>
</div>
</div>
<?php endif; ?>

<!-- Dienas skats -->
<?php if ($view == 'day'): ?>
<div class="day-view">
<button onclick="openTaskForm()" style="margin: 10px 0;">Add Task</button>

<!-- Forma jauna uzdevuma pievienošanai -->
<div id="taskForm" style="display: none; border: 1px solid #ccc; padding: 10px; margin-bottom: 20px;">
    <form method="post" action="add_task.php">
        <input type="hidden" name="date" value="<?= $current_date->format('Y-m-d') ?>">
        <label>Title: <input type="text" name="title" required></label><br>
        <label>Start Time: <input type="time" name="start_time" required></label><br>
        <label>End Time: <input type="time" name="end_time" required></label><br>
        <button type="submit">Save Task</button>
        <button type="button" onclick="closeTaskForm()">Cancel</button>
    </form>
</div>
<h3><?= $current_date->format('l, F j, Y') ?></h3>
<?php foreach ($task_list as $task): ?>
<?php if (date('Y-m-d', strtotime($task['start_datetime'])) == $current_date->format('Y-m-d')): ?>
<div style="background-color: <?= htmlspecialchars($task['color']) ?>;">
<strong><?= htmlspecialchars($task['title']) ?></strong><br>
<?= date('H:i', strtotime($task['start_datetime'])) ?> - <?= date('H:i', strtotime($task['end_datetime'])) ?>
</div>
<?php endif; ?>
<?php endforeach; ?>
</div>
<?php endif; ?>
</main>
</div>
</body>
</html>