<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <title>Rediģēt Grāmatu</title> <!-- Lapas nosaukums -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> <!-- Bootstrap -->
</head>
<body class="bg-light"> <!-- Fona krāsa-->
    <div class="container py-5"> <!-- Konteiners -->
        <h1 class="text-center mb-4 text-primary">Rediģēt Grāmatu</h1> <!-- Lapas nosaukums -->

        <!-- Lietotāja pieteikšanās un reģistrēšanās sadaļa -->
        <div class="d-flex justify-content-end mb-4">
            <?php if(auth()->guard()->guest()): ?> <!-- Ja lietotājs nav autentificējies -->
                <div>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-primary me-2">Login</a> <!-- Pieteikšanās poga -->
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-secondary">Register</a> <!-- Reģistrēšanās poga -->
                </div>
            <?php else: ?> <!-- Ja lietotājs ir autentificējies -->
                <div>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?> <!-- CSRF aizsardzība -->
                        <button type="submit" class="btn btn-outline-danger">Logout</button> <!-- Izrakstīšanās poga -->
                    </form>
                </div>
            <?php endif; ?>
        </div>

        <?php if(auth()->guard()->check()): ?> <!-- Tikai autentificētiem lietotājiem -->
            <!-- Grāmatas rediģēšanas forma -->
            <div class="card mb-4 shadow-sm"> <!-- Bootstrap kartīte ar ēnu -->
                <div class="card-body"> <!-- Kartītes saturs -->
                    <h5 class="card-title text-secondary">Rediģēt grāmatu: "<?php echo e($gramata->nosaukums); ?>"</h5> <!-- Grāmatas nosaukums -->
                    <form action="<?php echo e(route('gramatas.update', $gramata->id)); ?>" method="POST" enctype="multipart/form-data"> <!-- Forma ar PUT metodi -->
                        <?php echo csrf_field(); ?> <!-- CSRF aizsardzība -->
                        <?php echo method_field('PUT'); ?> <!-- HTTP metode PUT -->
                        <div class="row mb-3"> <!-- Rinda ar ievades laukiem -->
                            <div class="col"> <!-- Grāmatas nosaukuma ievades lauks -->
                                <input type="text" name="nosaukums" value="<?php echo e(old('nosaukums', $gramata->nosaukums)); ?>" placeholder="Grāmatas nosaukums" required class="form-control">
                            </div>
                            <div class="col"> <!-- Grāmatas autora ievades lauks -->
                                <input type="text" name="autors" value="<?php echo e(old('autors', $gramata->autors)); ?>" placeholder="Autors" required class="form-control">
                            </div>
                            <div class="col"> <!-- Audio faila augšupielāde -->
                                <input type="file" name="audio" accept=".mp3" class="form-control">
                                <?php if($gramata->audio_path): ?> <!-- Pārbauda, vai grāmatai ir audio fails -->
                                    <div class="mt-2">
                                        <audio controls> <!-- Audio atskaņotājs -->
                                            <source src="<?php echo e(asset('storage/' . $gramata->audio_path)); ?>" type="audio/mpeg">
                                            Jūsu pārlūkprogramma neatbalsta audio atskaņotāju. <!-- Rezerves ziņojums -->
                                        </audio>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-auto"> <!-- Saglabāšanas poga -->
                                <button type="submit" class="btn btn-primary">Saglabāt izmaiņas</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- jQuery bibliotēka -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\projekts\resources\views/gramatas/edit.blade.php ENDPATH**/ ?>