<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <title>Grāmatas</title> <!-- Lapas nosaukums -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> <!-- Bootstrap -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"> <!-- CSRF aizsardzības tokens -->
</head>
<body class="bg-light"> <!-- Fona krāsa-->
    <div class="container py-5"> <!-- Konteiners-->
        <h1 class="text-center mb-4 text-primary">Grāmatas</h1> <!-- Galvenais virsraksts lapai -->

        <!-- Lietotāja autentifikācijas sadaļa -->
        <div class="d-flex justify-content-end mb-4">
            <?php if(auth()->guard()->guest()): ?> <!-- Ja lietotājs nav pieslēdzies -->
                <div>
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-primary me-2">Login</a> <!-- Pieslēgšanās poga -->
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-secondary">Register</a> <!-- Reģistrācijas poga -->
                </div>
            <?php else: ?> <!-- Ja lietotājs ir pieslēdzies -->
                <div>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?> <!-- CSRF aizsardzība -->
                        <button type="submit" class="btn btn-outline-danger">Logout</button> <!-- Izrakstīšanās poga -->
                    </form>
                </div>
            <?php endif; ?>
        </div>

        <?php if(auth()->guard()->check()): ?> <!-- Tikai autentificētiem lietotājiem -->
            <!-- "Rādīt tikai iecienītās" izvēles rūtiņa -->
            <div class="mb-4">
                <label class="form-check-label" for="show-favorites">
                    <input type="checkbox" id="favorites-checkbox" class="form-check-input">
                    Show only favorites <!-- Etiķete iecienītajām grāmatām -->
                </label>
            </div>

            <!-- Poga, lai pievienotu jaunu grāmatu -->
            <div class="text-center mb-3">
                <a href="<?php echo e(route('gramatas.create')); ?>" class="btn btn-info">Pievienot jaunu grāmatu</a>
            </div>

            <!-- Forma jaunas grāmatas pievienošanai -->
            <div id="add-book-form" class="card mb-4 shadow-sm" style="display: none;"> <!-- Sākotnēji paslēpta -->
                <div class="card-body">
                    <h5 class="card-title text-secondary">Pievienot jaunu grāmatu</h5>
                    <form action="<?php echo e(route('gramatas.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?> <!-- CSRF aizsardzība -->
                        <div class="row mb-3"> <!-- Rinda ar ievades laukiem -->
                            <div class="col">
                                <input type="text" name="nosaukums" placeholder="Grāmatas nosaukums" required class="form-control">
                            </div>
                            <div class="col">
                                <input type="text" name="autors" placeholder="Autors" required class="form-control">
                            </div>
                            <div class="col">
                                <input type="file" name="audio" accept=".mp3" class="form-control">
                            </div>
                            <div class="col-auto">
                                <button type="submit" class="btn btn-primary">Saglabāt</button> <!-- Saglabāšanas poga -->
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <!-- Grāmatu saraksts -->
        <div class="row" id="book-list">
            <?php $__currentLoopData = $gramatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gramata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <!-- Iterācija caur visām grāmatām -->
                <div class="col-md-4 mb-4 book-item" data-book-id="<?php echo e($gramata->id); ?>" data-favorite="<?php echo e($gramata->is_favorite ? 'true' : 'false'); ?>">
                    <div class="card shadow-sm"> <!-- Bootstrap kartīte ar ēnu -->
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($gramata->nosaukums); ?></h5> <!-- Grāmatas nosaukums -->
                            <p class="card-text"><?php echo e($gramata->autors); ?></p> <!-- Grāmatas autors -->
                            <?php if($gramata->audio_path): ?> <!-- Pārbaude, vai ir audio fails -->
                                <audio controls> <!-- Audio atskaņotājs -->
                                    <source src="<?php echo e(asset('storage/' . $gramata->audio_path)); ?>" type="audio/mpeg">
                                    Jūsu pārlūkprogramma neatbalsta audio atskaņotāju. <!-- Rezerves teksts -->
                                </audio>
                            <?php endif; ?>
                            <?php if(auth()->guard()->check()): ?> <!-- Rediģēšana un dzēšana tikai autentificētiem lietotājiem -->
                                <div class="d-flex justify-content-between mt-3">
                                    <!-- Rediģēšanas poga -->
                                    <a href="<?php echo e(route('gramatas.edit', $gramata)); ?>" class="btn btn-secondary btn-sm">✏️</a>
                                    <!-- Dzēšanas forma ar apstiprinājumu -->
                                    <form action="<?php echo e(route('gramatas.destroy', $gramata)); ?>" method="POST" class="delete-form d-inline">
                                        <?php echo csrf_field(); ?> <!-- CSRF aizsardzība -->
                                        <?php echo method_field('DELETE'); ?> <!-- HTTP DELETE metode -->
                                        <button type="submit" class="btn btn-danger btn-sm delete-button">🗑️</button> <!-- Dzēšanas poga -->
                                    </form>
                                    <!-- Mīļākās grāmatas poga -->
                                    <button class="btn btn-outline-warning btn-sm favorite-button" data-id="<?php echo e($gramata->id); ?>">
                                        <?php echo e($gramata->is_favorite ? '⭐' : '☆'); ?>

                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>

    <!-- jQuery bibliotēka -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- JavaScript lokācija -->
    <script src="<?php echo e(asset('js/gramatas.js')); ?>"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\projekts\resources\views/gramatas/index.blade.php ENDPATH**/ ?>