<?php

use App\Http\Controllers\GramataController;

Route::get('/', [GramataController::class, 'index'])->name('home'); // Home route
Route::get('/gramatas', [GramataController::class, 'index'])->name('gramatas.index');
Route::get('/gramatas/favorites', [GramataController::class, 'showFavorites']); // Izmanto GET metodi priekš showFavorites
Route::post('/gramatas', [GramataController::class, 'store'])->name('gramatas.store');
Route::post('/gramatas/favorite', [GramataController::class, 'toggleFavorite']);
Route::put('/gramatas/{gramata}', [GramataController::class, 'update'])->name('gramatas.update');
Route::delete('/gramatas/{gramata}', [GramataController::class, 'destroy'])->name('gramatas.destroy');
// Route for displaying the edit form
Route::get('/gramatas/{gramata}/edit', [GramataController::class, 'edit'])->name('gramatas.edit');
Route::get('/gramatas/izveidot', [GramataController::class, 'create'])->name('gramatas.create');

Auth::routes();

