<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\GramataApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| API routes for books (Gramata). No authentication required.
|
*/

// Get all books
Route::get('/gramatas', [GramataApiController::class, 'index']);

// Get a single book by ID
Route::get('/gramatas/{id}', [GramataApiController::class, 'show']);

// Create a new book
Route::post('/gramatas', [GramataApiController::class, 'store']);

// Update a book by ID
Route::put('/gramatas/{id}', [GramataApiController::class, 'update']);

// Delete a book by ID
Route::delete('/gramatas/{id}', [GramataApiController::class, 'destroy']);
