<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Responsīvais skats mobilajām ierīcēm -->
    <title>Pievienot Grāmatu</title> <!-- Lapas nosaukums -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> <!-- Bootstrap -->
</head>
<body class="bg-light"> <!-- Fona krāsa-->
    <div class="container py-5"> <!-- Konteiners-->
        <h1 class="text-center mb-4 text-primary">Pievienot Jaunu Grāmatu</h1> <!-- Galvenais virsraksts ar noformējumu -->

        <!-- Jaunas grāmatas pievienošanas forma -->
        <div class="card mb-4 shadow-sm"> <!-- Kartīte ar ēnu un margin -->
            <div class="card-body"> <!-- Kartītes saturs -->
                <h5 class="card-title text-secondary">Pievienot jaunu grāmatu</h5> <!-- Kartītes virsraksts -->
                <form action="{{ route('gramatas.store') }}" method="POST" enctype="multipart/form-data"> <!-- Forma ar POST metodi un failu augšupielādi -->
                    @csrf <!-- CSRF aizsardzības tokens -->
                    <div class="row mb-3"> <!-- Rinda ar input laukiem -->
                        <div class="col"> <!-- Grāmatas nosaukuma lauks -->
                            <input type="text" name="nosaukums" placeholder="Grāmatas nosaukums" required class="form-control">
                        </div>
                        <div class="col"> <!-- Grāmatas autora lauks -->
                            <input type="text" name="autors" placeholder="Autors" required class="form-control">
                        </div>
                        <div class="col"> <!-- Audio faila augšupielādes lauks -->
                            <input type="file" name="audio" accept=".mp3" class="form-control">
                        </div>
                        <div class="col-auto"> <!-- Poga formas iesniegšanai -->
                            <button type="submit" class="btn btn-primary">Saglabāt</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Atpakaļ uz grāmatu sarakstu -->
        <div class="text-center">
            <a href="{{ route('gramatas.index') }}" class="btn btn-secondary">Atpakaļ uz grāmatu sarakstu</a>
        </div>
    </div>
</body>
</html>
