@foreach($gramatas as $gramata) <!-- Iterē caur katru grāmatu -->
    <div class="col-md-4 mb-4 book-item" data-book-id="{{ $gramata->id }}" data-favorite="{{ $gramata->is_favorite ? 'true' : 'false' }}"> <!-- Konteineris katrai grāmatai -->
        <div class="card shadow-sm"> <!-- Bootstrap kartīte ar ēnu -->
            <div class="card-body"> <!-- Kartītes saturs -->
                <h5 class="card-title">{{ $gramata->nosaukums }}</h5> <!-- Grāmatas nosaukums -->
                <p class="card-text">{{ $gramata->autors }}</p> <!-- Grāmatas autors -->
                @if($gramata->audio_path) <!-- Pārbauda, vai grāmatai ir audio fails -->
                    <audio controls> <!-- Audio atskaņotājs -->
                        <source src="{{ asset('storage/' . $gramata->audio_path) }}" type="audio/mpeg">
                        Jūsu pārlūkprogramma neatbalsta audio atskaņotāju. <!-- Kļūdas ziņojums -->
                    </audio>
                @endif
                @auth <!-- Pārbauda, vai lietotājs ir autentificējies -->
                    <div class="d-flex justify-content-between mt-3"> <!-- Pogas izkārtojums -->
                        <button class="btn btn-secondary btn-sm edit-button" data-id="{{ $gramata->id }}">✏️</button> <!-- Rediģēšanas poga -->
                        <form action="{{ route('gramatas.destroy', $gramata) }}" method="POST" class="delete-form d-inline"> <!-- Dzēšanas forma -->
                            @csrf 
                            @method('DELETE') <!-- HTTP metode DELETE -->
                            <button type="submit" class="btn btn-danger btn-sm delete-button">🗑️</button> <!-- Dzēšanas poga -->
                        </form>
                        <button class="btn btn-outline-warning btn-sm favorite-button" data-id="{{ $gramata->id }}"> <!-- Favorītu poga -->
                            {{ $gramata->is_favorite ? '⭐' : '☆' }} <!-- Parāda zvaigzni, ja ir favorīts -->
                        </button>
                    </div>
                @endauth
            </div> 
        </div> 
    </div> 
@endforeach <!-- Beidz ciklu caur grāmatām -->
