<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Book Manager</title>
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body class="bg-gray-100 p-6">
    <div class="container mx-auto">
        <h1 class="text-2xl font-bold mb-4">Grāmatas</h1>

        <!-- Add Book Form -->
        <form action="{{ route('gramatas.store') }}" method="POST" class="mb-6">
            @csrf
            <div class="flex space-x-4">
                <input type="text" name="nosaukums" placeholder="Grāmatas nosaukums" required class="border p-2 w-full">
                <input type="text" name="autors" placeholder="Autors" required class="border p-2 w-full">
                <button type="submit" class="bg-gray-700 text-white p-2">Saglabāt</button>
            </div>
        </form>

        <!-- List of Books -->
        <div class="grid grid-cols-3 gap-4">
            @foreach($gramatas as $gramata)
            <div class="border p-4 bg-white">
                <h2 class="font-bold text-lg">{{ $gramata->nosaukums }}</h2>
                <p class="text-gray-600">{{ $gramata->autors }}</p>
                <div class="flex space-x-2 mt-2">
                    <form action="{{ route('gramatas.destroy', $gramata) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="text-red-500">🗑️</button>
                    </form>
                    <!-- Edit button should show a modal or redirect to an edit page -->
                    <a href="#" class="text-gray-500">✏️</a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</body>
</html>
