// uzstāda CSRF tokenu AJAX pieprasījumiem
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$(document).ready(function () {
    // Jaunas grāmatas formas slēdzis
    $('#toggle-form-button').on('click', function () {
        $('#add-book-form').toggle();
        $(this).text(function(i, text){
            return text === "Pievienot jaunu grāmatu" ? "X" : "Pievienot jaunu grāmatu";
        });
    });

    // Pārbauda grāmatas statusu
    $('.favorite-button').on('click', function () {
        const bookId = $(this).data('id');
        const button = $(this);

        $.post('/gramatas/favorite', { book_id: bookId })
            .done(function (response) {
                if (response.success) {
                    button.text(response.favorite ? '⭐' : '☆');
                }
            })
            .fail(function () {
                alert('Failed to update favorite status.');
            });
    });

    // Favorītu slēdzis
    $('#favorites-checkbox').on('change', function () {
        const showFavorites = $(this).is(':checked');
        const url = '/gramatas/favorites?show_favorites=' + (showFavorites ? 'true' : 'false');

        if (!showFavorites) {
            window.location.href = '/gramatas';
        } else {
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('book-list').innerHTML = data.books;
                })
                .catch(error => console.error('Error:', error));
        }
    });

    // Grāmatas dzēšanas apstiprināšana
    $('.delete-button').on('click', function (e) {
        e.preventDefault();
        const form = $(this).closest('form');
        const bookTitle = form.closest('.book-item').find('.card-title').text();
        
        const confirmation = confirm(`Vai jūs vēlaties izdzēst grāmatu: "${bookTitle}"?`);
        
        if (confirmation) {
            form.submit();
        }
    });
});
