<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * Masīvs ar laukiem kurus var aizpildīt lietotājs
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',       // Lietotāja vārds
        'email',      // Lietotāja e-pasta adrese
        'password',   // Lietotāja parole
    ];

    /**
     * Atribūti, kuri jāslēpj no serializācijas.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',          // Parole
        'remember_token',    // Token lietotāja atcerēšanai
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime', // E-pasta verifikācijas laiks
        'password' => 'hashed',           // Paroles hešošana
    ];

    /**
     * Attiecība: iegūt grāmatas, kuras lietotājs ir pievienojis favorītiem
     *
     * belongsToMany: attiecība starp lietotājiem un grāmatām.
     */
    public function favorites()
    {
        return $this->belongsToMany(Gramata::class, 'user_favorites', 'user_id', 'book_id');
    }
}
