<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gramata extends Model
{
    use HasFactory;

    protected $fillable = [
        'nosaukums', // Grāmatas nosaukums
        'autors',   // Grāmatas autors
        'audio_path', // Pievienot audio ceļa lauku
    ];

    /**
     * Iegūst lietotājus, kuri ir grāmatu pievienojuši favorītiem, izmanto arī belongstomany, izmanto user_favorites tabulu no datu bāzes
     */
    public function favoritedByUsers()
    {
        return $this->belongsToMany(User::class, 'user_favorites', 'book_id', 'user_id');
    }
}

