<?php

namespace App\Http\Controllers;

use App\Models\Main;
use Illuminate\Http\Request;

class MainController extends Controller
{
    public function index()
    {
        $gramatas = Main::all();
        return view('gramatas.index', compact('gramatas'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nosaukums' => 'required',
            'autors' => 'required',
        ]);

        Main::create($request->all());

        return redirect('/');
    }

    public function update(Request $request, Main $gramatas)
    {
        $request->validate([
            'nosaukums' => 'required',
            'autors' => 'required',
        ]);

        $gramatas->update($request->all());

        return redirect('/');
    }

    public function destroy(Main $gramatas)
    {
        $gramatas->delete();
        return redirect('/');
    }
}

