<?php
include 'db_conn.php';
session_start();

$error_message = '';
$email = $_GET['email'] ?? '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $otp = $_POST['otp'];

    $stmt = $conn->prepare("SELECT id FROM users WHERE email_id=? AND otp=? AND otp_expiry > NOW()");
    $stmt->bind_param("ss", $email, $otp);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($user = $result->fetch_assoc()) {
        $_SESSION['email'] = $email;
        $_SESSION['user_id'] = $user['id'];
        header("Location: home.php");
        exit();
    } else {
        $error_message = "Nederīgs kods! Vai kods ir beidzies?";
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Verifikācija</title>
    <link rel="stylesheet" href="style.css" />
    <script src="verify.js" defer></script>
</head>
<body>
<div class="container">
    <h2>Ievadiet piekļuves kodu</h2>

    <?php if ($error_message): ?>
        <div class="error"><?php echo htmlspecialchars($error_message); ?></div>
    <?php endif; ?>

    <form action="verify.php" method="POST">
        <input type="hidden" name="email" id="emailField" value="<?php echo htmlspecialchars($email); ?>">
        <input type="text" name="otp" placeholder="Ievadiet piekļuves kodu šeit" required>
        <button type="submit">Verificēt</button>
    </form>
</div>
</body>
</html>
