<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file'];

    if ($file['error'] !== UPLOAD_ERR_OK) {
        echo "<script>alert('Faila augšupielāde neizdevās.');</script>";
        exit();
    }

    $checksum = hash_file('sha256', $file['tmp_name']);
    $targetDir = 'uploads/';
    $folder = $_POST['folder'];
    $folderPath = $targetDir . $folder . '/';

    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0777, true);
    }

    $originalName = basename($file['name']);
    $filePath = $folderPath . $originalName;

    // pārbauda vai fails ar tādu pašu checksummu neeksistē
    $stmt = $conn->prepare("SELECT id, file_path FROM files WHERE checksum = ?");
    $stmt->bind_param("s", $checksum);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // File with the same checksum exists — do not upload the file again
        $existingFile = $result->fetch_assoc();
        $filePath = $existingFile['file_path'];  // Use the existing file path
        $originalName = basename($filePath);    // Use the original name as stored in the DB

        // Insert a reference to the existing file in the database (not re-uploading the file)
        $stmt = $conn->prepare("INSERT INTO files (user_id, original_name, checksum, file_path, folder) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("issss", $_SESSION['user_id'], $originalName, $checksum, $filePath, $folder);

        if ($stmt->execute()) {
            echo "<script>alert('Fails jau pastāv un ir pievienots tavai mapītei!');</script>";
        } else {
            echo "<script>alert('Kļūda, pievienojot failu datubāzē.');</script>";
        }
    } else {
        // If the file doesn't exist, proceed with uploading it
        if (move_uploaded_file($file['tmp_name'], $filePath)) {
            // Insert the new file into the database
            $stmt = $conn->prepare("INSERT INTO files (user_id, original_name, checksum, file_path, folder) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $_SESSION['user_id'], $originalName, $checksum, $filePath, $folder);

            if ($stmt->execute()) {
                echo "<script>alert('Fails tika veiksmīgi augšupielādēts!');</script>";
            } else {
                echo "<script>alert('Kļūda, augšupielādējot failu datubāzē.');</script>";
            }
        } else {
            echo "<script>alert('Kļūda, pārvietojot failu.');</script>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Upload File</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Upload a File</h2>
    <form method="POST" enctype="multipart/form-data">
        <input type="file" name="file" required><br><br>

        <label for="folder">Select Folder:</label>
        <select name="folder" required>
            <option value="" disabled selected>Select Folder</option>
            <?php
            $stmt = $conn->prepare("SELECT name FROM folders WHERE user_id = ?");
            $stmt->bind_param("i", $_SESSION['user_id']);
            $stmt->execute();
            $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) {
                echo "<option value=\"" . htmlspecialchars($row['name']) . "\">" . htmlspecialchars($row['name']) . "</option>";
            }
            ?>
        </select><br><br>

        <button type="submit">Upload File</button>
    </form>
    <a href="home.php">Back to Home</a>
</div>
</body>
</html>
