<?php
session_start();

include 'db_conn.php';

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

// Fetch the correct user_id from the verified_users table using the email
$email = $_SESSION['email'];
$userId = null;

$stmt = $conn->prepare("SELECT id FROM verified_users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $userId = $row['id']; // Now we get the correct user ID from verified_users
} else {
    echo "Error: User not found in verified_users.";
    exit;
}

$userName = $_SESSION['email']; // You can pull full name if you'd like
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Files Shared With Me</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .container {
            max-width: 900px;
            margin: auto;
            padding: 20px;
        }
        .file-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
            margin-top: 20px;
        }
        .file-item {
            border: 1px solid #ddd;
            padding: 12px;
            width: 200px;
            text-align: center;
            background: #f9f9f9;
            border-radius: 8px;
        }
        .file-icon {
            font-size: 2rem;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>📂 Files Shared With You</h2>

    <div class="file-grid">
        <?php
        // Now using the correct userId (from verified_users table)
        $stmt = $conn->prepare("
            SELECT f.original_name, f.checksum, sf.permission
            FROM shared_files sf
            JOIN files f ON sf.file_id = f.id
            WHERE sf.receiver_id = ?
        ");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $shared = $stmt->get_result();

        if ($shared->num_rows === 0) {
            echo "<p>No files shared with you yet.</p>";
        }

        while ($row = $shared->fetch_assoc()): ?>
            <div class="file-item">
                <div class="file-icon">📄</div>
                <div><strong><?= htmlspecialchars($row['original_name']) ?></strong></div>
                <div>Permission: <em><?= $row['permission'] ?></em></div>
                <a href="download.php?hash=<?= $row['checksum'] ?>">Download</a>
                <?php if ($row['permission'] === 'edit'): ?>
                    | <a href="edit_file.php?hash=<?= $row['checksum'] ?>">Edit</a>
                <?php endif; ?>
            </div>
        <?php endwhile; ?>
    </div>

    <a href="home.php" class="button" style="margin-top: 30px; display: inline-block;">⬅ Back to Home</a>
</div>
</body>
</html>
