<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['email']) || !isset($_POST['file_id'], $_POST['receiver_email'], $_POST['permission'])) {
    header("Location: home.php");
    exit();
}

$senderId = $_SESSION['user_id'];
$fileId = $_POST['file_id'];
$receiverEmail = $_POST['receiver_email'];
$permission = $_POST['permission'];

// meklē saņēmēja user_id
$stmt = $conn->prepare("SELECT id FROM verified_users WHERE email = ?");
$stmt->bind_param("s", $receiverEmail);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $receiverId = $row['id'];

    // nevar sūtīt sev failu
    if ($receiverId === $senderId) {
        header("Location: home.php?msg=❌ You cannot share files with yourself.");
        exit();
    }

    // pārbauda vai nav dalījies ar failu
    $checkStmt = $conn->prepare("SELECT id FROM shared_files WHERE file_id = ? AND receiver_id = ?");
    $checkStmt->bind_param("ii", $fileId, $receiverId);
    $checkStmt->execute();
    $existing = $checkStmt->get_result();

    if ($existing->num_rows > 0) {
        header("Location: home.php?msg=⚠️ File already shared with this user.");
        exit();
    }

    // pievieno datus shared_files tabulā
    $shareStmt = $conn->prepare("INSERT INTO shared_files (file_id, sender_id, receiver_id, permission) VALUES (?, ?, ?, ?)");
    $shareStmt->bind_param("iiis", $fileId, $senderId, $receiverId, $permission);

    if ($shareStmt->execute()) {
        header("Location: home.php?msg=✅ File shared successfully!");
    } else {
        header("Location: home.php?msg=❌ Error sharing file: " . $conn->error);
    }

    $shareStmt->close();
} else {
    header("Location: home.php?msg=❌ Receiver not found.");
}
?>
