<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['email'], $_POST['hash'], $_POST['content'])) {
    die("❌ Unauthorized request.");
}

$email = $_SESSION['email'];
$hash = $_POST['hash'];
$newContent = $_POST['content'];

// Fetch user ID
$stmt = $conn->prepare("SELECT id FROM verified_users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$userResult = $stmt->get_result();

if (!$userRow = $userResult->fetch_assoc()) {
    die("❌ User not found.");
}
$userId = $userRow['id'];

// Check permission
$stmt = $conn->prepare("
    SELECT f.original_name, sf.permission
    FROM shared_files sf
    JOIN files f ON sf.file_id = f.id
    WHERE sf.receiver_id = ? AND f.checksum = ?
");
$stmt->bind_param("is", $userId, $hash);
$stmt->execute();
$fileResult = $stmt->get_result();

if (!$fileRow = $fileResult->fetch_assoc()) {
    die("❌ File not found or not shared with you.");
}

if ($fileRow['permission'] !== 'edit') {
    die("❌ You do not have permission to save changes to this file.");
}

$filePath = 'uploads/' . $fileRow['original_name'];

// Save the file
if (file_put_contents($filePath, $newContent) !== false) {
    echo "✅ File saved successfully. <a href='shared_with_me.php'>Back</a>";
} else {
    echo "❌ Failed to save file.";
}
