<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userId = $_SESSION['user_id'];

// Handle replacement
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_file']) && isset($_FILES['replacement'])) {
    $selectedFileId = (int)$_POST['selected_file'];
    $replacement = $_FILES['replacement'];

    if ($replacement['error'] !== UPLOAD_ERR_OK) {
        echo "<script>alert('File upload failed.');</script>";
    } else {
        $checksum = hash_file('sha256', $replacement['tmp_name']);

        // Get file info
        $stmt = $conn->prepare("SELECT file_path, original_name, folder FROM files WHERE id = ? AND user_id = ?");
        $stmt->bind_param("ii", $selectedFileId, $userId);
        $stmt->execute();
        $fileData = $stmt->get_result()->fetch_assoc();

        if (!$fileData) {
            echo "<script>alert('Original file not found.');</script>";
        } else {
            $originalPath = $fileData['file_path'];
            $originalName = $fileData['original_name'];
            $folder = $fileData['folder'];
            $folderPath = 'uploads/' . $folder . '/';

            // Check how many references there are to the same file
            $stmt = $conn->prepare("SELECT COUNT(*) as refCount FROM files WHERE file_path = ?");
            $stmt->bind_param("s", $originalPath);
            $stmt->execute();
            $refCount = $stmt->get_result()->fetch_assoc()['refCount'];

            if ($refCount > 1) {
                // Save as new version
                $info = pathinfo($originalName);
                $newName = $info['filename'] . '_replaced_' . time() . '.' . $info['extension'];
                $newPath = $folderPath . $newName;
                move_uploaded_file($replacement['tmp_name'], $newPath);

                $stmt = $conn->prepare("INSERT INTO files (user_id, original_name, checksum, file_path, folder) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("issss", $userId, $newName, $checksum, $newPath, $folder);
                $stmt->execute();

                echo "<script>alert('File replaced with new version.');</script>";
            } else {
                // Overwrite
                unlink($originalPath);
                move_uploaded_file($replacement['tmp_name'], $originalPath);

                $stmt = $conn->prepare("UPDATE files SET checksum = ?, uploaded_at = NOW() WHERE id = ?");
                $stmt->bind_param("si", $checksum, $selectedFileId);
                $stmt->execute();

                echo "<script>alert('File successfully overwritten.');</script>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Replace File</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <h2>Replace a File</h2>
    <form method="POST" enctype="multipart/form-data">
        <label for="selected_file">Select File to Replace:</label>
        <select name="selected_file" required>
            <option value="" disabled selected>Choose a file</option>
            <?php
            $stmt = $conn->prepare("SELECT id, original_name, folder FROM files WHERE user_id = ?");
            $stmt->bind_param("i", $userId);
            $stmt->execute();
            $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) {
                $label = htmlspecialchars($row['folder']) . '/' . htmlspecialchars($row['original_name']);
                echo "<option value=\"{$row['id']}\">$label</option>";
            }
            ?>
        </select><br><br>

        <label for="replacement">Upload Replacement File:</label>
        <input type="file" name="replacement" required><br><br>

        <button type="submit">Replace File</button>
    </form>

    <br><a href="home.php">Back to Home</a>
</div>
</body>
</html>
