<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Unauthorized");
}

$userId = $_SESSION['user_id'];
$oldName = trim($_POST['oldName'] ?? '');
$newName = trim($_POST['newName'] ?? '');

if ($oldName === '' || $newName === '' || $oldName === $newName) {
    http_response_code(400);
    exit("Invalid folder name");
}

// pārbauda duplikātus
$check = $conn->prepare("SELECT 1 FROM folders WHERE user_id = ? AND name = ?");
$check->bind_param("is", $userId, $newName);
$check->execute();
$check->store_result();
if ($check->num_rows > 0) {
    http_response_code(409);
    exit("Folder name already exists");
}

// pievieno tabulā folders datus
$stmt = $conn->prepare("UPDATE folders SET name = ? WHERE user_id = ? AND name = ?");
$stmt->bind_param("sis", $newName, $userId, $oldName);
$stmt->execute();

// pievieno datus files tabulā
$stmt = $conn->prepare("UPDATE files SET folder = ? WHERE user_id = ? AND folder = ?");
$stmt->bind_param("sis", $newName, $userId, $oldName);
$stmt->execute();

// nosaukuma maiņa
$oldPath = "uploads/$oldName";
$newPath = "uploads/$newName";
if (is_dir($oldPath)) {
    rename($oldPath, $newPath);
}

echo "success";
