<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userId = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_folder'])) {
    $folderName = trim($_POST['new_folder']);
    if ($folderName !== '') {
        $stmt = $conn->prepare("INSERT IGNORE INTO folders (user_id, name) VALUES (?, ?)");
        $stmt->bind_param("is", $userId, $folderName);
        $stmt->execute();
        mkdir('uploads/' . $folderName, 0777, true);
    }
}

if (isset($_GET['delete']) && $_GET['delete'] !== '') {
    $folderName = $_GET['delete'];

    $stmt = $conn->prepare("SELECT file_path FROM files WHERE user_id = ? AND folder = ?");
    $stmt->bind_param("is", $userId, $folderName);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        if (file_exists($row['file_path'])) {
            unlink($row['file_path']);
        }
    }

    $stmt = $conn->prepare("DELETE FROM files WHERE user_id = ? AND folder = ?");
    $stmt->bind_param("is", $userId, $folderName);
    $stmt->execute();

    $stmt = $conn->prepare("DELETE FROM folders WHERE user_id = ? AND name = ?");
    $stmt->bind_param("is", $userId, $folderName);
    $stmt->execute();

    $folderPath = 'uploads/' . $folderName;
    if (is_dir($folderPath)) {
        rmdir($folderPath);
    }

    header("Location: manage_folders.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Manage Folders</title>
    <link rel="stylesheet" href="style.css" />
</head>
<body>
<div class="container">
    <h2>Manage Folders</h2>

    <form method="POST">
        <input type="text" name="new_folder" placeholder="New folder name" required />
        <button type="submit">Create Folder</button>
    </form>

    <h3>Your Folders</h3>
    <div class="folder-grid">
        <?php
        $stmt = $conn->prepare("SELECT name FROM folders WHERE user_id = ?");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $folder = htmlspecialchars($row['name']);
            echo "
            <div class='folder-item' data-folder=\"$folder\">
                <div class='folder-icon'>📁</div>
                <div class='folder-name' contenteditable='true' onblur='renameFolder(this)' onkeydown='checkEnter(event, this)'>$folder</div>
                <a class='delete-folder' href='?delete=" . urlencode($folder) . "' onclick=\"return confirm('Delete this folder and all files inside?')\">✖</a>
            </div>";
        }
        ?>
    </div>

    <a href="home.php" class="button">Back to Home</a>
</div>

<script src="manage_folders.js"></script>
</body>
</html>
