function renameFolder(div) {
    const folderItem = div.closest('.folder-item');
    const oldName = folderItem.dataset.folder;
    const newName = div.innerText.trim();

    if (!newName || oldName === newName) {
        div.innerText = oldName; // Reset
        return;
    }

    fetch('rename_folder.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `oldName=${encodeURIComponent(oldName)}&newName=${encodeURIComponent(newName)}`
    })
    .then(res => {
        if (!res.ok) throw new Error('Failed to rename');
        folderItem.dataset.folder = newName;
    })
    .catch(() => {
        alert('Rename failed. Folder might already exist.');
        div.innerText = oldName;
    });
}

function checkEnter(e, div) {
    if (e.key === 'Enter') {
        e.preventDefault();
        div.blur(); // Trigger rename
    }
}
