<?php
include 'db_conn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];

    // Check email validity using stored function
    $stmt = $conn->prepare("SELECT check_email(?) AS email_valid");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $verified_id = $row['email_valid'];

    if ($verified_id) {
        // Check if user already exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE email_id = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        // Insert new user if not found
        if ($result->num_rows == 0) {
            $stmt = $conn->prepare("INSERT INTO users (email_id) VALUES (?)");
            $stmt->bind_param("s", $email);
            $stmt->execute();
        }

        // Redirect to OTP sending page
        header("Location: send_otp.php?email=" . urlencode($email));
        exit();
    } else {
        // Redirect back with error
        header("Location: login.html?error=1");
        exit();
    }
}

$conn->close();
?>
