<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

$email = $_SESSION['email'];
$userName = '';
$userRole = '';
$isAdmin = false;
$addUserMsg = '';

// Get user's name and role from verified_users
$stmt = $conn->prepare("
    SELECT vu.sname, r.name 
    FROM verified_users vu
    JOIN roles r ON vu.Role_id = r.id
    WHERE vu.email = ?
");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $userName = $row['sname'];
    $userRole = $row['name'];
    $isAdmin = ($userRole === 'admin');
}

$verifiedUserId = null;
$stmt = $conn->prepare("SELECT id FROM verified_users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $verifiedUserId = $row['id'];
} else {
    // Handle the case if the user is not in verified_users table
    echo "User not found in verified_users.";
    exit;
}

$userId = $_SESSION['user_id'] ?? null;
$folders = [];
$selectedFolder = $_GET['folder'] ?? null;
$filesInSelectedFolder = [];

if ($userId) {
    $stmt = $conn->prepare("SELECT id, original_name, checksum, folder FROM files WHERE user_id = ?");
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($file = $result->fetch_assoc()) {
        $folderName = $file['folder'] ?: 'Root';
        $folders[$folderName][] = $file;
    }

    if ($selectedFolder && isset($folders[$selectedFolder])) {
        $filesInSelectedFolder = $folders[$selectedFolder];
    }
}

// Add verified user logic (admin)
$roles = [];
if ($isAdmin) {
    $rolesResult = $conn->query("SELECT id, name FROM roles");
    while ($row = $rolesResult->fetch_assoc()) {
        $roles[] = $row;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'], $_POST['sname'], $_POST['role_id'])) {
        $userEmail = $_POST['email'];
        $fullName = $_POST['sname'];
        $roleId = $_POST['role_id'];
        $roleName = '';
        foreach ($roles as $role) {
            if ($role['id'] == $roleId) {
                $roleName = $role['name'];
                break;
            }
        }

        $stmt = $conn->prepare("CALL add_verified_email(?, ?, ?)");
        $stmt->bind_param("sss", $userEmail, $fullName, $roleName);

        if ($stmt->execute()) {
            $addUserMsg = "✅ User successfully added!";
        } else {
            $addUserMsg = "⚠️ Error adding user: " . $conn->error;
        }
        $stmt->close();

        while ($conn->more_results() && $conn->next_result()) {
            $conn->use_result();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Home</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .container {
            max-width: 900px;
            margin: auto;
            padding: 20px;
        }
        .folder-grid, .file-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
            margin-top: 20px;
        }
        .folder-item, .file-item {
            border: 1px solid #ddd;
            padding: 12px;
            width: 180px;
            text-align: center;
            background: #f9f9f9;
            border-radius: 8px;
        }
        .file-icon, .folder-icon {
            font-size: 2rem;
        }
        .admin-form {
            max-width: 500px;
        }
        .admin-form label {
            display: block;
            margin-top: 16px;
            margin-bottom: 4px;
            font-weight: bold;
        }
        .admin-form input,
        .admin-form select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            font-size: 1rem;
        }
        .admin-form button {
            margin-top: 20px;
            padding: 10px 20px;
            font-size: 1rem;
        }
        .msg {
            margin-top: 15px;
            font-weight: bold;
            color: green;
        }
        #admin-panel {
            display: none;
            margin-top: 30px;
            padding: 20px;
            border: 1px solid #ccc;
            background-color: #fff;
        }
        .button {
            display: inline-block;
            margin: 10px 10px 0 0;
            padding: 10px 16px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Welcome, <?= htmlspecialchars($userName) ?>!</h2>
    <p>Role: <strong><?= htmlspecialchars($userRole) ?></strong></p>
    <p>You have successfully logged in.</p>

    <h3>Your Folders</h3>
    <div class="folder-grid">
        <?php foreach (array_keys($folders) as $folder): ?>
            <div class="folder-item">
                <a href="?folder=<?= urlencode($folder) ?>">
                    <div class="folder-icon">📁</div>
                    <div class="folder-name"><?= htmlspecialchars($folder) ?></div>
                </a>
            </div>
        <?php endforeach; ?>
    </div>

    <?php if ($selectedFolder): ?>
        <h3 style="margin-top: 40px;">Files in "<?= htmlspecialchars($selectedFolder) ?>"</h3>
        <div class="file-grid">
            <?php foreach ($filesInSelectedFolder as $file): ?>
                <div class="file-item">
                    <div class="file-icon">📄</div>
                    <div class="file-name"><?= htmlspecialchars($file['original_name']) ?></div>
                    <div class="file-actions">
                        <a href="download.php?hash=<?= $file['checksum'] ?>">Download</a> |
                        <a href="delete_file.php?hash=<?= $file['checksum'] ?>" onclick="return confirm('Delete this file?')">Delete</a>
                    </div>

                    <!-- Share File Form -->
                    <form action="share_file.php" method="POST" style="margin-top: 10px;">
                        <input type="hidden" name="file_id" value="<?= $file['id'] ?>">
                        <input type="email" name="receiver_email" placeholder="Receiver's email" required>
                        <select name="permission" required>
                            <option value="view">View</option>
                            <option value="edit">Edit</option>
                        </select>
                        <button type="submit">Share</button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <a href="upload.php" class="button">Upload New File</a>
    <a href="manage_folders.php" class="button">Manage Folders</a>
    <a href="logout.php" class="button">Logout</a>
    <a href="shared_with_me.php" class="button">📨 Files Shared With Me</a>
<a href="replace_file.php" class="button">♻️ Replace a File</a>


    <?php if ($isAdmin): ?>
        <button onclick="toggleAdminPanel()" class="button" style="background-color: #007bff;">🔐 Control Panel</button>

        <div id="admin-panel">
            <h3>👤 Add User</h3>
            <?php if ($addUserMsg): ?>
                <div class="msg"><?= $addUserMsg ?></div>
            <?php endif; ?>
            <form action="home.php" method="POST" class="admin-form">
                <label for="email">Email:</label>
                <input type="email" name="email" required>

                <label for="sname">Full Name:</label>
                <input type="text" name="sname" required>

                <label for="role_id">Role:</label>
                <select name="role_id" required>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['id'] ?>"><?= htmlspecialchars($role['name']) ?></option>
                    <?php endforeach; ?>
                </select>

                <button type="submit">Add User</button>
            </form>
        </div>
    <?php endif; ?>
</div>

<script>
function toggleAdminPanel() {
    const panel = document.getElementById("admin-panel");
    panel.style.display = (panel.style.display === "none" || panel.style.display === "") ? "block" : "none";
}
</script>
</body>
</html>
