<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit;
}

if (empty($_GET['hash'])) {
    die("❌ No file specified.");
}

$email = $_SESSION['email'];
$hash = $_GET['hash'];

// Get user ID
$query = $conn->prepare("SELECT id FROM verified_users WHERE email = ?");
$query->bind_param("s", $email);
$query->execute();
$user = $query->get_result()->fetch_assoc();

if (!$user) {
    die("❌ User not found.");
}

// Check if user can edit this file
$query = $conn->prepare("
    SELECT f.original_name 
    FROM files f 
    JOIN shared_files sf ON f.id = sf.file_id
    WHERE sf.receiver_id = ? AND f.checksum = ? AND sf.permission = 'edit'
");
$query->bind_param("is", $user['id'], $hash);
$query->execute();
$file = $query->get_result()->fetch_assoc();

if (!$file) {
    die("❌ File not found or you don't have permission.");
}

$path = __DIR__ . "/uploads/mape/" . $file['original_name'];

if (!file_exists($path)) {
    die("❌ File missing on server.");
}

// Save changes if form submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['file_content'])) {
    if (file_put_contents($path, $_POST['file_content']) !== false) {
        $msg = "✅ File saved.";
    } else {
        $msg = "❌ Could not save file.";
    }
}

// Show file content
$content = file_get_contents($path);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Edit <?= htmlspecialchars($file['original_name']) ?></title>
<style>
  body { font-family: Arial, sans-serif; max-width: 900px; margin: 20px auto; padding: 0 20px; }
  textarea { width: 100%; height: 400px; font-family: monospace; font-size: 14px; margin-top: 10px; padding: 10px; }
  button { margin-top: 10px; padding: 10px 18px; font-size: 16px; }
  .message { margin-top: 12px; font-weight: bold; }
  a.back-link { display: inline-block; margin-top: 20px; color: #444; text-decoration: none; }
</style>
</head>
<body>

<h2>Editing: <?= htmlspecialchars($file['original_name']) ?></h2>

<?php if (!empty($msg)): ?>
  <div class="message"><?= $msg ?></div>
<?php endif; ?>

<form method="POST">
  <textarea name="file_content"><?= htmlspecialchars($content) ?></textarea><br />
  <button>Save</button>
</form>

<a href="shared_with_me.php" class="back-link">⬅ Back to shared files</a>

</body>
</html>
