<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id'])) {
    die("Unauthorized access.");
}

if (isset($_GET['hash'])) {
    $checksum = $_GET['hash'];

    // Prepare and execute the query
    $stmt = $conn->prepare("SELECT file_path, original_name FROM files WHERE checksum = ?");
    $stmt->bind_param("s", $checksum);
    $stmt->execute();
    $stmt->bind_result($file_path, $original_name);
    $stmt->fetch();
    $stmt->close();

    if ($file_path && file_exists($file_path)) {
        // Set headers for file download
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"" . basename($original_name) . "\"");
        header("Content-Length: " . filesize($file_path));
        ob_clean();
        flush();
        readfile($file_path);
        exit;
    } else {
        echo "Error: File not found or checksum is invalid.";
    }
} else {
    echo "Error: No file specified.";
}
?>
<a href="home.php">Go back</a>
