<?php
session_start();
include 'db_conn.php';

if (!isset($_SESSION['user_id']) || !isset($_GET['hash'])) {
    header("Location: login.php");
    exit();
}

$hash = $_GET['hash'];
$userId = $_SESSION['user_id'];

$stmt = $conn->prepare("SELECT file_path FROM files WHERE checksum = ? AND user_id = ?");
$stmt->bind_param("si", $hash, $userId);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    if (file_exists($row['file_path'])) {
        unlink($row['file_path']);
    }
}

$stmt = $conn->prepare("DELETE FROM files WHERE checksum = ? AND user_id = ?");
$stmt->bind_param("si", $hash, $userId);
$stmt->execute();

header("Location: home.php");
exit();
