<!-- Author Raivis Rampāns
Created 01.04.2025
Editor Raivis
Modified 07.06.2025 -->

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Web NotePad</title>
    <link rel="shortcut icon" href="../images/favicon.ico" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<header>
    <?php include 'header.php'; ?>
</header>

<body>
    <div class="container mt-5">
        <?php
        include 'conn.php';

        // Pārbaudām, vai lietotājs ir pieteicies
        if (!isset($_SESSION['user_id'])) {
            header("Location: login.php");
            exit;
        }

        $fileId = isset($_GET['id']) ? intval($_GET['id']) : 0;

        if ($fileId === 0) {
            echo "<div class='alert alert-danger'>Invalid file ID.</div>";
            exit;
        }

        $sql = "SELECT name, text FROM files WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $fileId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();

            // Drošībai: nosaukumu sanitizējam, saturu attēlojam kā HTML
            $fileName = htmlspecialchars($row['name']);
            $fileText = $row['text']; // no htmlspecialchars – ļaujam interpretēt HTML tagus

            echo "<h2 class='mb-4'>File: $fileName</h2>";
            echo "<div class='border p-3' style='min-height: 300px;'>$fileText</div>";
        } else {
            echo "<div class='alert alert-warning'>File not found.</div>";
        }

        $stmt->close();
        $conn->close();
        ?>
    </div>

    <footer>
        <?php include 'footer.php'; ?>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>