<!-- Author  Raivis Rampāns
Created 12.03.2025
Editor Raivis
Modified 07.06.2025 -->

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Web Notepad</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="shortcut icon" href="../images/favicon.ico" type="image/x-icon">
</head>

<header>
    <?php include 'header.php'; ?>
</header>

<body>
    <div class="container mt-5">
        <h2 class="text-center">Notepad</h2>

        <!-- Rīku josla -->
        <div class="d-flex flex-wrap justify-content-start mb-3">
            <select id="fontSelect" class="form-select me-2" style="width: auto;">
                <option value="Arial">Arial</option>
                <option value="Courier New">Courier New</option>
                <option value="Georgia">Georgia</option>
                <option value="Times New Roman">Times New Roman</option>
                <option value="Verdana">Verdana</option>
            </select>

            <select id="sizeSelect" class="form-select me-2" style="width: auto;">
                <option value="1">1</option>
                <option value="2">2</option>
                <option value="3">3</option>
                <option value="4">4</option>
                <option value="5">5</option>
                <option value="6">6</option>
                <option value="7">7</option>
            </select>

            <select id="alignSelect" class="form-select me-2" style="width: auto;">
                <option value="left">Left</option>
                <option value="center">Center</option>
                <option value="right">Right</option>
                <option value="justify">Justify</option>
            </select>

            <button id="boldBtn" class="btn btn-outline-dark me-1"><b>B</b></button>
            <button id="italicBtn" class="btn btn-outline-dark me-1"><i>I</i></button>
            <button id="underlineBtn" class="btn btn-outline-dark me-1"><u>U</u></button>

            <div class="ms-auto">
                <button id="saveBtn" class="btn btn-outline-dark">Save</button>
                <button id="saveAsBtn" class="btn btn-outline-dark" data-bs-toggle="modal" data-bs-target="#saveAsModal">Save As</button>
            </div>
        </div>

        <!-- Rediģējamais teksts -->
        <div id="notepad" class="form-control" contenteditable="true" style="min-height: 379px;">
            Start writing here...
        </div>

        <!-- Save As Modālais logs -->
        <div class="modal fade" id="saveAsModal" tabindex="-1" aria-labelledby="saveAsModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="saveAsModalLabel">Save As</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="saveForm" action="savefile.php" method="POST">
                            <label for="fileName" class="form-label">File Name:</label>
                            <input type="text" id="fileName" name="fileName" class="form-control" placeholder="Enter file name">
                            <input type="hidden" id="fileText" name="fileText" value="">
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Cancel</button>
                        <button type="button" id="confirmSaveAs" class="btn btn-outline-dark">Save</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Turpināšanas modālis -->
        <div class="modal fade" id="continueModal" tabindex="-1" aria-labelledby="continueModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="continueModalLabel">Continue Editing?</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        You have unsaved work from your last session. Do you want to continue where you left off?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">No</button>
                        <button type="button" id="continueYesBtn" class="btn btn-outline-dark">Yes</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Brīdinājuma modālis nepieslēgtam lietotājam -->
        <div class="modal fade" id="loginWarningModal" tabindex="-1" aria-labelledby="loginWarningLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="loginWarningLabel">Access Denied</h5>
                        <a href="index.php" class="btn-close"></a>
                    </div>
                    <div class="modal-body">
                        This feature is only available for logged-in users.
                    </div>
                    <div class="modal-footer">
                        <a href="login.php" class="btn btn-outline-dark">Login</a>
                        <a href="index.php" class="btn btn-outline-dark">Close</a>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- JavaScript faili -->
    <script src="../js/textfont.js"></script>
    <script src="../js/textsize.js"></script>
    <script src="../js/textalign.js"></script>
    <script src="../js/textstyle.js"></script>
    <script src="../js/saveasmodal.js"></script>
    <script src="../js/autosave.js"></script>
    <script src="../js/warningmodal.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- PHP ielīmē JS mainīgo, lai pārbaudītu sesiju -->
    <script>
        const isLoggedIn = <?php echo isset($_SESSION['user_id']) ? 'true' : 'false'; ?>;
    </script>
</body>

<footer>
    <?php include 'footer.php'; ?>
</footer>

</html>