<!-- Author  Raivis Rampāns
Created 01.04.2025
Editor Raivis
Modified 07.06.2025 
Description: The page that shows a user's files in a list with the options of adding thumbnails, descriptions, open the files and edit them -->

<?php
session_start();
include 'conn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$userId = $_SESSION['user_id'];

// Iegūst failu sarakstu
$sql = "SELECT f.id, f.name, f.date, f.time, f.description
        FROM files f
        INNER JOIN file_users fu ON f.id = fu.files_id
        WHERE fu.users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web NotePad</title>
    <link rel="shortcut icon" href="../images/favicon.ico" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>

<header>
    <?php include 'header.php'; ?>
</header>

<div class="container mt-5">
    <h2 class="text-center mb-4" style="font-size: 36px; font-weight: bold;">Your files</h2>

    <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <?php
                $fileId = $row['id'];
                $fileName = htmlspecialchars($row['name']);
                $fileDate = htmlspecialchars($row['date']);
                $fileTime = date("H:i", strtotime($row['time']));
                $fileDescription = htmlspecialchars($row['description']);
            ?>
            <div class="card mb-4 border-dark" data-file-id="<?php echo $fileId; ?>" data-file-name="<?php echo $fileName; ?>" data-file-description="<?php echo $fileDescription; ?>">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="d-flex align-items-center gap-2">
                            <h4 class="card-title fw-bold m-0" style="font-size: 28px;"><?php echo $fileName; ?></h4>
                            <button class="btn btn-outline-dark btn-sm edit-btn" title="Edit file info">
                                <i class="bi bi-pencil"></i>
                            </button>
                        </div>

                        <div class="d-flex align-items-center gap-2">
                            <p class="text m-0"><strong>Created:</strong> <?php echo $fileTime . ' ' . $fileDate; ?></p>

                            <form method="get" action="viewfile.php" class="m-0">
                                <input type="hidden" name="id" value="<?php echo $fileId; ?>">
                                <button type="submit" class="btn btn-outline-dark">View</button>
                            </form>

                            <form method="get" action="deletefile.php" class="m-0">
                                <input type="hidden" name="id" value="<?php echo $fileId; ?>">
                                <button type="submit" class="btn btn-outline-dark">Delete</button>
                            </form>
                        </div>
                    </div>

                    <div>
                        <p class="card-text mb-1"><strong>Description:</strong> <?php echo nl2br($fileDescription); ?></p>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p class="text-center">No files found.</p>
    <?php endif; ?>
</div>

<!-- Modal -->
<div class="modal fade" id="editFileModal" tabindex="-1" aria-labelledby="editFileModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" action="updatefile.php" id="editFileForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editFileModalLabel">Edit File Info</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="file_id" id="modalFileId">
            <div class="mb-3">
                <label for="modalFileName" class="form-label"><strong>File Name</strong></label>
                <input type="text" class="form-control" id="modalFileName" name="name" required maxlength="255">
            </div>
            <div class="mb-3">
                <label for="modalFileDescription" class="form-label"><strong>Description</strong></label>
                <textarea class="form-control" id="modalFileDescription" name="description" rows="4" maxlength="1000"></textarea>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-outline-dark">Update</button>
        </div>
      </div>
    </form>
  </div>
</div>

<footer>
    <?php include 'footer.php'; ?>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="../js/fileinfomodal.js"></script>

</body>
</html>

<?php
$stmt->close();
$conn->close();
?>