<!-- Author  Raivis Rampāns
Created 12.03.2025
Editor Raivis
Modified 09.06.2025 
Description: Page that shows a list of published notepad files with options to filter, view, comment, like, dislike and favourite published files -->

<?php
session_start();
include "conn.php";

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Iegūst lietotāja failus
$userId = $_SESSION['user_id'];
$userFiles = [];

$stmt = $conn->prepare("SELECT f.id, f.name FROM files f
                        JOIN file_users fu ON fu.files_id = f.id
                        WHERE fu.users_id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $userFiles[] = $row;
}
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Web NotePad</title>
    <link rel="shortcut icon" href="../images/favicon.ico" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<header>
    <?php include 'header.php'; ?>
</header>

<div class="container mt-4">
    <!-- First bar: Share + dropdowns + search -->
    <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
        <!-- Left side -->
        <div class="d-flex flex-wrap gap-2">
            <!-- Share button triggers modal -->
            <button class="btn btn-outline-dark" data-bs-toggle="modal" data-bs-target="#postModal">Share</button>

            <select class="form-select" style="width: 150px;">
                <option selected>Category</option>
            </select>

            <select class="form-select" style="width: 150px;">
                <option selected>Option 1</option>
            </select>

            <select class="form-select" style="width: 150px;">
                <option selected>Option 2</option>
            </select>

            <select class="form-select" style="width: 150px;">
                <option selected>Option 3</option>
            </select>
        </div>

        <!-- Search -->
        <form class="d-flex" role="search">
            <input class="form-control" type="search" placeholder="Search" aria-label="Search">
        </form>
    </div>
</div>

<!-- Share Modal -->
<div class="modal fade" id="postModal" tabindex="-1" aria-labelledby="postModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form action="post.php" method="POST" enctype="multipart/form-data" id="shareForm">
        <div class="modal-header">
          <h5 class="modal-title" id="postModalLabel">Share a File</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label for="fileId" class="form-label">Select File</label>
            <select class="form-select" id="fileId" name="file_id" required>
              <option value="" disabled selected>Choose a file...</option>
              <?php foreach ($userFiles as $file): ?>
                <option value="<?= htmlspecialchars($file['id']) ?>"><?= htmlspecialchars($file['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="mb-3">
            <label for="titleInput" class="form-label">Title</label>
            <input type="text" class="form-control" id="titleInput" name="title" required>
          </div>

          <div class="mb-3">
            <label for="descInput" class="form-label">Description</label>
            <textarea class="form-control" id="descInput" name="description" rows="3" required></textarea>
          </div>

          <div class="mb-3">
            <label for="thumbnailInput" class="form-label">Thumbnail</label>
            <input type="file" class="form-control" id="thumbnailInput" name="thumbnail" accept="image/*">
          </div>

          <div class="mb-3">
            <label for="categoryInput" class="form-label">Categories (max 3)</label>
            <input type="text" class="form-control" id="categoryInput" placeholder="Type and press Enter">
            <div id="categoryTags" class="mt-2 d-flex flex-wrap gap-1"></div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Post</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="../js/postmodal.js"></script>

<footer class="mt-5">
    <?php include 'footer.php'; ?>
</footer>

</body>
</html>
