// Author  Raivis Rampāns
// Created 07.06.2025
// Editor Raivis
// Modified 07.06.2025

document.addEventListener('DOMContentLoaded', () => {
    const editButtons = document.querySelectorAll('.edit-btn');
    const modal = new bootstrap.Modal(document.getElementById('editFileModal'));
    const modalFileId = document.getElementById('modalFileId');
    const modalFileName = document.getElementById('modalFileName');
    const modalFileDescription = document.getElementById('modalFileDescription');

    editButtons.forEach(btn => {
        btn.addEventListener('click', () => {
            const card = btn.closest('.card');
            const fileId = card.getAttribute('data-file-id');
            const fileName = card.getAttribute('data-file-name');
            const fileDescription = card.getAttribute('data-file-description');

            modalFileId.value = fileId;
            modalFileName.value = fileName;
            modalFileDescription.value = fileDescription;

            modal.show();
        });
    });
});