// Author  Raivis Rampāns
// Created 07.06.2025
// Editor Raivis
// Modified 07.06.2025

document.addEventListener("DOMContentLoaded", function () {
    const notepad = document.getElementById("notepad");
    const LOCAL_KEY = "unsavedNotepadText";

    // Saglabā tekstu uz localStorage katrā ievadē
    notepad.addEventListener("input", () => {
        localStorage.setItem(LOCAL_KEY, notepad.innerHTML);
    });

    // Ja eksistē nesaglabāts teksts
    const savedText = localStorage.getItem(LOCAL_KEY);
    if (savedText && savedText.trim() !== "" && savedText !== "Start writing here...") {
        const continueModal = new bootstrap.Modal(document.getElementById("continueModal"));
        continueModal.show();

        document.getElementById("continueYesBtn").addEventListener("click", function () {
            notepad.innerHTML = savedText;
            continueModal.hide();
        });

        // Ja aizver bez turpināšanas, izdzēšam
        document.getElementById("continueModal").addEventListener("hidden.bs.modal", function () {
            localStorage.removeItem(LOCAL_KEY);
        });
    }
});