-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for anime_db
CREATE DATABASE IF NOT EXISTS `anime_db` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `anime_db`;

-- Dumping structure for table anime_db.anime
CREATE TABLE IF NOT EXISTS `anime` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `genre` varchar(191) NOT NULL,
  `episodes` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table anime_db.anime: ~2 rows (approximately)
INSERT INTO `anime` (`id`, `title`, `genre`, `episodes`, `description`) VALUES
	(1, 'XOX', 'Drama', 12, ''),
	(2, 'Snoopdawg', 'Rap', 104, 'Smoke');


-- Dumping database structure for animelist
CREATE DATABASE IF NOT EXISTS `animelist` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `animelist`;

-- Dumping structure for table animelist.anime
CREATE TABLE IF NOT EXISTS `anime` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT 'Anime title',
  `poster` varchar(255) DEFAULT NULL COMMENT 'Anime poster URL',
  `season` varchar(255) NOT NULL COMMENT 'Premiered season',
  `year` int(11) unsigned NOT NULL COMMENT 'Premiered year',
  `type` varchar(255) NOT NULL COMMENT 'Anime type',
  `rating` varchar(255) NOT NULL COMMENT 'Age rating',
  `source` varchar(255) NOT NULL COMMENT 'Anime source (manga, original, etc.)',
  `description` text NOT NULL COMMENT 'Anime description',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Tabula priekš anime';

-- Dumping data for table animelist.anime: ~15 rows (approximately)
INSERT INTO `anime` (`id`, `title`, `poster`, `season`, `year`, `type`, `rating`, `source`, `description`) VALUES
	(1, 'The Case Study of Vanitas', '1401/118483.jpg', 'Summer', 2021, 'TV', 'R - 17+ (violence & profanity)', 'Manga', 'Scorned by others of his kind for being born under a blue moon, the vampire Vanitas grew afraid and desolate. According to legend, he created a cursed grimoire known as the "Book of Vanitas," and it is said he would one day use it to bring retribution upon all vampires of the crimson moon.'),
	(2, 'Mashle', '1097/135946.jpg', 'Spring', 2023, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'In this magical world, one is easily identified as having magical abilities by a distinctive mark on their face. Those unable to practice magic are swiftly exterminated to maintain the magical integrity of society. However, deep within a forest lies an anomaly in Mash Burnedead, who can be found pumping iron with one arm and lifting a cream puff with the other. This aloof boy with superhuman strength—but no magical abilities—leads a quiet life with his father, far removed from society.'),
	(3, 'Heavenly Delusion', '1121/133132.jpg', 'Spring', 2023, 'TV', 'R - 17+ (violence & profanity)', 'Manga', 'Fifteen years ago, disaster struck human civilization, and now dangerous man-eating monsters roam the ravaged lands, posing an existential threat to the remaining survivors. Amid this turmoil, an isolated facility shelters children and nurtures them in peace. However, as a few among them find out about the world beyond the narrow periphery of their nursery\'s walls, their curiosity about it slowly grows.'),
	(4, 'Joshiraku', '8/48925.jpg', 'Summer', 2012, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'Joshiraku follows the conversations of five rakugo storyteller girls relating the odd things that happen to them each day. Their comedic and satirical chatting covers all kinds of topics, from pointless observations of everyday life, to politics, manga, and more. Each girl has something new to add to the discussion, and the discourse never ends in the same place it began.'),
	(5, 'Classroom of the Elite', '5/86830.jpg', 'Summer', 2017, 'TV', 'PG-13 - Teens 13 or older', 'Light novel', 'On the surface, Koudo Ikusei Senior High School is a utopia. The students enjoy an unparalleled amount of freedom, and it is ranked highly in Japan. However, the reality is less than ideal. Four classes, A through D, are ranked in order of merit, and only the top classes receive favorable treatment.'),
	(6, 'Rascal Does Not Dream of Bunny Girl Senpai', '1301/93586.jpg', 'Fall', 2018, 'TV', 'PG-13 - Teens 13 or older', 'Light novel', 'The rare and inexplicable Puberty Syndrome is thought of as a myth. It is a rare disease which only affects teenagers, and its symptoms are so supernatural that hardly anyone recognizes it as a legitimate occurrence. However, high school student Sakuta Azusagawa knows from personal experience that it is very much real, and happens to be quite prevalent in his school.'),
	(7, 'Terror in Resonance', '1417/117422.jpg', 'Summer', 2014, 'TV', 'R - 17+ (violence & profanity)', 'Original', 'Painted in red, the word "VON" is all that is left behind after a terrorist attack on a nuclear facility in Japan. The government is shattered by their inability to act, and the police are left frantically searching for ways to crack down the perpetrators. The public are clueless—until, six months later, a strange video makes its way onto the internet. In it, two teenage boys who identify themselves only as "Sphinx" directly challenge the police, threatening to cause destruction and mayhem across Tokyo. Unable to stop the mass panic quickly spreading through the city and desperate for any leads in their investigation, the police struggle to act effectively against these terrorists, with Detective Kenjirou Shibazaki caught in the middle of it all.'),
	(8, 'Oshi No Ko', '1812/134736.jpg', 'Spring', 2023, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'In the entertainment world, celebrities often show exaggerated versions of themselves to the public, concealing their true thoughts and struggles beneath elaborate lies. Fans buy into these fabrications, showering their idols with undying love and support, until something breaks the illusion. Sixteen-year-old rising star Ai Hoshino of pop idol group B Komachi has the world captivated'),
	(9, 'Blend S', '6/88286.jpg', 'Fall', 2017, 'TV', 'PG-13 - Teens 13 or older', '4-koma manga', 'Wishing to be independent, 16-year-old Maika Sakuranomiya is desperate to nail down a part-time job so that she can afford to study abroad. Unfortunately, her applications are constantly rejected due to the menacing look she unintentionally makes whenever she smiles, despite her otherwise cheerful disposition.'),
	(10, 'Attack on Titan', '10/47347.jpg', 'Spring', 2013, 'TV', 'R - 17+ (violence & profanity)', 'Manga', 'Centuries ago, mankind was slaughtered to near extinction by monstrous humanoid creatures called Titans, forcing humans to hide in fear behind enormous concentric walls. What makes these giants truly terrifying is that their taste for human flesh is not born out of hunger but what appears to be out of pleasure. To ensure their survival, the remnants of humanity began living within defensive barriers, resulting in one hundred years without a single titan encounter. However, that fragile calm is soon shattered when a colossal Titan manages to breach the supposedly impregnable outer wall, reigniting the fight for survival against the man-eating abominations.'),
	(11, 'Call of the Night', '1045/123711.jpg', 'Summer', 2022, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'Kou Yamori is an average middle school student who struggles with grasping the complex concept of love. Because he sees little sense in surrendering to the norm, he soon stops going to school. Plagued with insomnia due to his idleness, Kou begins roaming the lonesome streets at night.'),
	(12, 'Another', '4/75509.jpg', 'Winter', 2012, 'TV', 'R - 17+ (violence & profanity)', 'Novel', 'In class 3-3 of Yomiyama North Junior High, transfer student Kouichi Sakakibara makes his return after taking a sick leave for the first month of school. Among his new classmates, he is inexplicably drawn toward Mei Misaki—a reserved girl with an eyepatch whom he met in the hospital during his absence. But none of his classmates acknowledge her existence'),
	(13, 'Chainsaw Man', '1806/126216.jpg', 'Fall', 2022, 'TV', 'R - 17+ (violence & profanity)', 'Manga', 'Denji is robbed of a normal teenage life, left with nothing but his deadbeat father\'s overwhelming debt. His only companion is his pet, the chainsaw devil Pochita, with whom he slays devils for money that inevitably ends up in the yakuza\'s pockets. All Denji can do is dream of a good, simple life: one with delicious food and a beautiful girlfriend by his side. But an act of greedy betrayal by the yakuza leads to Denji\'s brutal, untimely death, crushing all hope of him ever achieving happiness.'),
	(14, 'Horimiya', '1695/111486.jpg', 'Winter', 2021, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'On the surface, the thought of Kyouko Hori and Izumi Miyamura getting along would be the last thing in people\'s minds. After all, Hori has a perfect combination of beauty and brains, while Miyamura appears meek and distant to his fellow classmates. However, a fateful meeting between the two lays both of their hidden selves bare. Even though she is popular at school, Hori has little time to socialize with her friends due to housework. On the other hand, Miyamura lives under the noses of his peers, his body bearing secret tattoos and piercings that make him look like a gentle delinquent.'),
	(15, 'Demon Slayer', '1286/99889.jpg', 'Spring', 2019, 'TV', 'R - 17+ (violence & profanity)', 'Manga', 'Ever since the death of his father, the burden of supporting the family has fallen upon Tanjirou Kamado\'s shoulders. Though living impoverished on a remote mountain, the Kamado family are able to enjoy a relatively peaceful and happy life. One day, Tanjirou decides to go down to the local village to make a little money selling charcoal. On his way back, night falls, forcing Tanjirou to take shelter in the house of a strange man, who warns him of the existence of flesh-eating demons that lurk in the woods at night.');

-- Dumping structure for table animelist.anime_genres
CREATE TABLE IF NOT EXISTS `anime_genres` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `anime_id` int(11) unsigned NOT NULL,
  `genre_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_anime_genres_anime` (`anime_id`),
  KEY `FK_anime_genres_genre` (`genre_id`),
  CONSTRAINT `FK_anime_genres_anime` FOREIGN KEY (`anime_id`) REFERENCES `anime` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_anime_genres_genre` FOREIGN KEY (`genre_id`) REFERENCES `genre` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Anime žanri';

-- Dumping data for table animelist.anime_genres: ~34 rows (approximately)
INSERT INTO `anime_genres` (`id`, `anime_id`, `genre_id`) VALUES
	(1, 1, 4),
	(2, 1, 5),
	(3, 1, 6),
	(4, 2, 4),
	(5, 2, 5),
	(6, 2, 7),
	(7, 3, 12),
	(8, 3, 6),
	(9, 3, 13),
	(10, 4, 7),
	(11, 5, 1),
	(12, 5, 10),
	(13, 6, 1),
	(14, 6, 3),
	(15, 7, 6),
	(16, 7, 10),
	(17, 8, 9),
	(18, 8, 2),
	(19, 9, 7),
	(20, 10, 4),
	(21, 10, 8),
	(22, 10, 1),
	(23, 10, 10),
	(24, 11, 3),
	(25, 11, 2),
	(26, 12, 11),
	(27, 12, 6),
	(28, 12, 2),
	(29, 13, 4),
	(30, 13, 5),
	(31, 14, 3),
	(32, 15, 4),
	(33, 15, 8),
	(34, 15, 5);

-- Dumping structure for table animelist.anime_licensor
CREATE TABLE IF NOT EXISTS `anime_licensor` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `anime_id` int(11) unsigned NOT NULL,
  `licensor_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_anime_licensor_anime` (`anime_id`),
  KEY `FK_anime_licensor_licensor` (`licensor_id`),
  CONSTRAINT `FK_anime_licensor_anime` FOREIGN KEY (`anime_id`) REFERENCES `anime` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Licnezētāji anime';

-- Dumping data for table animelist.anime_licensor: ~15 rows (approximately)
INSERT INTO `anime_licensor` (`id`, `anime_id`, `licensor_id`) VALUES
	(1, 1, 2),
	(2, 2, 1),
	(3, 3, 5),
	(4, 4, 4),
	(5, 5, 2),
	(6, 6, 1),
	(7, 7, 2),
	(8, 8, 3),
	(9, 9, 1),
	(10, 10, 2),
	(11, 11, 3),
	(12, 12, 3),
	(13, 13, 5),
	(14, 14, 2),
	(15, 15, 1);

-- Dumping structure for view animelist.anime_list
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `anime_list` (
	`title` VARCHAR(255) NOT NULL COMMENT 'Anime title' COLLATE 'utf8mb4_general_ci',
	`poster` VARCHAR(255) NULL COMMENT 'Anime poster URL' COLLATE 'utf8mb4_general_ci',
	`season` VARCHAR(255) NOT NULL COMMENT 'Premiered season' COLLATE 'utf8mb4_general_ci',
	`year` INT(11) UNSIGNED NOT NULL COMMENT 'Premiered year',
	`type` VARCHAR(255) NOT NULL COMMENT 'Anime type' COLLATE 'utf8mb4_general_ci',
	`rating` VARCHAR(255) NOT NULL COMMENT 'Age rating' COLLATE 'utf8mb4_general_ci',
	`source` VARCHAR(255) NOT NULL COMMENT 'Anime source (manga, original, etc.)' COLLATE 'utf8mb4_general_ci',
	`description` TEXT NOT NULL COMMENT 'Anime description' COLLATE 'utf8mb4_general_ci',
	`genres` MEDIUMTEXT NULL COLLATE 'utf8mb4_general_ci',
	`studio` VARCHAR(255) NULL COMMENT 'Studio name' COLLATE 'utf8mb4_general_ci',
	`licensor` VARCHAR(255) NULL COMMENT 'Licensor name' COLLATE 'utf8mb4_general_ci',
	`episodes` INT(11) UNSIGNED NULL COMMENT 'Number of episodes',
	`from` DATE NULL COMMENT 'Airing from',
	`to` DATE NULL COMMENT 'Airing to'
) ENGINE=MyISAM;

-- Dumping structure for table animelist.anime_studio
CREATE TABLE IF NOT EXISTS `anime_studio` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `anime_id` int(11) unsigned NOT NULL,
  `studio_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_anime_studio_anime` (`anime_id`),
  KEY `FK_anime_studio_studio` (`studio_id`),
  CONSTRAINT `FK_anime_studio_anime` FOREIGN KEY (`anime_id`) REFERENCES `anime` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_anime_studio_studio` FOREIGN KEY (`studio_id`) REFERENCES `studio` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Anime studija/s';

-- Dumping data for table animelist.anime_studio: ~15 rows (approximately)
INSERT INTO `anime_studio` (`id`, `anime_id`, `studio_id`) VALUES
	(1, 1, 2),
	(2, 2, 4),
	(3, 3, 11),
	(4, 4, 9),
	(5, 5, 10),
	(6, 6, 1),
	(7, 7, 7),
	(8, 8, 12),
	(9, 9, 4),
	(10, 10, 5),
	(11, 11, 3),
	(12, 12, 6),
	(13, 13, 7),
	(14, 14, 1),
	(15, 15, 8);

-- Dumping structure for table animelist.episode
CREATE TABLE IF NOT EXISTS `episode` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `anime_id` int(11) unsigned NOT NULL,
  `number` int(11) unsigned NOT NULL COMMENT 'Number of episodes',
  `from` date NOT NULL COMMENT 'Airing from',
  `to` date NOT NULL COMMENT 'Airing to',
  PRIMARY KEY (`id`),
  KEY `FK_episode_anime` (`anime_id`),
  CONSTRAINT `FK_episode_anime` FOREIGN KEY (`anime_id`) REFERENCES `anime` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Epizodes anime';

-- Dumping data for table animelist.episode: ~15 rows (approximately)
INSERT INTO `episode` (`id`, `anime_id`, `number`, `from`, `to`) VALUES
	(1, 1, 12, '2021-07-03', '2021-09-18'),
	(2, 2, 12, '2023-04-08', '2023-07-01'),
	(3, 3, 13, '2023-04-01', '2023-06-24'),
	(4, 4, 13, '2012-07-06', '2012-10-28'),
	(5, 5, 12, '2017-07-12', '2017-10-27'),
	(6, 6, 13, '2018-10-04', '2018-12-27'),
	(7, 7, 11, '2014-07-11', '2014-10-26'),
	(8, 8, 11, '2023-04-12', '2023-06-28'),
	(9, 9, 12, '2017-11-08', '2017-12-24'),
	(10, 10, 25, '2013-04-07', '2013-10-29'),
	(11, 11, 13, '2022-07-08', '2022-10-30'),
	(12, 12, 12, '2012-01-10', '2012-03-27'),
	(13, 13, 12, '2022-11-12', '2022-12-28'),
	(14, 14, 13, '2021-01-10', '2021-04-04'),
	(15, 15, 26, '2019-04-06', '2019-10-28');

-- Dumping structure for view animelist.episodes
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `episodes` (
	`id` INT(11) UNSIGNED NOT NULL,
	`title` VARCHAR(255) NULL COMMENT 'Anime title' COLLATE 'utf8mb4_general_ci',
	`number` INT(11) UNSIGNED NOT NULL COMMENT 'Number of episodes',
	`from` DATE NOT NULL COMMENT 'Airing from',
	`to` DATE NOT NULL COMMENT 'Airing to'
) ENGINE=MyISAM;

-- Dumping structure for table animelist.genre
CREATE TABLE IF NOT EXISTS `genre` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT 'Genre name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Anime žanru tabula';

-- Dumping data for table animelist.genre: ~13 rows (approximately)
INSERT INTO `genre` (`id`, `name`) VALUES
	(1, 'Drama'),
	(2, 'Supernatural'),
	(3, 'Romance'),
	(4, 'Action'),
	(5, 'Fantasy'),
	(6, 'Mystery'),
	(7, 'Comedy'),
	(8, 'Award Winning'),
	(9, 'Drama'),
	(10, 'Suspense'),
	(11, 'Horror'),
	(12, 'Adventure'),
	(13, 'Sci-Fi');

-- Dumping structure for view animelist.genres
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `genres` (
	`id` INT(11) UNSIGNED NOT NULL,
	`title` VARCHAR(255) NULL COMMENT 'Anime title' COLLATE 'utf8mb4_general_ci',
	`genres` MEDIUMTEXT NULL COLLATE 'utf8mb4_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for table animelist.licensor
CREATE TABLE IF NOT EXISTS `licensor` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT 'Licensor name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Licencori anime';

-- Dumping data for table animelist.licensor: ~5 rows (approximately)
INSERT INTO `licensor` (`id`, `name`) VALUES
	(1, 'Aniplex of America'),
	(2, 'Funimation'),
	(3, 'Sentai Filmworks'),
	(4, 'Maiden Japan'),
	(5, 'None found');

-- Dumping structure for view animelist.licensors
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `licensors` (
	`id` INT(11) UNSIGNED NOT NULL,
	`title` VARCHAR(255) NULL COMMENT 'Anime title' COLLATE 'utf8mb4_general_ci',
	`name` VARCHAR(255) NULL COMMENT 'Licensor name' COLLATE 'utf8mb4_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for table animelist.studio
CREATE TABLE IF NOT EXISTS `studio` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT 'Studio name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Studija/s priekš anime.';

-- Dumping data for table animelist.studio: ~12 rows (approximately)
INSERT INTO `studio` (`id`, `name`) VALUES
	(1, 'CloverWorks'),
	(2, 'Bones'),
	(3, 'LIDENFILMS'),
	(4, 'A-1 Pictures'),
	(5, 'Wit Studio'),
	(6, 'P.A. Works'),
	(7, 'MAPPA'),
	(8, 'ufotable'),
	(9, 'J.C.Staff'),
	(10, 'Lerche'),
	(11, 'Production I.G'),
	(12, 'Doga Kobo');

-- Dumping structure for view animelist.studios
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `studios` (
	`id` INT(11) UNSIGNED NOT NULL,
	`title` VARCHAR(255) NULL COMMENT 'Anime title' COLLATE 'utf8mb4_general_ci',
	`name` VARCHAR(255) NULL COMMENT 'Studio name' COLLATE 'utf8mb4_general_ci'
) ENGINE=MyISAM;

-- Dumping structure for table animelist.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(120) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table animelist.users: ~11 rows (approximately)
INSERT INTO `users` (`id`, `username`, `password`) VALUES
	(1, 'artorito_nlo_11', '$2y$10$y36Acla8nJqzHSrjkC4bKueo5OWedfz2z7w0R78lvIcgh8homAQzG'),
	(2, 'joebamna34555223433322332323', '$2y$10$Lc1FAxDNdEJgnouoah7qJ.LF2cJGZx1ad0ESzHbZNZQ4IJq5f04AW'),
	(3, 'andrei', '$2y$10$LpIeggdMh.bnj.T/6L/x8ejh5MLOuefIbTsx6MsIREHeKrdJG/dyu'),
	(4, 'janis', '$2y$10$ag4imi3gdw3MNv88chobjO4eTDprF/5xVIhMnZ925HwBRgUL.PWoK'),
	(5, 'Hollow', '$2y$10$V8dh0t4x.WFPjr0dBas43uFxPjc3oXajFpD5mPoY1LLcC/l0vK7Em'),
	(6, 'JuicerXQCLol', '$2y$10$xpNTos7fJhpxeUs9.9HxnenlYEO35CUFL89OIUMOHs2N8k3fnLQEa'),
	(7, 'admin', '$2y$10$V0zHMNPrOLhXb9sNj10R8uuHNZA5Uy2pDQMjxVIvQ7DOBpXks3P3G'),
	(8, 'admin1', '$2y$10$eDOFi4kACSFjBPWGSjJTdu0X97hbKJ7slERFuOPGaXuAIGKlbt.Um'),
	(9, 'admin2', '$2y$10$MMYece2BtWRKDJ7wwhgvqO4eC8t/ZZnRock95cZnIe9W6/oO/7ox6'),
	(10, 'admin3', '$2y$10$ZOP52imEyAEvYBQtEl860.HdPKeK6B.c3G92QhAI7wURDSyyle2nC'),
	(11, 'test', '$2y$10$UUtWw/0GoFZ9QmExqs3RhOy5QvU5EP6CEKbeqQHjBH/EZkA7/RxJy');

-- Dumping structure for table animelist.users_anime
CREATE TABLE IF NOT EXISTS `users_anime` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `users_id` int(11) unsigned NOT NULL,
  `users_list_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_anime_users_users` (`users_id`) USING BTREE,
  KEY `FK_anime_users_anime` (`users_list_id`) USING BTREE,
  CONSTRAINT `FK_anime_users_anime` FOREIGN KEY (`users_list_id`) REFERENCES `users_list` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_anime_users_users` FOREIGN KEY (`users_id`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Sasaista lietotaju ar vinu ievadito anime';

-- Dumping data for table animelist.users_anime: ~10 rows (approximately)
INSERT INTO `users_anime` (`id`, `users_id`, `users_list_id`) VALUES
	(1, 8, 1),
	(2, 8, 2),
	(3, 8, 3),
	(4, 8, 4),
	(5, 9, 5),
	(6, 9, 6),
	(7, 8, 7),
	(8, 8, 8),
	(9, 8, 9),
	(10, 10, 10);

-- Dumping structure for table animelist.users_list
CREATE TABLE IF NOT EXISTS `users_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL COMMENT 'Anime title',
  `poster` varchar(255) DEFAULT NULL COMMENT 'Anime poster URL',
  `season` varchar(255) NOT NULL COMMENT 'Gadalaiks, kad tika publicets',
  `year` int(11) unsigned NOT NULL COMMENT 'Gads, kad tika publicets',
  `type` varchar(255) NOT NULL COMMENT 'Anime tips',
  `rating` varchar(255) NOT NULL COMMENT 'Vecuma reitings',
  `source` varchar(255) NOT NULL COMMENT 'Anime avots',
  `description` text NOT NULL COMMENT 'Anime apraksts',
  `genre` varchar(255) NOT NULL COMMENT 'Anime žanri',
  `studios` varchar(255) NOT NULL COMMENT 'Anime studijas',
  `licensors` varchar(255) NOT NULL COMMENT 'Anime licenzori',
  `episodes` int(11) unsigned NOT NULL COMMENT 'Anime seriju skaits',
  `aired_from` date NOT NULL COMMENT 'Publicejas no',
  `aired_to` date NOT NULL COMMENT 'Publicejas lidz',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Animes added to users "my list"';

-- Dumping data for table animelist.users_list: ~10 rows (approximately)
INSERT INTO `users_list` (`id`, `title`, `poster`, `season`, `year`, `type`, `rating`, `source`, `description`, `genre`, `studios`, `licensors`, `episodes`, `aired_from`, `aired_to`) VALUES
	(1, 'Fate/stay night Movie: Heaven\'s Feel - I. Presage Flower', '/images/anime/1734072827-Fate Movie Poster.jpg', 'Test', 0, 'Movie', 'R - 17+ (violence & profanity)', 'Visual novel', 'The Holy Grail War: a violent battle between mages in which seven masters and their summoned servants fight for the Holy Grail, a magical artifact that can grant the victor any wish. Nearly 10 years ago, the final battle of the Fourth Holy Grail War wreaked havoc on Fuyuki City and took over 500 lives, leaving the city devastated.\r\n\r\nShirou Emiya, a survivor of this tragedy, aspires to become a hero of justice like his rescuer and adoptive father, Kiritsugu Emiya. Despite only being a student, Shirou is thrown into the Fifth Holy Grail War when he accidentally sees a battle between servants at school and summons his own servant, Saber.\r\n\r\nWhen a mysterious shadow begins a murderous spree in Fuyuki City, Shirou aligns himself with Rin Toosaka, a fellow participant in the Holy Grail War, in order to stop the deaths of countless people. However, Shirou\'s feelings for his close friend Sakura Matou lead him deeper into the dark secrets surrounding the war and the feuding families involved.', 'Action, Fantasy', '0', 'Aniplex of America', 1, '2017-10-13', '2017-10-13'),
	(2, 'Spice and Wolf: Merchant Meets the Wise Wolf', '../images/anime/1734074614-Spice & Wolf.jpg', '', 0, 'TV', 'PG-13 - Teens 13 or older', 'Light novel', 'With a cartload of fur pelts in tow, traveling merchant Kraft Lawrence stops by the village of Pasloe. According to local folklore, centuries ago, one of the villagers made a promise with the wolf deity Holo, who swore to bless Pasloe with bountiful harvests of wheat. Yet, as time passed, such stories became little more than relics of the past.', 'Adventure, Drama, Romance, Supernatural', '0', 'None found', 25, '2024-04-02', '2024-09-24'),
	(3, 'Mango', '/images/anime/1734075989-Spice & Wolf.jpg', '', 0, 'TV', 'f', 'f', 'fda', 'Action, Mango', '0', 'f', 12, '2024-12-02', '2024-12-27'),
	(4, 'Mango2', '/images/anime/1734076506-Spice & Wolf.jpg', '', 0, 'TV', 'f', 'f', 'gsdgds', 'Action, Mango', '0', 'f', 12, '2024-12-03', '2024-12-28'),
	(5, 'Frieren: Beyond Journey\'s End', '/images/anime/1734077143-Frieren.jpg', '', 0, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'During their decade-long quest to defeat the Demon King, the members of the hero\'s party—Himmel himself, the priest Heiter, the dwarf warrior Eisen, and the elven mage Frieren—forge bonds through adventures and battles, creating unforgettable precious memories for most of them.\r\n\r\nHowever, the time that Frieren spends with her comrades is equivalent to merely a fraction of her life, which has lasted over a thousand years. When the party disbands after their victory, Frieren casually returns to her "usual" routine of collecting spells across the continent. Due to her different sense of time, she seemingly holds no strong feelings toward the experiences she went through.\r\n\r\nAs the years pass, Frieren gradually realizes how her days in the hero\'s party truly impacted her. Witnessing the deaths of two of her former companions, Frieren begins to regret having taken their presence for granted; she vows to better understand humans and create real personal connections. Although the story of that once memorable journey has long ended, a new tale is about to begin.', 'Adventure, Drama, Fantasy', '0', 'Crunchyroll', 28, '2023-09-29', '2024-03-22'),
	(6, 'Frieren: Beyond Journey\'s End', '/images/anime/1734077320-Frieren.jpg', '', 0, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'During their decade-long quest to defeat the Demon King, the members of the hero\'s party—Himmel himself, the priest Heiter, the dwarf warrior Eisen, and the elven mage Frieren—forge bonds through adventures and battles, creating unforgettable precious memories for most of them.\r\n\r\nHowever, the time that Frieren spends with her comrades is equivalent to merely a fraction of her life, which has lasted over a thousand years. When the party disbands after their victory, Frieren casually returns to her "usual" routine of collecting spells across the continent. Due to her different sense of time, she seemingly holds no strong feelings toward the experiences she went through.\r\n\r\nAs the years pass, Frieren gradually realizes how her days in the hero\'s party truly impacted her. Witnessing the deaths of two of her former companions, Frieren begins to regret having taken their presence for granted; she vows to better understand humans and create real personal connections. Although the story of that once memorable journey has long ended, a new tale is about to begin.', 'Adventure, Drama, Fantasy', 'Madhouse', 'Crunchyroll', 28, '2024-12-02', '2024-12-26'),
	(7, 'Frieren: Beyond Journey\'s End', '/images/anime/1734078119-Frieren.jpg', '', 0, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'During their decade-long quest to defeat the Demon King, the members of the hero\'s party—Himmel himself, the priest Heiter, the dwarf warrior Eisen, and the elven mage Frieren—forge bonds through adventures and battles, creating unforgettable precious memories for most of them.\r\n\r\nHowever, the time that Frieren spends with her comrades is equivalent to merely a fraction of her life, which has lasted over a thousand years. When the party disbands after their victory, Frieren casually returns to her "usual" routine of collecting spells across the continent. Due to her different sense of time, she seemingly holds no strong feelings toward the experiences she went through.\r\n\r\nAs the years pass, Frieren gradually realizes how her days in the hero\'s party truly impacted her. Witnessing the deaths of two of her former companions, Frieren begins to regret having taken their presence for granted; she vows to better understand humans and create real personal connections. Although the story of that once memorable journey has long ended, a new tale is about to begin.', 'Adventure, Drama, Fantasy', 'Madhouse', 'Crunchyroll', 28, '2023-09-29', '2024-03-22'),
	(8, 'Frieren: Beyond Journey\'s End', '/images/anime/1734078221-Frieren.jpg', '', 0, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'During their decade-long quest to defeat the Demon King, the members of the hero\'s party—Himmel himself, the priest Heiter, the dwarf warrior Eisen, and the elven mage Frieren—forge bonds through adventures and battles, creating unforgettable precious memories for most of them.\r\n\r\nHowever, the time that Frieren spends with her comrades is equivalent to merely a fraction of her life, which has lasted over a thousand years. When the party disbands after their victory, Frieren casually returns to her "usual" routine of collecting spells across the continent. Due to her different sense of time, she seemingly holds no strong feelings toward the experiences she went through.\r\n\r\nAs the years pass, Frieren gradually realizes how her days in the hero\'s party truly impacted her. Witnessing the deaths of two of her former companions, Frieren begins to regret having taken their presence for granted; she vows to better understand humans and create real personal connections. Although the story of that once memorable journey has long ended, a new tale is about to begin.', 'Adventure, Drama, Fantasy', 'Madhouse', 'Crunchyroll', 28, '2024-12-02', '2024-12-26'),
	(9, 'Frieren: Beyond Journey\'s End', '/images/anime/1734080642-Frieren.jpg', 'Fall', 2023, 'TV', 'PG-13 - Teens 13 or older', 'Manga', 'During their decade-long quest to defeat the Demon King, the members of the hero\'s party—Himmel himself, the priest Heiter, the dwarf warrior Eisen, and the elven mage Frieren—forge bonds through adventures and battles, creating unforgettable precious memories for most of them.\r\n\r\nHowever, the time that Frieren spends with her comrades is equivalent to merely a fraction of her life, which has lasted over a thousand years. When the party disbands after their victory, Frieren casually returns to her "usual" routine of collecting spells across the continent. Due to her different sense of time, she seemingly holds no strong feelings toward the experiences she went through.\r\n\r\nAs the years pass, Frieren gradually realizes how her days in the hero\'s party truly impacted her. Witnessing the deaths of two of her former companions, Frieren begins to regret having taken their presence for granted; she vows to better understand humans and create real personal connections. Although the story of that once memorable journey has long ended, a new tale is about to begin.', 'Adventure, Drama, Fantasy', 'Madhouse', 'Crunchyroll', 28, '2023-09-23', '2024-03-22'),
	(10, 'Attack on Titan: Final Season - The Final Chapters', '/images/anime/1734080882-AOT.jpg', 'Spring', 2023, 'TV Special', 'R - 17+ (violence & profanity)', 'Manga', 'In the wake of Eren Yeager\'s cataclysmic actions, his friends and former enemies form an alliance against his genocidal rampage. Though once bitter foes, Armin Arlert, Mikasa Ackerman, and the remaining members of the Scout Regiment join forces with Reiner Braun and the survivors of the Marleyan military. Their meager united front sets out on a mission to stop Eren\'s wrath and—if possible—save their old comrade in the process.\r\n\r\nAs Eren pushes forward at any cost, he battles his own internal turmoil. Although he feels immense remorse over his horrific invasion, Eren believes he harbors noble intentions: he believes the path ahead is the only way to save his friends and, to a greater extent, his people.\r\n\r\nThe opposing battalions spiral toward an inevitable final clash that may claim the lives of millions. Though they face an army of monsters beyond anything they could have previously imagined, Mikasa, Armin, and their allies stand brave in the face of certain doom.', 'Action, Drama, Suspense', 'MAPPA', 'None found', 2, '2023-03-04', '2023-11-05');

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `anime_list`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `anime_list` AS SELECT anime.title, anime.poster, anime.season, anime.year, anime.type, anime.rating, 
anime.source, anime.description, genres.genres AS genres, studios.name AS studio, 
licensors.name AS licensor, episodes.number AS episodes, episodes.`from`, episodes.`to` FROM anime
LEFT JOIN genres ON genres.title = anime.title
LEFT JOIN studios ON studios.title = anime.title 
LEFT JOIN licensors ON licensors.title = anime.title 
LEFT JOIN episodes ON episodes.title = anime.title ;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `episodes`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `episodes` AS SELECT episode.id, anime.title, episode.number, episode.`from`, episode.`to` FROM episode
LEFT JOIN anime ON anime.id=episode.anime_id ;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `genres`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `genres` AS SELECT anime_genres.id, anime.title, GROUP_CONCAT(" ", genre.name) AS genres FROM anime_genres
LEFT JOIN anime ON anime.id=anime_genres.anime_id
LEFT JOIN genre ON genre.id=anime_genres.genre_id GROUP BY anime_genres.anime_id ;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `licensors`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `licensors` AS SELECT anime_licensor.id, anime.title, licensor.name FROM anime_licensor
LEFT JOIN anime ON anime.id=anime_licensor.anime_id
LEFT JOIN licensor ON licensor.id=anime_licensor.licensor_id ;

-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `studios`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `studios` AS SELECT anime_studio.id, anime.title, studio.name FROM anime_studio
LEFT JOIN anime ON anime.id=anime_studio.anime_id
LEFT JOIN studio ON studio.id=anime_studio.studio_id ;


-- Dumping database structure for bootstrapprakseraivis
CREATE DATABASE IF NOT EXISTS `bootstrapprakseraivis` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `bootstrapprakseraivis`;

-- Dumping structure for table bootstrapprakseraivis.wp_commentmeta
CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_commentmeta: ~0 rows (approximately)

-- Dumping structure for table bootstrapprakseraivis.wp_comments
CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_comments: ~0 rows (approximately)

-- Dumping structure for table bootstrapprakseraivis.wp_links
CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_links: ~0 rows (approximately)

-- Dumping structure for table bootstrapprakseraivis.wp_options
CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=615 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_options: ~150 rows (approximately)
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
	(1, 'siteurl', 'http://localhost/bootstrapprakseraivis', 'yes'),
	(2, 'home', 'http://localhost/bootstrapprakseraivis', 'yes'),
	(3, 'blogname', 'bootstrapprakseraivis', 'yes'),
	(4, 'blogdescription', '', 'yes'),
	(5, 'users_can_register', '0', 'yes'),
	(6, 'admin_email', 'raivis@gmail.com', 'yes'),
	(7, 'start_of_week', '1', 'yes'),
	(8, 'use_balanceTags', '0', 'yes'),
	(9, 'use_smilies', '1', 'yes'),
	(10, 'require_name_email', '', 'yes'),
	(11, 'comments_notify', '', 'yes'),
	(12, 'posts_per_rss', '10', 'yes'),
	(13, 'rss_use_excerpt', '0', 'yes'),
	(14, 'mailserver_url', 'mail.example.com', 'yes'),
	(15, 'mailserver_login', 'login@example.com', 'yes'),
	(16, 'mailserver_pass', 'password', 'yes'),
	(17, 'mailserver_port', '110', 'yes'),
	(18, 'default_category', '1', 'yes'),
	(19, 'default_comment_status', '', 'yes'),
	(20, 'default_ping_status', 'open', 'yes'),
	(21, 'default_pingback_flag', '', 'yes'),
	(22, 'posts_per_page', '10', 'yes'),
	(23, 'date_format', 'F j, Y', 'yes'),
	(24, 'time_format', 'g:i a', 'yes'),
	(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
	(26, 'comment_moderation', '', 'yes'),
	(27, 'moderation_notify', '1', 'yes'),
	(28, 'permalink_structure', '/%category%/%postname%/', 'yes'),
	(29, 'rewrite_rules', 'a:97:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:31:".+?/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:41:".+?/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:61:".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:37:".+?/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:22:"(.+?)/([^/]+)/embed/?$";s:63:"index.php?category_name=$matches[1]&name=$matches[2]&embed=true";s:26:"(.+?)/([^/]+)/trackback/?$";s:57:"index.php?category_name=$matches[1]&name=$matches[2]&tb=1";s:46:"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]";s:41:"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]";s:34:"(.+?)/([^/]+)/page/?([0-9]{1,})/?$";s:70:"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]";s:41:"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$";s:70:"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]";s:30:"(.+?)/([^/]+)(?:/([0-9]+))?/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]";s:20:".+?/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:30:".+?/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:50:".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:45:".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:45:".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:26:".+?/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:38:"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:33:"(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:14:"(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:26:"(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:33:"(.+?)/comment-page-([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&cpage=$matches[2]";s:8:"(.+?)/?$";s:35:"index.php?category_name=$matches[1]";}', 'yes'),
	(30, 'hack_file', '0', 'yes'),
	(31, 'blog_charset', 'UTF-8', 'yes'),
	(32, 'moderation_keys', '', 'no'),
	(33, 'active_plugins', 'a:1:{i:0;s:30:"advanced-custom-fields/acf.php";}', 'yes'),
	(34, 'category_base', '', 'yes'),
	(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
	(36, 'comment_max_links', '2', 'yes'),
	(37, 'gmt_offset', '0', 'yes'),
	(38, 'default_email_category', '1', 'yes'),
	(39, 'recently_edited', 'a:5:{i:0;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/temas/style.css";i:2;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/temas/lapa.php";i:3;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/temas/footer.php";i:4;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/temas/functions.php";i:5;s:0:"";}', 'no'),
	(40, 'template', 'temas', 'yes'),
	(41, 'stylesheet', 'temas', 'yes'),
	(42, 'comment_registration', '', 'yes'),
	(43, 'html_type', 'text/html', 'yes'),
	(44, 'use_trackback', '0', 'yes'),
	(45, 'default_role', 'subscriber', 'yes'),
	(46, 'db_version', '57155', 'yes'),
	(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
	(48, 'upload_path', '', 'yes'),
	(49, 'blog_public', '0', 'yes'),
	(50, 'default_link_category', '2', 'yes'),
	(51, 'show_on_front', 'posts', 'yes'),
	(52, 'tag_base', '', 'yes'),
	(53, 'show_avatars', '1', 'yes'),
	(54, 'avatar_rating', 'G', 'yes'),
	(55, 'upload_url_path', '', 'yes'),
	(56, 'thumbnail_size_w', '150', 'yes'),
	(57, 'thumbnail_size_h', '150', 'yes'),
	(58, 'thumbnail_crop', '1', 'yes'),
	(59, 'medium_size_w', '300', 'yes'),
	(60, 'medium_size_h', '300', 'yes'),
	(61, 'avatar_default', 'mystery', 'yes'),
	(62, 'large_size_w', '1024', 'yes'),
	(63, 'large_size_h', '1024', 'yes'),
	(64, 'image_default_link_type', 'none', 'yes'),
	(65, 'image_default_size', '', 'yes'),
	(66, 'image_default_align', '', 'yes'),
	(67, 'close_comments_for_old_posts', '', 'yes'),
	(68, 'close_comments_days_old', '14', 'yes'),
	(69, 'thread_comments', '1', 'yes'),
	(70, 'thread_comments_depth', '5', 'yes'),
	(71, 'page_comments', '', 'yes'),
	(72, 'comments_per_page', '50', 'yes'),
	(73, 'default_comments_page', 'newest', 'yes'),
	(74, 'comment_order', 'asc', 'yes'),
	(75, 'sticky_posts', 'a:0:{}', 'yes'),
	(76, 'widget_categories', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
	(77, 'widget_text', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
	(78, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
	(79, 'uninstall_plugins', 'a:0:{}', 'no'),
	(80, 'timezone_string', '', 'yes'),
	(81, 'page_for_posts', '0', 'yes'),
	(82, 'page_on_front', '0', 'yes'),
	(83, 'default_post_format', '0', 'yes'),
	(84, 'link_manager_enabled', '0', 'yes'),
	(85, 'finished_splitting_shared_terms', '1', 'yes'),
	(86, 'site_icon', '0', 'yes'),
	(87, 'medium_large_size_w', '768', 'yes'),
	(88, 'medium_large_size_h', '0', 'yes'),
	(89, 'wp_page_for_privacy_policy', '3', 'yes'),
	(90, 'show_comments_cookies_opt_in', '1', 'yes'),
	(91, 'admin_email_lifespan', '1720340321', 'yes'),
	(92, 'disallowed_keys', '', 'no'),
	(93, 'comment_previously_approved', '1', 'yes'),
	(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
	(95, 'auto_update_core_dev', 'enabled', 'yes'),
	(96, 'auto_update_core_minor', 'enabled', 'yes'),
	(97, 'auto_update_core_major', 'enabled', 'yes'),
	(98, 'wp_force_deactivated_plugins', 'a:0:{}', 'yes'),
	(99, 'wp_attachment_pages_enabled', '0', 'yes'),
	(100, 'initial_db_version', '56657', 'yes'),
	(101, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:61:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'),
	(102, 'fresh_site', '0', 'yes'),
	(103, 'user_count', '1', 'no'),
	(104, 'widget_block', 'a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}', 'yes'),
	(105, 'sidebars_widgets', 'a:2:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:13:"array_version";i:3;}', 'yes'),
	(106, 'cron', 'a:8:{i:1725345604;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1725351521;a:1:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725351522;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1725351534;a:3:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725351535;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725437922;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1725561247;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}', 'yes'),
	(107, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(108, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(109, 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(110, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(111, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(112, 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(113, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(114, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(115, 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(116, 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(117, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(118, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(119, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(120, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(121, '_transient_wp_core_block_css_files', 'a:2:{s:7:"version";s:5:"6.4.2";s:5:"files";a:500:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:20:"block/editor-rtl.css";i:29;s:24:"block/editor-rtl.min.css";i:30;s:16:"block/editor.css";i:31;s:20:"block/editor.min.css";i:32;s:21:"button/editor-rtl.css";i:33;s:25:"button/editor-rtl.min.css";i:34;s:17:"button/editor.css";i:35;s:21:"button/editor.min.css";i:36;s:20:"button/style-rtl.css";i:37;s:24:"button/style-rtl.min.css";i:38;s:16:"button/style.css";i:39;s:20:"button/style.min.css";i:40;s:22:"buttons/editor-rtl.css";i:41;s:26:"buttons/editor-rtl.min.css";i:42;s:18:"buttons/editor.css";i:43;s:22:"buttons/editor.min.css";i:44;s:21:"buttons/style-rtl.css";i:45;s:25:"buttons/style-rtl.min.css";i:46;s:17:"buttons/style.css";i:47;s:21:"buttons/style.min.css";i:48;s:22:"calendar/style-rtl.css";i:49;s:26:"calendar/style-rtl.min.css";i:50;s:18:"calendar/style.css";i:51;s:22:"calendar/style.min.css";i:52;s:25:"categories/editor-rtl.css";i:53;s:29:"categories/editor-rtl.min.css";i:54;s:21:"categories/editor.css";i:55;s:25:"categories/editor.min.css";i:56;s:24:"categories/style-rtl.css";i:57;s:28:"categories/style-rtl.min.css";i:58;s:20:"categories/style.css";i:59;s:24:"categories/style.min.css";i:60;s:19:"code/editor-rtl.css";i:61;s:23:"code/editor-rtl.min.css";i:62;s:15:"code/editor.css";i:63;s:19:"code/editor.min.css";i:64;s:18:"code/style-rtl.css";i:65;s:22:"code/style-rtl.min.css";i:66;s:14:"code/style.css";i:67;s:18:"code/style.min.css";i:68;s:18:"code/theme-rtl.css";i:69;s:22:"code/theme-rtl.min.css";i:70;s:14:"code/theme.css";i:71;s:18:"code/theme.min.css";i:72;s:22:"columns/editor-rtl.css";i:73;s:26:"columns/editor-rtl.min.css";i:74;s:18:"columns/editor.css";i:75;s:22:"columns/editor.min.css";i:76;s:21:"columns/style-rtl.css";i:77;s:25:"columns/style-rtl.min.css";i:78;s:17:"columns/style.css";i:79;s:21:"columns/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:30:"comment-template/style-rtl.css";i:85;s:34:"comment-template/style-rtl.min.css";i:86;s:26:"comment-template/style.css";i:87;s:30:"comment-template/style.min.css";i:88;s:42:"comments-pagination-numbers/editor-rtl.css";i:89;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:90;s:38:"comments-pagination-numbers/editor.css";i:91;s:42:"comments-pagination-numbers/editor.min.css";i:92;s:34:"comments-pagination/editor-rtl.css";i:93;s:38:"comments-pagination/editor-rtl.min.css";i:94;s:30:"comments-pagination/editor.css";i:95;s:34:"comments-pagination/editor.min.css";i:96;s:33:"comments-pagination/style-rtl.css";i:97;s:37:"comments-pagination/style-rtl.min.css";i:98;s:29:"comments-pagination/style.css";i:99;s:33:"comments-pagination/style.min.css";i:100;s:29:"comments-title/editor-rtl.css";i:101;s:33:"comments-title/editor-rtl.min.css";i:102;s:25:"comments-title/editor.css";i:103;s:29:"comments-title/editor.min.css";i:104;s:23:"comments/editor-rtl.css";i:105;s:27:"comments/editor-rtl.min.css";i:106;s:19:"comments/editor.css";i:107;s:23:"comments/editor.min.css";i:108;s:22:"comments/style-rtl.css";i:109;s:26:"comments/style-rtl.min.css";i:110;s:18:"comments/style.css";i:111;s:22:"comments/style.min.css";i:112;s:20:"cover/editor-rtl.css";i:113;s:24:"cover/editor-rtl.min.css";i:114;s:16:"cover/editor.css";i:115;s:20:"cover/editor.min.css";i:116;s:19:"cover/style-rtl.css";i:117;s:23:"cover/style-rtl.min.css";i:118;s:15:"cover/style.css";i:119;s:19:"cover/style.min.css";i:120;s:22:"details/editor-rtl.css";i:121;s:26:"details/editor-rtl.min.css";i:122;s:18:"details/editor.css";i:123;s:22:"details/editor.min.css";i:124;s:21:"details/style-rtl.css";i:125;s:25:"details/style-rtl.min.css";i:126;s:17:"details/style.css";i:127;s:21:"details/style.min.css";i:128;s:20:"embed/editor-rtl.css";i:129;s:24:"embed/editor-rtl.min.css";i:130;s:16:"embed/editor.css";i:131;s:20:"embed/editor.min.css";i:132;s:19:"embed/style-rtl.css";i:133;s:23:"embed/style-rtl.min.css";i:134;s:15:"embed/style.css";i:135;s:19:"embed/style.min.css";i:136;s:19:"embed/theme-rtl.css";i:137;s:23:"embed/theme-rtl.min.css";i:138;s:15:"embed/theme.css";i:139;s:19:"embed/theme.min.css";i:140;s:19:"file/editor-rtl.css";i:141;s:23:"file/editor-rtl.min.css";i:142;s:15:"file/editor.css";i:143;s:19:"file/editor.min.css";i:144;s:18:"file/style-rtl.css";i:145;s:22:"file/style-rtl.min.css";i:146;s:14:"file/style.css";i:147;s:18:"file/style.min.css";i:148;s:23:"footnotes/style-rtl.css";i:149;s:27:"footnotes/style-rtl.min.css";i:150;s:19:"footnotes/style.css";i:151;s:23:"footnotes/style.min.css";i:152;s:23:"freeform/editor-rtl.css";i:153;s:27:"freeform/editor-rtl.min.css";i:154;s:19:"freeform/editor.css";i:155;s:23:"freeform/editor.min.css";i:156;s:22:"gallery/editor-rtl.css";i:157;s:26:"gallery/editor-rtl.min.css";i:158;s:18:"gallery/editor.css";i:159;s:22:"gallery/editor.min.css";i:160;s:21:"gallery/style-rtl.css";i:161;s:25:"gallery/style-rtl.min.css";i:162;s:17:"gallery/style.css";i:163;s:21:"gallery/style.min.css";i:164;s:21:"gallery/theme-rtl.css";i:165;s:25:"gallery/theme-rtl.min.css";i:166;s:17:"gallery/theme.css";i:167;s:21:"gallery/theme.min.css";i:168;s:20:"group/editor-rtl.css";i:169;s:24:"group/editor-rtl.min.css";i:170;s:16:"group/editor.css";i:171;s:20:"group/editor.min.css";i:172;s:19:"group/style-rtl.css";i:173;s:23:"group/style-rtl.min.css";i:174;s:15:"group/style.css";i:175;s:19:"group/style.min.css";i:176;s:19:"group/theme-rtl.css";i:177;s:23:"group/theme-rtl.min.css";i:178;s:15:"group/theme.css";i:179;s:19:"group/theme.min.css";i:180;s:21:"heading/style-rtl.css";i:181;s:25:"heading/style-rtl.min.css";i:182;s:17:"heading/style.css";i:183;s:21:"heading/style.min.css";i:184;s:19:"html/editor-rtl.css";i:185;s:23:"html/editor-rtl.min.css";i:186;s:15:"html/editor.css";i:187;s:19:"html/editor.min.css";i:188;s:20:"image/editor-rtl.css";i:189;s:24:"image/editor-rtl.min.css";i:190;s:16:"image/editor.css";i:191;s:20:"image/editor.min.css";i:192;s:19:"image/style-rtl.css";i:193;s:23:"image/style-rtl.min.css";i:194;s:15:"image/style.css";i:195;s:19:"image/style.min.css";i:196;s:19:"image/theme-rtl.css";i:197;s:23:"image/theme-rtl.min.css";i:198;s:15:"image/theme.css";i:199;s:19:"image/theme.min.css";i:200;s:29:"latest-comments/style-rtl.css";i:201;s:33:"latest-comments/style-rtl.min.css";i:202;s:25:"latest-comments/style.css";i:203;s:29:"latest-comments/style.min.css";i:204;s:27:"latest-posts/editor-rtl.css";i:205;s:31:"latest-posts/editor-rtl.min.css";i:206;s:23:"latest-posts/editor.css";i:207;s:27:"latest-posts/editor.min.css";i:208;s:26:"latest-posts/style-rtl.css";i:209;s:30:"latest-posts/style-rtl.min.css";i:210;s:22:"latest-posts/style.css";i:211;s:26:"latest-posts/style.min.css";i:212;s:18:"list/style-rtl.css";i:213;s:22:"list/style-rtl.min.css";i:214;s:14:"list/style.css";i:215;s:18:"list/style.min.css";i:216;s:25:"media-text/editor-rtl.css";i:217;s:29:"media-text/editor-rtl.min.css";i:218;s:21:"media-text/editor.css";i:219;s:25:"media-text/editor.min.css";i:220;s:24:"media-text/style-rtl.css";i:221;s:28:"media-text/style-rtl.min.css";i:222;s:20:"media-text/style.css";i:223;s:24:"media-text/style.min.css";i:224;s:19:"more/editor-rtl.css";i:225;s:23:"more/editor-rtl.min.css";i:226;s:15:"more/editor.css";i:227;s:19:"more/editor.min.css";i:228;s:30:"navigation-link/editor-rtl.css";i:229;s:34:"navigation-link/editor-rtl.min.css";i:230;s:26:"navigation-link/editor.css";i:231;s:30:"navigation-link/editor.min.css";i:232;s:29:"navigation-link/style-rtl.css";i:233;s:33:"navigation-link/style-rtl.min.css";i:234;s:25:"navigation-link/style.css";i:235;s:29:"navigation-link/style.min.css";i:236;s:33:"navigation-submenu/editor-rtl.css";i:237;s:37:"navigation-submenu/editor-rtl.min.css";i:238;s:29:"navigation-submenu/editor.css";i:239;s:33:"navigation-submenu/editor.min.css";i:240;s:25:"navigation/editor-rtl.css";i:241;s:29:"navigation/editor-rtl.min.css";i:242;s:21:"navigation/editor.css";i:243;s:25:"navigation/editor.min.css";i:244;s:24:"navigation/style-rtl.css";i:245;s:28:"navigation/style-rtl.min.css";i:246;s:20:"navigation/style.css";i:247;s:24:"navigation/style.min.css";i:248;s:23:"nextpage/editor-rtl.css";i:249;s:27:"nextpage/editor-rtl.min.css";i:250;s:19:"nextpage/editor.css";i:251;s:23:"nextpage/editor.min.css";i:252;s:24:"page-list/editor-rtl.css";i:253;s:28:"page-list/editor-rtl.min.css";i:254;s:20:"page-list/editor.css";i:255;s:24:"page-list/editor.min.css";i:256;s:23:"page-list/style-rtl.css";i:257;s:27:"page-list/style-rtl.min.css";i:258;s:19:"page-list/style.css";i:259;s:23:"page-list/style.min.css";i:260;s:24:"paragraph/editor-rtl.css";i:261;s:28:"paragraph/editor-rtl.min.css";i:262;s:20:"paragraph/editor.css";i:263;s:24:"paragraph/editor.min.css";i:264;s:23:"paragraph/style-rtl.css";i:265;s:27:"paragraph/style-rtl.min.css";i:266;s:19:"paragraph/style.css";i:267;s:23:"paragraph/style.min.css";i:268;s:25:"post-author/style-rtl.css";i:269;s:29:"post-author/style-rtl.min.css";i:270;s:21:"post-author/style.css";i:271;s:25:"post-author/style.min.css";i:272;s:33:"post-comments-form/editor-rtl.css";i:273;s:37:"post-comments-form/editor-rtl.min.css";i:274;s:29:"post-comments-form/editor.css";i:275;s:33:"post-comments-form/editor.min.css";i:276;s:32:"post-comments-form/style-rtl.css";i:277;s:36:"post-comments-form/style-rtl.min.css";i:278;s:28:"post-comments-form/style.css";i:279;s:32:"post-comments-form/style.min.css";i:280;s:23:"post-date/style-rtl.css";i:281;s:27:"post-date/style-rtl.min.css";i:282;s:19:"post-date/style.css";i:283;s:23:"post-date/style.min.css";i:284;s:27:"post-excerpt/editor-rtl.css";i:285;s:31:"post-excerpt/editor-rtl.min.css";i:286;s:23:"post-excerpt/editor.css";i:287;s:27:"post-excerpt/editor.min.css";i:288;s:26:"post-excerpt/style-rtl.css";i:289;s:30:"post-excerpt/style-rtl.min.css";i:290;s:22:"post-excerpt/style.css";i:291;s:26:"post-excerpt/style.min.css";i:292;s:34:"post-featured-image/editor-rtl.css";i:293;s:38:"post-featured-image/editor-rtl.min.css";i:294;s:30:"post-featured-image/editor.css";i:295;s:34:"post-featured-image/editor.min.css";i:296;s:33:"post-featured-image/style-rtl.css";i:297;s:37:"post-featured-image/style-rtl.min.css";i:298;s:29:"post-featured-image/style.css";i:299;s:33:"post-featured-image/style.min.css";i:300;s:34:"post-navigation-link/style-rtl.css";i:301;s:38:"post-navigation-link/style-rtl.min.css";i:302;s:30:"post-navigation-link/style.css";i:303;s:34:"post-navigation-link/style.min.css";i:304;s:28:"post-template/editor-rtl.css";i:305;s:32:"post-template/editor-rtl.min.css";i:306;s:24:"post-template/editor.css";i:307;s:28:"post-template/editor.min.css";i:308;s:27:"post-template/style-rtl.css";i:309;s:31:"post-template/style-rtl.min.css";i:310;s:23:"post-template/style.css";i:311;s:27:"post-template/style.min.css";i:312;s:24:"post-terms/style-rtl.css";i:313;s:28:"post-terms/style-rtl.min.css";i:314;s:20:"post-terms/style.css";i:315;s:24:"post-terms/style.min.css";i:316;s:24:"post-title/style-rtl.css";i:317;s:28:"post-title/style-rtl.min.css";i:318;s:20:"post-title/style.css";i:319;s:24:"post-title/style.min.css";i:320;s:26:"preformatted/style-rtl.css";i:321;s:30:"preformatted/style-rtl.min.css";i:322;s:22:"preformatted/style.css";i:323;s:26:"preformatted/style.min.css";i:324;s:24:"pullquote/editor-rtl.css";i:325;s:28:"pullquote/editor-rtl.min.css";i:326;s:20:"pullquote/editor.css";i:327;s:24:"pullquote/editor.min.css";i:328;s:23:"pullquote/style-rtl.css";i:329;s:27:"pullquote/style-rtl.min.css";i:330;s:19:"pullquote/style.css";i:331;s:23:"pullquote/style.min.css";i:332;s:23:"pullquote/theme-rtl.css";i:333;s:27:"pullquote/theme-rtl.min.css";i:334;s:19:"pullquote/theme.css";i:335;s:23:"pullquote/theme.min.css";i:336;s:39:"query-pagination-numbers/editor-rtl.css";i:337;s:43:"query-pagination-numbers/editor-rtl.min.css";i:338;s:35:"query-pagination-numbers/editor.css";i:339;s:39:"query-pagination-numbers/editor.min.css";i:340;s:31:"query-pagination/editor-rtl.css";i:341;s:35:"query-pagination/editor-rtl.min.css";i:342;s:27:"query-pagination/editor.css";i:343;s:31:"query-pagination/editor.min.css";i:344;s:30:"query-pagination/style-rtl.css";i:345;s:34:"query-pagination/style-rtl.min.css";i:346;s:26:"query-pagination/style.css";i:347;s:30:"query-pagination/style.min.css";i:348;s:25:"query-title/style-rtl.css";i:349;s:29:"query-title/style-rtl.min.css";i:350;s:21:"query-title/style.css";i:351;s:25:"query-title/style.min.css";i:352;s:20:"query/editor-rtl.css";i:353;s:24:"query/editor-rtl.min.css";i:354;s:16:"query/editor.css";i:355;s:20:"query/editor.min.css";i:356;s:19:"query/style-rtl.css";i:357;s:23:"query/style-rtl.min.css";i:358;s:15:"query/style.css";i:359;s:19:"query/style.min.css";i:360;s:19:"quote/style-rtl.css";i:361;s:23:"quote/style-rtl.min.css";i:362;s:15:"quote/style.css";i:363;s:19:"quote/style.min.css";i:364;s:19:"quote/theme-rtl.css";i:365;s:23:"quote/theme-rtl.min.css";i:366;s:15:"quote/theme.css";i:367;s:19:"quote/theme.min.css";i:368;s:23:"read-more/style-rtl.css";i:369;s:27:"read-more/style-rtl.min.css";i:370;s:19:"read-more/style.css";i:371;s:23:"read-more/style.min.css";i:372;s:18:"rss/editor-rtl.css";i:373;s:22:"rss/editor-rtl.min.css";i:374;s:14:"rss/editor.css";i:375;s:18:"rss/editor.min.css";i:376;s:17:"rss/style-rtl.css";i:377;s:21:"rss/style-rtl.min.css";i:378;s:13:"rss/style.css";i:379;s:17:"rss/style.min.css";i:380;s:21:"search/editor-rtl.css";i:381;s:25:"search/editor-rtl.min.css";i:382;s:17:"search/editor.css";i:383;s:21:"search/editor.min.css";i:384;s:20:"search/style-rtl.css";i:385;s:24:"search/style-rtl.min.css";i:386;s:16:"search/style.css";i:387;s:20:"search/style.min.css";i:388;s:20:"search/theme-rtl.css";i:389;s:24:"search/theme-rtl.min.css";i:390;s:16:"search/theme.css";i:391;s:20:"search/theme.min.css";i:392;s:24:"separator/editor-rtl.css";i:393;s:28:"separator/editor-rtl.min.css";i:394;s:20:"separator/editor.css";i:395;s:24:"separator/editor.min.css";i:396;s:23:"separator/style-rtl.css";i:397;s:27:"separator/style-rtl.min.css";i:398;s:19:"separator/style.css";i:399;s:23:"separator/style.min.css";i:400;s:23:"separator/theme-rtl.css";i:401;s:27:"separator/theme-rtl.min.css";i:402;s:19:"separator/theme.css";i:403;s:23:"separator/theme.min.css";i:404;s:24:"shortcode/editor-rtl.css";i:405;s:28:"shortcode/editor-rtl.min.css";i:406;s:20:"shortcode/editor.css";i:407;s:24:"shortcode/editor.min.css";i:408;s:24:"site-logo/editor-rtl.css";i:409;s:28:"site-logo/editor-rtl.min.css";i:410;s:20:"site-logo/editor.css";i:411;s:24:"site-logo/editor.min.css";i:412;s:23:"site-logo/style-rtl.css";i:413;s:27:"site-logo/style-rtl.min.css";i:414;s:19:"site-logo/style.css";i:415;s:23:"site-logo/style.min.css";i:416;s:27:"site-tagline/editor-rtl.css";i:417;s:31:"site-tagline/editor-rtl.min.css";i:418;s:23:"site-tagline/editor.css";i:419;s:27:"site-tagline/editor.min.css";i:420;s:25:"site-title/editor-rtl.css";i:421;s:29:"site-title/editor-rtl.min.css";i:422;s:21:"site-title/editor.css";i:423;s:25:"site-title/editor.min.css";i:424;s:24:"site-title/style-rtl.css";i:425;s:28:"site-title/style-rtl.min.css";i:426;s:20:"site-title/style.css";i:427;s:24:"site-title/style.min.css";i:428;s:26:"social-link/editor-rtl.css";i:429;s:30:"social-link/editor-rtl.min.css";i:430;s:22:"social-link/editor.css";i:431;s:26:"social-link/editor.min.css";i:432;s:27:"social-links/editor-rtl.css";i:433;s:31:"social-links/editor-rtl.min.css";i:434;s:23:"social-links/editor.css";i:435;s:27:"social-links/editor.min.css";i:436;s:26:"social-links/style-rtl.css";i:437;s:30:"social-links/style-rtl.min.css";i:438;s:22:"social-links/style.css";i:439;s:26:"social-links/style.min.css";i:440;s:21:"spacer/editor-rtl.css";i:441;s:25:"spacer/editor-rtl.min.css";i:442;s:17:"spacer/editor.css";i:443;s:21:"spacer/editor.min.css";i:444;s:20:"spacer/style-rtl.css";i:445;s:24:"spacer/style-rtl.min.css";i:446;s:16:"spacer/style.css";i:447;s:20:"spacer/style.min.css";i:448;s:20:"table/editor-rtl.css";i:449;s:24:"table/editor-rtl.min.css";i:450;s:16:"table/editor.css";i:451;s:20:"table/editor.min.css";i:452;s:19:"table/style-rtl.css";i:453;s:23:"table/style-rtl.min.css";i:454;s:15:"table/style.css";i:455;s:19:"table/style.min.css";i:456;s:19:"table/theme-rtl.css";i:457;s:23:"table/theme-rtl.min.css";i:458;s:15:"table/theme.css";i:459;s:19:"table/theme.min.css";i:460;s:23:"tag-cloud/style-rtl.css";i:461;s:27:"tag-cloud/style-rtl.min.css";i:462;s:19:"tag-cloud/style.css";i:463;s:23:"tag-cloud/style.min.css";i:464;s:28:"template-part/editor-rtl.css";i:465;s:32:"template-part/editor-rtl.min.css";i:466;s:24:"template-part/editor.css";i:467;s:28:"template-part/editor.min.css";i:468;s:27:"template-part/theme-rtl.css";i:469;s:31:"template-part/theme-rtl.min.css";i:470;s:23:"template-part/theme.css";i:471;s:27:"template-part/theme.min.css";i:472;s:30:"term-description/style-rtl.css";i:473;s:34:"term-description/style-rtl.min.css";i:474;s:26:"term-description/style.css";i:475;s:30:"term-description/style.min.css";i:476;s:27:"text-columns/editor-rtl.css";i:477;s:31:"text-columns/editor-rtl.min.css";i:478;s:23:"text-columns/editor.css";i:479;s:27:"text-columns/editor.min.css";i:480;s:26:"text-columns/style-rtl.css";i:481;s:30:"text-columns/style-rtl.min.css";i:482;s:22:"text-columns/style.css";i:483;s:26:"text-columns/style.min.css";i:484;s:19:"verse/style-rtl.css";i:485;s:23:"verse/style-rtl.min.css";i:486;s:15:"verse/style.css";i:487;s:19:"verse/style.min.css";i:488;s:20:"video/editor-rtl.css";i:489;s:24:"video/editor-rtl.min.css";i:490;s:16:"video/editor.css";i:491;s:20:"video/editor.min.css";i:492;s:19:"video/style-rtl.css";i:493;s:23:"video/style-rtl.min.css";i:494;s:15:"video/style.css";i:495;s:19:"video/style.min.css";i:496;s:19:"video/theme-rtl.css";i:497;s:23:"video/theme-rtl.min.css";i:498;s:15:"video/theme.css";i:499;s:19:"video/theme.min.css";}}', 'yes'),
	(123, 'recovery_keys', 'a:0:{}', 'yes'),
	(127, 'theme_mods_twentytwentyfour', 'a:4:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1705008347;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}s:19:"wp_classic_sidebars";a:0:{}s:18:"nav_menu_locations";a:0:{}}', 'no'),
	(151, 'finished_updating_comment_type', '1', 'yes'),
	(152, 'current_theme', '', 'yes'),
	(153, 'theme_mods_temas', 'a:4:{i:0;b:0;s:18:"nav_menu_locations";a:2:{s:9:"main-menu";i:6;s:11:"footer-menu";i:0;}s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1705008343;s:4:"data";a:1:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}}}}', 'yes'),
	(154, 'theme_switched', '', 'yes'),
	(164, 'wp_calendar_block_has_published_posts', '1', 'yes'),
	(211, 'https_detection_errors', 'a:2:{s:23:"ssl_verification_failed";a:1:{i:0;s:24:"SSL verification failed.";}s:19:"bad_response_source";a:1:{i:0;s:55:"It looks like the response did not come from this site.";}}', 'yes'),
	(212, '_transient_health-check-site-status-result', '{"good":17,"recommended":5,"critical":1}', 'yes'),
	(229, 'recovery_mode_email_last_sent', '1704991176', 'yes'),
	(236, '_transient_timeout_dirsize_cache', '2020352419', 'no'),
	(237, '_transient_dirsize_cache', 'a:309:{s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/blue";i:77778;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/coffee";i:75892;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/ectoplasm";i:77742;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/light";i:78474;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/midnight";i:78486;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/modern";i:77989;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/ocean";i:75229;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors/sunrise";i:78407;s:57:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css/colors";i:643556;s:50:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/css";i:2517729;s:53:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/images";i:412436;s:55:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/includes";i:3032936;s:57:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/js/widgets";i:139380;s:49:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/js";i:1929744;s:52:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/maint";i:7592;s:54:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/network";i:125258;s:51:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin/user";i:3418;s:46:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-admin";i:8946348;s:48:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content";i:28;s:56:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/assets";i:25344;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/block-patterns";i:8843;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/block-supports";i:108965;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/archives";i:1671;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/audio";i:3542;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/avatar";i:2156;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/block";i:5038;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/button";i:25521;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/buttons";i:11092;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/calendar";i:3750;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/categories";i:2771;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/code";i:2576;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/column";i:1525;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/columns";i:9084;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-author-name";i:1138;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-content";i:1369;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-date";i:1058;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-edit-link";i:1159;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-reply-link";i:1001;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comment-template";i:2856;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments";i:28882;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments-pagination";i:8439;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments-pagination-next";i:957;s:84:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments-pagination-numbers";i:1779;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments-pagination-previous";i:969;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/comments-title";i:1646;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/cover";i:84691;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/details";i:2005;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/embed";i:11032;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/file";i:10458;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/footnotes";i:2531;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/freeform";i:41936;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/gallery";i:74915;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/group";i:13130;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/heading";i:5721;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/home-link";i:1076;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/html";i:3678;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/image";i:71443;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/latest-comments";i:6603;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/latest-posts";i:11200;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/legacy-widget";i:501;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/list";i:2063;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/list-item";i:876;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/loginout";i:828;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/media-text";i:13734;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/missing";i:564;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/more";i:3698;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/navigation";i:133186;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/navigation-link";i:10951;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/navigation-submenu";i:5812;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/nextpage";i:2985;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/page-list";i:7792;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/page-list-item";i:1055;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/paragraph";i:6850;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/pattern";i:336;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-author";i:2841;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-author-biography";i:917;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-author-name";i:1064;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-comments-form";i:9575;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-content";i:1009;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-date";i:1323;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-excerpt";i:2871;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-featured-image";i:26362;s:77:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-navigation-link";i:3865;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-template";i:9000;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-terms";i:1661;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/post-title";i:1824;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/preformatted";i:1652;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/pullquote";i:7773;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query";i:16382;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-no-results";i:845;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-pagination";i:9465;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-pagination-next";i:985;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-pagination-numbers";i:1887;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-pagination-previous";i:997;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/query-title";i:1393;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/quote";i:6270;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/read-more";i:2280;s:60:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/rss";i:5023;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/search";i:17268;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/separator";i:5308;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/shortcode";i:3216;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/site-logo";i:16209;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/site-tagline";i:1516;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/site-title";i:2253;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/social-link";i:2290;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/social-links";i:53196;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/spacer";i:4647;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/table";i:28464;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/tag-cloud";i:3446;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/template-part";i:8427;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/term-description";i:1697;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/text-columns";i:2980;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/verse";i:1844;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/video";i:11501;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks/widget-group";i:319;s:56:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/blocks";i:1462574;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/certificates";i:233231;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/block-directory";i:15034;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/block-editor";i:615321;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/block-library";i:804556;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/commands";i:12638;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/components";i:352551;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/customize-widgets";i:27076;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/edit-post";i:219684;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/edit-site";i:404246;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/edit-widgets";i:117832;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/editor";i:74740;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/format-library";i:7080;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/list-reusable-blocks";i:17714;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/nux";i:11478;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/patterns";i:4816;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/reusable-blocks";i:2076;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist/widgets";i:23542;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css/dist";i:2710384;s:53:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/css";i:3356433;s:59:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/customize";i:175188;s:55:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/fonts";i:305179;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/html-api";i:154919;s:53:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/ID3";i:1155209;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/images/crystal";i:15541;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/images/media";i:2419;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/images/smilies";i:10082;s:56:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/images";i:99334;s:53:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/IXR";i:33915;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/codemirror";i:1287141;s:57:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/crop";i:20004;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/dist/development";i:174586;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/dist/vendor";i:2976435;s:57:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/dist";i:20601973;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/imgareaselect";i:49553;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/jcrop";i:24976;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/jquery/ui";i:808535;s:59:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/jquery";i:1326271;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/mediaelement/renderers";i:18880;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/mediaelement";i:721307;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/plupload";i:489844;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/swfupload";i:8715;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/thickbox";i:31233;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/langs";i:15529;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/charmap";i:31811;s:80:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/colorpicker";i:4910;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/compat3x/css";i:8179;s:77:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/compat3x";i:21758;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/directionality";i:2749;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/fullscreen";i:7779;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/hr";i:1347;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/image";i:55874;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/link";i:32949;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/lists";i:97383;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/media";i:57914;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/paste";i:113193;s:77:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/tabfocus";i:5336;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/textcolor";i:16237;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wordpress";i:50628;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpautoresize";i:8332;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpdialogs";i:3761;s:80:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpeditimage";i:37711;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpemoji";i:5099;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpgallery";i:4806;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wplink";i:26476;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wptextpattern";i:11923;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins/wpview";i:8985;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/plugins";i:606961;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins/lightgray/fonts";i:155760;s:80:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins/lightgray/img";i:2856;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins/lightgray";i:210254;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins/wordpress/images";i:14207;s:76:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins/wordpress";i:22831;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/skins";i:233085;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/themes/inlite";i:452642;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/themes/modern";i:446221;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/themes";i:898863;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce/utils";i:18822;s:60:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js/tinymce";i:2853651;s:52:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/js";i:29831197;s:60:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/php-compat";i:1251;s:59:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/PHPMailer";i:228579;s:54:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/pomo";i:54208;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/library";i:261;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Auth";i:2541;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Cookie";i:4363;s:77:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Exception/Http";i:16715;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Exception/Transport";i:1397;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Exception";i:22464;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Proxy";i:4217;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Response";i:3101;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Transport";i:35060;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src/Utility";i:7176;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests/src";i:214155;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Requests";i:214416;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/rest-api/endpoints";i:779742;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/rest-api/fields";i:22340;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/rest-api/search";i:15908;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/rest-api";i:906471;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Cache";i:39607;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Content/Type";i:8015;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Content";i:8015;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Decode/HTML";i:17241;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Decode";i:17241;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/HTTP";i:11487;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Net";i:7493;s:65:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/Parse";i:20551;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/XML/Declaration";i:7098;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie/XML";i:7098;s:59:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/SimplePie";i:458625;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sitemaps/providers";i:16754;s:58:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sitemaps";i:46652;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/lib";i:87360;s:88:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced/Core/ChaCha20";i:224;s:93:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge";i:602;s:90:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced/Core/Curve25519";i:820;s:88:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced/Core/Poly1305";i:112;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced/Core";i:2444;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/namespaced";i:2698;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/Base64";i:22135;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/ChaCha20";i:5264;s:86:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/Curve25519/Ge";i:7881;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/Curve25519";i:121645;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/Poly1305";i:12912;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core/SecretStream";i:3624;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core";i:452743;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32/ChaCha20";i:6407;s:88:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32/Curve25519/Ge";i:8177;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32/Curve25519";i:122690;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32/Poly1305";i:15965;s:87:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32/SecretStream";i:3656;s:74:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/Core32";i:437041;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src/PHP52";i:4116;s:67:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat/src";i:1207254;s:63:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/sodium_compat";i:1303525;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/style-engine";i:42972;s:66:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Text/Diff/Engine";i:31802;s:68:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Text/Diff/Renderer";i:5528;s:59:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Text/Diff";i:44136;s:54:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/Text";i:57048;s:62:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/theme-compat";i:15446;s:57:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes/widgets";i:158520;s:49:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-includes";i:47517931;s:37:"C:\\xampp\\htdocs\\bootstrapprakseraivis";i:56649151;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/temas";i:22778;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/css";i:357;s:91:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/fonts/cardo";i:388180;s:101:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/fonts/instrument-sans";i:187522;s:91:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/fonts/inter";i:331004;s:90:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/fonts/jost";i:116852;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/fonts";i:1023558;s:86:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets/images";i:1152100;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/assets";i:2176015;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/parts";i:1322;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/patterns";i:155627;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/styles";i:33892;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour/templates";i:12593;s:72:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentyfour";i:3367930;s:94:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets/fonts/dm-sans";i:79121;s:100:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets/fonts/ibm-plex-mono";i:148118;s:92:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets/fonts/inter";i:807760;s:103:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets/fonts/source-serif-pro";i:1409152;s:86:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets/fonts";i:2444151;s:80:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/assets";i:2444151;s:79:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/parts";i:727;s:82:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/patterns";i:9142;s:80:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/styles";i:52622;s:83:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree/templates";i:10626;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentythree";i:2631273;s:92:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/fonts/dm-sans";i:301601;s:93:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/fonts/ibm-plex";i:423403;s:90:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/fonts/inter";i:809786;s:101:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/fonts/source-serif-pro";i:1409152;s:84:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/fonts";i:4348514;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/images";i:1453963;s:85:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets/videos";i:468755;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/assets";i:6271232;s:84:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/inc/patterns";i:158029;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/inc";i:161972;s:77:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/parts";i:2724;s:78:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/styles";i:11351;s:81:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo/templates";i:13966;s:71:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes/twentytwentytwo";i:6645615;s:55:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/themes";i:12667624;s:70:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet/views";i:39133;s:75:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet/_inc/fonts";i:2193;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet/_inc/img";i:17542;s:73:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet/_inc/rtl";i:19825;s:69:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet/_inc";i:83530;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins/akismet";i:320699;s:56:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/plugins";i:323305;s:64:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/uploads/2024/01";i:4751803;s:61:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/uploads/2024";i:4751803;s:56:"C:\\xampp\\htdocs\\bootstrapprakseraivis/wp-content/uploads";i:4751803;}', 'no'),
	(246, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
	(256, 'recently_activated', 'a:0:{}', 'yes'),
	(271, 'gutenberg_version_migration', '9.8.0', 'yes'),
	(423, 'category_children', 'a:0:{}', 'yes'),
	(466, 'acf_version', '6.2.5', 'yes'),
	(524, 'custom_category_children', 'a:0:{}', 'yes'),
	(538, 'auto_core_update_notified', 'a:4:{s:4:"type";s:7:"success";s:5:"email";s:16:"raivis@gmail.com";s:7:"version";s:5:"6.6.1";s:9:"timestamp";i:1724888798;}', 'no'),
	(583, 'db_upgraded', '1', 'yes'),
	(597, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.1.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.1.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-6.6.1-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-6.6.1-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.6.1";s:7:"version";s:5:"6.6.1";s:11:"php_version";s:6:"7.2.24";s:13:"mysql_version";s:5:"5.5.5";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1725342987;s:15:"version_checked";s:5:"6.6.1";s:12:"translations";a:0:{}}', 'off'),
	(600, '_site_transient_timeout_php_check_da775d00ae55849f14f81cf79fc50d46', '1725493599', 'no'),
	(601, '_site_transient_php_check_da775d00ae55849f14f81cf79fc50d46', 'a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}', 'no'),
	(606, '_site_transient_timeout_theme_roots', '1725344790', 'off'),
	(607, '_site_transient_theme_roots', 'a:4:{s:5:"temas";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";s:15:"twentytwentytwo";s:7:"/themes";}', 'off'),
	(608, '_site_transient_update_themes', 'O:8:"stdClass":5:{s:12:"last_checked";i:1725342992;s:7:"checked";a:4:{s:5:"temas";s:0:"";s:16:"twentytwentyfour";s:3:"1.0";s:17:"twentytwentythree";s:3:"1.3";s:15:"twentytwentytwo";s:3:"1.6";}s:8:"response";a:3:{s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.2";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.2.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}s:17:"twentytwentythree";a:6:{s:5:"theme";s:17:"twentytwentythree";s:11:"new_version";s:3:"1.5";s:3:"url";s:47:"https://wordpress.org/themes/twentytwentythree/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/twentytwentythree.1.5.zip";s:8:"requires";s:3:"6.1";s:12:"requires_php";s:3:"5.6";}s:15:"twentytwentytwo";a:6:{s:5:"theme";s:15:"twentytwentytwo";s:11:"new_version";s:3:"1.8";s:3:"url";s:45:"https://wordpress.org/themes/twentytwentytwo/";s:7:"package";s:61:"https://downloads.wordpress.org/theme/twentytwentytwo.1.8.zip";s:8:"requires";s:3:"5.9";s:12:"requires_php";s:3:"5.6";}}s:9:"no_update";a:0:{}s:12:"translations";a:0:{}}', 'off'),
	(609, '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1725342993;s:8:"response";a:2:{s:30:"advanced-custom-fields/acf.php";O:8:"stdClass":13:{s:2:"id";s:36:"w.org/plugins/advanced-custom-fields";s:4:"slug";s:22:"advanced-custom-fields";s:6:"plugin";s:30:"advanced-custom-fields/acf.php";s:11:"new_version";s:5:"6.3.6";s:3:"url";s:53:"https://wordpress.org/plugins/advanced-custom-fields/";s:7:"package";s:71:"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.3.6.zip";s:5:"icons";a:2:{s:2:"1x";s:67:"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3096880";s:3:"svg";s:67:"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3096880";}s:7:"banners";a:2:{s:2:"2x";s:78:"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=3096880";s:2:"1x";s:77:"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=3096880";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"6.0";s:6:"tested";s:5:"6.6.1";s:12:"requires_php";s:3:"7.4";s:16:"requires_plugins";a:0:{}}s:19:"akismet/akismet.php";O:8:"stdClass":13:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"5.3.3";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.5.3.3.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";s:6:"tested";s:5:"6.6.1";s:12:"requires_php";s:6:"5.6.20";s:16:"requires_plugins";a:0:{}}}s:12:"translations";a:0:{}s:9:"no_update";a:1:{s:9:"hello.php";O:8:"stdClass":10:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:5:"1.7.2";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855";s:2:"1x";s:64:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582";s:2:"1x";s:66:"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.6";}}s:7:"checked";a:3:{s:30:"advanced-custom-fields/acf.php";s:5:"6.2.5";s:19:"akismet/akismet.php";s:3:"5.3";s:9:"hello.php";s:5:"1.7.2";}}', 'off'),
	(610, '_site_transient_timeout_wp_theme_files_patterns-f4c401de3989c8ab0587cde1c0c2c12c', '1725344823', 'off'),
	(612, '_site_transient_wp_theme_files_patterns-f4c401de3989c8ab0587cde1c0c2c12c', 'a:2:{s:7:"version";s:0:"";s:8:"patterns";a:0:{}}', 'off');

-- Dumping structure for table bootstrapprakseraivis.wp_postmeta
CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=402 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_postmeta: ~165 rows (approximately)
INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
	(3, 6, '_wp_attached_file', '2024/01/hollow2023.png'),
	(4, 6, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:22:"2024/01/hollow2023.png";s:8:"filesize";i:587438;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(5, 7, '_wp_attached_file', '2024/01/Macabre.jpg'),
	(6, 7, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:19:"2024/01/Macabre.jpg";s:8:"filesize";i:72453;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(7, 8, '_wp_attached_file', '2024/01/roundhollow.png'),
	(8, 8, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:1000;s:4:"file";s:23:"2024/01/roundhollow.png";s:8:"filesize";i:406964;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(9, 9, '_wp_attached_file', '2024/01/TowerOfFantasy.png'),
	(10, 9, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:26:"2024/01/TowerOfFantasy.png";s:8:"filesize";i:867328;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(15, 11, '_edit_lock', '1705498201:1'),
	(17, 13, '_edit_lock', '1705498196:1'),
	(19, 15, '_edit_lock', '1705498186:1'),
	(21, 15, '_edit_last', '1'),
	(23, 13, '_edit_last', '1'),
	(25, 11, '_edit_last', '1'),
	(39, 27, '_edit_lock', '1705501926:1'),
	(48, 27, '_edit_last', '1'),
	(49, 27, '_wp_page_template', 'aboutpage.php'),
	(50, 29, '_wp_attached_file', '2024/01/Youtube.png'),
	(51, 29, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:2048;s:6:"height";i:2048;s:4:"file";s:19:"2024/01/Youtube.png";s:8:"filesize";i:327815;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(61, 15, '_wp_old_slug', 'posts-3'),
	(63, 13, '_wp_old_slug', 'posts-2'),
	(65, 11, '_wp_old_slug', 'posts-1'),
	(75, 41, '_wp_attached_file', '2024/01/Hollow-2023-Rewind-Thumbnail.png'),
	(76, 41, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:40:"2024/01/Hollow-2023-Rewind-Thumbnail.png";s:8:"filesize";i:587438;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(78, 43, '_wp_attached_file', '2024/01/Youtube-1.png'),
	(79, 43, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:2048;s:6:"height";i:2048;s:4:"file";s:21:"2024/01/Youtube-1.png";s:8:"filesize";i:327815;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(85, 48, '_wp_attached_file', '2024/01/Snapshot_55.png'),
	(86, 48, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:23:"2024/01/Snapshot_55.png";s:8:"filesize";i:1574552;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(135, 63, '_menu_item_type', 'taxonomy'),
	(136, 63, '_menu_item_menu_item_parent', '0'),
	(137, 63, '_menu_item_object_id', '2'),
	(138, 63, '_menu_item_object', 'category'),
	(139, 63, '_menu_item_target', ''),
	(140, 63, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(141, 63, '_menu_item_xfn', ''),
	(142, 63, '_menu_item_url', ''),
	(144, 64, '_menu_item_type', 'taxonomy'),
	(145, 64, '_menu_item_menu_item_parent', '0'),
	(146, 64, '_menu_item_object_id', '3'),
	(147, 64, '_menu_item_object', 'category'),
	(148, 64, '_menu_item_target', ''),
	(149, 64, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(150, 64, '_menu_item_xfn', ''),
	(151, 64, '_menu_item_url', ''),
	(153, 65, '_menu_item_type', 'taxonomy'),
	(154, 65, '_menu_item_menu_item_parent', '0'),
	(155, 65, '_menu_item_object_id', '4'),
	(156, 65, '_menu_item_object', 'category'),
	(157, 65, '_menu_item_target', ''),
	(158, 65, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(159, 65, '_menu_item_xfn', ''),
	(160, 65, '_menu_item_url', ''),
	(162, 66, '_menu_item_type', 'taxonomy'),
	(163, 66, '_menu_item_menu_item_parent', '0'),
	(164, 66, '_menu_item_object_id', '5'),
	(165, 66, '_menu_item_object', 'category'),
	(166, 66, '_menu_item_target', ''),
	(167, 66, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(168, 66, '_menu_item_xfn', ''),
	(169, 66, '_menu_item_url', ''),
	(189, 15, '_thumbnail_id', '97'),
	(191, 13, '_thumbnail_id', '41'),
	(193, 11, '_thumbnail_id', '100'),
	(194, 15, '_wp_page_template', 'posts.php'),
	(197, 13, '_wp_page_template', 'posts.php'),
	(199, 11, '_wp_page_template', 'posts.php'),
	(203, 11, '_wp_old_slug', 'posts1'),
	(205, 13, '_wp_old_slug', 'posts2'),
	(207, 15, '_wp_old_slug', 'posts3'),
	(229, 88, '_edit_lock', '1705498177:1'),
	(231, 88, '_thumbnail_id', '93'),
	(232, 90, 'footnotes', ''),
	(235, 93, '_wp_attached_file', '2024/01/Black-Book-5-Belt-Thumbnail.png'),
	(236, 93, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:39:"2024/01/Black-Book-5-Belt-Thumbnail.png";s:8:"filesize";i:726507;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(239, 95, 'footnotes', ''),
	(242, 97, '_wp_attached_file', '2024/01/FinalFantasyVIIEverCrisisTutorial.MP4-Thumbnail.png'),
	(243, 97, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:59:"2024/01/FinalFantasyVIIEverCrisisTutorial.MP4-Thumbnail.png";s:8:"filesize";i:973501;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(246, 100, '_wp_attached_file', '2024/01/Enigmatic.jpg'),
	(247, 100, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:21:"2024/01/Enigmatic.jpg";s:8:"filesize";i:87145;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(249, 88, '_edit_last', '1'),
	(250, 88, '_wp_page_template', 'posts.php'),
	(252, 88, '_wp_old_date', '2024-01-17'),
	(256, 15, '_wp_old_date', '2024-01-09'),
	(258, 13, '_wp_old_date', '2024-01-09'),
	(260, 11, '_wp_old_date', '2024-01-09'),
	(266, 104, '_wp_attached_file', '2024/01/Hollow-Background-Channel.png'),
	(267, 104, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:5120;s:6:"height";i:2880;s:4:"file";s:37:"2024/01/Hollow-Background-Channel.png";s:8:"filesize";i:11109427;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(268, 106, '_wp_attached_file', '2024/01/Hollow-Background-Channel-1.png'),
	(269, 106, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:5120;s:6:"height";i:2880;s:4:"file";s:39:"2024/01/Hollow-Background-Channel-1.png";s:8:"filesize";i:11109427;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(270, 107, 'footnotes', ''),
	(271, 27, '_thumbnail_id', '106'),
	(272, 109, '_edit_lock', '1705522797:1'),
	(276, 109, '_thumbnail_id', '112'),
	(277, 112, '_wp_attached_file', '2024/01/Black-Book-4-Thumbnail.png'),
	(278, 112, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:34:"2024/01/Black-Book-4-Thumbnail.png";s:8:"filesize";i:613631;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(280, 109, '_edit_last', '1'),
	(281, 109, '_wp_page_template', 'posts.php'),
	(284, 109, '_wp_old_date', '2024-01-17'),
	(286, 114, '_edit_lock', '1705522899:1'),
	(288, 114, '_thumbnail_id', '9'),
	(289, 114, '_edit_last', '1'),
	(290, 114, '_wp_page_template', 'posts.php'),
	(292, 114, '_wp_old_date', '2024-01-17'),
	(293, 116, '_edit_lock', '1705522903:1'),
	(294, 117, '_wp_attached_file', '2024/01/Blizzard-Thumbnail.jpg'),
	(295, 117, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:30:"2024/01/Blizzard-Thumbnail.jpg";s:8:"filesize";i:207634;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(297, 116, '_thumbnail_id', '117'),
	(298, 116, '_edit_last', '1'),
	(299, 116, '_wp_page_template', 'posts.php'),
	(301, 116, '_wp_old_date', '2024-01-17'),
	(312, 63, '_wp_old_date', '2024-01-11'),
	(313, 64, '_wp_old_date', '2024-01-11'),
	(314, 65, '_wp_old_date', '2024-01-11'),
	(315, 66, '_wp_old_date', '2024-01-11'),
	(316, 121, '_edit_lock', '1705523667:1'),
	(317, 122, '_wp_attached_file', '2024/01/PB-Attempts-Solar-Sprint-NFS-Payback-Thumbnail.png'),
	(318, 122, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:58:"2024/01/PB-Attempts-Solar-Sprint-NFS-Payback-Thumbnail.png";s:8:"filesize";i:914679;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(320, 121, '_thumbnail_id', '122'),
	(321, 121, '_edit_last', '1'),
	(322, 121, '_wp_page_template', 'posts.php'),
	(339, 127, '_edit_last', '1'),
	(340, 127, '_edit_lock', '1706012429:1'),
	(341, 128, '_edit_last', '1'),
	(342, 128, '_edit_lock', '1706012417:1'),
	(343, 129, '_edit_lock', '1706191745:1'),
	(344, 129, '_edit_last', '1'),
	(345, 129, '_wp_page_template', 'videos.php'),
	(346, 128, '_thumbnail_id', '93'),
	(347, 127, '_thumbnail_id', '122'),
	(348, 131, '_edit_last', '1'),
	(349, 131, '_edit_lock', '1706012409:1'),
	(350, 131, '_thumbnail_id', '97'),
	(351, 132, '_edit_last', '1'),
	(352, 132, '_edit_lock', '1706012401:1'),
	(353, 132, '_thumbnail_id', '41'),
	(354, 133, '_edit_last', '1'),
	(355, 133, '_edit_lock', '1706012393:1'),
	(356, 133, '_thumbnail_id', '100'),
	(357, 134, '_edit_last', '1'),
	(358, 134, '_edit_lock', '1706105308:1'),
	(359, 134, '_thumbnail_id', '112'),
	(360, 135, '_edit_last', '1'),
	(361, 135, '_edit_lock', '1706191061:1'),
	(362, 135, '_thumbnail_id', '9'),
	(363, 136, '_edit_last', '1'),
	(364, 136, '_edit_lock', '1706105291:1'),
	(365, 136, '_thumbnail_id', '117'),
	(368, 136, 'check_box_1', 'a:1:{i:0;s:5:"music";}'),
	(369, 136, '_check_box_1', 'field_65afaa1ece57a'),
	(370, 135, 'check_box_1', 'a:3:{i:0;s:6:"series";i:1;s:6:"gaming";i:2;s:5:"funny";}'),
	(371, 135, '_check_box_1', 'field_65afaa1ece57a'),
	(372, 134, 'check_box_1', 'a:2:{i:0;s:6:"series";i:1;s:6:"gaming";}'),
	(373, 134, '_check_box_1', 'field_65afaa1ece57a'),
	(374, 133, 'check_box_1', 'a:1:{i:0;s:5:"music";}'),
	(375, 133, '_check_box_1', 'field_65afaa1ece57a'),
	(376, 132, 'check_box_1', 'a:4:{i:0;s:5:"music";i:1;s:6:"series";i:2;s:6:"gaming";i:3;s:5:"funny";}'),
	(377, 132, '_check_box_1', 'field_65afaa1ece57a'),
	(378, 131, 'check_box_1', 'a:3:{i:0;s:6:"series";i:1;s:6:"gaming";i:2;s:5:"funny";}'),
	(379, 131, '_check_box_1', 'field_65afaa1ece57a'),
	(380, 128, 'check_box_1', 'a:2:{i:0;s:6:"series";i:1;s:6:"gaming";}'),
	(381, 128, '_check_box_1', 'field_65afaa1ece57a'),
	(382, 127, 'check_box_1', 'a:2:{i:0;s:6:"gaming";i:1;s:5:"funny";}'),
	(383, 127, '_check_box_1', 'field_65afaa1ece57a'),
	(384, 139, '_edit_last', '1'),
	(385, 139, '_edit_lock', '1707068833:1');

-- Dumping structure for table bootstrapprakseraivis.wp_posts
CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_posts: ~91 rows (approximately)
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
	(4, 0, '2024-01-09 08:18:43', '2024-01-09 08:18:43', '<!-- wp:page-list /-->', 'Navigation', '', 'publish', 'closed', 'closed', '', 'navigation', '', '', '2024-01-09 08:18:43', '2024-01-09 08:18:43', '', 0, 'http://localhost/bootstrapprakseraivis/2024/01/09/navigation/', 0, 'wp_navigation', '', 0),
	(6, 1, '2024-01-09 08:22:18', '2024-01-09 08:22:18', '', 'hollow2023', '', 'inherit', 'open', 'closed', '', 'hollow2023', '', '', '2024-01-09 08:22:18', '2024-01-09 08:22:18', '', 0, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/hollow2023.png', 0, 'attachment', 'image/png', 0),
	(7, 1, '2024-01-09 08:22:18', '2024-01-09 08:22:18', '', 'Macabre', '', 'inherit', 'open', 'closed', '', 'macabre', '', '', '2024-01-09 08:22:18', '2024-01-09 08:22:18', '', 0, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Macabre.jpg', 0, 'attachment', 'image/jpeg', 0),
	(8, 1, '2024-01-09 08:22:19', '2024-01-09 08:22:19', '', 'roundhollow', '', 'inherit', 'open', 'closed', '', 'roundhollow', '', '', '2024-01-09 08:22:19', '2024-01-09 08:22:19', '', 0, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/roundhollow.png', 0, 'attachment', 'image/png', 0),
	(9, 1, '2024-01-09 08:22:19', '2024-01-09 08:22:19', '', 'TowerOfFantasy', '', 'inherit', 'open', 'closed', '', 'toweroffantasy', '', '', '2024-01-09 08:22:19', '2024-01-09 08:22:19', '', 0, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/TowerOfFantasy.png', 0, 'attachment', 'image/png', 0),
	(11, 1, '2023-12-16 21:15:37', '2023-12-16 21:15:37', '<!-- wp:paragraph -->\n<p>The 1 hour version of Enigmatic.</p>\n<!-- /wp:paragraph -->', 'Enigmatic | 1 Hour Version', '', 'publish', 'closed', 'closed', '', 'post1', '', '', '2024-01-17 13:30:01', '2024-01-17 13:30:01', '', 0, 'http://localhost/bootstrapprakseraivis/?p=11', 0, 'post', '', 0),
	(12, 1, '2024-01-09 08:26:37', '2024-01-09 08:26:37', '', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 08:26:37', '2024-01-09 08:26:37', '', 11, 'http://localhost/bootstrapprakseraivis/?p=12', 0, 'revision', '', 0),
	(13, 1, '2023-12-23 21:15:54', '2023-12-23 21:15:54', '<!-- wp:paragraph -->\n<p>This is a recap video of all that I\'ve uploaded on my channel in 2023! It has been a great year for me, because I passed my first milestone - 10k views. Thank you everyone that has supported me on this channel and I hope I can keep you entertained with my uploads in the following year!</p>\n<!-- /wp:paragraph -->', 'A Hollow 2023 Rewind', '', 'publish', 'open', 'open', '', 'post2', '', '', '2024-01-17 13:29:56', '2024-01-17 13:29:56', '', 0, 'http://localhost/bootstrapprakseraivis/?p=13', 0, 'post', '', 0),
	(14, 1, '2024-01-09 08:26:54', '2024-01-09 08:26:54', '', 'Posts 2', '', 'inherit', 'closed', 'closed', '', '13-revision-v1', '', '', '2024-01-09 08:26:54', '2024-01-09 08:26:54', '', 13, 'http://localhost/bootstrapprakseraivis/?p=14', 0, 'revision', '', 0),
	(15, 1, '2023-12-29 21:15:02', '2023-12-29 21:15:02', '<!-- wp:paragraph -->\n<p>Compilation of funny moments and memes in my first gameplay of Final Fantasy VII Ever Crisis.</p>\n<!-- /wp:paragraph -->', 'FinalFantasyVIIEverCrisisTutorial.MP4', '', 'publish', 'open', 'open', '', 'post3', '', '', '2024-01-17 13:29:46', '2024-01-17 13:29:46', '', 0, 'http://localhost/bootstrapprakseraivis/?p=15', 0, 'post', '', 0),
	(16, 1, '2024-01-09 08:27:02', '2024-01-09 08:27:02', '', 'Posts 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-09 08:27:02', '2024-01-09 08:27:02', '', 15, 'http://localhost/bootstrapprakseraivis/?p=16', 0, 'revision', '', 0),
	(27, 1, '2024-01-09 08:29:42', '2024-01-09 08:29:42', '<!-- wp:paragraph -->\n<p>Hollow, but deadly..<br>In this channel you can find music, meme, gameplay and other types of content.</p>\n<!-- /wp:paragraph -->', 'About', '', 'publish', 'closed', 'closed', '', 'about', '', '', '2024-01-17 14:32:05', '2024-01-17 14:32:05', '', 0, 'http://localhost/bootstrapprakseraivis/?page_id=27', 0, 'page', '', 0),
	(28, 1, '2024-01-09 08:29:42', '2024-01-09 08:29:42', '', 'Lapa', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2024-01-09 08:29:42', '2024-01-09 08:29:42', '', 27, 'http://localhost/bootstrapprakseraivis/?p=28', 0, 'revision', '', 0),
	(29, 1, '2024-01-09 09:07:34', '2024-01-09 09:07:34', '', 'Youtube', '', 'inherit', '', 'closed', '', 'youtube', '', '', '2024-01-09 09:07:34', '2024-01-09 09:07:34', '', 0, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Youtube.png', 0, 'attachment', 'image/png', 0),
	(30, 1, '2024-01-09 09:25:05', '2024-01-09 09:25:05', '?>\n<!DOCTYPE html>\n<html lang="en">\n\n<head>\n  <meta charset="UTF-8">\n  <meta name="viewport" content="width=device-width, initial-scale=1.0">\n  <title>Bootstrap demo</title>\n  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"\n    integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">\n  <style>\n    /* Your existing CSS styles */\n  </style>\n</head>\n\n<body>\n  <nav class="navbar navbar-expand-lg navbar-light bg-light">\n    <div class="container-fluid">\n      <!-- Icon on the left side of the navbar -->\n      <a class="navbar-brand" href="sakums.html">\n        <img src="roundhollow.png" alt="Icon" width="80" height="80" class="d-inline-block align-text-top">\n      </a>\n\n      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"\n        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">\n        <span class="navbar-toggler-icon"></span>\n      </button>\n\n      <div class="collapse navbar-collapse justify-content-center" id="navbarNav">\n        <ul class="navbar-nav">\n          <li class="nav-item">\n            <a class="nav-link" href="sakums.html">Sākums</a>\n          </li>\n          <li class="nav-item dropdown">\n            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"\n              aria-expanded="false">\n              Kategoriju izvēlne\n            </a>\n            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">\n              <li><a class="dropdown-item" href="kategorija1.html">Kategorija 1</a></li>\n              <li><a class="dropdown-item" href="kategorija2.html">Kategorija 2</a></li>\n              <li><a class="dropdown-item" href="kategorija3.html">Kategorija 3</a></li>\n              <li><a class="dropdown-item" href="kategorija4.html">Kategorija 4</a></li>\n            </ul>\n          </li>\n          <li class="nav-item">\n            <a class="nav-link" href="lapa.html">Lapa</a>\n          </li>\n        </ul>\n      </div>\n\n      <div class="text-size-buttons">\n        <button id="size100" class="btn btn-primary me-2">100%</button>\n        <button id="size200" class="btn btn-primary">200%</button>\n      </div>\n    </div>\n  </nav>\n\n  <div class="container mt-3">\n    <div class="row">\n      <div class="col-md-8">\n        <!-- Elements on the top right -->\n        <h1>Hollow 2023 Rewind</h1>\n        <p>\n          Kategorijas: <a href="kategorija1.html">Kategorija 1</a>,\n          <a href="kategorija2.html">Kategorija 2</a>,\n          <a href="kategorija3.html">Kategorija 3</a>\n        </p>\n        <p>28.12.2023</p>\n      </div>\n      <div class="col-md-4">\n        <!-- Image on the right side -->\n        <img src="hollow2023.PNG" class="img-fluid" alt="Image">\n      </div>\n    </div>\n\n    <div class="row mt-3">\n      <div class="col-md-12">\n        <!-- Paragraph content -->\n        <p>\n          This is a recap video of all that I\'ve uploaded on my channel in 2023! It has been a great year for me, because I passed my first milestone - 10k views. Thank you everyone that has supported me on this channel and I hope I can keep you entertained with my uploads in the following year!\n        </p>\n      </div>\n    </div>\n  </div>\n\n  <!-- Footer -->\n  <footer class="navbar navbar-expand-lg navbar-light bg-light fixed-bottom">\n    <div class="container-fluid">\n      <!-- Logo on the left side of the footer -->\n      <a class="navbar-brand" href="sakums.html">\n        <img src="roundhollow.png" alt="Icon" width="50" height="50" class="d-inline-block align-text-top">\n      </a>\n\n      <!-- Title on the right side of the footer -->\n      <span class="navbar-text ms-auto">\n        BootstrapPrakse\n      </span>\n    </div>\n  </footer>\n\n  <!-- Bootstrap JS and your script -->\n  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"\n    integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>\n  <script>\n    const size100Button = document.getElementById(\'size100\');\n    const size200Button = document.getElementById(\'size200\');\n\n    // Function to change text size\n    function changeTextSize(size) {\n      document.body.style.fontSize = size;\n      const dropdownItems = document.querySelectorAll(\'.dropdown-item\');\n      dropdownItems.forEach(item => {\n        item.style.fontSize = size;\n      });\n    }\n\n    // Function to set text size to localStorage\n    function setTextSizeToStorage(size) {\n      localStorage.setItem(\'textSize\', size);\n    }\n\n    size100Button.addEventListener(\'click\', function () {\n      changeTextSize(\'100%\');\n      setTextSizeToStorage(\'100%\');\n    });\n\n    size200Button.addEventListener(\'click\', function () {\n      changeTextSize(\'200%\');\n      setTextSizeToStorage(\'200%\');\n    });\n\n    // Retrieve and apply text size from localStorage on page load\n    document.addEventListener(\'DOMContentLoaded\', function () {\n      const savedTextSize = localStorage.getItem(\'textSize\');\n      if (savedTextSize) {\n        changeTextSize(savedTextSize);\n      }\n    });\n  </script>\n</body>\n\n</html>\n', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 09:25:05', '2024-01-09 09:25:05', '', 11, 'http://localhost/bootstrapprakseraivis/?p=30', 0, 'revision', '', 0),
	(32, 1, '2024-01-09 09:26:03', '2024-01-09 09:26:03', '<?php\n/*\nTemplate Name: Posts 1\nTemplate Post Type: custompost\n*/\n?>\n<!DOCTYPE html>\n<html lang="en">\n\n<head>\n  <meta charset="UTF-8">\n  <meta name="viewport" content="width=device-width, initial-scale=1.0">\n  <title>Bootstrap demo</title>\n  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"\n    integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">\n  <style>\n    /* Your existing CSS styles */\n  </style>\n</head>\n\n<body>\n  <nav class="navbar navbar-expand-lg navbar-light bg-light">\n    <div class="container-fluid">\n      <!-- Icon on the left side of the navbar -->\n      <a class="navbar-brand" href="sakums.html">\n        <img src="roundhollow.png" alt="Icon" width="80" height="80" class="d-inline-block align-text-top">\n      </a>\n\n      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"\n        aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">\n        <span class="navbar-toggler-icon"></span>\n      </button>\n\n      <div class="collapse navbar-collapse justify-content-center" id="navbarNav">\n        <ul class="navbar-nav">\n          <li class="nav-item">\n            <a class="nav-link" href="sakums.html">Sākums</a>\n          </li>\n          <li class="nav-item dropdown">\n            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"\n              aria-expanded="false">\n              Kategoriju izvēlne\n            </a>\n            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">\n              <li><a class="dropdown-item" href="kategorija1.html">Kategorija 1</a></li>\n              <li><a class="dropdown-item" href="kategorija2.html">Kategorija 2</a></li>\n              <li><a class="dropdown-item" href="kategorija3.html">Kategorija 3</a></li>\n              <li><a class="dropdown-item" href="kategorija4.html">Kategorija 4</a></li>\n            </ul>\n          </li>\n          <li class="nav-item">\n            <a class="nav-link" href="lapa.html">Lapa</a>\n          </li>\n        </ul>\n      </div>\n\n      <div class="text-size-buttons">\n        <button id="size100" class="btn btn-primary me-2">100%</button>\n        <button id="size200" class="btn btn-primary">200%</button>\n      </div>\n    </div>\n  </nav>\n\n  <div class="container mt-3">\n    <div class="row">\n      <div class="col-md-8">\n        <!-- Elements on the top right -->\n        <h1>Hollow 2023 Rewind</h1>\n        <p>\n          Kategorijas: <a href="kategorija1.html">Kategorija 1</a>,\n          <a href="kategorija2.html">Kategorija 2</a>,\n          <a href="kategorija3.html">Kategorija 3</a>\n        </p>\n        <p>28.12.2023</p>\n      </div>\n      <div class="col-md-4">\n        <!-- Image on the right side -->\n        <img src="hollow2023.PNG" class="img-fluid" alt="Image">\n      </div>\n    </div>\n\n    <div class="row mt-3">\n      <div class="col-md-12">\n        <!-- Paragraph content -->\n        <p>\n          This is a recap video of all that I\'ve uploaded on my channel in 2023! It has been a great year for me, because I passed my first milestone - 10k views. Thank you everyone that has supported me on this channel and I hope I can keep you entertained with my uploads in the following year!\n        </p>\n      </div>\n    </div>\n  </div>\n\n  <!-- Footer -->\n  <footer class="navbar navbar-expand-lg navbar-light bg-light fixed-bottom">\n    <div class="container-fluid">\n      <!-- Logo on the left side of the footer -->\n      <a class="navbar-brand" href="sakums.html">\n        <img src="roundhollow.png" alt="Icon" width="50" height="50" class="d-inline-block align-text-top">\n      </a>\n\n      <!-- Title on the right side of the footer -->\n      <span class="navbar-text ms-auto">\n        BootstrapPrakse\n      </span>\n    </div>\n  </footer>\n\n  <!-- Bootstrap JS and your script -->\n  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"\n    integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>\n  <script>\n    const size100Button = document.getElementById(\'size100\');\n    const size200Button = document.getElementById(\'size200\');\n\n    // Function to change text size\n    function changeTextSize(size) {\n      document.body.style.fontSize = size;\n      const dropdownItems = document.querySelectorAll(\'.dropdown-item\');\n      dropdownItems.forEach(item => {\n        item.style.fontSize = size;\n      });\n    }\n\n    // Function to set text size to localStorage\n    function setTextSizeToStorage(size) {\n      localStorage.setItem(\'textSize\', size);\n    }\n\n    size100Button.addEventListener(\'click\', function () {\n      changeTextSize(\'100%\');\n      setTextSizeToStorage(\'100%\');\n    });\n\n    size200Button.addEventListener(\'click\', function () {\n      changeTextSize(\'200%\');\n      setTextSizeToStorage(\'200%\');\n    });\n\n    // Retrieve and apply text size from localStorage on page load\n    document.addEventListener(\'DOMContentLoaded\', function () {\n      const savedTextSize = localStorage.getItem(\'textSize\');\n      if (savedTextSize) {\n        changeTextSize(savedTextSize);\n      }\n    });\n  </script>\n</body>\n\n</html>\n', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 09:26:03', '2024-01-09 09:26:03', '', 11, 'http://localhost/bootstrapprakseraivis/?p=32', 0, 'revision', '', 0),
	(40, 1, '2024-01-09 11:30:27', '2024-01-09 11:30:27', '', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 11:30:27', '2024-01-09 11:30:27', '', 11, 'http://localhost/bootstrapprakseraivis/?p=40', 0, 'revision', '', 0),
	(41, 1, '2024-01-09 11:45:47', '2024-01-09 11:45:47', '', 'Hollow 2023 Rewind Thumbnail', '', 'inherit', '', 'closed', '', 'hollow-2023-rewind-thumbnail', '', '', '2024-01-09 11:45:47', '2024-01-09 11:45:47', '', 11, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Hollow-2023-Rewind-Thumbnail.png', 0, 'attachment', 'image/png', 0),
	(43, 1, '2024-01-09 11:46:01', '2024-01-09 11:46:01', '', 'Youtube', '', 'inherit', '', 'closed', '', 'youtube-2', '', '', '2024-01-09 11:46:01', '2024-01-09 11:46:01', '', 11, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Youtube-1.png', 0, 'attachment', 'image/png', 0),
	(44, 1, '2024-01-09 11:47:05', '2024-01-09 11:47:05', '<!-- wp:paragraph -->\n<p>Mango</p>\n<!-- /wp:paragraph -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 11:47:05', '2024-01-09 11:47:05', '', 11, 'http://localhost/bootstrapprakseraivis/?p=44', 0, 'revision', '', 0),
	(45, 1, '2024-01-09 11:47:14', '2024-01-09 11:47:14', '', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-09 11:47:14', '2024-01-09 11:47:14', '', 11, 'http://localhost/bootstrapprakseraivis/?p=45', 0, 'revision', '', 0),
	(46, 1, '2024-01-11 16:57:37', '2024-01-11 16:57:37', '<!-- wp:paragraph -->\n<p>Juice</p>\n<!-- /wp:paragraph -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 16:57:37', '2024-01-11 16:57:37', '', 11, 'http://localhost/bootstrapprakseraivis/?p=46', 0, 'revision', '', 0),
	(48, 1, '2024-01-11 16:58:57', '2024-01-11 16:58:57', '', 'Snapshot_55', '', 'inherit', '', 'closed', '', 'snapshot_55', '', '', '2024-01-11 16:58:57', '2024-01-11 16:58:57', '', 11, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Snapshot_55.png', 0, 'attachment', 'image/png', 0),
	(49, 1, '2024-01-11 16:59:06', '2024-01-11 16:59:06', '<!-- wp:paragraph -->\n<p>Juice</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image -->\n<figure class="wp-block-image"><img alt=""/></figure>\n<!-- /wp:image -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 16:59:06', '2024-01-11 16:59:06', '', 11, 'http://localhost/bootstrapprakseraivis/?p=49', 0, 'revision', '', 0),
	(50, 1, '2024-01-11 16:59:18', '2024-01-11 16:59:18', '', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 16:59:18', '2024-01-11 16:59:18', '', 11, 'http://localhost/bootstrapprakseraivis/?p=50', 0, 'revision', '', 0),
	(63, 1, '2024-01-17 23:19:07', '2024-01-11 17:21:33', ' ', '', '', 'publish', 'closed', 'closed', '', '63', '', '', '2024-01-17 23:19:07', '2024-01-17 23:19:07', '', 0, 'http://localhost/bootstrapprakseraivis/?p=63', 1, 'nav_menu_item', '', 0),
	(64, 1, '2024-01-17 23:19:08', '2024-01-11 17:21:33', ' ', '', '', 'publish', 'closed', 'closed', '', '64', '', '', '2024-01-17 23:19:08', '2024-01-17 23:19:08', '', 0, 'http://localhost/bootstrapprakseraivis/?p=64', 2, 'nav_menu_item', '', 0),
	(65, 1, '2024-01-17 23:19:08', '2024-01-11 17:21:33', ' ', '', '', 'publish', 'closed', 'closed', '', '65', '', '', '2024-01-17 23:19:08', '2024-01-17 23:19:08', '', 0, 'http://localhost/bootstrapprakseraivis/?p=65', 3, 'nav_menu_item', '', 0),
	(66, 1, '2024-01-17 23:19:08', '2024-01-11 17:21:33', ' ', '', '', 'publish', 'closed', 'closed', '', '66', '', '', '2024-01-17 23:19:08', '2024-01-17 23:19:08', '', 0, 'http://localhost/bootstrapprakseraivis/?p=66', 4, 'nav_menu_item', '', 0),
	(67, 1, '2024-01-11 17:24:58', '2024-01-11 17:24:58', '<!-- wp:paragraph -->\n<p>Juice</p>\n<!-- /wp:paragraph -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 17:24:58', '2024-01-11 17:24:58', '', 11, 'http://localhost/bootstrapprakseraivis/?p=67', 0, 'revision', '', 0),
	(69, 1, '2024-01-11 17:27:23', '2024-01-11 17:27:23', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 17:27:23', '2024-01-11 17:27:23', '', 11, 'http://localhost/bootstrapprakseraivis/?p=69', 0, 'revision', '', 0),
	(70, 1, '2024-01-11 17:41:22', '2024-01-11 17:41:22', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJu</p>\n<!-- /wp:paragraph -->', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 17:41:22', '2024-01-11 17:41:22', '', 11, 'http://localhost/bootstrapprakseraivis/?p=70', 0, 'revision', '', 0),
	(71, 1, '2024-01-11 19:03:34', '2024-01-11 19:03:34', '<!-- wp:paragraph -->\n<p>Grape</p>\n<!-- /wp:paragraph -->', 'Posts 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-11 19:03:34', '2024-01-11 19:03:34', '', 15, 'http://localhost/bootstrapprakseraivis/?p=71', 0, 'revision', '', 0),
	(72, 1, '2024-01-11 21:01:22', '2024-01-11 21:01:22', '<!-- wp:paragraph -->\n<p>Wiggle</p>\n<!-- /wp:paragraph -->', 'Posts 2', '', 'inherit', 'closed', 'closed', '', '13-revision-v1', '', '', '2024-01-11 21:01:22', '2024-01-11 21:01:22', '', 13, 'http://localhost/bootstrapprakseraivis/?p=72', 0, 'revision', '', 0),
	(73, 1, '2024-01-11 21:43:20', '2024-01-11 21:43:20', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJu</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 21:43:20', '2024-01-11 21:43:20', '', 11, 'http://localhost/bootstrapprakseraivis/?p=73', 0, 'revision', '', 0),
	(74, 1, '2024-01-11 21:43:25', '2024-01-11 21:43:25', '<!-- wp:paragraph -->\n<p>Wiggle</p>\n<!-- /wp:paragraph -->', 'Post 2', '', 'inherit', 'closed', 'closed', '', '13-revision-v1', '', '', '2024-01-11 21:43:25', '2024-01-11 21:43:25', '', 13, 'http://localhost/bootstrapprakseraivis/?p=74', 0, 'revision', '', 0),
	(75, 1, '2024-01-11 21:43:31', '2024-01-11 21:43:31', '<!-- wp:paragraph -->\n<p>Grape</p>\n<!-- /wp:paragraph -->', 'Post 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-11 21:43:31', '2024-01-11 21:43:31', '', 15, 'http://localhost/bootstrapprakseraivis/?p=75', 0, 'revision', '', 0),
	(76, 1, '2024-01-11 21:45:15', '2024-01-11 21:45:15', '', 'Page', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2024-01-11 21:45:15', '2024-01-11 21:45:15', '', 27, 'http://localhost/bootstrapprakseraivis/?p=76', 0, 'revision', '', 0),
	(77, 1, '2024-01-11 21:59:53', '2024-01-11 21:59:53', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 21:59:53', '2024-01-11 21:59:53', '', 11, 'http://localhost/bootstrapprakseraivis/?p=77', 0, 'revision', '', 0),
	(78, 1, '2024-01-11 21:59:56', '2024-01-11 21:59:56', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 21:59:56', '2024-01-11 21:59:56', '', 11, 'http://localhost/bootstrapprakseraivis/?p=78', 0, 'revision', '', 0),
	(79, 1, '2024-01-11 22:00:08', '2024-01-11 22:00:08', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 22:00:08', '2024-01-11 22:00:08', '', 11, 'http://localhost/bootstrapprakseraivis/?p=79', 0, 'revision', '', 0),
	(80, 1, '2024-01-11 22:00:27', '2024-01-11 22:00:27', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 22:00:27', '2024-01-11 22:00:27', '', 11, 'http://localhost/bootstrapprakseraivis/?p=80', 0, 'revision', '', 0),
	(81, 1, '2024-01-11 22:01:49', '2024-01-11 22:01:49', '<!-- wp:paragraph -->\n<p>JuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuiceJuice</p>\n<!-- /wp:paragraph -->', 'Post 1', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-11 22:01:49', '2024-01-11 22:01:49', '', 11, 'http://localhost/bootstrapprakseraivis/?p=81', 0, 'revision', '', 0),
	(85, 1, '2024-01-17 13:01:31', '2024-01-17 13:01:31', '<!-- wp:paragraph -->\n<p>Grape Grape</p>\n<!-- /wp:paragraph -->', 'Post 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-17 13:01:31', '2024-01-17 13:01:31', '', 15, 'http://localhost/bootstrapprakseraivis/?p=85', 0, 'revision', '', 0),
	(86, 1, '2024-01-17 13:01:45', '2024-01-17 13:01:45', '<!-- wp:paragraph -->\n<p>Grape Grape</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"id":29,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image size-full"><img src="http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Youtube.png" alt="" class="wp-image-29"/></figure>\n<!-- /wp:image -->', 'Post 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-17 13:01:45', '2024-01-17 13:01:45', '', 15, 'http://localhost/bootstrapprakseraivis/?p=86', 0, 'revision', '', 0),
	(87, 1, '2024-01-17 13:01:56', '2024-01-17 13:01:56', '<!-- wp:paragraph -->\n<p>Grape Grape</p>\n<!-- /wp:paragraph -->', 'Post 3', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-17 13:01:56', '2024-01-17 13:01:56', '', 15, 'http://localhost/bootstrapprakseraivis/?p=87', 0, 'revision', '', 0),
	(88, 1, '2024-01-11 21:15:24', '2024-01-11 21:15:24', '<!-- wp:paragraph -->\n<p>First adventure with the elder.. </p>\n<!-- /wp:paragraph -->', 'Belt | Black Book', '', 'publish', 'closed', 'open', '', 'post-4', '', '', '2024-01-17 13:29:37', '2024-01-17 13:29:37', '', 0, 'http://localhost/bootstrapprakseraivis/?p=88', 0, 'post', '', 0),
	(89, 1, '2024-01-17 13:10:24', '2024-01-17 13:10:24', '', 'Post 4', '', 'inherit', 'closed', 'closed', '', '88-revision-v1', '', '', '2024-01-17 13:10:24', '2024-01-17 13:10:24', '', 88, 'http://localhost/bootstrapprakseraivis/?p=89', 0, 'revision', '', 0),
	(90, 1, '2024-01-17 13:13:51', '2024-01-17 13:13:51', '<!-- wp:paragraph -->\n<p>First adventure with the elder.. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>--------------------------------------------------------------------------------------------------------------------Socials:Discord Server: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbEVhQ1VVdWxIYXlDNkFaZDFocXZDczBleWtYUXxBQ3Jtc0ttQlhiQ0tTeWVLSm0xYmhiYmU1TlVtcm84OEh0cFBOQmM4bWZJak1kZzlOMHZ4UHdCcEdLMjlnbzNPRkMtb3VWOHJucjBWZG5Ba2xNeThQdHJRVTN6QVFBTjBDZ3B6TWU4blVHUDY5SXBZa0RQV055dw&amp;q=https%3A%2F%2Fdiscord.gg%2FdFhWq4eQJC&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / discord  </a> Twitter/X: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbURLalJKSXYxWEU5YndoSjh4SHFoNWJENGJOd3xBQ3Jtc0tsbVZ0bnRGQ25DY3lLQXk5dUtKU2lTQmhNMGMyak1SN3RMMG9fVzZQZTBYZVdMTTdjNmlLZVdMZE11WjlyaHVXaWFxd2xpdGlTNTVYcWk3eFJFQm1wQlJIMXdIQkFLeXJUczVoSV9BZ1h2OGx2M000VQ&amp;q=https%3A%2F%2Ftwitter.com%2FLoyalty48052368&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / loyalty48052368  </a> Instagram: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbFdmTFRlYl9YQ241Y2hwRzZTdENMMUhaTXc5Z3xBQ3Jtc0trRDh1UHZqdkgzVUhTMWQ4S19oc0dRazZIRlMtWHU1akNxcW9PSWNqb1BvRjYwYWFhN2NHOGQzYVBadDN2aTNfTEptREY2X0JOdWZPV2ZibTR0U0ZOYXBRcjh6UGt6akpseHNQTURmcUlqRzA1X2k1aw&amp;q=https%3A%2F%2Finstagram.com%2Fh__o__l_l__o__w..&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / h__o__l_l__o__w.  </a>. TikTok: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbjBmZjhoYml0eG52aVdUV0pqR25fRmY4YWFqQXxBQ3Jtc0tuRFdLMEU4SEF5c1BqYzVsUzN5R2lHcFNiUVU0MW5VUGUxVFZ0ZEtnNXVpaG5MMmV0NFNNTTNPN0M4RU01T3dUcGhKdENXSzVnYWJrUjhBLVpQN1R1STNMZ3NZNVZXaGctM25yV2pTZlN2d2ZiS211dw&amp;q=https%3A%2F%2Fwww.tiktok.com%2F%40hoiiow__&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / hoiiow__  </a> ---------------------------------------------------------------------------------------------------------------------------</p>\n<!-- /wp:paragraph -->', 'Belt | Black Book', '', 'inherit', 'closed', 'closed', '', '88-autosave-v1', '', '', '2024-01-17 13:13:51', '2024-01-17 13:13:51', '', 88, 'http://localhost/bootstrapprakseraivis/?p=90', 0, 'revision', '', 0),
	(91, 1, '2024-01-17 13:14:15', '2024-01-17 13:14:15', '<!-- wp:paragraph -->\n<p>First adventure with the elder.. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>--------------------------------------------------------------------------------------------------------------------Socials:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Discord Server: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbEVhQ1VVdWxIYXlDNkFaZDFocXZDczBleWtYUXxBQ3Jtc0ttQlhiQ0tTeWVLSm0xYmhiYmU1TlVtcm84OEh0cFBOQmM4bWZJak1kZzlOMHZ4UHdCcEdLMjlnbzNPRkMtb3VWOHJucjBWZG5Ba2xNeThQdHJRVTN6QVFBTjBDZ3B6TWU4blVHUDY5SXBZa0RQV055dw&amp;q=https%3A%2F%2Fdiscord.gg%2FdFhWq4eQJC&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / discord  </a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Twitter/X: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbURLalJKSXYxWEU5YndoSjh4SHFoNWJENGJOd3xBQ3Jtc0tsbVZ0bnRGQ25DY3lLQXk5dUtKU2lTQmhNMGMyak1SN3RMMG9fVzZQZTBYZVdMTTdjNmlLZVdMZE11WjlyaHVXaWFxd2xpdGlTNTVYcWk3eFJFQm1wQlJIMXdIQkFLeXJUczVoSV9BZ1h2OGx2M000VQ&amp;q=https%3A%2F%2Ftwitter.com%2FLoyalty48052368&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / loyalty48052368  </a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Instagram: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbFdmTFRlYl9YQ241Y2hwRzZTdENMMUhaTXc5Z3xBQ3Jtc0trRDh1UHZqdkgzVUhTMWQ4S19oc0dRazZIRlMtWHU1akNxcW9PSWNqb1BvRjYwYWFhN2NHOGQzYVBadDN2aTNfTEptREY2X0JOdWZPV2ZibTR0U0ZOYXBRcjh6UGt6akpseHNQTURmcUlqRzA1X2k1aw&amp;q=https%3A%2F%2Finstagram.com%2Fh__o__l_l__o__w..&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / h__o__l_l__o__w.  </a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>TikTok: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbjBmZjhoYml0eG52aVdUV0pqR25fRmY4YWFqQXxBQ3Jtc0tuRFdLMEU4SEF5c1BqYzVsUzN5R2lHcFNiUVU0MW5VUGUxVFZ0ZEtnNXVpaG5MMmV0NFNNTTNPN0M4RU01T3dUcGhKdENXSzVnYWJrUjhBLVpQN1R1STNMZ3NZNVZXaGctM25yV2pTZlN2d2ZiS211dw&amp;q=https%3A%2F%2Fwww.tiktok.com%2F%40hoiiow__&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / hoiiow__  </a> </p>\n<!-- /wp:paragraph -->', 'Belt | Black Book', '', 'inherit', 'closed', 'closed', '', '88-revision-v1', '', '', '2024-01-17 13:14:15', '2024-01-17 13:14:15', '', 88, 'http://localhost/bootstrapprakseraivis/?p=91', 0, 'revision', '', 0),
	(92, 1, '2024-01-17 13:14:43', '2024-01-17 13:14:43', '<!-- wp:paragraph -->\n<p>First adventure with the elder.. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class="wp-block-heading">Socials:</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Discord Server: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbEVhQ1VVdWxIYXlDNkFaZDFocXZDczBleWtYUXxBQ3Jtc0ttQlhiQ0tTeWVLSm0xYmhiYmU1TlVtcm84OEh0cFBOQmM4bWZJak1kZzlOMHZ4UHdCcEdLMjlnbzNPRkMtb3VWOHJucjBWZG5Ba2xNeThQdHJRVTN6QVFBTjBDZ3B6TWU4blVHUDY5SXBZa0RQV055dw&amp;q=https%3A%2F%2Fdiscord.gg%2FdFhWq4eQJC&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / discord  </a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Twitter/X: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbURLalJKSXYxWEU5YndoSjh4SHFoNWJENGJOd3xBQ3Jtc0tsbVZ0bnRGQ25DY3lLQXk5dUtKU2lTQmhNMGMyak1SN3RMMG9fVzZQZTBYZVdMTTdjNmlLZVdMZE11WjlyaHVXaWFxd2xpdGlTNTVYcWk3eFJFQm1wQlJIMXdIQkFLeXJUczVoSV9BZ1h2OGx2M000VQ&amp;q=https%3A%2F%2Ftwitter.com%2FLoyalty48052368&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / loyalty48052368  </a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Instagram: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbFdmTFRlYl9YQ241Y2hwRzZTdENMMUhaTXc5Z3xBQ3Jtc0trRDh1UHZqdkgzVUhTMWQ4S19oc0dRazZIRlMtWHU1akNxcW9PSWNqb1BvRjYwYWFhN2NHOGQzYVBadDN2aTNfTEptREY2X0JOdWZPV2ZibTR0U0ZOYXBRcjh6UGt6akpseHNQTURmcUlqRzA1X2k1aw&amp;q=https%3A%2F%2Finstagram.com%2Fh__o__l_l__o__w..&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / h__o__l_l__o__w.  </a>.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>TikTok: <a href="https://www.youtube.com/redirect?event=video_description&amp;redir_token=QUFFLUhqbjBmZjhoYml0eG52aVdUV0pqR25fRmY4YWFqQXxBQ3Jtc0tuRFdLMEU4SEF5c1BqYzVsUzN5R2lHcFNiUVU0MW5VUGUxVFZ0ZEtnNXVpaG5MMmV0NFNNTTNPN0M4RU01T3dUcGhKdENXSzVnYWJrUjhBLVpQN1R1STNMZ3NZNVZXaGctM25yV2pTZlN2d2ZiS211dw&amp;q=https%3A%2F%2Fwww.tiktok.com%2F%40hoiiow__&amp;v=GY5kworcZ6g" target="_blank" rel="noreferrer noopener">  / hoiiow__  </a> </p>\n<!-- /wp:paragraph -->', 'Belt | Black Book', '', 'inherit', 'closed', 'closed', '', '88-revision-v1', '', '', '2024-01-17 13:14:43', '2024-01-17 13:14:43', '', 88, 'http://localhost/bootstrapprakseraivis/?p=92', 0, 'revision', '', 0),
	(93, 1, '2024-01-17 13:15:04', '2024-01-17 13:15:04', '', 'Black Book #5 (Belt) Thumbnail', '', 'inherit', '', 'closed', '', 'black-book-5-belt-thumbnail', '', '', '2024-01-17 13:15:04', '2024-01-17 13:15:04', '', 88, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Black-Book-5-Belt-Thumbnail.png', 0, 'attachment', 'image/png', 0),
	(94, 1, '2024-01-17 13:15:23', '2024-01-17 13:15:23', '<!-- wp:paragraph -->\n<p>First adventure with the elder.. </p>\n<!-- /wp:paragraph -->', 'Belt | Black Book', '', 'inherit', 'closed', 'closed', '', '88-revision-v1', '', '', '2024-01-17 13:15:23', '2024-01-17 13:15:23', '', 88, 'http://localhost/bootstrapprakseraivis/?p=94', 0, 'revision', '', 0),
	(95, 1, '2024-01-17 13:18:13', '2024-01-17 13:18:13', '<!-- wp:paragraph -->\n<p>Compilation of funny moments and memes in my first gameplay of Final Fantasy VII Ever Crisis </p>\n<!-- /wp:paragraph -->', 'FinalFantasyVIIEverCrisisTutorial.MP4', '', 'inherit', 'closed', 'closed', '', '15-autosave-v1', '', '', '2024-01-17 13:18:13', '2024-01-17 13:18:13', '', 15, 'http://localhost/bootstrapprakseraivis/?p=95', 0, 'revision', '', 0),
	(97, 1, '2024-01-17 13:18:53', '2024-01-17 13:18:53', '', 'FinalFantasyVIIEverCrisisTutorial.MP4 Thumbnail', '', 'inherit', '', 'closed', '', 'finalfantasyviievercrisistutorial-mp4-thumbnail', '', '', '2024-01-17 13:18:53', '2024-01-17 13:18:53', '', 15, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/FinalFantasyVIIEverCrisisTutorial.MP4-Thumbnail.png', 0, 'attachment', 'image/png', 0),
	(98, 1, '2024-01-17 13:18:56', '2024-01-17 13:18:56', '<!-- wp:paragraph -->\n<p>Compilation of funny moments and memes in my first gameplay of Final Fantasy VII Ever Crisis.</p>\n<!-- /wp:paragraph -->', 'FinalFantasyVIIEverCrisisTutorial.MP4', '', 'inherit', 'closed', 'closed', '', '15-revision-v1', '', '', '2024-01-17 13:18:56', '2024-01-17 13:18:56', '', 15, 'http://localhost/bootstrapprakseraivis/?p=98', 0, 'revision', '', 0),
	(99, 1, '2024-01-17 13:19:48', '2024-01-17 13:19:48', '<!-- wp:paragraph -->\n<p>This is a recap video of all that I\'ve uploaded on my channel in 2023! It has been a great year for me, because I passed my first milestone - 10k views. Thank you everyone that has supported me on this channel and I hope I can keep you entertained with my uploads in the following year!</p>\n<!-- /wp:paragraph -->', 'A Hollow 2023 Rewind', '', 'inherit', 'closed', 'closed', '', '13-revision-v1', '', '', '2024-01-17 13:19:48', '2024-01-17 13:19:48', '', 13, 'http://localhost/bootstrapprakseraivis/?p=99', 0, 'revision', '', 0),
	(100, 1, '2024-01-17 13:20:50', '2024-01-17 13:20:50', '', 'Enigmatic', '', 'inherit', '', 'closed', '', 'enigmatic', '', '', '2024-01-17 13:20:50', '2024-01-17 13:20:50', '', 11, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Enigmatic.jpg', 0, 'attachment', 'image/jpeg', 0),
	(101, 1, '2024-01-17 13:20:53', '2024-01-17 13:20:53', '<!-- wp:paragraph -->\n<p>The 1 hour version of Enigmatic.</p>\n<!-- /wp:paragraph -->', 'Enigmatic | 1 Hour Version', '', 'inherit', 'closed', 'closed', '', '11-revision-v1', '', '', '2024-01-17 13:20:53', '2024-01-17 13:20:53', '', 11, 'http://localhost/bootstrapprakseraivis/?p=101', 0, 'revision', '', 0),
	(102, 1, '2024-01-17 13:48:24', '2024-01-17 13:48:24', '', 'About', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2024-01-17 13:48:24', '2024-01-17 13:48:24', '', 27, 'http://localhost/bootstrapprakseraivis/?p=102', 0, 'revision', '', 0),
	(104, 1, '2024-01-17 14:15:25', '2024-01-17 14:15:25', '', 'Hollow-Background-Channel', '', 'inherit', '', 'closed', '', 'hollow-background-channel', '', '', '2024-01-17 14:15:25', '2024-01-17 14:15:25', '', 27, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Hollow-Background-Channel.png', 0, 'attachment', 'image/png', 0),
	(105, 1, '2024-01-17 14:15:27', '2024-01-17 14:15:27', '<!-- wp:paragraph -->\n<p>Hollow, but deadly..<br>In this channel you can find music, meme, gameplay and other types of content.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"id":104,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image size-full"><img src="http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Hollow-Background-Channel.png" alt="" class="wp-image-104"/></figure>\n<!-- /wp:image -->', 'About', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2024-01-17 14:15:27', '2024-01-17 14:15:27', '', 27, 'http://localhost/bootstrapprakseraivis/?p=105', 0, 'revision', '', 0),
	(106, 1, '2024-01-17 14:29:46', '2024-01-17 14:29:46', '', 'Hollow Background Channel', '', 'inherit', '', 'closed', '', 'hollow-background-channel-2', '', '', '2024-01-17 14:29:46', '2024-01-17 14:29:46', '', 27, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Hollow-Background-Channel-1.png', 0, 'attachment', 'image/png', 0),
	(107, 1, '2024-01-17 14:30:35', '2024-01-17 14:30:35', '<!-- wp:paragraph -->\n<p>Hollow, but deadly..<br>In this channel you can find music, meme, gameplay and other types of content.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"id":104,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image size-full"><img src="http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Hollow-Background-Channel.png" alt="" class="wp-image-104"/></figure>\n<!-- /wp:image -->', 'About', '', 'inherit', 'closed', 'closed', '', '27-autosave-v1', '', '', '2024-01-17 14:30:35', '2024-01-17 14:30:35', '', 27, 'http://localhost/bootstrapprakseraivis/?p=107', 0, 'revision', '', 0),
	(108, 1, '2024-01-17 14:31:14', '2024-01-17 14:31:14', '<!-- wp:paragraph -->\n<p>Hollow, but deadly..<br>In this channel you can find music, meme, gameplay and other types of content.</p>\n<!-- /wp:paragraph -->', 'About', '', 'inherit', 'closed', 'closed', '', '27-revision-v1', '', '', '2024-01-17 14:31:14', '2024-01-17 14:31:14', '', 27, 'http://localhost/bootstrapprakseraivis/?p=108', 0, 'revision', '', 0),
	(109, 1, '2023-12-13 21:15:33', '2023-12-13 21:15:33', '<!-- wp:paragraph -->\n<p>Her name is..</p>\n<!-- /wp:paragraph -->', 'Name | Black Book', '', 'publish', 'closed', 'open', '', 'test', '', '', '2024-01-17 20:19:57', '2024-01-17 20:19:57', '', 0, 'http://localhost/bootstrapprakseraivis/?p=109', 0, 'post', '', 0),
	(110, 1, '2024-01-17 20:14:33', '2024-01-17 20:14:33', '', 'Test', '', 'inherit', 'closed', 'closed', '', '109-revision-v1', '', '', '2024-01-17 20:14:33', '2024-01-17 20:14:33', '', 109, 'http://localhost/bootstrapprakseraivis/?p=110', 0, 'revision', '', 0),
	(111, 1, '2024-01-17 20:15:03', '2024-01-17 20:15:03', '<!-- wp:paragraph -->\n<p>Mango</p>\n<!-- /wp:paragraph -->', 'Test', '', 'inherit', 'closed', 'closed', '', '109-revision-v1', '', '', '2024-01-17 20:15:03', '2024-01-17 20:15:03', '', 109, 'http://localhost/bootstrapprakseraivis/?p=111', 0, 'revision', '', 0),
	(112, 1, '2024-01-17 20:18:57', '2024-01-17 20:18:57', '', 'Black Book #4 Thumbnail', '', 'inherit', '', 'closed', '', 'black-book-4-thumbnail', '', '', '2024-01-17 20:18:57', '2024-01-17 20:18:57', '', 109, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Black-Book-4-Thumbnail.png', 0, 'attachment', 'image/png', 0),
	(113, 1, '2024-01-17 20:19:00', '2024-01-17 20:19:00', '<!-- wp:paragraph -->\n<p>Her name is..</p>\n<!-- /wp:paragraph -->', 'Name | Black Book', '', 'inherit', 'closed', 'closed', '', '109-revision-v1', '', '', '2024-01-17 20:19:00', '2024-01-17 20:19:00', '', 109, 'http://localhost/bootstrapprakseraivis/?p=113', 0, 'revision', '', 0),
	(114, 1, '2023-12-10 21:15:08', '2023-12-10 21:15:08', '<!-- wp:paragraph -->\n<p>Compilation of funny moments and memes in my first gameplay of Tower Of Fantasy.</p>\n<!-- /wp:paragraph -->', 'TowerOfFantasy.MP4', '', 'publish', 'closed', 'open', '', 'toweroffantasy-mp4', '', '', '2024-01-17 20:21:39', '2024-01-17 20:21:39', '', 0, 'http://localhost/bootstrapprakseraivis/?p=114', 0, 'post', '', 0),
	(115, 1, '2024-01-17 20:21:08', '2024-01-17 20:21:08', '<!-- wp:paragraph -->\n<p>Compilation of funny moments and memes in my first gameplay of Tower Of Fantasy.</p>\n<!-- /wp:paragraph -->', 'TowerOfFantasy.MP4', '', 'inherit', 'closed', 'closed', '', '114-revision-v1', '', '', '2024-01-17 20:21:08', '2024-01-17 20:21:08', '', 114, 'http://localhost/bootstrapprakseraivis/?p=115', 0, 'revision', '', 0),
	(116, 1, '2023-12-06 21:15:38', '2023-12-06 21:15:38', '<!-- wp:paragraph -->\n<p>Blizzard. Happy Holidays Everyone!</p>\n<!-- /wp:paragraph -->', 'Blizzard', '', 'publish', 'closed', 'open', '', 'blizzard', '', '', '2024-01-17 20:23:32', '2024-01-17 20:23:32', '', 0, 'http://localhost/bootstrapprakseraivis/?p=116', 0, 'post', '', 0),
	(117, 1, '2024-01-17 20:22:35', '2024-01-17 20:22:35', '', 'Blizzard Thumbnail', '', 'inherit', '', 'closed', '', 'blizzard-thumbnail', '', '', '2024-01-17 20:22:35', '2024-01-17 20:22:35', '', 116, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/Blizzard-Thumbnail.jpg', 0, 'attachment', 'image/jpeg', 0),
	(118, 1, '2024-01-17 20:22:38', '2024-01-17 20:22:38', '<!-- wp:paragraph -->\n<p>Blizzard<br>Happy Holidays Everyone!</p>\n<!-- /wp:paragraph -->', 'Blizzard', '', 'inherit', 'closed', 'closed', '', '116-revision-v1', '', '', '2024-01-17 20:22:38', '2024-01-17 20:22:38', '', 116, 'http://localhost/bootstrapprakseraivis/?p=118', 0, 'revision', '', 0),
	(119, 1, '2024-01-17 20:23:32', '2024-01-17 20:23:32', '<!-- wp:paragraph -->\n<p>Blizzard. Happy Holidays Everyone!</p>\n<!-- /wp:paragraph -->', 'Blizzard', '', 'inherit', 'closed', 'closed', '', '116-revision-v1', '', '', '2024-01-17 20:23:32', '2024-01-17 20:23:32', '', 116, 'http://localhost/bootstrapprakseraivis/?p=119', 0, 'revision', '', 0),
	(121, 1, '2024-01-18 21:15:53', '2024-01-18 21:15:53', '<!-- wp:paragraph -->\n<p>Here are some of my NFS Payback PB attempts in the Solar Sprint race! Do I perform better when I\'m recording? Watch to find out! Sorry if it\'s a bit laggy. If a lot of you enjoy this video and I decide to make another, then I\'ll try to fix the lag.</p>\n<!-- /wp:paragraph -->', 'PB Attempts | Solar Sprint | Need For Speed Payback', '', 'publish', 'closed', 'open', '', 'pb-attempts-solar-sprint-need-for-speed-payback', '', '', '2024-01-17 20:34:27', '2024-01-17 20:34:27', '', 0, 'http://localhost/bootstrapprakseraivis/?p=121', 0, 'post', '', 0),
	(122, 1, '2024-01-17 20:33:49', '2024-01-17 20:33:49', '', 'PB Attempts Solar Sprint NFS Payback Thumbnail', '', 'inherit', '', 'closed', '', 'pb-attempts-solar-sprint-nfs-payback-thumbnail', '', '', '2024-01-17 20:33:49', '2024-01-17 20:33:49', '', 121, 'http://localhost/bootstrapprakseraivis/wp-content/uploads/2024/01/PB-Attempts-Solar-Sprint-NFS-Payback-Thumbnail.png', 0, 'attachment', 'image/png', 0),
	(123, 1, '2024-01-17 20:33:53', '2024-01-17 20:33:53', '<!-- wp:paragraph -->\n<p>Here are some of my NFS Payback PB attempts in the Solar Sprint race! Do I perform better when I\'m recording? Watch to find out! Sorry if it\'s a bit laggy. If a lot of you enjoy this video and I decide to make another, then I\'ll try to fix the lag.</p>\n<!-- /wp:paragraph -->', 'PB Attempts | Solar Sprint | Need For Speed Payback', '', 'inherit', 'closed', 'closed', '', '121-revision-v1', '', '', '2024-01-17 20:33:53', '2024-01-17 20:33:53', '', 121, 'http://localhost/bootstrapprakseraivis/?p=123', 0, 'revision', '', 0),
	(127, 1, '2024-01-23 10:41:03', '2024-01-23 10:41:03', '', 'PB Attempts | Solar Sprint | Need For Speed Payback', '', 'publish', 'closed', 'closed', '', 'pb-attempts-solar-sprint-need-for-speed-payback', '', '', '2024-01-23 12:22:52', '2024-01-23 12:22:52', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=127', 0, 'custom_post_type', '', 0),
	(128, 1, '2024-01-23 10:41:43', '2024-01-23 10:41:43', '', 'Belt | Black Book', '', 'publish', 'closed', 'closed', '', 'belt-black-book', '', '', '2024-01-23 12:22:41', '2024-01-23 12:22:41', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=128', 0, 'custom_post_type', '', 0),
	(129, 1, '2024-01-23 10:48:07', '2024-01-23 10:48:07', '', 'Videos', '', 'publish', 'closed', 'closed', '', 'videos', '', '', '2024-01-25 14:09:05', '2024-01-25 14:09:05', '', 0, 'http://localhost/bootstrapprakseraivis/?page_id=129', 0, 'page', '', 0),
	(130, 1, '2024-01-23 10:48:07', '2024-01-23 10:48:07', '', 'Videos', '', 'inherit', 'closed', 'closed', '', '129-revision-v1', '', '', '2024-01-23 10:48:07', '2024-01-23 10:48:07', '', 129, 'http://localhost/bootstrapprakseraivis/?p=130', 0, 'revision', '', 0),
	(131, 1, '2024-01-23 11:37:45', '2024-01-23 11:37:45', '', 'FinalFantasyVIIEverCrisisTutorial.MP4', '', 'publish', 'closed', 'closed', '', 'finalfantasyviievercrisistutorial-mp4', '', '', '2024-01-23 12:22:32', '2024-01-23 12:22:32', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=131', 0, 'custom_post_type', '', 0),
	(132, 1, '2024-01-23 11:38:16', '2024-01-23 11:38:16', '', 'A Hollow 2023 Rewind', '', 'publish', 'closed', 'closed', '', 'a-hollow-2023-rewind', '', '', '2024-01-23 12:22:24', '2024-01-23 12:22:24', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=132', 0, 'custom_post_type', '', 0),
	(133, 1, '2024-01-23 11:50:03', '2024-01-23 11:50:03', '', 'Enigmatic | 1 Hour Version', '', 'publish', 'closed', 'closed', '', 'enigmatic-1-hour-version', '', '', '2024-01-23 12:22:17', '2024-01-23 12:22:17', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=133', 0, 'custom_post_type', '', 0),
	(134, 1, '2024-01-23 11:51:08', '2024-01-23 11:51:08', '', 'Name | Black Book', '', 'publish', 'closed', 'closed', '', 'name-black-book', '', '', '2024-01-24 14:08:28', '2024-01-24 14:08:28', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=134', 0, 'custom_post_type', '', 0),
	(135, 1, '2024-01-23 11:52:22', '2024-01-23 11:52:22', '', 'TowerOfFantasy.MP4', '', 'publish', 'closed', 'closed', '', 'toweroffantasy-mp4', '', '', '2024-01-24 14:08:21', '2024-01-24 14:08:21', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=135', 0, 'custom_post_type', '', 0),
	(136, 1, '2024-01-23 11:52:51', '2024-01-23 11:52:51', '', 'Blizzard', '', 'publish', 'closed', 'closed', '', 'blizzard', '', '', '2024-01-24 14:08:11', '2024-01-24 14:08:11', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=custom_post_type&#038;p=136', 0, 'custom_post_type', '', 0),
	(139, 1, '2024-01-25 12:56:37', '2024-01-25 12:56:37', 'a:8:{s:8:"location";a:1:{i:0;a:1:{i:0;a:3:{s:5:"param";s:9:"post_type";s:8:"operator";s:2:"==";s:5:"value";s:16:"custom_post_type";}}}s:8:"position";s:6:"normal";s:5:"style";s:7:"default";s:15:"label_placement";s:3:"top";s:21:"instruction_placement";s:5:"label";s:14:"hide_on_screen";s:0:"";s:11:"description";s:0:"";s:12:"show_in_rest";i:0;}', 'custom_post_types_categories', 'custom_post_types_categories', 'publish', 'closed', 'closed', '', 'group_65b259d3569fe', '', '', '2024-01-25 13:01:13', '2024-01-25 13:01:13', '', 0, 'http://localhost/bootstrapprakseraivis/?post_type=acf-field-group&#038;p=139', 0, 'acf-field-group', '', 0),
	(140, 1, '2024-01-25 12:56:37', '2024-01-25 12:56:37', 'a:16:{s:10:"aria-label";s:0:"";s:4:"type";s:8:"taxonomy";s:12:"instructions";s:0:"";s:8:"required";i:0;s:17:"conditional_logic";i:0;s:7:"wrapper";a:3:{s:5:"width";s:0:"";s:5:"class";s:0:"";s:2:"id";s:0:"";}s:8:"taxonomy";s:15:"custom_category";s:8:"add_term";i:1;s:10:"save_terms";i:1;s:10:"load_terms";i:0;s:13:"return_format";s:2:"id";s:10:"field_type";s:8:"checkbox";s:13:"bidirectional";i:0;s:8:"multiple";i:0;s:10:"allow_null";i:0;s:20:"bidirectional_target";a:0:{}}', 'category', 'category', 'publish', 'closed', 'closed', '', 'field_65b259d31e847', '', '', '2024-01-25 13:01:13', '2024-01-25 13:01:13', '', 139, 'http://localhost/bootstrapprakseraivis/?post_type=acf-field&#038;p=140', 0, 'acf-field', '', 0);

-- Dumping structure for table bootstrapprakseraivis.wp_termmeta
CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_termmeta: ~0 rows (approximately)

-- Dumping structure for table bootstrapprakseraivis.wp_terms
CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_terms: ~11 rows (approximately)
INSERT INTO `wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
	(1, 'Uncategorized', 'uncategorized', 0),
	(2, 'Music', 'music', 0),
	(3, 'Funny', 'funny', 0),
	(4, 'Gaming', 'gaming', 0),
	(5, 'Series', 'series', 0),
	(6, 'Kategoriju izvēlne', 'kategoriju-izvelne', 0),
	(8, 'Test', 'test', 0),
	(10, 'Music', 'music', 0),
	(11, 'Series', 'series', 0),
	(12, 'Gaming', 'gaming', 0),
	(13, 'Funny', 'funny', 0);

-- Dumping structure for table bootstrapprakseraivis.wp_term_relationships
CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_term_relationships: ~40 rows (approximately)
INSERT INTO `wp_term_relationships` (`object_id`, `term_taxonomy_id`, `term_order`) VALUES
	(11, 2, 0),
	(13, 2, 0),
	(13, 3, 0),
	(13, 4, 0),
	(13, 5, 0),
	(15, 3, 0),
	(15, 4, 0),
	(15, 5, 0),
	(63, 6, 0),
	(64, 6, 0),
	(65, 6, 0),
	(66, 6, 0),
	(88, 4, 0),
	(88, 5, 0),
	(109, 4, 0),
	(109, 5, 0),
	(114, 3, 0),
	(114, 4, 0),
	(114, 5, 0),
	(116, 2, 0),
	(121, 3, 0),
	(121, 4, 0),
	(127, 12, 0),
	(127, 13, 0),
	(128, 11, 0),
	(128, 12, 0),
	(131, 11, 0),
	(131, 12, 0),
	(131, 13, 0),
	(132, 10, 0),
	(132, 11, 0),
	(132, 12, 0),
	(132, 13, 0),
	(133, 10, 0),
	(134, 11, 0),
	(134, 12, 0),
	(135, 11, 0),
	(135, 12, 0),
	(135, 13, 0),
	(136, 10, 0);

-- Dumping structure for table bootstrapprakseraivis.wp_term_taxonomy
CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_term_taxonomy: ~11 rows (approximately)
INSERT INTO `wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
	(1, 1, 'category', '', 0, 0),
	(2, 2, 'category', '', 0, 3),
	(3, 3, 'category', '', 0, 4),
	(4, 4, 'category', '', 0, 6),
	(5, 5, 'category', '', 0, 5),
	(6, 6, 'nav_menu', '', 0, 4),
	(8, 8, 'category', '', 0, 0),
	(10, 10, 'custom_category', '', 0, 3),
	(11, 11, 'custom_category', '', 0, 5),
	(12, 12, 'custom_category', '', 0, 6),
	(13, 13, 'custom_category', '', 0, 4);

-- Dumping structure for table bootstrapprakseraivis.wp_usermeta
CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_usermeta: ~30 rows (approximately)
INSERT INTO `wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
	(1, 1, 'nickname', 'raivis'),
	(2, 1, 'first_name', ''),
	(3, 1, 'last_name', ''),
	(4, 1, 'description', ''),
	(5, 1, 'rich_editing', 'true'),
	(6, 1, 'syntax_highlighting', 'true'),
	(7, 1, 'comment_shortcuts', 'false'),
	(8, 1, 'admin_color', 'fresh'),
	(9, 1, 'use_ssl', '0'),
	(10, 1, 'show_admin_bar_front', 'true'),
	(11, 1, 'locale', ''),
	(12, 1, 'wp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
	(13, 1, 'wp_user_level', '10'),
	(14, 1, 'dismissed_wp_pointers', 'theme_editor_notice'),
	(15, 1, 'show_welcome_panel', '0'),
	(16, 1, 'session_tokens', 'a:1:{s:64:"2fb0d5611c8d8b866c1704d9e53ef3b1753d03d514b4a110a11e724751378be8";a:4:{s:10:"expiration";i:1707215557;s:2:"ip";s:3:"::1";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0";s:5:"login";i:1706005957;}}'),
	(17, 1, 'wp_dashboard_quick_press_last_post_id', '143'),
	(18, 1, 'wp_media_library_mode', 'list'),
	(19, 1, 'wp_persisted_preferences', 'a:5:{s:4:"core";a:1:{s:29:"isTemplatePartMoveHintVisible";b:0;}s:9:"_modified";s:24:"2024-01-24T14:30:51.401Z";s:14:"core/edit-post";a:5:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;s:10:"openPanels";a:3:{i:0;s:11:"post-status";i:1;s:14:"featured-image";i:2;s:23:"taxonomy-panel-category";}s:20:"welcomeGuideTemplate";b:0;s:10:"editorMode";s:6:"visual";}s:14:"core/edit-site";a:6:{s:12:"welcomeGuide";b:0;s:26:"isComplementaryAreaVisible";b:0;s:18:"welcomeGuideStyles";b:0;s:16:"welcomeGuidePage";b:0;s:20:"welcomeGuideTemplate";b:0;s:10:"editorMode";s:6:"visual";}s:17:"core/block-editor";a:1:{s:25:"linkControlSettingsDrawer";b:0;}}'),
	(20, 1, 'edit_post_per_page', '20'),
	(21, 1, 'wp_user-settings', 'posts_list_mode=list&libraryContent=browse&editor=tinymce'),
	(22, 1, 'wp_user-settings-time', '1706006459'),
	(23, 1, 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}'),
	(24, 1, 'metaboxhidden_nav-menus', 'a:1:{i:0;s:12:"add-post_tag";}'),
	(25, 1, 'nav_menu_recently_edited', '6'),
	(26, 1, 'enable_custom_fields', ''),
	(27, 1, 'closedpostboxes_acf-field-group', 'a:0:{}'),
	(28, 1, 'metaboxhidden_acf-field-group', 'a:1:{i:0;s:7:"slugdiv";}'),
	(29, 1, 'manageedit-acf-taxonomycolumnshidden', 'a:1:{i:0;s:7:"acf-key";}'),
	(30, 1, 'acf_user_settings', 'a:1:{s:20:"taxonomies-first-run";b:1;}');

-- Dumping structure for table bootstrapprakseraivis.wp_users
CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrapprakseraivis.wp_users: ~1 rows (approximately)
INSERT INTO `wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
	(1, 'raivis', '$P$By.Qq0.ukqQvl7TL/wUcZIt2oEzxY6.', 'raivis', 'raivis@gmail.com', 'http://localhost/bootstrapprakseraivis', '2024-01-09 08:18:41', '', 0, 'raivis');


-- Dumping database structure for bootstrappraksewordpress
CREATE DATABASE IF NOT EXISTS `bootstrappraksewordpress` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `bootstrappraksewordpress`;

-- Dumping structure for table bootstrappraksewordpress.wp_commentmeta
CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_commentmeta: ~0 rows (approximately)

-- Dumping structure for table bootstrappraksewordpress.wp_comments
CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_comments: ~0 rows (approximately)

-- Dumping structure for table bootstrappraksewordpress.wp_links
CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_links: ~0 rows (approximately)

-- Dumping structure for table bootstrappraksewordpress.wp_options
CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_options: ~143 rows (approximately)
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
	(1, 'siteurl', 'http://localhost/BootstrapPrakseWordpress', 'yes'),
	(2, 'home', 'http://localhost/BootstrapPrakseWordpress', 'yes'),
	(3, 'blogname', 'BootstrapPrakseWordpress', 'yes'),
	(4, 'blogdescription', '', 'yes'),
	(5, 'users_can_register', '0', 'yes'),
	(6, 'admin_email', 'hollow@gmail.com', 'yes'),
	(7, 'start_of_week', '1', 'yes'),
	(8, 'use_balanceTags', '0', 'yes'),
	(9, 'use_smilies', '1', 'yes'),
	(10, 'require_name_email', '1', 'yes'),
	(11, 'comments_notify', '1', 'yes'),
	(12, 'posts_per_rss', '10', 'yes'),
	(13, 'rss_use_excerpt', '0', 'yes'),
	(14, 'mailserver_url', 'mail.example.com', 'yes'),
	(15, 'mailserver_login', 'login@example.com', 'yes'),
	(16, 'mailserver_pass', 'password', 'yes'),
	(17, 'mailserver_port', '110', 'yes'),
	(18, 'default_category', '1', 'yes'),
	(19, 'default_comment_status', 'open', 'yes'),
	(20, 'default_ping_status', 'open', 'yes'),
	(21, 'default_pingback_flag', '0', 'yes'),
	(22, 'posts_per_page', '10', 'yes'),
	(23, 'date_format', 'F j, Y', 'yes'),
	(24, 'time_format', 'g:i a', 'yes'),
	(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
	(26, 'comment_moderation', '0', 'yes'),
	(27, 'moderation_notify', '1', 'yes'),
	(28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
	(29, 'rewrite_rules', 'a:94:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}', 'yes'),
	(30, 'hack_file', '0', 'yes'),
	(31, 'blog_charset', 'UTF-8', 'yes'),
	(32, 'moderation_keys', '', 'no'),
	(33, 'active_plugins', 'a:0:{}', 'yes'),
	(34, 'category_base', '', 'yes'),
	(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
	(36, 'comment_max_links', '2', 'yes'),
	(37, 'gmt_offset', '0', 'yes'),
	(38, 'default_email_category', '1', 'yes'),
	(39, 'recently_edited', 'a:2:{i:0;s:93:"C:\\xampp\\htdocs\\BootstrapPrakseWordpress/wp-content/themes/BootstrapPrakseWordpress/style.css";i:1;s:0:"";}', 'no'),
	(40, 'template', 'BootstrapPrakseWordpress', 'yes'),
	(41, 'stylesheet', 'BootstrapPrakseWordpress', 'yes'),
	(42, 'comment_registration', '0', 'yes'),
	(43, 'html_type', 'text/html', 'yes'),
	(44, 'use_trackback', '0', 'yes'),
	(45, 'default_role', 'subscriber', 'yes'),
	(46, 'db_version', '57155', 'yes'),
	(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
	(48, 'upload_path', '', 'yes'),
	(49, 'blog_public', '0', 'yes'),
	(50, 'default_link_category', '2', 'yes'),
	(51, 'show_on_front', 'posts', 'yes'),
	(52, 'tag_base', '', 'yes'),
	(53, 'show_avatars', '1', 'yes'),
	(54, 'avatar_rating', 'G', 'yes'),
	(55, 'upload_url_path', '', 'yes'),
	(56, 'thumbnail_size_w', '150', 'yes'),
	(57, 'thumbnail_size_h', '150', 'yes'),
	(58, 'thumbnail_crop', '1', 'yes'),
	(59, 'medium_size_w', '300', 'yes'),
	(60, 'medium_size_h', '300', 'yes'),
	(61, 'avatar_default', 'mystery', 'yes'),
	(62, 'large_size_w', '1024', 'yes'),
	(63, 'large_size_h', '1024', 'yes'),
	(64, 'image_default_link_type', 'none', 'yes'),
	(65, 'image_default_size', '', 'yes'),
	(66, 'image_default_align', '', 'yes'),
	(67, 'close_comments_for_old_posts', '0', 'yes'),
	(68, 'close_comments_days_old', '14', 'yes'),
	(69, 'thread_comments', '1', 'yes'),
	(70, 'thread_comments_depth', '5', 'yes'),
	(71, 'page_comments', '0', 'yes'),
	(72, 'comments_per_page', '50', 'yes'),
	(73, 'default_comments_page', 'newest', 'yes'),
	(74, 'comment_order', 'asc', 'yes'),
	(75, 'sticky_posts', 'a:0:{}', 'yes'),
	(76, 'widget_categories', 'a:0:{}', 'yes'),
	(77, 'widget_text', 'a:0:{}', 'yes'),
	(78, 'widget_rss', 'a:0:{}', 'yes'),
	(79, 'uninstall_plugins', 'a:0:{}', 'no'),
	(80, 'timezone_string', '', 'yes'),
	(81, 'page_for_posts', '0', 'yes'),
	(82, 'page_on_front', '0', 'yes'),
	(83, 'default_post_format', '0', 'yes'),
	(84, 'link_manager_enabled', '0', 'yes'),
	(85, 'finished_splitting_shared_terms', '1', 'yes'),
	(86, 'site_icon', '0', 'yes'),
	(87, 'medium_large_size_w', '768', 'yes'),
	(88, 'medium_large_size_h', '0', 'yes'),
	(89, 'wp_page_for_privacy_policy', '3', 'yes'),
	(90, 'show_comments_cookies_opt_in', '1', 'yes'),
	(91, 'admin_email_lifespan', '1720280423', 'yes'),
	(92, 'disallowed_keys', '', 'no'),
	(93, 'comment_previously_approved', '1', 'yes'),
	(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
	(95, 'auto_update_core_dev', 'enabled', 'yes'),
	(96, 'auto_update_core_minor', 'enabled', 'yes'),
	(97, 'auto_update_core_major', 'enabled', 'yes'),
	(98, 'wp_force_deactivated_plugins', 'a:0:{}', 'yes'),
	(99, 'wp_attachment_pages_enabled', '0', 'yes'),
	(100, 'initial_db_version', '56657', 'yes'),
	(101, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:61:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'),
	(102, 'fresh_site', '0', 'yes'),
	(103, 'user_count', '1', 'no'),
	(104, 'widget_block', 'a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}', 'yes'),
	(105, 'sidebars_widgets', 'a:2:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:13:"array_version";i:3;}', 'yes'),
	(106, 'cron', 'a:6:{i:1725345624;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1725378024;a:5:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725378065;a:3:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725378067;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1725916238;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}', 'yes'),
	(107, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(108, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(109, 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(110, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(111, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(112, 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(113, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(114, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(115, 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(116, 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(117, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(118, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(119, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(120, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(121, '_transient_wp_core_block_css_files', 'a:2:{s:7:"version";s:5:"6.4.2";s:5:"files";a:500:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:20:"block/editor-rtl.css";i:29;s:24:"block/editor-rtl.min.css";i:30;s:16:"block/editor.css";i:31;s:20:"block/editor.min.css";i:32;s:21:"button/editor-rtl.css";i:33;s:25:"button/editor-rtl.min.css";i:34;s:17:"button/editor.css";i:35;s:21:"button/editor.min.css";i:36;s:20:"button/style-rtl.css";i:37;s:24:"button/style-rtl.min.css";i:38;s:16:"button/style.css";i:39;s:20:"button/style.min.css";i:40;s:22:"buttons/editor-rtl.css";i:41;s:26:"buttons/editor-rtl.min.css";i:42;s:18:"buttons/editor.css";i:43;s:22:"buttons/editor.min.css";i:44;s:21:"buttons/style-rtl.css";i:45;s:25:"buttons/style-rtl.min.css";i:46;s:17:"buttons/style.css";i:47;s:21:"buttons/style.min.css";i:48;s:22:"calendar/style-rtl.css";i:49;s:26:"calendar/style-rtl.min.css";i:50;s:18:"calendar/style.css";i:51;s:22:"calendar/style.min.css";i:52;s:25:"categories/editor-rtl.css";i:53;s:29:"categories/editor-rtl.min.css";i:54;s:21:"categories/editor.css";i:55;s:25:"categories/editor.min.css";i:56;s:24:"categories/style-rtl.css";i:57;s:28:"categories/style-rtl.min.css";i:58;s:20:"categories/style.css";i:59;s:24:"categories/style.min.css";i:60;s:19:"code/editor-rtl.css";i:61;s:23:"code/editor-rtl.min.css";i:62;s:15:"code/editor.css";i:63;s:19:"code/editor.min.css";i:64;s:18:"code/style-rtl.css";i:65;s:22:"code/style-rtl.min.css";i:66;s:14:"code/style.css";i:67;s:18:"code/style.min.css";i:68;s:18:"code/theme-rtl.css";i:69;s:22:"code/theme-rtl.min.css";i:70;s:14:"code/theme.css";i:71;s:18:"code/theme.min.css";i:72;s:22:"columns/editor-rtl.css";i:73;s:26:"columns/editor-rtl.min.css";i:74;s:18:"columns/editor.css";i:75;s:22:"columns/editor.min.css";i:76;s:21:"columns/style-rtl.css";i:77;s:25:"columns/style-rtl.min.css";i:78;s:17:"columns/style.css";i:79;s:21:"columns/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:30:"comment-template/style-rtl.css";i:85;s:34:"comment-template/style-rtl.min.css";i:86;s:26:"comment-template/style.css";i:87;s:30:"comment-template/style.min.css";i:88;s:42:"comments-pagination-numbers/editor-rtl.css";i:89;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:90;s:38:"comments-pagination-numbers/editor.css";i:91;s:42:"comments-pagination-numbers/editor.min.css";i:92;s:34:"comments-pagination/editor-rtl.css";i:93;s:38:"comments-pagination/editor-rtl.min.css";i:94;s:30:"comments-pagination/editor.css";i:95;s:34:"comments-pagination/editor.min.css";i:96;s:33:"comments-pagination/style-rtl.css";i:97;s:37:"comments-pagination/style-rtl.min.css";i:98;s:29:"comments-pagination/style.css";i:99;s:33:"comments-pagination/style.min.css";i:100;s:29:"comments-title/editor-rtl.css";i:101;s:33:"comments-title/editor-rtl.min.css";i:102;s:25:"comments-title/editor.css";i:103;s:29:"comments-title/editor.min.css";i:104;s:23:"comments/editor-rtl.css";i:105;s:27:"comments/editor-rtl.min.css";i:106;s:19:"comments/editor.css";i:107;s:23:"comments/editor.min.css";i:108;s:22:"comments/style-rtl.css";i:109;s:26:"comments/style-rtl.min.css";i:110;s:18:"comments/style.css";i:111;s:22:"comments/style.min.css";i:112;s:20:"cover/editor-rtl.css";i:113;s:24:"cover/editor-rtl.min.css";i:114;s:16:"cover/editor.css";i:115;s:20:"cover/editor.min.css";i:116;s:19:"cover/style-rtl.css";i:117;s:23:"cover/style-rtl.min.css";i:118;s:15:"cover/style.css";i:119;s:19:"cover/style.min.css";i:120;s:22:"details/editor-rtl.css";i:121;s:26:"details/editor-rtl.min.css";i:122;s:18:"details/editor.css";i:123;s:22:"details/editor.min.css";i:124;s:21:"details/style-rtl.css";i:125;s:25:"details/style-rtl.min.css";i:126;s:17:"details/style.css";i:127;s:21:"details/style.min.css";i:128;s:20:"embed/editor-rtl.css";i:129;s:24:"embed/editor-rtl.min.css";i:130;s:16:"embed/editor.css";i:131;s:20:"embed/editor.min.css";i:132;s:19:"embed/style-rtl.css";i:133;s:23:"embed/style-rtl.min.css";i:134;s:15:"embed/style.css";i:135;s:19:"embed/style.min.css";i:136;s:19:"embed/theme-rtl.css";i:137;s:23:"embed/theme-rtl.min.css";i:138;s:15:"embed/theme.css";i:139;s:19:"embed/theme.min.css";i:140;s:19:"file/editor-rtl.css";i:141;s:23:"file/editor-rtl.min.css";i:142;s:15:"file/editor.css";i:143;s:19:"file/editor.min.css";i:144;s:18:"file/style-rtl.css";i:145;s:22:"file/style-rtl.min.css";i:146;s:14:"file/style.css";i:147;s:18:"file/style.min.css";i:148;s:23:"footnotes/style-rtl.css";i:149;s:27:"footnotes/style-rtl.min.css";i:150;s:19:"footnotes/style.css";i:151;s:23:"footnotes/style.min.css";i:152;s:23:"freeform/editor-rtl.css";i:153;s:27:"freeform/editor-rtl.min.css";i:154;s:19:"freeform/editor.css";i:155;s:23:"freeform/editor.min.css";i:156;s:22:"gallery/editor-rtl.css";i:157;s:26:"gallery/editor-rtl.min.css";i:158;s:18:"gallery/editor.css";i:159;s:22:"gallery/editor.min.css";i:160;s:21:"gallery/style-rtl.css";i:161;s:25:"gallery/style-rtl.min.css";i:162;s:17:"gallery/style.css";i:163;s:21:"gallery/style.min.css";i:164;s:21:"gallery/theme-rtl.css";i:165;s:25:"gallery/theme-rtl.min.css";i:166;s:17:"gallery/theme.css";i:167;s:21:"gallery/theme.min.css";i:168;s:20:"group/editor-rtl.css";i:169;s:24:"group/editor-rtl.min.css";i:170;s:16:"group/editor.css";i:171;s:20:"group/editor.min.css";i:172;s:19:"group/style-rtl.css";i:173;s:23:"group/style-rtl.min.css";i:174;s:15:"group/style.css";i:175;s:19:"group/style.min.css";i:176;s:19:"group/theme-rtl.css";i:177;s:23:"group/theme-rtl.min.css";i:178;s:15:"group/theme.css";i:179;s:19:"group/theme.min.css";i:180;s:21:"heading/style-rtl.css";i:181;s:25:"heading/style-rtl.min.css";i:182;s:17:"heading/style.css";i:183;s:21:"heading/style.min.css";i:184;s:19:"html/editor-rtl.css";i:185;s:23:"html/editor-rtl.min.css";i:186;s:15:"html/editor.css";i:187;s:19:"html/editor.min.css";i:188;s:20:"image/editor-rtl.css";i:189;s:24:"image/editor-rtl.min.css";i:190;s:16:"image/editor.css";i:191;s:20:"image/editor.min.css";i:192;s:19:"image/style-rtl.css";i:193;s:23:"image/style-rtl.min.css";i:194;s:15:"image/style.css";i:195;s:19:"image/style.min.css";i:196;s:19:"image/theme-rtl.css";i:197;s:23:"image/theme-rtl.min.css";i:198;s:15:"image/theme.css";i:199;s:19:"image/theme.min.css";i:200;s:29:"latest-comments/style-rtl.css";i:201;s:33:"latest-comments/style-rtl.min.css";i:202;s:25:"latest-comments/style.css";i:203;s:29:"latest-comments/style.min.css";i:204;s:27:"latest-posts/editor-rtl.css";i:205;s:31:"latest-posts/editor-rtl.min.css";i:206;s:23:"latest-posts/editor.css";i:207;s:27:"latest-posts/editor.min.css";i:208;s:26:"latest-posts/style-rtl.css";i:209;s:30:"latest-posts/style-rtl.min.css";i:210;s:22:"latest-posts/style.css";i:211;s:26:"latest-posts/style.min.css";i:212;s:18:"list/style-rtl.css";i:213;s:22:"list/style-rtl.min.css";i:214;s:14:"list/style.css";i:215;s:18:"list/style.min.css";i:216;s:25:"media-text/editor-rtl.css";i:217;s:29:"media-text/editor-rtl.min.css";i:218;s:21:"media-text/editor.css";i:219;s:25:"media-text/editor.min.css";i:220;s:24:"media-text/style-rtl.css";i:221;s:28:"media-text/style-rtl.min.css";i:222;s:20:"media-text/style.css";i:223;s:24:"media-text/style.min.css";i:224;s:19:"more/editor-rtl.css";i:225;s:23:"more/editor-rtl.min.css";i:226;s:15:"more/editor.css";i:227;s:19:"more/editor.min.css";i:228;s:30:"navigation-link/editor-rtl.css";i:229;s:34:"navigation-link/editor-rtl.min.css";i:230;s:26:"navigation-link/editor.css";i:231;s:30:"navigation-link/editor.min.css";i:232;s:29:"navigation-link/style-rtl.css";i:233;s:33:"navigation-link/style-rtl.min.css";i:234;s:25:"navigation-link/style.css";i:235;s:29:"navigation-link/style.min.css";i:236;s:33:"navigation-submenu/editor-rtl.css";i:237;s:37:"navigation-submenu/editor-rtl.min.css";i:238;s:29:"navigation-submenu/editor.css";i:239;s:33:"navigation-submenu/editor.min.css";i:240;s:25:"navigation/editor-rtl.css";i:241;s:29:"navigation/editor-rtl.min.css";i:242;s:21:"navigation/editor.css";i:243;s:25:"navigation/editor.min.css";i:244;s:24:"navigation/style-rtl.css";i:245;s:28:"navigation/style-rtl.min.css";i:246;s:20:"navigation/style.css";i:247;s:24:"navigation/style.min.css";i:248;s:23:"nextpage/editor-rtl.css";i:249;s:27:"nextpage/editor-rtl.min.css";i:250;s:19:"nextpage/editor.css";i:251;s:23:"nextpage/editor.min.css";i:252;s:24:"page-list/editor-rtl.css";i:253;s:28:"page-list/editor-rtl.min.css";i:254;s:20:"page-list/editor.css";i:255;s:24:"page-list/editor.min.css";i:256;s:23:"page-list/style-rtl.css";i:257;s:27:"page-list/style-rtl.min.css";i:258;s:19:"page-list/style.css";i:259;s:23:"page-list/style.min.css";i:260;s:24:"paragraph/editor-rtl.css";i:261;s:28:"paragraph/editor-rtl.min.css";i:262;s:20:"paragraph/editor.css";i:263;s:24:"paragraph/editor.min.css";i:264;s:23:"paragraph/style-rtl.css";i:265;s:27:"paragraph/style-rtl.min.css";i:266;s:19:"paragraph/style.css";i:267;s:23:"paragraph/style.min.css";i:268;s:25:"post-author/style-rtl.css";i:269;s:29:"post-author/style-rtl.min.css";i:270;s:21:"post-author/style.css";i:271;s:25:"post-author/style.min.css";i:272;s:33:"post-comments-form/editor-rtl.css";i:273;s:37:"post-comments-form/editor-rtl.min.css";i:274;s:29:"post-comments-form/editor.css";i:275;s:33:"post-comments-form/editor.min.css";i:276;s:32:"post-comments-form/style-rtl.css";i:277;s:36:"post-comments-form/style-rtl.min.css";i:278;s:28:"post-comments-form/style.css";i:279;s:32:"post-comments-form/style.min.css";i:280;s:23:"post-date/style-rtl.css";i:281;s:27:"post-date/style-rtl.min.css";i:282;s:19:"post-date/style.css";i:283;s:23:"post-date/style.min.css";i:284;s:27:"post-excerpt/editor-rtl.css";i:285;s:31:"post-excerpt/editor-rtl.min.css";i:286;s:23:"post-excerpt/editor.css";i:287;s:27:"post-excerpt/editor.min.css";i:288;s:26:"post-excerpt/style-rtl.css";i:289;s:30:"post-excerpt/style-rtl.min.css";i:290;s:22:"post-excerpt/style.css";i:291;s:26:"post-excerpt/style.min.css";i:292;s:34:"post-featured-image/editor-rtl.css";i:293;s:38:"post-featured-image/editor-rtl.min.css";i:294;s:30:"post-featured-image/editor.css";i:295;s:34:"post-featured-image/editor.min.css";i:296;s:33:"post-featured-image/style-rtl.css";i:297;s:37:"post-featured-image/style-rtl.min.css";i:298;s:29:"post-featured-image/style.css";i:299;s:33:"post-featured-image/style.min.css";i:300;s:34:"post-navigation-link/style-rtl.css";i:301;s:38:"post-navigation-link/style-rtl.min.css";i:302;s:30:"post-navigation-link/style.css";i:303;s:34:"post-navigation-link/style.min.css";i:304;s:28:"post-template/editor-rtl.css";i:305;s:32:"post-template/editor-rtl.min.css";i:306;s:24:"post-template/editor.css";i:307;s:28:"post-template/editor.min.css";i:308;s:27:"post-template/style-rtl.css";i:309;s:31:"post-template/style-rtl.min.css";i:310;s:23:"post-template/style.css";i:311;s:27:"post-template/style.min.css";i:312;s:24:"post-terms/style-rtl.css";i:313;s:28:"post-terms/style-rtl.min.css";i:314;s:20:"post-terms/style.css";i:315;s:24:"post-terms/style.min.css";i:316;s:24:"post-title/style-rtl.css";i:317;s:28:"post-title/style-rtl.min.css";i:318;s:20:"post-title/style.css";i:319;s:24:"post-title/style.min.css";i:320;s:26:"preformatted/style-rtl.css";i:321;s:30:"preformatted/style-rtl.min.css";i:322;s:22:"preformatted/style.css";i:323;s:26:"preformatted/style.min.css";i:324;s:24:"pullquote/editor-rtl.css";i:325;s:28:"pullquote/editor-rtl.min.css";i:326;s:20:"pullquote/editor.css";i:327;s:24:"pullquote/editor.min.css";i:328;s:23:"pullquote/style-rtl.css";i:329;s:27:"pullquote/style-rtl.min.css";i:330;s:19:"pullquote/style.css";i:331;s:23:"pullquote/style.min.css";i:332;s:23:"pullquote/theme-rtl.css";i:333;s:27:"pullquote/theme-rtl.min.css";i:334;s:19:"pullquote/theme.css";i:335;s:23:"pullquote/theme.min.css";i:336;s:39:"query-pagination-numbers/editor-rtl.css";i:337;s:43:"query-pagination-numbers/editor-rtl.min.css";i:338;s:35:"query-pagination-numbers/editor.css";i:339;s:39:"query-pagination-numbers/editor.min.css";i:340;s:31:"query-pagination/editor-rtl.css";i:341;s:35:"query-pagination/editor-rtl.min.css";i:342;s:27:"query-pagination/editor.css";i:343;s:31:"query-pagination/editor.min.css";i:344;s:30:"query-pagination/style-rtl.css";i:345;s:34:"query-pagination/style-rtl.min.css";i:346;s:26:"query-pagination/style.css";i:347;s:30:"query-pagination/style.min.css";i:348;s:25:"query-title/style-rtl.css";i:349;s:29:"query-title/style-rtl.min.css";i:350;s:21:"query-title/style.css";i:351;s:25:"query-title/style.min.css";i:352;s:20:"query/editor-rtl.css";i:353;s:24:"query/editor-rtl.min.css";i:354;s:16:"query/editor.css";i:355;s:20:"query/editor.min.css";i:356;s:19:"query/style-rtl.css";i:357;s:23:"query/style-rtl.min.css";i:358;s:15:"query/style.css";i:359;s:19:"query/style.min.css";i:360;s:19:"quote/style-rtl.css";i:361;s:23:"quote/style-rtl.min.css";i:362;s:15:"quote/style.css";i:363;s:19:"quote/style.min.css";i:364;s:19:"quote/theme-rtl.css";i:365;s:23:"quote/theme-rtl.min.css";i:366;s:15:"quote/theme.css";i:367;s:19:"quote/theme.min.css";i:368;s:23:"read-more/style-rtl.css";i:369;s:27:"read-more/style-rtl.min.css";i:370;s:19:"read-more/style.css";i:371;s:23:"read-more/style.min.css";i:372;s:18:"rss/editor-rtl.css";i:373;s:22:"rss/editor-rtl.min.css";i:374;s:14:"rss/editor.css";i:375;s:18:"rss/editor.min.css";i:376;s:17:"rss/style-rtl.css";i:377;s:21:"rss/style-rtl.min.css";i:378;s:13:"rss/style.css";i:379;s:17:"rss/style.min.css";i:380;s:21:"search/editor-rtl.css";i:381;s:25:"search/editor-rtl.min.css";i:382;s:17:"search/editor.css";i:383;s:21:"search/editor.min.css";i:384;s:20:"search/style-rtl.css";i:385;s:24:"search/style-rtl.min.css";i:386;s:16:"search/style.css";i:387;s:20:"search/style.min.css";i:388;s:20:"search/theme-rtl.css";i:389;s:24:"search/theme-rtl.min.css";i:390;s:16:"search/theme.css";i:391;s:20:"search/theme.min.css";i:392;s:24:"separator/editor-rtl.css";i:393;s:28:"separator/editor-rtl.min.css";i:394;s:20:"separator/editor.css";i:395;s:24:"separator/editor.min.css";i:396;s:23:"separator/style-rtl.css";i:397;s:27:"separator/style-rtl.min.css";i:398;s:19:"separator/style.css";i:399;s:23:"separator/style.min.css";i:400;s:23:"separator/theme-rtl.css";i:401;s:27:"separator/theme-rtl.min.css";i:402;s:19:"separator/theme.css";i:403;s:23:"separator/theme.min.css";i:404;s:24:"shortcode/editor-rtl.css";i:405;s:28:"shortcode/editor-rtl.min.css";i:406;s:20:"shortcode/editor.css";i:407;s:24:"shortcode/editor.min.css";i:408;s:24:"site-logo/editor-rtl.css";i:409;s:28:"site-logo/editor-rtl.min.css";i:410;s:20:"site-logo/editor.css";i:411;s:24:"site-logo/editor.min.css";i:412;s:23:"site-logo/style-rtl.css";i:413;s:27:"site-logo/style-rtl.min.css";i:414;s:19:"site-logo/style.css";i:415;s:23:"site-logo/style.min.css";i:416;s:27:"site-tagline/editor-rtl.css";i:417;s:31:"site-tagline/editor-rtl.min.css";i:418;s:23:"site-tagline/editor.css";i:419;s:27:"site-tagline/editor.min.css";i:420;s:25:"site-title/editor-rtl.css";i:421;s:29:"site-title/editor-rtl.min.css";i:422;s:21:"site-title/editor.css";i:423;s:25:"site-title/editor.min.css";i:424;s:24:"site-title/style-rtl.css";i:425;s:28:"site-title/style-rtl.min.css";i:426;s:20:"site-title/style.css";i:427;s:24:"site-title/style.min.css";i:428;s:26:"social-link/editor-rtl.css";i:429;s:30:"social-link/editor-rtl.min.css";i:430;s:22:"social-link/editor.css";i:431;s:26:"social-link/editor.min.css";i:432;s:27:"social-links/editor-rtl.css";i:433;s:31:"social-links/editor-rtl.min.css";i:434;s:23:"social-links/editor.css";i:435;s:27:"social-links/editor.min.css";i:436;s:26:"social-links/style-rtl.css";i:437;s:30:"social-links/style-rtl.min.css";i:438;s:22:"social-links/style.css";i:439;s:26:"social-links/style.min.css";i:440;s:21:"spacer/editor-rtl.css";i:441;s:25:"spacer/editor-rtl.min.css";i:442;s:17:"spacer/editor.css";i:443;s:21:"spacer/editor.min.css";i:444;s:20:"spacer/style-rtl.css";i:445;s:24:"spacer/style-rtl.min.css";i:446;s:16:"spacer/style.css";i:447;s:20:"spacer/style.min.css";i:448;s:20:"table/editor-rtl.css";i:449;s:24:"table/editor-rtl.min.css";i:450;s:16:"table/editor.css";i:451;s:20:"table/editor.min.css";i:452;s:19:"table/style-rtl.css";i:453;s:23:"table/style-rtl.min.css";i:454;s:15:"table/style.css";i:455;s:19:"table/style.min.css";i:456;s:19:"table/theme-rtl.css";i:457;s:23:"table/theme-rtl.min.css";i:458;s:15:"table/theme.css";i:459;s:19:"table/theme.min.css";i:460;s:23:"tag-cloud/style-rtl.css";i:461;s:27:"tag-cloud/style-rtl.min.css";i:462;s:19:"tag-cloud/style.css";i:463;s:23:"tag-cloud/style.min.css";i:464;s:28:"template-part/editor-rtl.css";i:465;s:32:"template-part/editor-rtl.min.css";i:466;s:24:"template-part/editor.css";i:467;s:28:"template-part/editor.min.css";i:468;s:27:"template-part/theme-rtl.css";i:469;s:31:"template-part/theme-rtl.min.css";i:470;s:23:"template-part/theme.css";i:471;s:27:"template-part/theme.min.css";i:472;s:30:"term-description/style-rtl.css";i:473;s:34:"term-description/style-rtl.min.css";i:474;s:26:"term-description/style.css";i:475;s:30:"term-description/style.min.css";i:476;s:27:"text-columns/editor-rtl.css";i:477;s:31:"text-columns/editor-rtl.min.css";i:478;s:23:"text-columns/editor.css";i:479;s:27:"text-columns/editor.min.css";i:480;s:26:"text-columns/style-rtl.css";i:481;s:30:"text-columns/style-rtl.min.css";i:482;s:22:"text-columns/style.css";i:483;s:26:"text-columns/style.min.css";i:484;s:19:"verse/style-rtl.css";i:485;s:23:"verse/style-rtl.min.css";i:486;s:15:"verse/style.css";i:487;s:19:"verse/style.min.css";i:488;s:20:"video/editor-rtl.css";i:489;s:24:"video/editor-rtl.min.css";i:490;s:16:"video/editor.css";i:491;s:20:"video/editor.min.css";i:492;s:19:"video/style-rtl.css";i:493;s:23:"video/style-rtl.min.css";i:494;s:15:"video/style.css";i:495;s:19:"video/style.min.css";i:496;s:19:"video/theme-rtl.css";i:497;s:23:"video/theme-rtl.min.css";i:498;s:15:"video/theme.css";i:499;s:19:"video/theme.min.css";}}', 'yes'),
	(123, 'recovery_keys', 'a:0:{}', 'yes'),
	(127, 'theme_mods_twentytwentyfour', 'a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1704747560;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}', 'no'),
	(151, 'finished_updating_comment_type', '1', 'yes'),
	(165, 'current_theme', '', 'yes'),
	(166, 'theme_mods_BootstrapPrakseWordpress', 'a:2:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}}', 'yes'),
	(167, 'theme_switched', '', 'yes'),
	(175, 'recently_activated', 'a:0:{}', 'yes'),
	(184, 'category_children', 'a:0:{}', 'yes'),
	(191, 'wp_calendar_block_has_published_posts', '1', 'yes'),
	(223, 'WPLANG', '', 'yes'),
	(224, 'new_admin_email', 'hollow@gmail.com', 'yes'),
	(234, 'https_detection_errors', 'a:2:{s:23:"ssl_verification_failed";a:1:{i:0;s:24:"SSL verification failed.";}s:19:"bad_response_source";a:1:{i:0;s:55:"It looks like the response did not come from this site.";}}', 'yes'),
	(235, '_transient_health-check-site-status-result', '{"good":17,"recommended":5,"critical":1}', 'yes'),
	(238, 'db_upgraded', '1', 'yes'),
	(242, 'auto_core_update_notified', 'a:4:{s:4:"type";s:7:"success";s:5:"email";s:16:"hollow@gmail.com";s:7:"version";s:5:"6.6.1";s:9:"timestamp";i:1724888798;}', 'no'),
	(252, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.1.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-6.6.1.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-6.6.1-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-6.6.1-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.6.1";s:7:"version";s:5:"6.6.1";s:11:"php_version";s:6:"7.2.24";s:13:"mysql_version";s:5:"5.5.5";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1725342975;s:15:"version_checked";s:5:"6.6.1";s:12:"translations";a:0:{}}', 'off'),
	(255, '_site_transient_timeout_php_check_da775d00ae55849f14f81cf79fc50d46', '1725493599', 'no'),
	(256, '_site_transient_php_check_da775d00ae55849f14f81cf79fc50d46', 'a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}', 'no'),
	(261, '_site_transient_timeout_theme_roots', '1725344778', 'off'),
	(262, '_site_transient_theme_roots', 'a:4:{s:24:"BootstrapPrakseWordpress";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";s:15:"twentytwentytwo";s:7:"/themes";}', 'off'),
	(263, '_site_transient_update_themes', 'O:8:"stdClass":5:{s:12:"last_checked";i:1725342979;s:7:"checked";a:4:{s:24:"BootstrapPrakseWordpress";s:0:"";s:16:"twentytwentyfour";s:3:"1.0";s:17:"twentytwentythree";s:3:"1.3";s:15:"twentytwentytwo";s:3:"1.6";}s:8:"response";a:3:{s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.2";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.2.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}s:17:"twentytwentythree";a:6:{s:5:"theme";s:17:"twentytwentythree";s:11:"new_version";s:3:"1.5";s:3:"url";s:47:"https://wordpress.org/themes/twentytwentythree/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/twentytwentythree.1.5.zip";s:8:"requires";s:3:"6.1";s:12:"requires_php";s:3:"5.6";}s:15:"twentytwentytwo";a:6:{s:5:"theme";s:15:"twentytwentytwo";s:11:"new_version";s:3:"1.8";s:3:"url";s:45:"https://wordpress.org/themes/twentytwentytwo/";s:7:"package";s:61:"https://downloads.wordpress.org/theme/twentytwentytwo.1.8.zip";s:8:"requires";s:3:"5.9";s:12:"requires_php";s:3:"5.6";}}s:9:"no_update";a:0:{}s:12:"translations";a:0:{}}', 'off'),
	(264, '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1725342980;s:8:"response";a:1:{s:19:"akismet/akismet.php";O:8:"stdClass":13:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:5:"5.3.3";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/akismet.5.3.3.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";s:6:"tested";s:5:"6.6.1";s:12:"requires_php";s:6:"5.6.20";s:16:"requires_plugins";a:0:{}}}s:12:"translations";a:0:{}s:9:"no_update";a:1:{s:9:"hello.php";O:8:"stdClass":10:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:5:"1.7.2";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855";s:2:"1x";s:64:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582";s:2:"1x";s:66:"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.6";}}s:7:"checked";a:2:{s:19:"akismet/akismet.php";s:3:"5.3";s:9:"hello.php";s:5:"1.7.2";}}', 'off');

-- Dumping structure for table bootstrappraksewordpress.wp_postmeta
CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_postmeta: ~37 rows (approximately)
INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
	(4, 7, '_edit_lock', '1704756026:1'),
	(8, 9, '_wp_attached_file', '2024/01/hollow2023.png'),
	(9, 9, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:22:"2024/01/hollow2023.png";s:8:"filesize";i:587438;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(10, 10, '_wp_attached_file', '2024/01/Macabre.jpg'),
	(11, 10, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:19:"2024/01/Macabre.jpg";s:8:"filesize";i:72453;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(12, 11, '_wp_attached_file', '2024/01/roundhollow.png'),
	(13, 11, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:1000;s:4:"file";s:23:"2024/01/roundhollow.png";s:8:"filesize";i:406964;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(14, 12, '_wp_attached_file', '2024/01/TowerOfFantasy.png'),
	(15, 12, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:26:"2024/01/TowerOfFantasy.png";s:8:"filesize";i:867328;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(16, 13, '_wp_attached_file', '2024/01/hollow2023-1.png'),
	(17, 13, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:24:"2024/01/hollow2023-1.png";s:8:"filesize";i:587438;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(18, 14, '_wp_attached_file', '2024/01/hollow2023-2.png'),
	(19, 14, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:562;s:4:"file";s:24:"2024/01/hollow2023-2.png";s:8:"filesize";i:587438;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(20, 7, '_edit_last', '1'),
	(22, 16, '_wp_attached_file', '2024/01/roundhollow-1.png'),
	(23, 16, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:1000;s:4:"file";s:25:"2024/01/roundhollow-1.png";s:8:"filesize";i:406964;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(24, 17, '_wp_attached_file', '2024/01/roundhollow-2.png'),
	(25, 17, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:1000;s:4:"file";s:25:"2024/01/roundhollow-2.png";s:8:"filesize";i:406964;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(26, 18, '_edit_lock', '1704787548:1'),
	(27, 20, '_wp_attached_file', '2024/01/roundhollow-3.png'),
	(28, 20, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1000;s:6:"height";i:1000;s:4:"file";s:25:"2024/01/roundhollow-3.png";s:8:"filesize";i:406964;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(29, 11, '_edit_lock', '1704753092:1'),
	(36, 23, '_edit_lock', '1704751581:1'),
	(38, 23, '_edit_last', '1'),
	(40, 23, '_wp_old_slug', 'post-1'),
	(41, 26, '_edit_lock', '1704751613:1'),
	(43, 26, '_edit_last', '1'),
	(45, 28, '_edit_lock', '1704751640:1'),
	(47, 28, '_edit_last', '1'),
	(55, 32, '_edit_lock', '1704788930:1'),
	(56, 34, '_edit_lock', '1704752021:1'),
	(57, 36, '_edit_lock', '1704752031:1'),
	(59, 42, 'footnotes', ''),
	(60, 32, '_edit_last', '1'),
	(61, 32, '_wp_page_template', 'kategorija1.php'),
	(62, 18, '_edit_last', '1'),
	(63, 18, '_wp_page_template', 'sakums.php');

-- Dumping structure for table bootstrappraksewordpress.wp_posts
CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_posts: ~35 rows (approximately)
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
	(4, 0, '2024-01-08 15:40:25', '2024-01-08 15:40:25', '<!-- wp:page-list /-->', 'Navigation', '', 'publish', 'closed', 'closed', '', 'navigation', '', '', '2024-01-08 15:40:25', '2024-01-08 15:40:25', '', 0, 'http://localhost/BootstrapPrakseWordpress/2024/01/08/navigation/', 0, 'wp_navigation', '', 0),
	(6, 1, '2024-01-08 15:46:46', '2024-01-08 15:46:46', '{"version": 2, "isGlobalStylesUserThemeJSON": true }', 'Custom Styles', '', 'publish', 'closed', 'closed', '', 'wp-global-styles-twentytwentyfour', '', '', '2024-01-08 15:46:46', '2024-01-08 15:46:46', '', 0, 'http://localhost/BootstrapPrakseWordpress/2024/01/08/wp-global-styles-twentytwentyfour/', 0, 'wp_global_styles', '', 0),
	(7, 1, '2024-01-08 21:14:18', '2024-01-08 21:14:18', '', 'Lapa', '', 'publish', 'closed', 'closed', '', 'lapa', '', '', '2024-01-08 23:22:49', '2024-01-08 23:22:49', '', 0, 'http://localhost/BootstrapPrakseWordpress/?page_id=7', 0, 'page', '', 0),
	(8, 1, '2024-01-08 21:14:18', '2024-01-08 21:14:18', '', 'Lapa', '', 'inherit', 'closed', 'closed', '', '7-revision-v1', '', '', '2024-01-08 21:14:18', '2024-01-08 21:14:18', '', 7, 'http://localhost/BootstrapPrakseWordpress/?p=8', 0, 'revision', '', 0),
	(9, 1, '2024-01-08 21:20:16', '2024-01-08 21:20:16', '', 'hollow2023', '', 'inherit', 'open', 'closed', '', 'hollow2023', '', '', '2024-01-08 21:20:16', '2024-01-08 21:20:16', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/hollow2023.png', 0, 'attachment', 'image/png', 0),
	(10, 1, '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 'Macabre', '', 'inherit', 'open', 'closed', '', 'macabre', '', '', '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/Macabre.jpg', 0, 'attachment', 'image/jpeg', 0),
	(11, 1, '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 'roundhollow', '', 'inherit', 'open', 'closed', '', 'roundhollow', '', '', '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/roundhollow.png', 0, 'attachment', 'image/png', 0),
	(12, 1, '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 'TowerOfFantasy', '', 'inherit', 'open', 'closed', '', 'toweroffantasy', '', '', '2024-01-08 21:20:17', '2024-01-08 21:20:17', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/TowerOfFantasy.png', 0, 'attachment', 'image/png', 0),
	(13, 1, '2024-01-08 21:21:30', '2024-01-08 21:21:30', '', 'hollow2023', '', 'inherit', 'open', 'closed', '', 'hollow2023-2', '', '', '2024-01-08 21:21:30', '2024-01-08 21:21:30', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/hollow2023-1.png', 0, 'attachment', 'image/png', 0),
	(14, 1, '2024-01-08 21:28:39', '2024-01-08 21:28:39', '', 'hollow2023', '', 'inherit', 'open', 'closed', '', 'hollow2023-3', '', '', '2024-01-08 21:28:39', '2024-01-08 21:28:39', '', 7, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/hollow2023-2.png', 0, 'attachment', 'image/png', 0),
	(16, 1, '2024-01-08 21:46:46', '2024-01-08 21:46:46', '', 'roundhollow', '', 'inherit', 'open', 'closed', '', 'roundhollow-2', '', '', '2024-01-08 21:46:46', '2024-01-08 21:46:46', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/roundhollow-1.png', 0, 'attachment', 'image/png', 0),
	(17, 1, '2024-01-08 21:46:55', '2024-01-08 21:46:55', '', 'roundhollow', '', 'inherit', 'open', 'closed', '', 'roundhollow-3', '', '', '2024-01-08 21:46:55', '2024-01-08 21:46:55', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/roundhollow-2.png', 0, 'attachment', 'image/png', 0),
	(18, 1, '2024-01-08 21:50:21', '2024-01-08 21:50:21', '', 'Sākums', '', 'publish', 'closed', 'closed', '', 'sakums', '', '', '2024-01-09 08:05:48', '2024-01-09 08:05:48', '', 0, 'http://localhost/BootstrapPrakseWordpress/?page_id=18', 0, 'page', '', 0),
	(19, 1, '2024-01-08 21:50:21', '2024-01-08 21:50:21', '', 'Sākums', '', 'inherit', 'closed', 'closed', '', '18-revision-v1', '', '', '2024-01-08 21:50:21', '2024-01-08 21:50:21', '', 18, 'http://localhost/BootstrapPrakseWordpress/?p=19', 0, 'revision', '', 0),
	(20, 1, '2024-01-08 21:55:06', '2024-01-08 21:55:06', '', 'roundhollow', '', 'inherit', 'open', 'closed', '', 'roundhollow-4', '', '', '2024-01-08 21:55:06', '2024-01-08 21:55:06', '', 0, 'http://localhost/BootstrapPrakseWordpress/wp-content/uploads/2024/01/roundhollow-3.png', 0, 'attachment', 'image/png', 0),
	(23, 1, '2024-01-08 22:05:40', '2024-01-08 22:05:40', '', 'Posts 1', '', 'publish', 'closed', 'closed', '', 'posts-1', '', '', '2024-01-08 22:06:21', '2024-01-08 22:06:21', '', 0, 'http://localhost/BootstrapPrakseWordpress/?p=23', 0, 'post', '', 0),
	(24, 1, '2024-01-08 22:05:40', '2024-01-08 22:05:40', '', 'Post 1', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2024-01-08 22:05:40', '2024-01-08 22:05:40', '', 23, 'http://localhost/BootstrapPrakseWordpress/?p=24', 0, 'revision', '', 0),
	(25, 1, '2024-01-08 22:06:21', '2024-01-08 22:06:21', '', 'Posts 1', '', 'inherit', 'closed', 'closed', '', '23-revision-v1', '', '', '2024-01-08 22:06:21', '2024-01-08 22:06:21', '', 23, 'http://localhost/BootstrapPrakseWordpress/?p=25', 0, 'revision', '', 0),
	(26, 1, '2024-01-08 22:06:31', '2024-01-08 22:06:31', '', 'Posts 2', '', 'publish', 'open', 'open', '', 'posts-2', '', '', '2024-01-08 22:06:53', '2024-01-08 22:06:53', '', 0, 'http://localhost/BootstrapPrakseWordpress/?p=26', 0, 'post', '', 0),
	(27, 1, '2024-01-08 22:06:31', '2024-01-08 22:06:31', '', 'Posts 2', '', 'inherit', 'closed', 'closed', '', '26-revision-v1', '', '', '2024-01-08 22:06:31', '2024-01-08 22:06:31', '', 26, 'http://localhost/BootstrapPrakseWordpress/?p=27', 0, 'revision', '', 0),
	(28, 1, '2024-01-08 22:07:01', '2024-01-08 22:07:01', '', 'Posts 3', '', 'publish', 'open', 'open', '', 'posts-3', '', '', '2024-01-08 22:07:20', '2024-01-08 22:07:20', '', 0, 'http://localhost/BootstrapPrakseWordpress/?p=28', 0, 'post', '', 0),
	(29, 1, '2024-01-08 22:07:01', '2024-01-08 22:07:01', '', 'Posts 3', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2024-01-08 22:07:01', '2024-01-08 22:07:01', '', 28, 'http://localhost/BootstrapPrakseWordpress/?p=29', 0, 'revision', '', 0),
	(32, 1, '2024-01-08 22:15:50', '2024-01-08 22:15:50', '<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->\n<div class="wp-block-query"><!-- wp:query-no-results /--></div>\n<!-- /wp:query -->', 'Kategorija 1', '', 'publish', 'closed', 'closed', '', 'kategorija-1', '', '', '2024-01-09 08:28:50', '2024-01-09 08:28:50', '', 0, 'http://localhost/BootstrapPrakseWordpress/?page_id=32', 0, 'page', '', 0),
	(33, 1, '2024-01-08 22:15:50', '2024-01-08 22:15:50', '', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-revision-v1', '', '', '2024-01-08 22:15:50', '2024-01-08 22:15:50', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=33', 0, 'revision', '', 0),
	(34, 1, '2024-01-08 22:16:05', '2024-01-08 22:16:05', '', 'Kategorija 2', '', 'publish', 'closed', 'closed', '', 'kategorija-2', '', '', '2024-01-08 22:16:05', '2024-01-08 22:16:05', '', 0, 'http://localhost/BootstrapPrakseWordpress/?page_id=34', 0, 'page', '', 0),
	(35, 1, '2024-01-08 22:16:05', '2024-01-08 22:16:05', '', 'Kategorija 2', '', 'inherit', 'closed', 'closed', '', '34-revision-v1', '', '', '2024-01-08 22:16:05', '2024-01-08 22:16:05', '', 34, 'http://localhost/BootstrapPrakseWordpress/?p=35', 0, 'revision', '', 0),
	(36, 1, '2024-01-08 22:16:14', '2024-01-08 22:16:14', '', 'Kategorija 3', '', 'publish', 'closed', 'closed', '', 'kategorija-3', '', '', '2024-01-08 22:16:14', '2024-01-08 22:16:14', '', 0, 'http://localhost/BootstrapPrakseWordpress/?page_id=36', 0, 'page', '', 0),
	(37, 1, '2024-01-08 22:16:14', '2024-01-08 22:16:14', '', 'Kategorija 3', '', 'inherit', 'closed', 'closed', '', '36-revision-v1', '', '', '2024-01-08 22:16:14', '2024-01-08 22:16:14', '', 36, 'http://localhost/BootstrapPrakseWordpress/?p=37', 0, 'revision', '', 0),
	(40, 1, '2024-01-08 22:17:21', '2024-01-08 22:17:21', '<!-- wp:paragraph -->\n<p>Paragraph</p>\n<!-- /wp:paragraph -->', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-revision-v1', '', '', '2024-01-08 22:17:21', '2024-01-08 22:17:21', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=40', 0, 'revision', '', 0),
	(41, 1, '2024-01-08 22:17:52', '2024-01-08 22:17:52', '<!-- wp:paragraph -->\n<p>Juice</p>\n<!-- /wp:paragraph -->', 'Lapa', '', 'inherit', 'closed', 'closed', '', '7-revision-v1', '', '', '2024-01-08 22:17:52', '2024-01-08 22:17:52', '', 7, 'http://localhost/BootstrapPrakseWordpress/?p=41', 0, 'revision', '', 0),
	(42, 1, '2024-01-08 23:03:53', '2024-01-08 23:03:53', '<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->\n<div class="wp-block-query"><!-- wp:query-no-results -->\n<!-- wp:paragraph {"placeholder":"Add text or blocks that will display when a query returns no results."} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-autosave-v1', '', '', '2024-01-08 23:03:53', '2024-01-08 23:03:53', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=42', 0, 'revision', '', 0),
	(43, 1, '2024-01-08 22:35:23', '2024-01-08 22:35:23', '<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->\n<div class="wp-block-query"><!-- wp:post-template -->\n<!-- wp:post-featured-image /-->\n\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {"placeholder":"Add text or blocks that will display when a query returns no results."} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-revision-v1', '', '', '2024-01-08 22:35:23', '2024-01-08 22:35:23', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=43', 0, 'revision', '', 0),
	(44, 1, '2024-01-08 22:36:16', '2024-01-08 22:36:16', '<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->\n<div class="wp-block-query"><!-- wp:query-no-results -->\n<!-- wp:post-title {"textAlign":"center"} /-->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-revision-v1', '', '', '2024-01-08 22:36:16', '2024-01-08 22:36:16', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=44', 0, 'revision', '', 0),
	(45, 1, '2024-01-08 22:36:50', '2024-01-08 22:36:50', '<!-- wp:query {"queryId":0,"query":{"perPage":3,"pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->\n<div class="wp-block-query"><!-- wp:query-no-results /--></div>\n<!-- /wp:query -->', 'Kategorija 1', '', 'inherit', 'closed', 'closed', '', '32-revision-v1', '', '', '2024-01-08 22:36:50', '2024-01-08 22:36:50', '', 32, 'http://localhost/BootstrapPrakseWordpress/?p=45', 0, 'revision', '', 0),
	(46, 1, '2024-01-08 23:22:49', '2024-01-08 23:22:49', '', 'Lapa', '', 'inherit', 'closed', 'closed', '', '7-revision-v1', '', '', '2024-01-08 23:22:49', '2024-01-08 23:22:49', '', 7, 'http://localhost/BootstrapPrakseWordpress/?p=46', 0, 'revision', '', 0);

-- Dumping structure for table bootstrappraksewordpress.wp_termmeta
CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_termmeta: ~0 rows (approximately)

-- Dumping structure for table bootstrappraksewordpress.wp_terms
CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_terms: ~6 rows (approximately)
INSERT INTO `wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
	(1, 'Uncategorized', 'uncategorized', 0),
	(2, 'twentytwentyfour', 'twentytwentyfour', 0),
	(3, 'Kategorija 1', 'kategorija1', 0),
	(4, 'Kategorija 2', 'kategorija2', 0),
	(5, 'Kategorija 3', 'kategorija3', 0),
	(6, 'Kategorija 4', 'kategorija4', 0);

-- Dumping structure for table bootstrappraksewordpress.wp_term_relationships
CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_term_relationships: ~9 rows (approximately)
INSERT INTO `wp_term_relationships` (`object_id`, `term_taxonomy_id`, `term_order`) VALUES
	(6, 2, 0),
	(23, 3, 0),
	(23, 4, 0),
	(23, 5, 0),
	(26, 3, 0),
	(26, 4, 0),
	(28, 3, 0),
	(28, 5, 0),
	(28, 6, 0);

-- Dumping structure for table bootstrappraksewordpress.wp_term_taxonomy
CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_term_taxonomy: ~6 rows (approximately)
INSERT INTO `wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
	(1, 1, 'category', '', 0, 0),
	(2, 2, 'wp_theme', '', 0, 1),
	(3, 3, 'category', '', 0, 3),
	(4, 4, 'category', '', 0, 2),
	(5, 5, 'category', '', 0, 2),
	(6, 6, 'category', '', 0, 1);

-- Dumping structure for table bootstrappraksewordpress.wp_usermeta
CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_usermeta: ~21 rows (approximately)
INSERT INTO `wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
	(1, 1, 'nickname', 'raivisrampans'),
	(2, 1, 'first_name', ''),
	(3, 1, 'last_name', ''),
	(4, 1, 'description', ''),
	(5, 1, 'rich_editing', 'true'),
	(6, 1, 'syntax_highlighting', 'true'),
	(7, 1, 'comment_shortcuts', 'false'),
	(8, 1, 'admin_color', 'fresh'),
	(9, 1, 'use_ssl', '0'),
	(10, 1, 'show_admin_bar_front', 'true'),
	(11, 1, 'locale', ''),
	(12, 1, 'wp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
	(13, 1, 'wp_user_level', '10'),
	(14, 1, 'dismissed_wp_pointers', ''),
	(15, 1, 'show_welcome_panel', '0'),
	(16, 1, 'session_tokens', 'a:1:{s:64:"2f9ccaf43b18c5e4de6d8afbfe7f66d065deff826ba5f6f3781e8b0d425be140";a:4:{s:10:"expiration";i:1705938065;s:2:"ip";s:3:"::1";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0";s:5:"login";i:1704728465;}}'),
	(17, 1, 'wp_dashboard_quick_press_last_post_id', '5'),
	(18, 1, 'wp_persisted_preferences', 'a:5:{s:4:"core";a:1:{s:29:"isTemplatePartMoveHintVisible";b:0;}s:9:"_modified";s:24:"2024-01-08T23:07:01.452Z";s:14:"core/edit-post";a:4:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;s:10:"openPanels";a:3:{i:0;s:23:"taxonomy-panel-category";i:1;s:14:"featured-image";i:2;s:11:"post-status";}s:20:"welcomeGuideTemplate";b:0;}s:14:"core/edit-site";a:6:{s:12:"welcomeGuide";b:0;s:26:"isComplementaryAreaVisible";b:0;s:18:"welcomeGuideStyles";b:0;s:16:"welcomeGuidePage";b:0;s:20:"welcomeGuideTemplate";b:0;s:10:"editorMode";s:6:"visual";}s:17:"core/block-editor";a:1:{s:25:"linkControlSettingsDrawer";b:0;}}'),
	(19, 1, 'wp_user-settings', 'libraryContent=browse'),
	(20, 1, 'wp_user-settings-time', '1704749327'),
	(21, 1, 'wp_media_library_mode', 'list');

-- Dumping structure for table bootstrappraksewordpress.wp_users
CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table bootstrappraksewordpress.wp_users: ~1 rows (approximately)
INSERT INTO `wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
	(1, 'raivisrampans', '$P$BuodO0mYRUwyZtFYU5v1DMGi9LJeLj1', 'raivisrampans', 'hollow@gmail.com', 'http://localhost/BootstrapPrakseWordpress', '2024-01-08 15:40:23', '', 0, 'raivisrampans');


-- Dumping database structure for database_prakse
CREATE DATABASE IF NOT EXISTS `database_prakse` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `database_prakse`;

-- Dumping structure for table database_prakse.wp_commentmeta
CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_commentmeta: ~0 rows (approximately)

-- Dumping structure for table database_prakse.wp_comments
CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_comments: ~1 rows (approximately)
INSERT INTO `wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
	(1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2023-12-15 15:07:28', '2023-12-15 15:07:28', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href="https://en.gravatar.com/">Gravatar</a>.', 0, '1', '', 'comment', 0, 0);

-- Dumping structure for table database_prakse.wp_links
CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_links: ~0 rows (approximately)

-- Dumping structure for table database_prakse.wp_options
CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_options: ~139 rows (approximately)
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
	(1, 'siteurl', 'http://localhost/wordpress/wordpressprakse', 'yes'),
	(2, 'home', 'http://localhost/wordpress/wordpressprakse', 'yes'),
	(3, 'blogname', 'PrakseRaivis', 'yes'),
	(4, 'blogdescription', '', 'yes'),
	(5, 'users_can_register', '0', 'yes'),
	(6, 'admin_email', 'rampansraivis3@gmail.com', 'yes'),
	(7, 'start_of_week', '1', 'yes'),
	(8, 'use_balanceTags', '0', 'yes'),
	(9, 'use_smilies', '1', 'yes'),
	(10, 'require_name_email', '1', 'yes'),
	(11, 'comments_notify', '', 'yes'),
	(12, 'posts_per_rss', '10', 'yes'),
	(13, 'rss_use_excerpt', '0', 'yes'),
	(14, 'mailserver_url', 'mail.example.com', 'yes'),
	(15, 'mailserver_login', 'login@example.com', 'yes'),
	(16, 'mailserver_pass', 'password', 'yes'),
	(17, 'mailserver_port', '110', 'yes'),
	(18, 'default_category', '1', 'yes'),
	(19, 'default_comment_status', '', 'yes'),
	(20, 'default_ping_status', '', 'yes'),
	(21, 'default_pingback_flag', '', 'yes'),
	(22, 'posts_per_page', '10', 'yes'),
	(23, 'date_format', 'F j, Y', 'yes'),
	(24, 'time_format', 'g:i a', 'yes'),
	(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
	(26, 'comment_moderation', '', 'yes'),
	(27, 'moderation_notify', '', 'yes'),
	(28, 'permalink_structure', '/%category%/%postname%/', 'yes'),
	(29, 'rewrite_rules', 'a:97:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:31:".+?/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:41:".+?/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:61:".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:37:".+?/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:22:"(.+?)/([^/]+)/embed/?$";s:63:"index.php?category_name=$matches[1]&name=$matches[2]&embed=true";s:26:"(.+?)/([^/]+)/trackback/?$";s:57:"index.php?category_name=$matches[1]&name=$matches[2]&tb=1";s:46:"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]";s:41:"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]";s:34:"(.+?)/([^/]+)/page/?([0-9]{1,})/?$";s:70:"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]";s:41:"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$";s:70:"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]";s:30:"(.+?)/([^/]+)(?:/([0-9]+))?/?$";s:69:"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]";s:20:".+?/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:30:".+?/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:50:".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:45:".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:45:".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:26:".+?/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:38:"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:33:"(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:14:"(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:26:"(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:33:"(.+?)/comment-page-([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&cpage=$matches[2]";s:8:"(.+?)/?$";s:35:"index.php?category_name=$matches[1]";}', 'yes'),
	(30, 'hack_file', '0', 'yes'),
	(31, 'blog_charset', 'UTF-8', 'yes'),
	(32, 'moderation_keys', '', 'no'),
	(33, 'active_plugins', 'a:0:{}', 'yes'),
	(34, 'category_base', '', 'yes'),
	(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
	(36, 'comment_max_links', '2', 'yes'),
	(37, 'gmt_offset', '0', 'yes'),
	(38, 'default_email_category', '1', 'yes'),
	(39, 'recently_edited', '', 'no'),
	(40, 'template', 'temas', 'yes'),
	(41, 'stylesheet', 'temas', 'yes'),
	(42, 'comment_registration', '', 'yes'),
	(43, 'html_type', 'text/html', 'yes'),
	(44, 'use_trackback', '0', 'yes'),
	(45, 'default_role', 'subscriber', 'yes'),
	(46, 'db_version', '56657', 'yes'),
	(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
	(48, 'upload_path', '', 'yes'),
	(49, 'blog_public', '0', 'yes'),
	(50, 'default_link_category', '2', 'yes'),
	(51, 'show_on_front', 'posts', 'yes'),
	(52, 'tag_base', '', 'yes'),
	(53, 'show_avatars', '1', 'yes'),
	(54, 'avatar_rating', 'G', 'yes'),
	(55, 'upload_url_path', '', 'yes'),
	(56, 'thumbnail_size_w', '150', 'yes'),
	(57, 'thumbnail_size_h', '150', 'yes'),
	(58, 'thumbnail_crop', '1', 'yes'),
	(59, 'medium_size_w', '300', 'yes'),
	(60, 'medium_size_h', '300', 'yes'),
	(61, 'avatar_default', 'mystery', 'yes'),
	(62, 'large_size_w', '1024', 'yes'),
	(63, 'large_size_h', '1024', 'yes'),
	(64, 'image_default_link_type', 'none', 'yes'),
	(65, 'image_default_size', '', 'yes'),
	(66, 'image_default_align', '', 'yes'),
	(67, 'close_comments_for_old_posts', '', 'yes'),
	(68, 'close_comments_days_old', '14', 'yes'),
	(69, 'thread_comments', '1', 'yes'),
	(70, 'thread_comments_depth', '5', 'yes'),
	(71, 'page_comments', '', 'yes'),
	(72, 'comments_per_page', '50', 'yes'),
	(73, 'default_comments_page', 'newest', 'yes'),
	(74, 'comment_order', 'asc', 'yes'),
	(75, 'sticky_posts', 'a:0:{}', 'yes'),
	(76, 'widget_categories', 'a:0:{}', 'yes'),
	(77, 'widget_text', 'a:0:{}', 'yes'),
	(78, 'widget_rss', 'a:0:{}', 'yes'),
	(79, 'uninstall_plugins', 'a:0:{}', 'no'),
	(80, 'timezone_string', '', 'yes'),
	(81, 'page_for_posts', '0', 'yes'),
	(82, 'page_on_front', '0', 'yes'),
	(83, 'default_post_format', '0', 'yes'),
	(84, 'link_manager_enabled', '0', 'yes'),
	(85, 'finished_splitting_shared_terms', '1', 'yes'),
	(86, 'site_icon', '0', 'yes'),
	(87, 'medium_large_size_w', '768', 'yes'),
	(88, 'medium_large_size_h', '0', 'yes'),
	(89, 'wp_page_for_privacy_policy', '3', 'yes'),
	(90, 'show_comments_cookies_opt_in', '1', 'yes'),
	(91, 'admin_email_lifespan', '1718204848', 'yes'),
	(92, 'disallowed_keys', '', 'no'),
	(93, 'comment_previously_approved', '1', 'yes'),
	(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
	(95, 'auto_update_core_dev', 'enabled', 'yes'),
	(96, 'auto_update_core_minor', 'enabled', 'yes'),
	(97, 'auto_update_core_major', 'enabled', 'yes'),
	(98, 'wp_force_deactivated_plugins', 'a:0:{}', 'yes'),
	(99, 'wp_attachment_pages_enabled', '0', 'yes'),
	(100, 'initial_db_version', '56657', 'yes'),
	(101, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:61:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'),
	(102, 'fresh_site', '0', 'yes'),
	(103, 'user_count', '1', 'no'),
	(104, 'widget_block', 'a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}', 'yes'),
	(105, 'sidebars_widgets', 'a:2:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:13:"array_version";i:3;}', 'yes'),
	(106, 'cron', 'a:7:{i:1704715648;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1704726448;a:4:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1704726471;a:3:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1704726472;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1705072784;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1705158448;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}', 'yes'),
	(107, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(108, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(109, 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(110, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(111, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(112, 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(113, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(114, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(115, 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(116, 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(117, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(118, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(119, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(120, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
	(121, '_transient_wp_core_block_css_files', 'a:2:{s:7:"version";s:5:"6.4.2";s:5:"files";a:500:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:20:"block/editor-rtl.css";i:29;s:24:"block/editor-rtl.min.css";i:30;s:16:"block/editor.css";i:31;s:20:"block/editor.min.css";i:32;s:21:"button/editor-rtl.css";i:33;s:25:"button/editor-rtl.min.css";i:34;s:17:"button/editor.css";i:35;s:21:"button/editor.min.css";i:36;s:20:"button/style-rtl.css";i:37;s:24:"button/style-rtl.min.css";i:38;s:16:"button/style.css";i:39;s:20:"button/style.min.css";i:40;s:22:"buttons/editor-rtl.css";i:41;s:26:"buttons/editor-rtl.min.css";i:42;s:18:"buttons/editor.css";i:43;s:22:"buttons/editor.min.css";i:44;s:21:"buttons/style-rtl.css";i:45;s:25:"buttons/style-rtl.min.css";i:46;s:17:"buttons/style.css";i:47;s:21:"buttons/style.min.css";i:48;s:22:"calendar/style-rtl.css";i:49;s:26:"calendar/style-rtl.min.css";i:50;s:18:"calendar/style.css";i:51;s:22:"calendar/style.min.css";i:52;s:25:"categories/editor-rtl.css";i:53;s:29:"categories/editor-rtl.min.css";i:54;s:21:"categories/editor.css";i:55;s:25:"categories/editor.min.css";i:56;s:24:"categories/style-rtl.css";i:57;s:28:"categories/style-rtl.min.css";i:58;s:20:"categories/style.css";i:59;s:24:"categories/style.min.css";i:60;s:19:"code/editor-rtl.css";i:61;s:23:"code/editor-rtl.min.css";i:62;s:15:"code/editor.css";i:63;s:19:"code/editor.min.css";i:64;s:18:"code/style-rtl.css";i:65;s:22:"code/style-rtl.min.css";i:66;s:14:"code/style.css";i:67;s:18:"code/style.min.css";i:68;s:18:"code/theme-rtl.css";i:69;s:22:"code/theme-rtl.min.css";i:70;s:14:"code/theme.css";i:71;s:18:"code/theme.min.css";i:72;s:22:"columns/editor-rtl.css";i:73;s:26:"columns/editor-rtl.min.css";i:74;s:18:"columns/editor.css";i:75;s:22:"columns/editor.min.css";i:76;s:21:"columns/style-rtl.css";i:77;s:25:"columns/style-rtl.min.css";i:78;s:17:"columns/style.css";i:79;s:21:"columns/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:30:"comment-template/style-rtl.css";i:85;s:34:"comment-template/style-rtl.min.css";i:86;s:26:"comment-template/style.css";i:87;s:30:"comment-template/style.min.css";i:88;s:42:"comments-pagination-numbers/editor-rtl.css";i:89;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:90;s:38:"comments-pagination-numbers/editor.css";i:91;s:42:"comments-pagination-numbers/editor.min.css";i:92;s:34:"comments-pagination/editor-rtl.css";i:93;s:38:"comments-pagination/editor-rtl.min.css";i:94;s:30:"comments-pagination/editor.css";i:95;s:34:"comments-pagination/editor.min.css";i:96;s:33:"comments-pagination/style-rtl.css";i:97;s:37:"comments-pagination/style-rtl.min.css";i:98;s:29:"comments-pagination/style.css";i:99;s:33:"comments-pagination/style.min.css";i:100;s:29:"comments-title/editor-rtl.css";i:101;s:33:"comments-title/editor-rtl.min.css";i:102;s:25:"comments-title/editor.css";i:103;s:29:"comments-title/editor.min.css";i:104;s:23:"comments/editor-rtl.css";i:105;s:27:"comments/editor-rtl.min.css";i:106;s:19:"comments/editor.css";i:107;s:23:"comments/editor.min.css";i:108;s:22:"comments/style-rtl.css";i:109;s:26:"comments/style-rtl.min.css";i:110;s:18:"comments/style.css";i:111;s:22:"comments/style.min.css";i:112;s:20:"cover/editor-rtl.css";i:113;s:24:"cover/editor-rtl.min.css";i:114;s:16:"cover/editor.css";i:115;s:20:"cover/editor.min.css";i:116;s:19:"cover/style-rtl.css";i:117;s:23:"cover/style-rtl.min.css";i:118;s:15:"cover/style.css";i:119;s:19:"cover/style.min.css";i:120;s:22:"details/editor-rtl.css";i:121;s:26:"details/editor-rtl.min.css";i:122;s:18:"details/editor.css";i:123;s:22:"details/editor.min.css";i:124;s:21:"details/style-rtl.css";i:125;s:25:"details/style-rtl.min.css";i:126;s:17:"details/style.css";i:127;s:21:"details/style.min.css";i:128;s:20:"embed/editor-rtl.css";i:129;s:24:"embed/editor-rtl.min.css";i:130;s:16:"embed/editor.css";i:131;s:20:"embed/editor.min.css";i:132;s:19:"embed/style-rtl.css";i:133;s:23:"embed/style-rtl.min.css";i:134;s:15:"embed/style.css";i:135;s:19:"embed/style.min.css";i:136;s:19:"embed/theme-rtl.css";i:137;s:23:"embed/theme-rtl.min.css";i:138;s:15:"embed/theme.css";i:139;s:19:"embed/theme.min.css";i:140;s:19:"file/editor-rtl.css";i:141;s:23:"file/editor-rtl.min.css";i:142;s:15:"file/editor.css";i:143;s:19:"file/editor.min.css";i:144;s:18:"file/style-rtl.css";i:145;s:22:"file/style-rtl.min.css";i:146;s:14:"file/style.css";i:147;s:18:"file/style.min.css";i:148;s:23:"footnotes/style-rtl.css";i:149;s:27:"footnotes/style-rtl.min.css";i:150;s:19:"footnotes/style.css";i:151;s:23:"footnotes/style.min.css";i:152;s:23:"freeform/editor-rtl.css";i:153;s:27:"freeform/editor-rtl.min.css";i:154;s:19:"freeform/editor.css";i:155;s:23:"freeform/editor.min.css";i:156;s:22:"gallery/editor-rtl.css";i:157;s:26:"gallery/editor-rtl.min.css";i:158;s:18:"gallery/editor.css";i:159;s:22:"gallery/editor.min.css";i:160;s:21:"gallery/style-rtl.css";i:161;s:25:"gallery/style-rtl.min.css";i:162;s:17:"gallery/style.css";i:163;s:21:"gallery/style.min.css";i:164;s:21:"gallery/theme-rtl.css";i:165;s:25:"gallery/theme-rtl.min.css";i:166;s:17:"gallery/theme.css";i:167;s:21:"gallery/theme.min.css";i:168;s:20:"group/editor-rtl.css";i:169;s:24:"group/editor-rtl.min.css";i:170;s:16:"group/editor.css";i:171;s:20:"group/editor.min.css";i:172;s:19:"group/style-rtl.css";i:173;s:23:"group/style-rtl.min.css";i:174;s:15:"group/style.css";i:175;s:19:"group/style.min.css";i:176;s:19:"group/theme-rtl.css";i:177;s:23:"group/theme-rtl.min.css";i:178;s:15:"group/theme.css";i:179;s:19:"group/theme.min.css";i:180;s:21:"heading/style-rtl.css";i:181;s:25:"heading/style-rtl.min.css";i:182;s:17:"heading/style.css";i:183;s:21:"heading/style.min.css";i:184;s:19:"html/editor-rtl.css";i:185;s:23:"html/editor-rtl.min.css";i:186;s:15:"html/editor.css";i:187;s:19:"html/editor.min.css";i:188;s:20:"image/editor-rtl.css";i:189;s:24:"image/editor-rtl.min.css";i:190;s:16:"image/editor.css";i:191;s:20:"image/editor.min.css";i:192;s:19:"image/style-rtl.css";i:193;s:23:"image/style-rtl.min.css";i:194;s:15:"image/style.css";i:195;s:19:"image/style.min.css";i:196;s:19:"image/theme-rtl.css";i:197;s:23:"image/theme-rtl.min.css";i:198;s:15:"image/theme.css";i:199;s:19:"image/theme.min.css";i:200;s:29:"latest-comments/style-rtl.css";i:201;s:33:"latest-comments/style-rtl.min.css";i:202;s:25:"latest-comments/style.css";i:203;s:29:"latest-comments/style.min.css";i:204;s:27:"latest-posts/editor-rtl.css";i:205;s:31:"latest-posts/editor-rtl.min.css";i:206;s:23:"latest-posts/editor.css";i:207;s:27:"latest-posts/editor.min.css";i:208;s:26:"latest-posts/style-rtl.css";i:209;s:30:"latest-posts/style-rtl.min.css";i:210;s:22:"latest-posts/style.css";i:211;s:26:"latest-posts/style.min.css";i:212;s:18:"list/style-rtl.css";i:213;s:22:"list/style-rtl.min.css";i:214;s:14:"list/style.css";i:215;s:18:"list/style.min.css";i:216;s:25:"media-text/editor-rtl.css";i:217;s:29:"media-text/editor-rtl.min.css";i:218;s:21:"media-text/editor.css";i:219;s:25:"media-text/editor.min.css";i:220;s:24:"media-text/style-rtl.css";i:221;s:28:"media-text/style-rtl.min.css";i:222;s:20:"media-text/style.css";i:223;s:24:"media-text/style.min.css";i:224;s:19:"more/editor-rtl.css";i:225;s:23:"more/editor-rtl.min.css";i:226;s:15:"more/editor.css";i:227;s:19:"more/editor.min.css";i:228;s:30:"navigation-link/editor-rtl.css";i:229;s:34:"navigation-link/editor-rtl.min.css";i:230;s:26:"navigation-link/editor.css";i:231;s:30:"navigation-link/editor.min.css";i:232;s:29:"navigation-link/style-rtl.css";i:233;s:33:"navigation-link/style-rtl.min.css";i:234;s:25:"navigation-link/style.css";i:235;s:29:"navigation-link/style.min.css";i:236;s:33:"navigation-submenu/editor-rtl.css";i:237;s:37:"navigation-submenu/editor-rtl.min.css";i:238;s:29:"navigation-submenu/editor.css";i:239;s:33:"navigation-submenu/editor.min.css";i:240;s:25:"navigation/editor-rtl.css";i:241;s:29:"navigation/editor-rtl.min.css";i:242;s:21:"navigation/editor.css";i:243;s:25:"navigation/editor.min.css";i:244;s:24:"navigation/style-rtl.css";i:245;s:28:"navigation/style-rtl.min.css";i:246;s:20:"navigation/style.css";i:247;s:24:"navigation/style.min.css";i:248;s:23:"nextpage/editor-rtl.css";i:249;s:27:"nextpage/editor-rtl.min.css";i:250;s:19:"nextpage/editor.css";i:251;s:23:"nextpage/editor.min.css";i:252;s:24:"page-list/editor-rtl.css";i:253;s:28:"page-list/editor-rtl.min.css";i:254;s:20:"page-list/editor.css";i:255;s:24:"page-list/editor.min.css";i:256;s:23:"page-list/style-rtl.css";i:257;s:27:"page-list/style-rtl.min.css";i:258;s:19:"page-list/style.css";i:259;s:23:"page-list/style.min.css";i:260;s:24:"paragraph/editor-rtl.css";i:261;s:28:"paragraph/editor-rtl.min.css";i:262;s:20:"paragraph/editor.css";i:263;s:24:"paragraph/editor.min.css";i:264;s:23:"paragraph/style-rtl.css";i:265;s:27:"paragraph/style-rtl.min.css";i:266;s:19:"paragraph/style.css";i:267;s:23:"paragraph/style.min.css";i:268;s:25:"post-author/style-rtl.css";i:269;s:29:"post-author/style-rtl.min.css";i:270;s:21:"post-author/style.css";i:271;s:25:"post-author/style.min.css";i:272;s:33:"post-comments-form/editor-rtl.css";i:273;s:37:"post-comments-form/editor-rtl.min.css";i:274;s:29:"post-comments-form/editor.css";i:275;s:33:"post-comments-form/editor.min.css";i:276;s:32:"post-comments-form/style-rtl.css";i:277;s:36:"post-comments-form/style-rtl.min.css";i:278;s:28:"post-comments-form/style.css";i:279;s:32:"post-comments-form/style.min.css";i:280;s:23:"post-date/style-rtl.css";i:281;s:27:"post-date/style-rtl.min.css";i:282;s:19:"post-date/style.css";i:283;s:23:"post-date/style.min.css";i:284;s:27:"post-excerpt/editor-rtl.css";i:285;s:31:"post-excerpt/editor-rtl.min.css";i:286;s:23:"post-excerpt/editor.css";i:287;s:27:"post-excerpt/editor.min.css";i:288;s:26:"post-excerpt/style-rtl.css";i:289;s:30:"post-excerpt/style-rtl.min.css";i:290;s:22:"post-excerpt/style.css";i:291;s:26:"post-excerpt/style.min.css";i:292;s:34:"post-featured-image/editor-rtl.css";i:293;s:38:"post-featured-image/editor-rtl.min.css";i:294;s:30:"post-featured-image/editor.css";i:295;s:34:"post-featured-image/editor.min.css";i:296;s:33:"post-featured-image/style-rtl.css";i:297;s:37:"post-featured-image/style-rtl.min.css";i:298;s:29:"post-featured-image/style.css";i:299;s:33:"post-featured-image/style.min.css";i:300;s:34:"post-navigation-link/style-rtl.css";i:301;s:38:"post-navigation-link/style-rtl.min.css";i:302;s:30:"post-navigation-link/style.css";i:303;s:34:"post-navigation-link/style.min.css";i:304;s:28:"post-template/editor-rtl.css";i:305;s:32:"post-template/editor-rtl.min.css";i:306;s:24:"post-template/editor.css";i:307;s:28:"post-template/editor.min.css";i:308;s:27:"post-template/style-rtl.css";i:309;s:31:"post-template/style-rtl.min.css";i:310;s:23:"post-template/style.css";i:311;s:27:"post-template/style.min.css";i:312;s:24:"post-terms/style-rtl.css";i:313;s:28:"post-terms/style-rtl.min.css";i:314;s:20:"post-terms/style.css";i:315;s:24:"post-terms/style.min.css";i:316;s:24:"post-title/style-rtl.css";i:317;s:28:"post-title/style-rtl.min.css";i:318;s:20:"post-title/style.css";i:319;s:24:"post-title/style.min.css";i:320;s:26:"preformatted/style-rtl.css";i:321;s:30:"preformatted/style-rtl.min.css";i:322;s:22:"preformatted/style.css";i:323;s:26:"preformatted/style.min.css";i:324;s:24:"pullquote/editor-rtl.css";i:325;s:28:"pullquote/editor-rtl.min.css";i:326;s:20:"pullquote/editor.css";i:327;s:24:"pullquote/editor.min.css";i:328;s:23:"pullquote/style-rtl.css";i:329;s:27:"pullquote/style-rtl.min.css";i:330;s:19:"pullquote/style.css";i:331;s:23:"pullquote/style.min.css";i:332;s:23:"pullquote/theme-rtl.css";i:333;s:27:"pullquote/theme-rtl.min.css";i:334;s:19:"pullquote/theme.css";i:335;s:23:"pullquote/theme.min.css";i:336;s:39:"query-pagination-numbers/editor-rtl.css";i:337;s:43:"query-pagination-numbers/editor-rtl.min.css";i:338;s:35:"query-pagination-numbers/editor.css";i:339;s:39:"query-pagination-numbers/editor.min.css";i:340;s:31:"query-pagination/editor-rtl.css";i:341;s:35:"query-pagination/editor-rtl.min.css";i:342;s:27:"query-pagination/editor.css";i:343;s:31:"query-pagination/editor.min.css";i:344;s:30:"query-pagination/style-rtl.css";i:345;s:34:"query-pagination/style-rtl.min.css";i:346;s:26:"query-pagination/style.css";i:347;s:30:"query-pagination/style.min.css";i:348;s:25:"query-title/style-rtl.css";i:349;s:29:"query-title/style-rtl.min.css";i:350;s:21:"query-title/style.css";i:351;s:25:"query-title/style.min.css";i:352;s:20:"query/editor-rtl.css";i:353;s:24:"query/editor-rtl.min.css";i:354;s:16:"query/editor.css";i:355;s:20:"query/editor.min.css";i:356;s:19:"query/style-rtl.css";i:357;s:23:"query/style-rtl.min.css";i:358;s:15:"query/style.css";i:359;s:19:"query/style.min.css";i:360;s:19:"quote/style-rtl.css";i:361;s:23:"quote/style-rtl.min.css";i:362;s:15:"quote/style.css";i:363;s:19:"quote/style.min.css";i:364;s:19:"quote/theme-rtl.css";i:365;s:23:"quote/theme-rtl.min.css";i:366;s:15:"quote/theme.css";i:367;s:19:"quote/theme.min.css";i:368;s:23:"read-more/style-rtl.css";i:369;s:27:"read-more/style-rtl.min.css";i:370;s:19:"read-more/style.css";i:371;s:23:"read-more/style.min.css";i:372;s:18:"rss/editor-rtl.css";i:373;s:22:"rss/editor-rtl.min.css";i:374;s:14:"rss/editor.css";i:375;s:18:"rss/editor.min.css";i:376;s:17:"rss/style-rtl.css";i:377;s:21:"rss/style-rtl.min.css";i:378;s:13:"rss/style.css";i:379;s:17:"rss/style.min.css";i:380;s:21:"search/editor-rtl.css";i:381;s:25:"search/editor-rtl.min.css";i:382;s:17:"search/editor.css";i:383;s:21:"search/editor.min.css";i:384;s:20:"search/style-rtl.css";i:385;s:24:"search/style-rtl.min.css";i:386;s:16:"search/style.css";i:387;s:20:"search/style.min.css";i:388;s:20:"search/theme-rtl.css";i:389;s:24:"search/theme-rtl.min.css";i:390;s:16:"search/theme.css";i:391;s:20:"search/theme.min.css";i:392;s:24:"separator/editor-rtl.css";i:393;s:28:"separator/editor-rtl.min.css";i:394;s:20:"separator/editor.css";i:395;s:24:"separator/editor.min.css";i:396;s:23:"separator/style-rtl.css";i:397;s:27:"separator/style-rtl.min.css";i:398;s:19:"separator/style.css";i:399;s:23:"separator/style.min.css";i:400;s:23:"separator/theme-rtl.css";i:401;s:27:"separator/theme-rtl.min.css";i:402;s:19:"separator/theme.css";i:403;s:23:"separator/theme.min.css";i:404;s:24:"shortcode/editor-rtl.css";i:405;s:28:"shortcode/editor-rtl.min.css";i:406;s:20:"shortcode/editor.css";i:407;s:24:"shortcode/editor.min.css";i:408;s:24:"site-logo/editor-rtl.css";i:409;s:28:"site-logo/editor-rtl.min.css";i:410;s:20:"site-logo/editor.css";i:411;s:24:"site-logo/editor.min.css";i:412;s:23:"site-logo/style-rtl.css";i:413;s:27:"site-logo/style-rtl.min.css";i:414;s:19:"site-logo/style.css";i:415;s:23:"site-logo/style.min.css";i:416;s:27:"site-tagline/editor-rtl.css";i:417;s:31:"site-tagline/editor-rtl.min.css";i:418;s:23:"site-tagline/editor.css";i:419;s:27:"site-tagline/editor.min.css";i:420;s:25:"site-title/editor-rtl.css";i:421;s:29:"site-title/editor-rtl.min.css";i:422;s:21:"site-title/editor.css";i:423;s:25:"site-title/editor.min.css";i:424;s:24:"site-title/style-rtl.css";i:425;s:28:"site-title/style-rtl.min.css";i:426;s:20:"site-title/style.css";i:427;s:24:"site-title/style.min.css";i:428;s:26:"social-link/editor-rtl.css";i:429;s:30:"social-link/editor-rtl.min.css";i:430;s:22:"social-link/editor.css";i:431;s:26:"social-link/editor.min.css";i:432;s:27:"social-links/editor-rtl.css";i:433;s:31:"social-links/editor-rtl.min.css";i:434;s:23:"social-links/editor.css";i:435;s:27:"social-links/editor.min.css";i:436;s:26:"social-links/style-rtl.css";i:437;s:30:"social-links/style-rtl.min.css";i:438;s:22:"social-links/style.css";i:439;s:26:"social-links/style.min.css";i:440;s:21:"spacer/editor-rtl.css";i:441;s:25:"spacer/editor-rtl.min.css";i:442;s:17:"spacer/editor.css";i:443;s:21:"spacer/editor.min.css";i:444;s:20:"spacer/style-rtl.css";i:445;s:24:"spacer/style-rtl.min.css";i:446;s:16:"spacer/style.css";i:447;s:20:"spacer/style.min.css";i:448;s:20:"table/editor-rtl.css";i:449;s:24:"table/editor-rtl.min.css";i:450;s:16:"table/editor.css";i:451;s:20:"table/editor.min.css";i:452;s:19:"table/style-rtl.css";i:453;s:23:"table/style-rtl.min.css";i:454;s:15:"table/style.css";i:455;s:19:"table/style.min.css";i:456;s:19:"table/theme-rtl.css";i:457;s:23:"table/theme-rtl.min.css";i:458;s:15:"table/theme.css";i:459;s:19:"table/theme.min.css";i:460;s:23:"tag-cloud/style-rtl.css";i:461;s:27:"tag-cloud/style-rtl.min.css";i:462;s:19:"tag-cloud/style.css";i:463;s:23:"tag-cloud/style.min.css";i:464;s:28:"template-part/editor-rtl.css";i:465;s:32:"template-part/editor-rtl.min.css";i:466;s:24:"template-part/editor.css";i:467;s:28:"template-part/editor.min.css";i:468;s:27:"template-part/theme-rtl.css";i:469;s:31:"template-part/theme-rtl.min.css";i:470;s:23:"template-part/theme.css";i:471;s:27:"template-part/theme.min.css";i:472;s:30:"term-description/style-rtl.css";i:473;s:34:"term-description/style-rtl.min.css";i:474;s:26:"term-description/style.css";i:475;s:30:"term-description/style.min.css";i:476;s:27:"text-columns/editor-rtl.css";i:477;s:31:"text-columns/editor-rtl.min.css";i:478;s:23:"text-columns/editor.css";i:479;s:27:"text-columns/editor.min.css";i:480;s:26:"text-columns/style-rtl.css";i:481;s:30:"text-columns/style-rtl.min.css";i:482;s:22:"text-columns/style.css";i:483;s:26:"text-columns/style.min.css";i:484;s:19:"verse/style-rtl.css";i:485;s:23:"verse/style-rtl.min.css";i:486;s:15:"verse/style.css";i:487;s:19:"verse/style.min.css";i:488;s:20:"video/editor-rtl.css";i:489;s:24:"video/editor-rtl.min.css";i:490;s:16:"video/editor.css";i:491;s:20:"video/editor.min.css";i:492;s:19:"video/style-rtl.css";i:493;s:23:"video/style-rtl.min.css";i:494;s:15:"video/style.css";i:495;s:19:"video/style.min.css";i:496;s:19:"video/theme-rtl.css";i:497;s:23:"video/theme-rtl.min.css";i:498;s:15:"video/theme.css";i:499;s:19:"video/theme.min.css";}}', 'yes'),
	(123, 'recovery_keys', 'a:0:{}', 'yes'),
	(124, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-6.4.2.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-6.4.2.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-6.4.2-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-6.4.2-new-bundled.zip";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.4.2";s:7:"version";s:5:"6.4.2";s:11:"php_version";s:5:"7.0.0";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1704710073;s:15:"version_checked";s:5:"6.4.2";s:12:"translations";a:0:{}}', 'no'),
	(126, 'theme_mods_twentytwentyfour', 'a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1702653282;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}', 'yes'),
	(127, '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1704710076;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:2:{s:19:"akismet/akismet.php";O:8:"stdClass":10:{s:2:"id";s:21:"w.org/plugins/akismet";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:3:"5.3";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:54:"https://downloads.wordpress.org/plugin/akismet.5.3.zip";s:5:"icons";a:2:{s:2:"2x";s:60:"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463";s:2:"1x";s:60:"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463";}s:7:"banners";a:2:{s:2:"2x";s:63:"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731";s:2:"1x";s:62:"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"5.8";}s:9:"hello.php";O:8:"stdClass":10:{s:2:"id";s:25:"w.org/plugins/hello-dolly";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:5:"1.7.2";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855";s:2:"1x";s:64:"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582";s:2:"1x";s:66:"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855";}s:11:"banners_rtl";a:0:{}s:8:"requires";s:3:"4.6";}}s:7:"checked";a:2:{s:19:"akismet/akismet.php";s:3:"5.3";s:9:"hello.php";s:5:"1.7.2";}}', 'no'),
	(130, '_site_transient_update_themes', 'O:8:"stdClass":5:{s:12:"last_checked";i:1704710076;s:7:"checked";a:4:{s:5:"temas";s:0:"";s:16:"twentytwentyfour";s:3:"1.0";s:17:"twentytwentythree";s:3:"1.3";s:15:"twentytwentytwo";s:3:"1.6";}s:8:"response";a:0:{}s:9:"no_update";a:3:{s:16:"twentytwentyfour";a:6:{s:5:"theme";s:16:"twentytwentyfour";s:11:"new_version";s:3:"1.0";s:3:"url";s:46:"https://wordpress.org/themes/twentytwentyfour/";s:7:"package";s:62:"https://downloads.wordpress.org/theme/twentytwentyfour.1.0.zip";s:8:"requires";s:3:"6.4";s:12:"requires_php";s:3:"7.0";}s:17:"twentytwentythree";a:6:{s:5:"theme";s:17:"twentytwentythree";s:11:"new_version";s:3:"1.3";s:3:"url";s:47:"https://wordpress.org/themes/twentytwentythree/";s:7:"package";s:63:"https://downloads.wordpress.org/theme/twentytwentythree.1.3.zip";s:8:"requires";s:3:"6.1";s:12:"requires_php";s:3:"5.6";}s:15:"twentytwentytwo";a:6:{s:5:"theme";s:15:"twentytwentytwo";s:11:"new_version";s:3:"1.6";s:3:"url";s:45:"https://wordpress.org/themes/twentytwentytwo/";s:7:"package";s:61:"https://downloads.wordpress.org/theme/twentytwentytwo.1.6.zip";s:8:"requires";s:3:"5.9";s:12:"requires_php";s:3:"5.6";}}s:12:"translations";a:0:{}}', 'no'),
	(136, 'can_compress_scripts', '1', 'yes'),
	(151, 'finished_updating_comment_type', '1', 'yes'),
	(152, 'current_theme', '', 'yes'),
	(153, 'theme_mods_temas', 'a:3:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:11:"header-menu";i:2;}s:18:"custom_css_post_id";i:-1;}', 'yes'),
	(154, 'theme_switched', '', 'yes'),
	(170, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
	(175, 'category_children', 'a:0:{}', 'yes'),
	(180, 'https_detection_errors', 'a:1:{s:23:"ssl_verification_failed";a:1:{i:0;s:24:"SSL verification failed.";}}', 'yes'),
	(181, '_transient_health-check-site-status-result', '{"good":17,"recommended":5,"critical":1}', 'yes'),
	(217, '_site_transient_timeout_theme_roots', '1704711876', 'no'),
	(218, '_site_transient_theme_roots', 'a:4:{s:5:"temas";s:7:"/themes";s:16:"twentytwentyfour";s:7:"/themes";s:17:"twentytwentythree";s:7:"/themes";s:15:"twentytwentytwo";s:7:"/themes";}', 'no'),
	(219, '_site_transient_timeout_php_check_da775d00ae55849f14f81cf79fc50d46', '1705314878', 'no'),
	(220, '_site_transient_php_check_da775d00ae55849f14f81cf79fc50d46', 'a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:3:"7.0";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}', 'no');

-- Dumping structure for table database_prakse.wp_postmeta
CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_postmeta: ~72 rows (approximately)
INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
	(1, 2, '_wp_page_template', 'default'),
	(2, 3, '_wp_page_template', 'default'),
	(4, 2, '_wp_trash_meta_status', 'publish'),
	(5, 2, '_wp_trash_meta_time', '1702653642'),
	(6, 2, '_wp_desired_post_slug', 'sample-page'),
	(7, 8, '_edit_lock', '1702993333:1'),
	(8, 10, '_edit_lock', '1702994519:1'),
	(9, 12, '_edit_lock', '1702989412:1'),
	(10, 14, '_edit_lock', '1702990190:1'),
	(11, 16, '_wp_attached_file', '2023/12/Hollow_Clown_Pfp.jpg'),
	(12, 16, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:28:"2023/12/Hollow_Clown_Pfp.jpg";s:8:"filesize";i:73189;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(13, 18, '_wp_attached_file', '2023/12/Hollow_Frozen_Pfp.jpg'),
	(14, 18, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:2048;s:6:"height";i:2048;s:4:"file";s:29:"2023/12/Hollow_Frozen_Pfp.jpg";s:8:"filesize";i:1300095;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(15, 20, '_wp_attached_file', '2023/12/Shallow.jpg'),
	(16, 20, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:19:"2023/12/Shallow.jpg";s:8:"filesize";i:143243;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(17, 22, '_wp_attached_file', '2023/12/Dismal.jpg'),
	(18, 22, '_wp_attachment_metadata', 'a:6:{s:5:"width";i:1280;s:6:"height";i:720;s:4:"file";s:18:"2023/12/Dismal.jpg";s:8:"filesize";i:102217;s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
	(19, 24, '_menu_item_type', 'custom'),
	(20, 24, '_menu_item_menu_item_parent', '0'),
	(21, 24, '_menu_item_object_id', '24'),
	(22, 24, '_menu_item_object', 'custom'),
	(23, 24, '_menu_item_target', ''),
	(24, 24, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(25, 24, '_menu_item_xfn', ''),
	(26, 24, '_menu_item_url', 'http://localhost/wordpress/wordpressprakse/'),
	(28, 25, '_menu_item_type', 'post_type'),
	(29, 25, '_menu_item_menu_item_parent', '0'),
	(30, 25, '_menu_item_object_id', '8'),
	(31, 25, '_menu_item_object', 'page'),
	(32, 25, '_menu_item_target', ''),
	(33, 25, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(34, 25, '_menu_item_xfn', ''),
	(35, 25, '_menu_item_url', ''),
	(37, 26, '_menu_item_type', 'post_type'),
	(38, 26, '_menu_item_menu_item_parent', '0'),
	(39, 26, '_menu_item_object_id', '10'),
	(40, 26, '_menu_item_object', 'page'),
	(41, 26, '_menu_item_target', ''),
	(42, 26, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(43, 26, '_menu_item_xfn', ''),
	(44, 26, '_menu_item_url', ''),
	(46, 27, '_menu_item_type', 'post_type'),
	(47, 27, '_menu_item_menu_item_parent', '26'),
	(48, 27, '_menu_item_object_id', '12'),
	(49, 27, '_menu_item_object', 'page'),
	(50, 27, '_menu_item_target', ''),
	(51, 27, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(52, 27, '_menu_item_xfn', ''),
	(53, 27, '_menu_item_url', ''),
	(55, 28, '_menu_item_type', 'post_type'),
	(56, 28, '_menu_item_menu_item_parent', '26'),
	(57, 28, '_menu_item_object_id', '14'),
	(58, 28, '_menu_item_object', 'page'),
	(59, 28, '_menu_item_target', ''),
	(60, 28, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(61, 28, '_menu_item_xfn', ''),
	(62, 28, '_menu_item_url', ''),
	(64, 30, '_menu_item_type', 'taxonomy'),
	(65, 30, '_menu_item_menu_item_parent', '0'),
	(66, 30, '_menu_item_object_id', '3'),
	(67, 30, '_menu_item_object', 'category'),
	(68, 30, '_menu_item_target', ''),
	(69, 30, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
	(70, 30, '_menu_item_xfn', ''),
	(71, 30, '_menu_item_url', ''),
	(73, 24, '_wp_old_date', '2023-12-15'),
	(74, 25, '_wp_old_date', '2023-12-15'),
	(75, 26, '_wp_old_date', '2023-12-15'),
	(76, 27, '_wp_old_date', '2023-12-15'),
	(77, 28, '_wp_old_date', '2023-12-15'),
	(78, 30, '_wp_old_date', '2023-12-15'),
	(79, 31, 'footnotes', '');

-- Dumping structure for table database_prakse.wp_posts
CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_posts: ~30 rows (approximately)
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
	(1, 1, '2023-12-15 15:07:28', '2023-12-15 15:07:28', '<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->', 'Hello world!', '', 'publish', 'open', 'open', '', 'hello-world', '', '', '2023-12-15 15:07:28', '2023-12-15 15:07:28', '', 0, 'http://localhost/wordpress/wordpressprakse/?p=1', 0, 'post', '', 1),
	(2, 1, '2023-12-15 15:07:28', '2023-12-15 15:07:28', '<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href="http://localhost/wordpress/wordpressprakse/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->', 'Sample Page', '', 'trash', 'closed', 'open', '', 'sample-page__trashed', '', '', '2023-12-15 15:20:42', '2023-12-15 15:20:42', '', 0, 'http://localhost/wordpress/wordpressprakse/?page_id=2', 0, 'page', '', 0),
	(3, 1, '2023-12-15 15:07:28', '2023-12-15 15:07:28', '<!-- wp:heading --><h2>Who we are</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>Our website address is: http://localhost/wordpress/wordpressprakse.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Comments</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Media</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Embedded content from other websites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Who we share your data with</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>How long we retain your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What rights you have over your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Where your data is sent</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class="privacy-policy-tutorial">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p><!-- /wp:paragraph -->', 'Privacy Policy', '', 'draft', 'closed', 'open', '', 'privacy-policy', '', '', '2023-12-15 15:07:28', '2023-12-15 15:07:28', '', 0, 'http://localhost/wordpress/wordpressprakse/?page_id=3', 0, 'page', '', 0),
	(4, 0, '2023-12-15 15:07:31', '2023-12-15 15:07:31', '<!-- wp:page-list /-->', 'Navigation', '', 'publish', 'closed', 'closed', '', 'navigation', '', '', '2023-12-15 15:07:31', '2023-12-15 15:07:31', '', 0, 'http://localhost/wordpress/wordpressprakse/2023/12/15/navigation/', 0, 'wp_navigation', '', 0),
	(7, 1, '2023-12-15 15:20:42', '2023-12-15 15:20:42', '<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class="wp-block-quote"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href="http://localhost/wordpress/wordpressprakse/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2023-12-15 15:20:42', '2023-12-15 15:20:42', '', 2, 'http://localhost/wordpress/wordpressprakse/?p=7', 0, 'revision', '', 0),
	(8, 1, '2023-12-15 15:20:55', '2023-12-15 15:20:55', '<!-- wp:paragraph -->\n<p>I have no friends..</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":16,"width":"522px","height":"auto","sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full is-resized"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Clown_Pfp.jpg" alt="" class="wp-image-16" style="width:522px;height:auto"/></figure>\n<!-- /wp:image -->', 'Page 1', '', 'publish', 'closed', 'closed', '', 'page-1', '', '', '2023-12-15 16:19:36', '2023-12-15 16:19:36', '', 0, 'http://localhost/wordpress/wordpressprakse/?page_id=8', 0, 'page', '', 0),
	(9, 1, '2023-12-15 15:20:55', '2023-12-15 15:20:55', '', 'Page 1', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2023-12-15 15:20:55', '2023-12-15 15:20:55', '', 8, 'http://localhost/wordpress/wordpressprakse/?p=9', 0, 'revision', '', 0),
	(10, 1, '2023-12-15 15:21:04', '2023-12-15 15:21:04', '<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:media-text {"mediaId":20,"linkDestination":"custom","mediaType":"image","verticalAlignment":"center"} -->\n<div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center"><figure class="wp-block-media-text__media"><a href="http://localhost/wordpress/wordpressprakse/page-2/page-3/"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg" alt="" class="wp-image-20 size-full"/></a></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 3</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:media-text {"mediaId":22,"linkDestination":"custom","mediaType":"image"} -->\n<div class="wp-block-media-text is-stacked-on-mobile"><figure class="wp-block-media-text__media"><a href="http://localhost/wordpress/wordpressprakse/page-2/page-4/"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg" alt="" class="wp-image-22 size-full"/></a></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 4</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->', 'Page 2', '', 'publish', 'closed', 'closed', '', 'page-2', '', '', '2023-12-19 14:02:09', '2023-12-19 14:02:09', '', 0, 'http://localhost/wordpress/wordpressprakse/?page_id=10', 0, 'page', '', 0),
	(11, 1, '2023-12-15 15:21:04', '2023-12-15 15:21:04', '', 'Page 2', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2023-12-15 15:21:04', '2023-12-15 15:21:04', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=11', 0, 'revision', '', 0),
	(12, 1, '2023-12-15 15:21:28', '2023-12-15 15:21:28', '<!-- wp:paragraph -->\n<p>Kaboooooom</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":20,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg" alt="" class="wp-image-20"/></figure>\n<!-- /wp:image -->', 'Page 3', '', 'publish', 'closed', 'closed', '', 'page-3', '', '', '2023-12-19 12:39:15', '2023-12-19 12:39:15', '', 10, 'http://localhost/wordpress/wordpressprakse/?page_id=12', 0, 'page', '', 0),
	(13, 1, '2023-12-15 15:21:28', '2023-12-15 15:21:28', '', 'Page 3', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2023-12-15 15:21:28', '2023-12-15 15:21:28', '', 12, 'http://localhost/wordpress/wordpressprakse/?p=13', 0, 'revision', '', 0),
	(14, 1, '2023-12-15 15:21:38', '2023-12-15 15:21:38', '<!-- wp:paragraph -->\n<p>Dark street...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":22,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg" alt="" class="wp-image-22"/></figure>\n<!-- /wp:image -->', 'Page 4', '', 'publish', 'closed', 'closed', '', 'page-4', '', '', '2023-12-19 12:39:28', '2023-12-19 12:39:28', '', 10, 'http://localhost/wordpress/wordpressprakse/?page_id=14', 0, 'page', '', 0),
	(15, 1, '2023-12-15 15:21:38', '2023-12-15 15:21:38', '', 'Page 4', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2023-12-15 15:21:38', '2023-12-15 15:21:38', '', 14, 'http://localhost/wordpress/wordpressprakse/?p=15', 0, 'revision', '', 0),
	(16, 1, '2023-12-15 15:22:20', '2023-12-15 15:22:20', '', 'Hollow_Clown_Pfp', '', 'inherit', '', 'closed', '', 'hollow_clown_pfp', '', '', '2023-12-15 15:22:20', '2023-12-15 15:22:20', '', 8, 'http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Clown_Pfp.jpg', 0, 'attachment', 'image/jpeg', 0),
	(17, 1, '2023-12-15 15:22:52', '2023-12-15 15:22:52', '<!-- wp:paragraph -->\n<p>I have no friends</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":16,"width":"522px","height":"auto","sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full is-resized"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Clown_Pfp.jpg" alt="" class="wp-image-16" style="width:522px;height:auto"/></figure>\n<!-- /wp:image -->', 'Page 1', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2023-12-15 15:22:52', '2023-12-15 15:22:52', '', 8, 'http://localhost/wordpress/wordpressprakse/?p=17', 0, 'revision', '', 0),
	(18, 1, '2023-12-15 15:23:28', '2023-12-15 15:23:28', '', 'Hollow_Frozen_Pfp', '', 'inherit', '', 'closed', '', 'hollow_frozen_pfp', '', '', '2023-12-15 15:23:28', '2023-12-15 15:23:28', '', 10, 'http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Frozen_Pfp.jpg', 0, 'attachment', 'image/jpeg', 0),
	(19, 1, '2023-12-15 15:23:37', '2023-12-15 15:23:37', '<!-- wp:paragraph -->\n<p>It\'s cold brrrr..</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":18,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Frozen_Pfp.jpg" alt="" class="wp-image-18"/></figure>\n<!-- /wp:image -->', 'Page 2', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2023-12-15 15:23:37', '2023-12-15 15:23:37', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=19', 0, 'revision', '', 0),
	(20, 1, '2023-12-15 15:24:08', '2023-12-15 15:24:08', '', 'Shallow', '', 'inherit', '', 'closed', '', 'shallow', '', '', '2023-12-15 15:24:08', '2023-12-15 15:24:08', '', 12, 'http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg', 0, 'attachment', 'image/jpeg', 0),
	(21, 1, '2023-12-15 15:24:13', '2023-12-15 15:24:13', '<!-- wp:paragraph -->\n<p>Kaboooooom</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":20,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg" alt="" class="wp-image-20"/></figure>\n<!-- /wp:image -->', 'Page 3', '', 'inherit', 'closed', 'closed', '', '12-revision-v1', '', '', '2023-12-15 15:24:13', '2023-12-15 15:24:13', '', 12, 'http://localhost/wordpress/wordpressprakse/?p=21', 0, 'revision', '', 0),
	(22, 1, '2023-12-15 15:24:42', '2023-12-15 15:24:42', '', 'Dismal', '', 'inherit', '', 'closed', '', 'dismal', '', '', '2023-12-15 15:24:42', '2023-12-15 15:24:42', '', 14, 'http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg', 0, 'attachment', 'image/jpeg', 0),
	(23, 1, '2023-12-15 15:24:47', '2023-12-15 15:24:47', '<!-- wp:paragraph -->\n<p>Dark street...</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":22,"sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg" alt="" class="wp-image-22"/></figure>\n<!-- /wp:image -->', 'Page 4', '', 'inherit', 'closed', 'closed', '', '14-revision-v1', '', '', '2023-12-15 15:24:47', '2023-12-15 15:24:47', '', 14, 'http://localhost/wordpress/wordpressprakse/?p=23', 0, 'revision', '', 0),
	(24, 1, '2023-12-19 12:52:54', '2023-12-15 16:09:20', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 0, 'http://localhost/wordpress/wordpressprakse/?p=24', 1, 'nav_menu_item', '', 0),
	(25, 1, '2023-12-19 12:52:54', '2023-12-15 16:09:20', ' ', '', '', 'publish', 'closed', 'closed', '', '25', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 0, 'http://localhost/wordpress/wordpressprakse/?p=25', 2, 'nav_menu_item', '', 0),
	(26, 1, '2023-12-19 12:52:54', '2023-12-15 16:09:20', ' ', '', '', 'publish', 'closed', 'closed', '', '26', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 0, 'http://localhost/wordpress/wordpressprakse/?p=26', 3, 'nav_menu_item', '', 0),
	(27, 1, '2023-12-19 12:52:54', '2023-12-15 16:09:20', ' ', '', '', 'publish', 'closed', 'closed', '', '27', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=27', 4, 'nav_menu_item', '', 0),
	(28, 1, '2023-12-19 12:52:54', '2023-12-15 16:09:20', ' ', '', '', 'publish', 'closed', 'closed', '', '28', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=28', 5, 'nav_menu_item', '', 0),
	(29, 1, '2023-12-15 16:19:36', '2023-12-15 16:19:36', '<!-- wp:paragraph -->\n<p>I have no friends..</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {"align":"center","id":16,"width":"522px","height":"auto","sizeSlug":"full","linkDestination":"none"} -->\n<figure class="wp-block-image aligncenter size-full is-resized"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Hollow_Clown_Pfp.jpg" alt="" class="wp-image-16" style="width:522px;height:auto"/></figure>\n<!-- /wp:image -->', 'Page 1', '', 'inherit', 'closed', 'closed', '', '8-revision-v1', '', '', '2023-12-15 16:19:36', '2023-12-15 16:19:36', '', 8, 'http://localhost/wordpress/wordpressprakse/?p=29', 0, 'revision', '', 0),
	(30, 1, '2023-12-19 12:52:54', '2023-12-15 16:25:18', ' ', '', '', 'publish', 'closed', 'closed', '', '30', '', '', '2023-12-19 12:52:54', '2023-12-19 12:52:54', '', 0, 'http://localhost/wordpress/wordpressprakse/?p=30', 6, 'nav_menu_item', '', 0),
	(31, 1, '2023-12-19 14:01:59', '2023-12-19 14:01:59', '<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:media-text {"mediaId":20,"linkDestination":"custom","mediaType":"image","verticalAlignment":"center"} -->\n<div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center"><figure class="wp-block-media-text__media"><a href="http://localhost/wordpress/wordpressprakse/page-2/page-3/"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg" alt="" class="wp-image-20 size-full"/></a></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 3</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:media-text {"mediaId":22,"mediaType":"image"} -->\n<div class="wp-block-media-text is-stacked-on-mobile"><figure class="wp-block-media-text__media"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg" alt="" class="wp-image-22 size-full"/></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 4</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->', 'Page 2', '', 'inherit', 'closed', 'closed', '', '10-autosave-v1', '', '', '2023-12-19 14:01:59', '2023-12-19 14:01:59', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=31', 0, 'revision', '', 0),
	(32, 1, '2023-12-19 14:02:09', '2023-12-19 14:02:09', '<!-- wp:columns -->\n<div class="wp-block-columns"><!-- wp:column -->\n<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->\n<div class="wp-block-group"><!-- wp:media-text {"mediaId":20,"linkDestination":"custom","mediaType":"image","verticalAlignment":"center"} -->\n<div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center"><figure class="wp-block-media-text__media"><a href="http://localhost/wordpress/wordpressprakse/page-2/page-3/"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Shallow.jpg" alt="" class="wp-image-20 size-full"/></a></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 3</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class="wp-block-column"><!-- wp:media-text {"mediaId":22,"linkDestination":"custom","mediaType":"image"} -->\n<div class="wp-block-media-text is-stacked-on-mobile"><figure class="wp-block-media-text__media"><a href="http://localhost/wordpress/wordpressprakse/page-2/page-4/"><img src="http://localhost/wordpress/wordpressprakse/wp-content/uploads/2023/12/Dismal.jpg" alt="" class="wp-image-22 size-full"/></a></figure><div class="wp-block-media-text__content"><!-- wp:paragraph {"placeholder":"Content…"} -->\n<p><strong>Page 4</strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->', 'Page 2', '', 'inherit', 'closed', 'closed', '', '10-revision-v1', '', '', '2023-12-19 14:02:09', '2023-12-19 14:02:09', '', 10, 'http://localhost/wordpress/wordpressprakse/?p=32', 0, 'revision', '', 0);

-- Dumping structure for table database_prakse.wp_termmeta
CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_termmeta: ~0 rows (approximately)

-- Dumping structure for table database_prakse.wp_terms
CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_terms: ~3 rows (approximately)
INSERT INTO `wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
	(1, 'Uncategorized', 'uncategorized', 0),
	(2, 'Menu', 'menu', 0),
	(3, 'Category 1', 'category1', 0);

-- Dumping structure for table database_prakse.wp_term_relationships
CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_term_relationships: ~7 rows (approximately)
INSERT INTO `wp_term_relationships` (`object_id`, `term_taxonomy_id`, `term_order`) VALUES
	(1, 1, 0),
	(24, 2, 0),
	(25, 2, 0),
	(26, 2, 0),
	(27, 2, 0),
	(28, 2, 0),
	(30, 2, 0);

-- Dumping structure for table database_prakse.wp_term_taxonomy
CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_term_taxonomy: ~3 rows (approximately)
INSERT INTO `wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
	(1, 1, 'category', '', 0, 1),
	(2, 2, 'nav_menu', '', 0, 6),
	(3, 3, 'category', '', 0, 0);

-- Dumping structure for table database_prakse.wp_usermeta
CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_usermeta: ~23 rows (approximately)
INSERT INTO `wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
	(1, 1, 'nickname', 'admin'),
	(2, 1, 'first_name', ''),
	(3, 1, 'last_name', ''),
	(4, 1, 'description', ''),
	(5, 1, 'rich_editing', 'true'),
	(6, 1, 'syntax_highlighting', 'true'),
	(7, 1, 'comment_shortcuts', 'false'),
	(8, 1, 'admin_color', 'fresh'),
	(9, 1, 'use_ssl', '0'),
	(10, 1, 'show_admin_bar_front', 'true'),
	(11, 1, 'locale', ''),
	(12, 1, 'wp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
	(13, 1, 'wp_user_level', '10'),
	(14, 1, 'dismissed_wp_pointers', ''),
	(15, 1, 'show_welcome_panel', '1'),
	(16, 1, 'session_tokens', 'a:1:{s:64:"5433d3d070252f14de3ed237ce208db93923688effdcc923dcc83a60cb136267";a:4:{s:10:"expiration";i:1705920990;s:2:"ip";s:3:"::1";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0";s:5:"login";i:1704711390;}}'),
	(17, 1, 'wp_user-settings', 'libraryContent=browse'),
	(18, 1, 'wp_user-settings-time', '1702652867'),
	(19, 1, 'wp_dashboard_quick_press_last_post_id', '5'),
	(20, 1, 'wp_persisted_preferences', 'a:5:{s:4:"core";a:1:{s:29:"isTemplatePartMoveHintVisible";b:0;}s:9:"_modified";s:24:"2023-12-19T12:52:30.459Z";s:14:"core/edit-post";a:4:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;s:10:"openPanels";a:4:{i:0;s:11:"post-status";i:1;s:23:"taxonomy-panel-category";i:2;s:14:"featured-image";i:3;s:15:"page-attributes";}s:20:"welcomeGuideTemplate";b:0;}s:14:"core/edit-site";a:6:{s:12:"welcomeGuide";b:0;s:26:"isComplementaryAreaVisible";b:0;s:18:"welcomeGuideStyles";b:0;s:16:"welcomeGuidePage";b:0;s:20:"welcomeGuideTemplate";b:0;s:10:"editorMode";s:6:"visual";}s:17:"core/block-editor";a:1:{s:25:"linkControlSettingsDrawer";b:0;}}'),
	(21, 1, 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}'),
	(22, 1, 'metaboxhidden_nav-menus', 'a:1:{i:0;s:12:"add-post_tag";}'),
	(23, 1, 'nav_menu_recently_edited', '2');

-- Dumping structure for table database_prakse.wp_users
CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- Dumping data for table database_prakse.wp_users: ~1 rows (approximately)
INSERT INTO `wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
	(1, 'admin', '$P$BuvdGX7zHq1OZlF9jYeKla.BlPCNTG1', 'admin', 'rampansraivis3@gmail.com', 'http://localhost/wordpress/wordpressprakse', '2023-12-15 15:07:28', '', 0, 'admin');


-- Dumping database structure for information_schema
CREATE DATABASE IF NOT EXISTS `information_schema` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;
USE `information_schema`;

-- Dumping structure for table information_schema.ALL_PLUGINS
CREATE TEMPORARY TABLE IF NOT EXISTS `ALL_PLUGINS` (
  `PLUGIN_NAME` varchar(64) NOT NULL,
  `PLUGIN_VERSION` varchar(20) NOT NULL,
  `PLUGIN_STATUS` varchar(16) NOT NULL,
  `PLUGIN_TYPE` varchar(80) NOT NULL,
  `PLUGIN_TYPE_VERSION` varchar(20) NOT NULL,
  `PLUGIN_LIBRARY` varchar(64),
  `PLUGIN_LIBRARY_VERSION` varchar(20),
  `PLUGIN_AUTHOR` varchar(64),
  `PLUGIN_DESCRIPTION` longtext,
  `PLUGIN_LICENSE` varchar(80) NOT NULL,
  `LOAD_OPTION` varchar(64) NOT NULL,
  `PLUGIN_MATURITY` varchar(12) NOT NULL,
  `PLUGIN_AUTH_VERSION` varchar(80)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=0;

-- Dumping data for table information_schema.ALL_PLUGINS: -1 rows
/*!40000 ALTER TABLE `ALL_PLUGINS` DISABLE KEYS */;

-- Dumping database structure for information_schema
CREATE DATABASE IF NOT EXISTS `information_schema` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;
USE `information_schema`;

-- Dumping structure for table information_schema.APPLICABLE_ROLES
CREATE TEMPORARY TABLE IF NOT EXISTS `APPLICABLE_ROLES` (
  `GRANTEE` varchar(190) NOT NULL,
  `ROLE_NAME` varchar(128) NOT NULL,
  `IS_GRANTABLE` varchar(3) NOT NULL,
  `IS_DEFAULT` varchar(3)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table information_schema.APPLICABLE_ROLES: -1 rows
/*!40000 ALTER TABLE `APPLICABLE_ROLES` DISABLE KEYS */;
/*!40000 ALTER TABLE `APPLICABLE_ROLES` ENABLE KEYS */;

-- Dumping structure for table information_schema.CHARACTER_SETS
CREATE TEMPORARY TABLE IF NOT EXISTS `CHARACTER_SETS` (
  `CHARACTER_SET_NAME` varchar(32) NOT NULL,
  `DEFAULT_COLLATE_NAME` varchar(32) NOT NULL,
  `DESCRIPTION` varchar(60) NOT NULL,
  `MAXLEN` bigint(3) NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table information_schema.CHARACTER_SETS: -1 rows
/*!40000 ALTER TABLE `CHARACTER_SETS` DISABLE KEYS */;
INSERT INTO `CHARACTER_SETS` (`CHARACTER_SET_NAME`, `DEFAULT_COLLATE_NAME`, `DESCRIPTION`, `MAXLEN`) VALUES
	('big5', 'big5_chinese_ci', 'Big5 Traditional Chinese', 2),
	('dec8', 'dec8_swedish_ci', 'DEC West European', 1),
	('cp850', 'cp850_general_ci', 'DOS West European', 1),
	('hp8', 'hp8_english_ci', 'HP West European', 1),
	('koi8r', 'koi8r_general_ci', 'KOI8-R Relcom Russian', 1),
	('latin1', 'latin1_swedish_ci', 'cp1252 West European', 1),
	('latin2', 'latin2_general_ci', 'ISO 8859-2 Central European', 1),
	('swe7', 'swe7_swedish_ci', '7bit Swedish', 1),
	('ascii', 'ascii_general_ci', 'US ASCII', 1),
	('ujis', 'ujis_japanese_ci', 'EUC-JP Japanese', 3),
	('sjis', 'sjis_japanese_ci', 'Shift-JIS Japanese', 2),
	('hebrew', 'hebrew_general_ci', 'ISO 8859-8 Hebrew', 1),
	('tis620', 'tis620_thai_ci', 'TIS620 Thai', 1),
	('euckr', 'euckr_korean_ci', 'EUC-KR Korean', 2),
	('koi8u', 'koi8u_general_ci', 'KOI8-U Ukrainian', 1),
	('gb2312', 'gb2312_chinese_ci', 'GB2312 Simplified Chinese', 2),
	('greek', 'greek_general_ci', 'ISO 8859-7 Greek', 1),
	('cp1250', 'cp1250_general_ci', 'Windows Central European', 1),
	('gbk', 'gbk_chinese_ci', 'GBK Simplified Chinese', 2),
	('latin5', 'latin5_turkish_ci', 'ISO 8859-9 Turkish', 1),
	('armscii8', 'armscii8_general_ci', 'ARMSCII-8 Armenian', 1),
	('utf8', 'utf8_general_ci', 'UTF-8 Unicode', 3),
	('ucs2', 'ucs2_general_ci', 'UCS-2 Unicode', 2),
	('cp866', 'cp866_general_ci', 'DOS Russian', 1),
	('keybcs2', 'keybcs2_general_ci', 'DOS Kamenicky Czech-Slovak', 1),
	('macce', 'macce_general_ci', 'Mac Central European', 1),
	('macroman', 'macroman_general_ci', 'Mac West European', 1),
	('cp852', 'cp852_general_ci', 'DOS Central European', 1),
	('latin7', 'latin7_general_ci', 'ISO 8859-13 Baltic', 1),
	('utf8mb4', 'utf8mb4_general_ci', 'UTF-8 Unicode', 4),
	('cp1251', 'cp1251_general_ci', 'Windows Cyrillic', 1),
	('utf16', 'utf16_general_ci', 'UTF-16 Unicode', 4),
	('utf16le', 'utf16le_general_ci', 'UTF-16LE Unicode', 4),
	('cp1256', 'cp1256_general_ci', 'Windows Arabic', 1),
	('cp1257', 'cp1257_general_ci', 'Windows Baltic', 1),
	('utf32', 'utf32_general_ci', 'UTF-32 Unicode', 4),
	('binary', 'binary', 'Binary pseudo charset', 1),
	('geostd8', 'geostd8_general_ci', 'GEOSTD8 Georgian', 1),
	('cp932', 'cp932_japanese_ci', 'SJIS for Windows Japanese', 2),
	('eucjpms', 'eucjpms_japanese_ci', 'UJIS for Windows Japanese', 3);
/*!40000 ALTER TABLE `CHARACTER_SETS` ENABLE KEYS */;

-- Dumping structure for table information_schema.CHECK_CONSTRAINTS
CREATE TEMPORARY TABLE IF NOT EXISTS `CHECK_CONSTRAINTS` (
  `CONSTRAINT_CATALOG` varchar(512) NOT NULL,
  `CONSTRAINT_SCHEMA` varchar(64) NOT NULL,
  `TABLE_NAME` varchar(64) NOT NULL,
  `CONSTRAINT_NAME` varchar(64) NOT NULL,
  `CHECK_CLAUSE` longtext NOT NULL
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=0;

-- Dumping data for table information_schema.CHECK_CONSTRAINTS: -1 rows
/*!40000 ALTER TABLE `CHECK_CONSTRAINTS` DISABLE KEYS */;
INSERT INTO `CHECK_CONSTRAINTS` (`CONSTRAINT_CATALOG`, `CONSTRAINT_SCHEMA`, `TABLE_NAME`, `CONSTRAINT_NAME`, `CHECK_CLAUSE`) VALUES
	('def', 'mysql', 'global_priv', 'Priv', 'json_valid(`Priv`)');
/*!40000 ALTER TABLE `CHECK_CONSTRAINTS` ENABLE KEYS */;

-- Dumping structure for table information_schema.CLIENT_STATISTICS
CREATE TEMPORARY TABLE IF NOT EXISTS `CLIENT_STATISTICS` (
  `CLIENT` varchar(64) NOT NULL,
  `TOTAL_CONNECTIONS` bigint(21) NOT NULL,
  `CONCURRENT_CONNECTIONS` bigint(21) NOT NULL,
  `CONNECTED_TIME` bigint(21) NOT NULL,
  `BUSY_TIME` double NOT NULL,
  `CPU_TIME` double NOT NULL,
  `BYTES_RECEIVED` bigint(21) NOT NULL,
  `BYTES_SENT` bigint(21) NOT NULL,
  `BINLOG_BYTES_WRITTEN` bigint(21) NOT NULL,
  `ROWS_READ` bigint(21) NOT NULL,
  `ROWS_SENT` bigint(21) NOT NULL,
  `ROWS_DELETED` bigint(21) NOT NULL,
  `ROWS_INSERTED` bigint(21) NOT NULL,
  `ROWS_UPDATED` bigint(21) NOT NULL,
  `SELECT_COMMANDS` bigint(21) NOT NULL,
  `UPDATE_COMMANDS` bigint(21) NOT NULL,
  `OTHER_COMMANDS` bigint(21) NOT NULL,
  `COMMIT_TRANSACTIONS` bigint(21) NOT NULL,
  `ROLLBACK_TRANSACTIONS` bigint(21) NOT NULL,
  `DENIED_CONNECTIONS` bigint(21) NOT NULL,
  `LOST_CONNECTIONS` bigint(21) NOT NULL,
  `ACCESS_DENIED` bigint(21) NOT NULL,
  `EMPTY_QUERIES` bigint(21) NOT NULL,
  `TOTAL_SSL_CONNECTIONS` bigint(21) unsigned NOT NULL,
  `MAX_STATEMENT_TIME_EXCEEDED` bigint(21) NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table information_schema.CLIENT_STATISTICS: -1 rows
/*!40000 ALTER TABLE `CLIENT_STATISTICS` DISABLE KEYS */;
/*!40000 ALTER TABLE `CLIENT_STATISTICS` ENABLE KEYS */;

-- Dumping structure for table information_schema.COLLATIONS
CREATE TEMPORARY TABLE IF NOT EXISTS `COLLATIONS` (
  `COLLATION_NAME` varchar(32) NOT NULL,
  `CHARACTER_SET_NAME` varchar(32) NOT NULL,
  `ID` bigint(11) NOT NULL,
  `IS_DEFAULT` varchar(3) NOT NULL,
  `IS_COMPILED` varchar(3) NOT NULL,
  `SORTLEN` bigint(3) NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table information_schema.COLLATIONS: -1 rows
/*!40000 ALTER TABLE `COLLATIONS` DISABLE KEYS */;
INSERT INTO `COLLATIONS` (`COLLATION_NAME`, `CHARACTER_SET_NAME`, `ID`, `IS_DEFAULT`, `IS_COMPILED`, `SORTLEN`) VALUES
	('big5_chinese_ci', 'big5', 1, 'Yes', 'Yes', 1),
	('big5_bin', 'big5', 84, '', 'Yes', 1),
	('big5_chinese_nopad_ci', 'big5', 1025, '', 'Yes', 1),
	('big5_nopad_bin', 'big5', 1108, '', 'Yes', 1),
	('dec8_swedish_ci', 'dec8', 3, 'Yes', 'Yes', 1),
	('dec8_bin', 'dec8', 69, '', 'Yes', 1),
	('dec8_swedish_nopad_ci', 'dec8', 1027, '', 'Yes', 1),
	('dec8_nopad_bin', 'dec8', 1093, '', 'Yes', 1),
	('cp850_general_ci', 'cp850', 4, 'Yes', 'Yes', 1),
	('cp850_bin', 'cp850', 80, '', 'Yes', 1),
	('cp850_general_nopad_ci', 'cp850', 1028, '', 'Yes', 1),
	('cp850_nopad_bin', 'cp850', 1104, '', 'Yes', 1),
	('hp8_english_ci', 'hp8', 6, 'Yes', 'Yes', 1),
	('hp8_bin', 'hp8', 72, '', 'Yes', 1),
	('hp8_english_nopad_ci', 'hp8', 1030, '', 'Yes', 1),
	('hp8_nopad_bin', 'hp8', 1096, '', 'Yes', 1),
	('koi8r_general_ci', 'koi8r', 7, 'Yes', 'Yes', 1),
	('koi8r_bin', 'koi8r', 74, '', 'Yes', 1),
	('koi8r_general_nopad_ci', 'koi8r', 1031, '', 'Yes', 1),
	('koi8r_nopad_bin', 'koi8r', 1098, '', 'Yes', 1),
	('latin1_german1_ci', 'latin1', 5, '', 'Yes', 1),
	('latin1_swedish_ci', 'latin1', 8, 'Yes', 'Yes', 1),
	('latin1_danish_ci', 'latin1', 15, '', 'Yes', 1),
	('latin1_german2_ci', 'latin1', 31, '', 'Yes', 2),
	('latin1_bin', 'latin1', 47, '', 'Yes', 1),
	('latin1_general_ci', 'latin1', 48, '', 'Yes', 1),
	('latin1_general_cs', 'latin1', 49, '', 'Yes', 1),
	('latin1_spanish_ci', 'latin1', 94, '', 'Yes', 1),
	('latin1_swedish_nopad_ci', 'latin1', 1032, '', 'Yes', 1),
	('latin1_nopad_bin', 'latin1', 1071, '', 'Yes', 1),
	('latin2_czech_cs', 'latin2', 2, '', 'Yes', 4),
	('latin2_general_ci', 'latin2', 9, 'Yes', 'Yes', 1),
	('latin2_hungarian_ci', 'latin2', 21, '', 'Yes', 1),
	('latin2_croatian_ci', 'latin2', 27, '', 'Yes', 1),
	('latin2_bin', 'latin2', 77, '', 'Yes', 1),
	('latin2_general_nopad_ci', 'latin2', 1033, '', 'Yes', 1),
	('latin2_nopad_bin', 'latin2', 1101, '', 'Yes', 1),
	('swe7_swedish_ci', 'swe7', 10, 'Yes', 'Yes', 1),
	('swe7_bin', 'swe7', 82, '', 'Yes', 1),
	('swe7_swedish_nopad_ci', 'swe7', 1034, '', 'Yes', 1),
	('swe7_nopad_bin', 'swe7', 1106, '', 'Yes', 1),
	('ascii_general_ci', 'ascii', 11, 'Yes', 'Yes', 1),
	('ascii_bin', 'ascii', 65, '', 'Yes', 1),
	('ascii_general_nopad_ci', 'ascii', 1035, '', 'Yes', 1),
	('ascii_nopad_bin', 'ascii', 1089, '', 'Yes', 1),
	('ujis_japanese_ci', 'ujis', 12, 'Yes', 'Yes', 1),
	('ujis_bin', 'ujis', 91, '', 'Yes', 1),
	('ujis_japanese_nopad_ci', 'ujis', 1036, '', 'Yes', 1),
	('ujis_nopad_bin', 'ujis', 1115, '', 'Yes', 1),
	('sjis_japanese_ci', 'sjis', 13, 'Yes', 'Yes', 1),
	('sjis_bin', 'sjis', 88, '', 'Yes', 1),
	('sjis_japanese_nopad_ci', 'sjis', 1037, '', 'Yes', 1),
	('sjis_nopad_bin', 'sjis', 1112, '', 'Yes', 1),
	('hebrew_general_ci', 'hebrew', 16, 'Yes', 'Yes', 1),
	('hebrew_bin', 'hebrew', 71, '', 'Yes', 1),
	('hebrew_general_nopad_ci', 'hebrew', 1040, '', 'Yes', 1),
	('hebrew_nopad_bin', 'hebrew', 1095, '', 'Yes', 1),
	('tis620_thai_ci', 'tis620', 18, 'Yes', 'Yes', 4),
	('tis620_bin', 'tis620', 89, '', 'Yes', 1),
	('tis620_thai_nopad_ci', 'tis620', 1042, '', 'Yes', 4),
	('tis620_nopad_bin', 'tis620', 1113, '', 'Yes', 1),
	('euckr_korean_ci', 'euckr', 19, 'Yes', 'Yes', 1),
	('euckr_bin', 'euckr', 85, '', 'Yes', 1),
	('euckr_korean_nopad_ci', 'euckr', 1043, '', 'Yes', 1),
	('euckr_nopad_bin', 'euckr', 1109, '', 'Yes', 1),
	('koi8u_general_ci', 'koi8u', 22, 'Yes', 'Yes', 1),
	('koi8u_bin', 'koi8u', 75, '', 'Yes', 1),
	('koi8u_general_nopad_ci', 'koi8u', 1046, '', 'Yes', 1),
	('koi8u_nopad_bin', 'koi8u', 1099, '', 'Yes', 1),
	('gb2312_chinese_ci', 'gb2312', 24, 'Yes', 'Yes', 1),
	('gb2312_bin', 'gb2312', 86, '', 'Yes', 1),
	('gb2312_chinese_nopad_ci', 'gb2312', 1048, '', 'Yes', 1),
	('gb2312_nopad_bin', 'gb2312', 1110, '', 'Yes', 1),
	('greek_general_ci', 'greek', 25, 'Yes', 'Yes', 1),
	('greek_bin', 'greek', 70, '', 'Yes', 1),
	('greek_general_nopad_ci', 'greek', 1049, '', 'Yes', 1),
	('greek_nopad_bin', 'greek', 1094, '', 'Yes', 1),
	('cp1250_general_ci', 'cp1250', 26, 'Yes', 'Yes', 1),
	('cp1250_czech_cs', 'cp1250', 34, '', 'Yes', 2),
	('cp1250_croatian_ci', 'cp1250', 44, '', 'Yes', 1),
	('cp1250_bin', 'cp1250', 66, '', 'Yes', 1),
	('cp1250_polish_ci', 'cp1250', 99, '', 'Yes', 1),
	('cp1250_general_nopad_ci', 'cp1250', 1050, '', 'Yes', 1),
	('cp1250_nopad_bin', 'cp1250', 1090, '', 'Yes', 1),
	('gbk_chinese_ci', 'gbk', 28, 'Yes', 'Yes', 1),
	('gbk_bin', 'gbk', 87, '', 'Yes', 1),
	('gbk_chinese_nopad_ci', 'gbk', 1052, '', 'Yes', 1),
	('gbk_nopad_bin', 'gbk', 1111, '', 'Yes', 1),
	('latin5_turkish_ci', 'latin5', 30, 'Yes', 'Yes', 1),
	('latin5_bin', 'latin5', 78, '', 'Yes', 1),
	('latin5_turkish_nopad_ci', 'latin5', 1054, '', 'Yes', 1),
	('latin5_nopad_bin', 'latin5', 1102, '', 'Yes', 1),
	('armscii8_general_ci', 'armscii8', 32, 'Yes', 'Yes', 1),
	('armscii8_bin', 'armscii8', 64, '', 'Yes', 1),
	('armscii8_general_nopad_ci', 'armscii8', 1056, '', 'Yes', 1),
	('armscii8_nopad_bin', 'armscii8', 1088, '', 'Yes', 1),
	('utf8_general_ci', 'utf8', 33, 'Yes', 'Yes', 1),
	('utf8_bin', 'utf8', 83, '', 'Yes', 1),
	('utf8_unicode_ci', 'utf8', 192, '', 'Yes', 8),
	('utf8_icelandic_ci', 'utf8', 193, '', 'Yes', 8),
	('utf8_latvian_ci', 'utf8', 194, '', 'Yes', 8),
	('utf8_romanian_ci', 'utf8', 195, '', 'Yes', 8),
	('utf8_slovenian_ci', 'utf8', 196, '', 'Yes', 8),
	('utf8_polish_ci', 'utf8', 197, '', 'Yes', 8),
	('utf8_estonian_ci', 'utf8', 198, '', 'Yes', 8),
	('utf8_spanish_ci', 'utf8', 199, '', 'Yes', 8),
	('utf8_swedish_ci', 'utf8', 200, '', 'Yes', 8),
	('utf8_turkish_ci', 'utf8', 201, '', 'Yes', 8),
	('utf8_czech_ci', 'utf8', 202, '', 'Yes', 8),
	('utf8_danish_ci', 'utf8', 203, '', 'Yes', 8),
	('utf8_lithuanian_ci', 'utf8', 204, '', 'Yes', 8),
	('utf8_slovak_ci', 'utf8', 205, '', 'Yes', 8),
	('utf8_spanish2_ci', 'utf8', 206, '', 'Yes', 8),
	('utf8_roman_ci', 'utf8', 207, '', 'Yes', 8),
	('utf8_persian_ci', 'utf8', 208, '', 'Yes', 8),
	('utf8_esperanto_ci', 'utf8', 209, '', 'Yes', 8),
	('utf8_hungarian_ci', 'utf8', 210, '', 'Yes', 8),
	('utf8_sinhala_ci', 'utf8', 211, '', 'Yes', 8),
	('utf8_german2_ci', 'utf8', 212, '', 'Yes', 8),
	('utf8_croatian_mysql561_ci', 'utf8', 213, '', 'Yes', 8),
	('utf8_unicode_520_ci', 'utf8', 214, '', 'Yes', 8),
	('utf8_vietnamese_ci', 'utf8', 215, '', 'Yes', 8),
	('utf8_general_mysql500_ci', 'utf8', 223, '', 'Yes', 1),
	('utf8_croatian_ci', 'utf8', 576, '', 'Yes', 8),
	('utf8_myanmar_ci', 'utf8', 577, '', 'Yes', 8),
	('utf8_thai_520_w2', 'utf8', 578, '', 'Yes', 4),
	('utf8_general_nopad_ci', 'utf8', 1057, '', 'Yes', 1),
	('utf8_nopad_bin', 'utf8', 1107, '', 'Yes', 1),
	('utf8_unicode_nopad_ci', 'utf8', 1216, '', 'Yes', 8),
	('utf8_unicode_520_nopad_ci', 'utf8', 1238, '', 'Yes', 8),
	('ucs2_general_ci', 'ucs2', 35, 'Yes', 'Yes', 1),
	('ucs2_bin', 'ucs2', 90, '', 'Yes', 1),
	('ucs2_unicode_ci', 'ucs2', 128, '', 'Yes', 8),
	('ucs2_icelandic_ci', 'ucs2', 129, '', 'Yes', 8),
	('ucs2_latvian_ci', 'ucs2', 130, '', 'Yes', 8),
	('ucs2_romanian_ci', 'ucs2', 131, '', 'Yes', 8),
	('ucs2_slovenian_ci', 'ucs2', 132, '', 'Yes', 8),
	('ucs2_polish_ci', 'ucs2', 133, '', 'Yes', 8),
	('ucs2_estonian_ci', 'ucs2', 134, '', 'Yes', 8),
	('ucs2_spanish_ci', 'ucs2', 135, '', 'Yes', 8),
	('ucs2_swedish_ci', 'ucs2', 136, '', 'Yes', 8),
	('ucs2_turkish_ci', 'ucs2', 137, '', 'Yes', 8),
	('ucs2_czech_ci', 'ucs2', 138, '', 'Yes', 8),
	('ucs2_danish_ci', 'ucs2', 139, '', 'Yes', 8),
	('ucs2_lithuanian_ci', 'ucs2', 140, '', 'Yes', 8),
	('ucs2_slovak_ci', 'ucs2', 141, '', 'Yes', 8),
	('ucs2_spanish2_ci', 'ucs2', 142, '', 'Yes', 8),
	('ucs2_roman_ci', 'ucs2', 143, '', 'Yes', 8),
	('ucs2_persian_ci', 'ucs2', 144, '', 'Yes', 8),
	('ucs2_esperanto_ci', 'ucs2', 145, '', 'Yes', 8),
	('ucs2_hungarian_ci', 'ucs2', 146, '', 'Yes', 8),
	('ucs2_sinhala_ci', 'ucs2', 147, '', 'Yes', 8),
	('ucs2_german2_ci', 'ucs2', 148, '', 'Yes', 8),
	('ucs2_croatian_mysql561_ci', 'ucs2', 149, '', 'Yes', 8),
	('ucs2_unicode_520_ci', 'ucs2', 150, '', 'Yes', 8),
	('ucs2_vietnamese_ci', 'ucs2', 151, '', 'Yes', 8),
	('ucs2_general_mysql500_ci', 'ucs2', 159, '', 'Yes', 1),
	('ucs2_croatian_ci', 'ucs2', 640, '', 'Yes', 8),
	('ucs2_myanmar_ci', 'ucs2', 641, '', 'Yes', 8),
	('ucs2_thai_520_w2', 'ucs2', 642, '', 'Yes', 4),
	('ucs2_general_nopad_ci', 'ucs2', 1059, '', 'Yes', 1),
	('ucs2_nopad_bin', 'ucs2', 1114, '', 'Yes', 1),
	('ucs2_unicode_nopad_ci', 'ucs2', 1152, '', 'Yes', 8),
	('ucs2_unicode_520_nopad_ci', 'ucs2', 1174, '', 'Yes', 8),
	('cp866_general_ci', 'cp866', 36, 'Yes', 'Yes', 1),
	('cp866_bin', 'cp866', 68, '', 'Yes', 1),
	('cp866_general_nopad_ci', 'cp866', 1060, '', 'Yes', 1),
	('cp866_nopad_bin', 'cp866', 1092, '', 'Yes', 1),
	('keybcs2_general_ci', 'keybcs2', 37, 'Yes', 'Yes', 1),
	('keybcs2_bin', 'keybcs2', 73, '', 'Yes', 1),
	('keybcs2_general_nopad_ci', 'keybcs2', 1061, '', 'Yes', 1),
	('keybcs2_nopad_bin', 'keybcs2', 1097, '', 'Yes', 1),
	('macce_general_ci', 'macce', 38, 'Yes', 'Yes', 1),
	('macce_bin', 'macce', 43, '', 'Yes', 1),
	('macce_general_nopad_ci', 'macce', 1062, '', 'Yes', 1),
	('macce_nopad_bin', 'macce', 1067, '', 'Yes', 1),
	('macroman_general_ci', 'macroman', 39, 'Yes', 'Yes', 1),
	('macroman_bin', 'macroman', 53, '', 'Yes', 1),
	('macroman_general_nopad_ci', 'macroman', 1063, '', 'Yes', 1),
	('macroman_nopad_bin', 'macroman', 1077, '', 'Yes', 1),
	('cp852_general_ci', 'cp852', 40, 'Yes', 'Yes', 1),
	('cp852_bin', 'cp852', 81, '', 'Yes', 1),
	('cp852_general_nopad_ci', 'cp852', 1064, '', 'Yes', 1),
	('cp852_nopad_bin', 'cp852', 1105, '', 'Yes', 1),
	('latin7_estonian_cs', 'latin7', 20, '', 'Yes', 1),
	('latin7_general_ci', 'latin7', 41, 'Yes', 'Yes', 1),
	('latin7_general_cs', 'latin7', 42, '', 'Yes', 1),
	('latin7_bin', 'latin7', 79, '', 'Yes', 1),
	('latin7_general_nopad_ci', 'latin7', 1065, '', 'Yes', 1),
	('latin7_nopad_bin', 'latin7', 1103, '', 'Yes', 1),
	('utf8mb4_general_ci', 'utf8mb4', 45, 'Yes', 'Yes', 1),
	('utf8mb4_bin', 'utf8mb4', 46, '', 'Yes', 1),
	('utf8mb4_unicode_ci', 'utf8mb4', 224, '', 'Yes', 8),
	('utf8mb4_icelandic_ci', 'utf8mb4', 225, '', 'Yes', 8),
	('utf8mb4_latvian_ci', 'utf8mb4', 226, '', 'Yes', 8),
	('utf8mb4_romanian_ci', 'utf8mb4', 227, '', 'Yes', 8),
	('utf8mb4_slovenian_ci', 'utf8mb4', 228, '', 'Yes', 8),
	('utf8mb4_polish_ci', 'utf8mb4', 229, '', 'Yes', 8),
	('utf8mb4_estonian_ci', 'utf8mb4', 230, '', 'Yes', 8),
	('utf8mb4_spanish_ci', 'utf8mb4', 231, '', 'Yes', 8),
	('utf8mb4_swedish_ci', 'utf8mb4', 232, '', 'Yes', 8),
	('utf8mb4_turkish_ci', 'utf8mb4', 233, '', 'Yes', 8),
	('utf8mb4_czech_ci', 'utf8mb4', 234, '', 'Yes', 8),
	('utf8mb4_danish_ci', 'utf8mb4', 235, '', 'Yes', 8),
	('utf8mb4_lithuanian_ci', 'utf8mb4', 236, '', 'Yes', 8),
	('utf8mb4_slovak_ci', 'utf8mb4', 237, '', 'Yes', 8),
	('utf8mb4_spanish2_ci', 'utf8mb4', 238, '', 'Yes', 8),
	('utf8mb4_roman_ci', 'utf8mb4', 239, '', 'Yes', 8),
	('utf8mb4_persian_ci', 'utf8mb4', 240, '', 'Yes', 8),
	('utf8mb4_esperanto_ci', 'utf8mb4', 241, '', 'Yes', 8),
	('utf8mb4_hungarian_ci', 'utf8mb4', 242, '', 'Yes', 8),
	('utf8mb4_sinhala_ci', 'utf8mb4', 243, '', 'Yes', 8),
	('utf8mb4_german2_ci', 'utf8mb4', 244, '', 'Yes', 8),
	('utf8mb4_croatian_mysql561_ci', 'utf8mb4', 245, '', 'Yes', 8),
	('utf8mb4_unicode_520_ci', 'utf8mb4', 246, '', 'Yes', 8),
	('utf8mb4_vietnamese_ci', 'utf8mb4', 247, '', 'Yes', 8),
	('utf8mb4_croatian_ci', 'utf8mb4', 608, '', 'Yes', 8),
	('utf8mb4_myanmar_ci', 'utf8mb4', 609, '', 'Yes', 8),
	('utf8mb4_thai_520_w2', 'utf8mb4', 610, '', 'Yes', 4),
	('utf8mb4_general_nopad_ci', 'utf8mb4', 1069, '', 'Yes', 1),
	('utf8mb4_nopad_bin', 'utf8mb4', 1070, '', 'Yes', 1),
	('utf8mb4_unicode_nopad_ci', 'utf8mb4', 1248, '', 'Yes', 8),
	('utf8mb4_unicode_520_nopad_ci', 'utf8mb4', 1270, '', 'Yes', 8),
	('cp1251_bulgarian_ci', 'cp1251', 14, '', 'Yes', 1),
	('cp1251_ukrainian_ci', 'cp1251', 23, '', 'Yes', 1),
	('cp1251_bin', 'cp1251', 50, '', 'Yes', 1),
	('cp1251_general_ci', 'cp1251', 51, 'Yes', 'Yes', 1),
	('cp1251_general_cs', 'cp1251', 52, '', 'Yes', 1),
	('cp1251_nopad_bin', 'cp1251', 1074, '', 'Yes', 1),
	('cp1251_general_nopad_ci', 'cp1251', 1075, '', 'Yes', 1),
	('utf16_general_ci', 'utf16', 54, 'Yes', 'Yes', 1),
	('utf16_bin', 'utf16', 55, '', 'Yes', 1),
	('utf16_unicode_ci', 'utf16', 101, '', 'Yes', 8),
	('utf16_icelandic_ci', 'utf16', 102, '', 'Yes', 8),
	('utf16_latvian_ci', 'utf16', 103, '', 'Yes', 8),
	('utf16_romanian_ci', 'utf16', 104, '', 'Yes', 8),
	('utf16_slovenian_ci', 'utf16', 105, '', 'Yes', 8),
	('utf16_polish_ci', 'utf16', 106, '', 'Yes', 8),
	('utf16_estonian_ci', 'utf16', 107, '', 'Yes', 8),
	('utf16_spanish_ci', 'utf16', 108, '', 'Yes', 8),
	('utf16_swedish_ci', 'utf16', 109, '', 'Yes', 8),
	('utf16_turkish_ci', 'utf16', 110, '', 'Yes', 8),
	('utf16_czech_ci', 'utf16', 111, '', 'Yes', 8),
	('utf16_danish_ci', 'utf16', 112, '', 'Yes', 8),
	('utf16_lithuanian_ci', 'utf16', 113, '', 'Yes', 8),
	('utf16_slovak_ci', 'utf16', 114, '', 'Yes', 8),
	('utf16_spanish2_ci', 'utf16', 115, '', 'Yes', 8),
	('utf16_roman_ci', 'utf16', 116, '', 'Yes', 8),
	('utf16_persian_ci', 'utf16', 117, '', 'Yes', 8),
	('utf16_esperanto_ci', 'utf16', 118, '', 'Yes', 8),
	('utf16_hungarian_ci', 'utf16', 119, '', 'Yes', 8),
	('utf16_sinhala_ci', 'utf16', 120, '', 'Yes', 8),
	('utf16_german2_ci', 'utf16', 121, '', 'Yes', 8),
	('utf16_croatian_mysql561_ci', 'utf16', 122, '', 'Yes', 8),
	('utf16_unicode_520_ci', 'utf16', 123, '', 'Yes', 8),
	('utf16_vietnamese_ci', 'utf16', 124, '', 'Yes', 8),
	('utf16_croatian_ci', 'utf16', 672, '', 'Yes', 8),
	('utf16_myanmar_ci', 'utf16', 673, '', 'Yes', 8),
	('utf16_thai_520_w2', 'utf16', 674, '', 'Yes', 4),
	('utf16_general_nopad_ci', 'utf16', 1078, '', 'Yes', 1),
	('utf16_nopad_bin', 'utf16', 1079, '', 'Yes', 1),
	('utf16_unicode_nopad_ci', 'utf16', 1125, '', 'Yes', 8),
	('utf16_unicode_520_nopad_ci', 'utf16', 1147, '', 'Yes', 8),
	('utf16le_general_ci', 'utf16le', 56, 'Yes', 'Yes', 1),
	('utf16le_bin', 'utf16le', 62, '', 'Yes', 1),
	('utf16le_general_nopad_ci', 'utf16le', 1080, '', 'Yes', 1),
	('utf16le_nopad_bin', 'utf16le', 1086, '', 'Yes', 1),
	('cp1256_general_ci', 'cp1256', 57, 'Yes', 'Yes', 1),
	('cp1256_bin', 'cp1256', 67, '', 'Yes', 1),
	('cp1256_general_nopad_ci', 'cp1256', 1081, '', 'Yes', 1),
	('cp1256_nopad_bin', 'cp1256', 1091, '', 'Yes', 1),
	('cp1257_lithuanian_ci', 'cp1257', 29, '', 'Yes', 1),
	('cp1257_bin', 'cp1257', 58, '', 'Yes', 1),
	('cp1257_general_ci', 'cp1257', 59, 'Yes', 'Yes', 1),
	('cp1257_nopad_bin', 'cp1257', 1082, '', 'Yes', 1),
	('cp1257_general_nopad_ci', 'cp1257', 1083, '', 'Yes', 1),
	('utf32_general_ci', 'utf32', 60, 'Yes', 'Yes', 1),
	('utf32_bin', 'utf32', 61, '', 'Yes', 1),
	('utf32_unicode_ci', 'utf32', 160, '', 'Yes', 8),
	('utf32_icelandic_ci', 'utf32', 161, '', 'Yes', 8),
	('utf32_latvian_ci', 'utf32', 162, '', 'Yes', 8),
	('utf32_romanian_ci', 'utf32', 163, '', 'Yes', 8),
	('utf32_slovenian_ci', 'utf32', 164, '', 'Yes', 8),
	('utf32_polish_ci', 'utf32', 165, '', 'Yes', 8),
	('utf32_estonian_ci', 'utf32', 166, '', 'Yes', 8),
	('utf32_spanish_ci', 'utf32', 167, '', 'Yes', 8),
	('utf32_swedish_ci', 'utf32', 168, '', 'Yes', 8),
	('utf32_turkish_ci', 'utf32', 169, '', 'Yes', 8),
	('utf32_czech_ci', 'utf32', 170, '', 'Yes', 8),
	('utf32_danish_ci', 'utf32', 171, '', 'Yes', 8),
	('utf32_lithuanian_ci', 'utf32', 172, '', 'Yes', 8),
	('utf32_slovak_ci', 'utf32', 173, '', 'Yes', 8),
	('utf32_spanish2_ci', 'utf32', 174, '', 'Yes', 8),
	('utf32_roman_ci', 'utf32', 175, '', 'Yes', 8),
	('utf32_persian_ci', 'utf32', 176, '', 'Yes', 8),
	('utf32_esperanto_ci', 'utf32', 177, '', 'Yes', 8),
	('utf32_hungarian_ci', 'utf32', 178, '', 'Yes', 8),
	('utf32_sinhala_ci', 'utf32', 179, '', 'Yes', 8),
	('utf32_german2_ci', 'utf32', 180, '', 'Yes', 8),
	('utf32_croatian_mysql561_ci', 'utf32', 181, '', 'Yes', 8),
	('utf32_unicode_520_ci', 'utf32', 182, '', 'Yes', 8),
	('utf32_vietnamese_ci', 'utf32', 183, '', 'Yes', 8),
	('utf32_croatian_ci', 'utf32', 736, '', 'Yes', 8),
	('utf32_myanmar_ci', 'utf32', 737, '', 'Yes', 8),
	('utf32_thai_520_w2', 'utf32', 738, '', 'Yes', 4),
	('utf32_general_nopad_ci', 'utf32', 1084, '', 'Yes', 1),
	('utf32_nopad_bin', 'utf32', 1085, '', 'Yes', 1),
	('utf32_unicode_nopad_ci', 'utf32', 1184, '', 'Yes', 8),
	('utf32_unicode_520_nopad_ci', 'utf32', 1206, '', 'Yes', 8),
	('binary', 'binary', 63, 'Yes', 'Yes', 1),
	('geostd8_general_ci', 'geostd8', 92, 'Yes', 'Yes', 1),
	('geostd8_bin', 'geostd8', 93, '', 'Yes', 1),
	('geostd8_general_nopad_ci', 'geostd8', 1116, '', 'Yes', 1),
	('geostd8_nopad_bin', 'geostd8', 1117, '', 'Yes', 1),
	('cp932_japanese_ci', 'cp932', 95, 'Yes', 'Yes', 1),
	('cp932_bin', 'cp932', 96, '', 'Yes', 1),
	('cp932_japanese_nopad_ci', 'cp932', 1119, '', 'Yes', 1),
	('cp932_nopad_bin', 'cp932', 1120, '', 'Yes', 1),
	('eucjpms_japanese_ci', 'eucjpms', 97, 'Yes', 'Yes', 1),
	('eucjpms_bin', 'eucjpms', 98, '', 'Yes', 1),
	('eucjpms_japanese_nopad_ci', 'eucjpms', 1121, '', 'Yes', 1),
	('eucjpms_nopad_bin', 'eucjpms', 1122, '', 'Yes', 1);
/*!40000 ALTER TABLE `COLLATIONS` ENABLE KEYS */;

-- Dumping structure for table information_schema.COLLATION_CHARACTER_SET_APPLICABILITY
CREATE TEMPORARY TABLE IF NOT EXISTS `COLLATION_CHARACTER_SET_APPLICABILITY` (
  `COLLATION_NAME` varchar(32) NOT NULL,
  `CHARACTER_SET_NAME` varchar(32) NOT NULL
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Dumping data for table information_schema.COLLATION_CHARACTER_SET_APPLICABILITY: -1 rows
/*!40000 ALTER TABLE `COLLATION_CHARACTER_SET_APPLICABILITY` DISABLE KEYS */;
INSERT INTO `COLLATION_CHARACTER_SET_APPLICABILITY` (`COLLATION_NAME`, `CHARACTER_SET_NAME`) VALUES
	('big5_chinese_ci', 'big5'),
	('big5_bin', 'big5'),
	('big5_chinese_nopad_ci', 'big5'),
	('big5_nopad_bin', 'big5'),
	('dec8_swedish_ci', 'dec8'),
	('dec8_bin', 'dec8'),
	('dec8_swedish_nopad_ci', 'dec8'),
	('dec8_nopad_bin', 'dec8'),
	('cp850_general_ci', 'cp850'),
	('cp850_bin', 'cp850'),
	('cp850_general_nopad_ci', 'cp850'),
	('cp850_nopad_bin', 'cp850'),
	('hp8_english_ci', 'hp8'),
	('hp8_bin', 'hp8'),
	('hp8_english_nopad_ci', 'hp8'),
	('hp8_nopad_bin', 'hp8'),
	('koi8r_general_ci', 'koi8r'),
	('koi8r_bin', 'koi8r'),
	('koi8r_general_nopad_ci', 'koi8r'),
	('koi8r_nopad_bin', 'koi8r'),
	('latin1_german1_ci', 'latin1'),
	('latin1_swedish_ci', 'latin1'),
	('latin1_danish_ci', 'latin1'),
	('latin1_german2_ci', 'latin1'),
	('latin1_bin', 'latin1'),
	('latin1_general_ci', 'latin1'),
	('latin1_general_cs', 'latin1'),
	('latin1_spanish_ci', 'latin1'),
	('latin1_swedish_nopad_ci', 'latin1'),
	('latin1_nopad_bin', 'latin1'),
	('latin2_czech_cs', 'latin2'),
	('latin2_general_ci', 'latin2'),
	('latin2_hungarian_ci', 'latin2'),
	('latin2_croatian_ci', 'latin2'),
	('latin2_bin', 'latin2'),
	('latin2_general_nopad_ci', 'latin2'),
	('latin2_nopad_bin', 'latin2'),
	('swe7_swedish_ci', 'swe7'),
	('swe7_bin', 'swe7'),
	('swe7_swedish_nopad_ci', 'swe7'),
	('swe7_nopad_bin', 'swe7'),
	('ascii_general_ci', 'ascii'),
	('ascii_bin', 'ascii'),
	('ascii_general_nopad_ci', 'ascii'),
	('ascii_nopad_bin', 'ascii'),
	('ujis_japanese_ci', 'ujis'),
	('ujis_bin', 'ujis'),
	('ujis_japanese_nopad_ci', 'ujis'),
	('ujis_nopad_bin', 'ujis'),
	('sjis_japanese_ci', 'sjis'),
	('sjis_bin', 'sjis'),
	('sjis_japanese_nopad_ci', 'sjis'),
	('sjis_nopad_bin', 'sjis'),
	('hebrew_general_ci', 'hebrew'),
	('hebrew_bin', 'hebrew'),
	('hebrew_general_nopad_ci', 'hebrew'),
	('hebrew_nopad_bin', 'hebrew'),
	('tis620_thai_ci', 'tis620'),
	('tis620_bin', 'tis620'),
	('tis620_thai_nopad_ci', 'tis620'),
	('tis620_nopad_bin', 'tis620'),
	('euckr_korean_ci', 'euckr'),
	('euckr_bin', 'euckr'),
	('euckr_korean_nopad_ci', 'euckr'),
	('euckr_nopad_bin', 'euckr'),
	('koi8u_general_ci', 'koi8u'),
	('koi8u_bin', 'koi8u'),
	('koi8u_general_nopad_ci', 'koi8u'),
	('koi8u_nopad_bin', 'koi8u'),
	('gb2312_chinese_ci', 'gb2312'),
	('gb2312_bin', 'gb2312'),
	('gb2312_chinese_nopad_ci', 'gb2312'),
	('gb2312_nopad_bin', 'gb2312'),
	('greek_general_ci', 'greek'),
	('greek_bin', 'greek'),
	('greek_general_nopad_ci', 'greek'),
	('greek_nopad_bin', 'greek'),
	('cp1250_general_ci', 'cp1250'),
	('cp1250_czech_cs', 'cp1250'),
	('cp1250_croatian_ci', 'cp1250'),
	('cp1250_bin', 'cp1250'),
	('cp1250_polish_ci', 'cp1250'),
	('cp1250_general_nopad_ci', 'cp1250'),
	('cp1250_nopad_bin', 'cp1250'),
	('gbk_chinese_ci', 'gbk'),
	('gbk_bin', 'gbk'),
	('gbk_chinese_nopad_ci', 'gbk'),
	('gbk_nopad_bin', 'gbk'),
	('latin5_turkish_ci', 'latin5'),
	('latin5_bin', 'latin5'),
	('latin5_turkish_nopad_ci', 'latin5'),
	('latin5_nopad_bin', 'latin5'),
	('armscii8_general_ci', 'armscii8'),
	('armscii8_bin', 'armscii8'),
	('armscii8_general_nopad_ci', 'armscii8'),
	('armscii8_nopad_bin', 'armscii8'),
	('utf8_general_ci', 'utf8'),
	('utf8_bin', 'utf8'),
	('utf8_unicode_ci', 'utf8'),
	('utf8_icelandic_ci', 'utf8'),
	('utf8_latvian_ci', 'utf8'),
	('utf8_romanian_ci', 'utf8'),
	('utf8_slovenian_ci', 'utf8'),
	('utf8_polish_ci', 'utf8'),
	('utf8_estonian_ci', 'utf8'),
	('utf8_spanish_ci', 'utf8'),
	('utf8_swedish_ci', 'utf8'),
	('utf8_turkish_ci', 'utf8'),
	('utf8_czech_ci', 'utf8'),
	('utf8_danish_ci', 'utf8'),
	('utf8_lithuanian_ci', 'utf8'),
	('utf8_slovak_ci', 'utf8'),
	('utf8_spanish2_ci', 'utf8'),
	('utf8_roman_ci', 'utf8'),
	('utf8_persian_ci', 'utf8'),
	('utf8_esperanto_ci', 'utf8'),
	('utf8_hungarian_ci', 'utf8'),
	('utf8_sinhala_ci', 'utf8'),
	('utf8_german2_ci', 'utf8'),
	('utf8_croatian_mysql561_ci', 'utf8'),
	('utf8_unicode_520_ci', 'utf8'),
	('utf8_vietnamese_ci', 'utf8'),
	('utf8_general_mysql500_ci', 'utf8'),
	('utf8_croatian_ci', 'utf8'),
	('utf8_myanmar_ci', 'utf8'),
	('utf8_thai_520_w2', 'utf8'),
	('utf8_general_nopad_ci', 'utf8'),
	('utf8_nopad_bin', 'utf8'),
	('utf8_unicode_nopad_ci', 'utf8'),
	('utf8_unicode_520_nopad_ci', 'utf8'),
	('ucs2_general_ci', 'ucs2'),
	('ucs2_bin', 'ucs2'),
	('ucs2_unicode_ci', 'ucs2'),
	('ucs2_icelandic_ci', 'ucs2'),
	('ucs2_latvian_ci', 'ucs2'),
	('ucs2_romanian_ci', 'ucs2'),
	('ucs2_slovenian_ci', 'ucs2'),
	('ucs2_polish_ci', 'ucs2'),
	('ucs2_estonian_ci', 'ucs2'),
	('ucs2_spanish_ci', 'ucs2'),
	('ucs2_swedish_ci', 'ucs2'),
	('ucs2_turkish_ci', 'ucs2'),
	('ucs2_czech_ci', 'ucs2'),
	('ucs2_danish_ci', 'ucs2'),
	('ucs2_lithuanian_ci', 'ucs2'),
	('ucs2_slovak_ci', 'ucs2'),
	('ucs2_spanish2_ci', 'ucs2'),
	('ucs2_roman_ci', 'ucs2'),
	('ucs2_persian_ci', 'ucs2'),
	('ucs2_esperanto_ci', 'ucs2'),
	('ucs2_hungarian_ci', 'ucs2'),
	('ucs2_sinhala_ci', 'ucs2'),
	('ucs2_german2_ci', 'ucs2'),
	('ucs2_croatian_mysql561_ci', 'ucs2'),
	('ucs2_unicode_520_ci', 'ucs2'),
	('ucs2_vietnamese_ci', 'ucs2'),
	('ucs2_general_mysql500_ci', 'ucs2'),
	('ucs2_croatian_ci', 'ucs2'),
	('ucs2_myanmar_ci', 'ucs2'),
	('ucs2_thai_520_w2', 'ucs2'),
	('ucs2_general_nopad_ci', 'ucs2'),
	('ucs2_nopad_bin', 'ucs2'),
	('ucs2_unicode_nopad_ci', 'ucs2'),
	('ucs2_unicode_520_nopad_ci', 'ucs2'),
	('cp866_general_ci', 'cp866'),
	('cp866_bin', 'cp866'),
	('cp866_general_nopad_ci', 'cp866'),
	('cp866_nopad_bin', 'cp866'),
	('keybcs2_general_ci', 'keybcs2'),
	('keybcs2_bin', 'keybcs2'),
	('keybcs2_general_nopad_ci', 'keybcs2'),
	('keybcs2_nopad_bin', 'keybcs2'),
	('macce_general_ci', 'macce'),
	('macce_bin', 'macce'),
	('macce_general_nopad_ci', 'macce'),
	('macce_nopad_bin', 'macce'),
	('macroman_general_ci', 'macroman'),
	('macroman_bin', 'macroman'),
	('macroman_general_nopad_ci', 'macroman'),
	('macroman_nopad_bin', 'macroman'),
	('cp852_general_ci', 'cp852'),
	('cp852_bin', 'cp852'),
	('cp852_general_nopad_ci', 'cp852'),
	('cp852_nopad_bin', 'cp852'),
	('latin7_estonian_cs', 'latin7'),
	('latin7_general_ci', 'latin7'),
	('latin7_general_cs', 'latin7'),
	('latin7_bin', 'latin7'),
	('latin7_general_nopad_ci', 'latin7'),
	('latin7_nopad_bin', 'latin7'),
	('utf8mb4_general_ci', 'utf8mb4'),
	('utf8mb4_bin', 'utf8mb4'),
	('utf8mb4_unicode_ci', 'utf8mb4'),
	('utf8mb4_icelandic_ci', 'utf8mb4'),
	('utf8mb4_latvian_ci', 'utf8mb4'),
	('utf8mb4_romanian_ci', 'utf8mb4'),
	('utf8mb4_slovenian_ci', 'utf8mb4'),
	('utf8mb4_polish_ci', 'utf8mb4'),
	('utf8mb4_estonian_ci', 'utf8mb4'),
	('utf8mb4_spanish_ci', 'utf8mb4'),
	('utf8mb4_swedish_ci', 'utf8mb4'),
	('utf8mb4_turkish_ci', 'utf8mb4'),
	('utf8mb4_czech_ci', 'utf8mb4'),
	('utf8mb4_danish_ci', 'utf8mb4'),
	('utf8mb4_lithuanian_ci', 'utf8mb4'),
	('utf8mb4_slovak_ci', 'utf8mb4'),
	('utf8mb4_spanish2_ci', 'utf8mb4'),
	('utf8mb4_roman_ci', 'utf8mb4'),
	('utf8mb4_persian_ci', 'utf8mb4'),
	('utf8mb4_esperanto_ci', 'utf8mb4'),
	('utf8mb4_hungarian_ci', 'utf8mb4'),
	('utf8mb4_sinhala_ci', 'utf8mb4'),
	('utf8mb4_german2_ci', 'utf8mb4'),
	('utf8mb4_croatian_mysql561_ci', 'utf8mb4'),
	('utf8mb4_unicode_520_ci', 'utf8mb4'),
	('utf8mb4_vietnamese_ci', 'utf8mb4'),
	('utf8mb4_croatian_ci', 'utf8mb4'),
	('utf8mb4_myanmar_ci', 'utf8mb4'),
	('utf8mb4_thai_520_w2', 'utf8mb4'),
	('utf8mb4_general_nopad_ci', 'utf8mb4'),
	('utf8mb4_nopad_bin', 'utf8mb4'),
	('utf8mb4_unicode_nopad_ci', 'utf8mb4'),
	('utf8mb4_unicode_520_nopad_ci', 'utf8mb4'),
	('cp1251_bulgarian_ci', 'cp1251'),
	('cp1251_ukrainian_ci', 'cp1251'),
	('cp1251_bin', 'cp1251'),
	('cp1251_general_ci', 'cp1251'),
	('cp1251_general_cs', 'cp1251'),
	('cp1251_nopad_bin', 'cp1251'),
	('cp1251_general_nopad_ci', 'cp1251'),
	('utf16_general_ci', 'utf16'),
	('utf16_bin', 'utf16'),
	('utf16_unicode_ci', 'utf16'),
	('utf16_icelandic_ci', 'utf16'),
	('utf16_latvian_ci', 'utf16'),
	('utf16_romanian_ci', 'utf16'),
	('utf16_slovenian_ci', 'utf16'),
	('utf16_polish_ci', 'utf16'),
	('utf16_estonian_ci', 'utf16'),
	('utf16_spanish_ci', 'utf16'),
	('utf16_swedish_ci', 'utf16'),
	('utf16_turkish_ci', 'utf16'),
	('utf16_czech_ci', 'utf16'),
	('utf16_danish_ci', 'utf16'),
	('utf16_lithuanian_ci', 'utf16'),
	('utf16_slovak_ci', 'utf16'),
	('utf16_spanish2_ci', 'utf16'),
	('utf16_roman_ci', 'utf16'),
	('utf16_persian_ci', 'utf16'),
	('utf16_esperanto_ci', 'utf16'),
	('utf16_hungarian_ci', 'utf16'),
	('utf16_sinhala_ci', 'utf16'),
	('utf16_german2_ci', 'utf16'),
	('utf16_croatian_mysql561_ci', 'utf16'),
	('utf16_unicode_520_ci', 'utf16'),
	('utf16_vietnamese_ci', 'utf16'),
	('utf16_croatian_ci', 'utf16'),
	('utf16_myanmar_ci', 'utf16'),
	('utf16_thai_520_w2', 'utf16'),
	('utf16_general_nopad_ci', 'utf16'),
	('utf16_nopad_bin', 'utf16'),
	('utf16_unicode_nopad_ci', 'utf16'),
	('utf16_unicode_520_nopad_ci', 'utf16'),
	('utf16le_general_ci', 'utf16le'),
	('utf16le_bin', 'utf16le'),
	('utf16le_general_nopad_ci', 'utf16le'),
	('utf16le_nopad_bin', 'utf16le'),
	('cp1256_general_ci', 'cp1256'),
	('cp1256_bin', 'cp1256'),
	('cp1256_general_nopad_ci', 'cp1256'),
	('cp1256_nopad_bin', 'cp1256'),
	('cp1257_lithuanian_ci', 'cp1257'),
	('cp1257_bin', 'cp1257'),
	('cp1257_general_ci', 'cp1257'),
	('cp1257_nopad_bin', 'cp1257'),
	('cp1257_general_nopad_ci', 'cp1257'),
	('utf32_general_ci', 'utf32'),
	('utf32_bin', 'utf32'),
	('utf32_unicode_ci', 'utf32'),
	('utf32_icelandic_ci', 'utf32'),
	('utf32_latvian_ci', 'utf32'),
	('utf32_romanian_ci', 'utf32'),
	('utf32_slovenian_ci', 'utf32'),
	('utf32_polish_ci', 'utf32'),
	('utf32_estonian_ci', 'utf32'),
	('utf32_spanish_ci', 'utf32'),
	('utf32_swedish_ci', 'utf32'),
	('utf32_turkish_ci', 'utf32'),
	('utf32_czech_ci', 'utf32'),
	('utf32_danish_ci', 'utf32'),
	('utf32_lithuanian_ci', 'utf32'),
	('utf32_slovak_ci', 'utf32'),
	('utf32_spanish2_ci', 'utf32'),
	('utf32_roman_ci', 'utf32'),
	('utf32_persian_ci', 'utf32'),
	('utf32_esperanto_ci', 'utf32'),
	('utf32_hungarian_ci', 'utf32'),
	('utf32_sinhala_ci', 'utf32'),
	('utf32_german2_ci', 'utf32'),
	('utf32_croatian_mysql561_ci', 'utf32'),
	('utf32_unicode_520_ci', 'utf32'),
	('utf32_vietnamese_ci', 'utf32'),
	('utf32_croatian_ci', 'utf32'),
	('utf32_myanmar_ci', 'utf32'),
	('utf32_thai_520_w2', 'utf32'),
	('utf32_general_nopad_ci', 'utf32'),
	('utf32_nopad_bin', 'utf32'),
	('utf32_unicode_nopad_ci', 'utf32'),
	('utf32_unicode_520_nopad_ci', 'utf32'),
	('binary', 'binary'),
	('geostd8_general_ci', 'geostd8'),
	('geostd8_bin', 'geostd8'),
	('geostd8_general_nopad_ci', 'geostd8'),
	('geostd8_nopad_bin', 'geostd8'),
	('cp932_japanese_ci', 'cp932'),
	('cp932_bin', 'cp932'),
	('cp932_japanese_nopad_ci', 'cp932'),
	('cp932_nopad_bin', 'cp932'),
	('eucjpms_japanese_ci', 'eucjpms'),
	('eucjpms_bin', 'eucjpms'),
	('eucjpms_japanese_nopad_ci', 'eucjpms'),
	('eucjpms_nopad_bin', 'eucjpms');
/*!40000 ALTER TABLE `COLLATION_CHARACTER_SET_APPLICABILITY` ENABLE KEYS */;

-- Dumping structure for table information_schema.COLUMNS
CREATE TEMPORARY TABLE IF NOT EXISTS `COLUMNS` (
  `TABLE_CATALOG` varchar(512) NOT NULL,
  `TABLE_SCHEMA` varchar(64) NOT NULL,
  `TABLE_NAME` varchar(64) NOT NULL,
  `COLUMN_NAME` varchar(64) NOT NULL,
  `ORDINAL_POSITION` bigint(21) unsigned NOT NULL,
  `COLUMN_DEFAULT` longtext,
  `IS_NULLABLE` varchar(3) NOT NULL,
  `DATA_TYPE` varchar(64) NOT NULL,
  `CHARACTER_MAXIMUM_LENGTH` bigint(21) unsigned,
  `CHARACTER_OCTET_LENGTH` bigint(21) unsigned,
  `NUMERIC_PRECISION` bigint(21) unsigned,
  `NUMERIC_SCALE` bigint(21) unsigned,
  `DATETIME_PRECISION` bigint(21) unsigned,
  `CHARACTER_SET_NAME` varchar(32),
  `COLLATION_NAME` varchar(32),
  `COLUMN_TYPE` longtext NOT NULL,
  `COLUMN_KEY` varchar(3) NOT NULL,
  `EXTRA` varchar(80) NOT NULL,
  `PRIVILEGES` varchar(80) NOT NULL,
  `COLUMN_COMMENT` varchar(1024) NOT NULL,
  `IS_GENERATED` varchar(6) NOT NULL,
  `GENERATION_EXPRESSION` longtext
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=0;

-- Dumping data for table information_schema.COLUMNS: -1 rows
/*!40000 ALTER TABLE `COLUMNS` DISABLE KEYS */;
INSERT INTO `COLUMNS` (`TABLE_CATALOG`, `TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `ORDINAL_POSITION`, `COLUMN_DEFAULT`, `IS_NULLABLE`, `DATA_TYPE`, `CHARACTER_MAXIMUM_LENGTH`, `CHARACTER_OCTET_LENGTH`, `NUMERIC_PRECISION`, `NUMERIC_SCALE`, `DATETIME_PRECISION`, `CHARACTER_SET_NAME`, `COLLATION_NAME`, `COLUMN_TYPE`, `COLUMN_KEY`, `EXTRA`, `PRIVILEGES`, `COLUMN_COMMENT`, `IS_GENERATED`, `GENERATION_EXPRESSION`) VALUES
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_VERSION', 2, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_STATUS', 3, NULL, 'NO', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_TYPE', 4, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_TYPE_VERSION', 5, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_LIBRARY', 6, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_LIBRARY_VERSION', 7, NULL, 'YES', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_AUTHOR', 8, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_DESCRIPTION', 9, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_LICENSE', 10, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'LOAD_OPTION', 11, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_MATURITY', 12, NULL, 'NO', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ALL_PLUGINS', 'PLUGIN_AUTH_VERSION', 13, NULL, 'YES', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'APPLICABLE_ROLES', 'GRANTEE', 1, NULL, 'NO', 'varchar', 190, 570, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(190)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'APPLICABLE_ROLES', 'ROLE_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'APPLICABLE_ROLES', 'IS_GRANTABLE', 3, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'APPLICABLE_ROLES', 'IS_DEFAULT', 4, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHARACTER_SETS', 'CHARACTER_SET_NAME', 1, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHARACTER_SETS', 'DEFAULT_COLLATE_NAME', 2, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHARACTER_SETS', 'DESCRIPTION', 3, NULL, 'NO', 'varchar', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(60)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHARACTER_SETS', 'MAXLEN', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHECK_CONSTRAINTS', 'CONSTRAINT_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHECK_CONSTRAINTS', 'CONSTRAINT_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHECK_CONSTRAINTS', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHECK_CONSTRAINTS', 'CONSTRAINT_NAME', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CHECK_CONSTRAINTS', 'CHECK_CLAUSE', 5, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'COLLATION_NAME', 1, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'CHARACTER_SET_NAME', 2, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'ID', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'IS_DEFAULT', 4, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'IS_COMPILED', 5, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATIONS', 'SORTLEN', 6, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATION_CHARACTER_SET_APPLICABILITY', 'COLLATION_NAME', 1, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLLATION_CHARACTER_SET_APPLICABILITY', 'CHARACTER_SET_NAME', 2, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLUMN_NAME', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'ORDINAL_POSITION', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLUMN_DEFAULT', 6, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'IS_NULLABLE', 7, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'DATA_TYPE', 8, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'CHARACTER_MAXIMUM_LENGTH', 9, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'CHARACTER_OCTET_LENGTH', 10, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'NUMERIC_PRECISION', 11, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'NUMERIC_SCALE', 12, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'DATETIME_PRECISION', 13, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'CHARACTER_SET_NAME', 14, NULL, 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLLATION_NAME', 15, NULL, 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLUMN_TYPE', 16, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLUMN_KEY', 17, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'EXTRA', 18, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'PRIVILEGES', 19, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'COLUMN_COMMENT', 20, NULL, 'NO', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'IS_GENERATED', 21, NULL, 'NO', 'varchar', 6, 18, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMNS', 'GENERATION_EXPRESSION', 22, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'GRANTEE', 1, NULL, 'NO', 'varchar', 190, 570, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(190)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'TABLE_CATALOG', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'TABLE_SCHEMA', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'TABLE_NAME', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'COLUMN_NAME', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'PRIVILEGE_TYPE', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'COLUMN_PRIVILEGES', 'IS_GRANTABLE', 7, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENABLED_ROLES', 'ROLE_NAME', 1, NULL, 'YES', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'ENGINE', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'SUPPORT', 2, NULL, 'NO', 'varchar', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'COMMENT', 3, NULL, 'NO', 'varchar', 160, 480, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(160)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'TRANSACTIONS', 4, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'XA', 5, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ENGINES', 'SAVEPOINTS', 6, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_CATALOG', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'DEFINER', 4, NULL, 'NO', 'varchar', 189, 567, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(189)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'TIME_ZONE', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_BODY', 6, NULL, 'NO', 'varchar', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_DEFINITION', 7, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_TYPE', 8, NULL, 'NO', 'varchar', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(9)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EXECUTE_AT', 9, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'INTERVAL_VALUE', 10, NULL, 'YES', 'varchar', 256, 768, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(256)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'INTERVAL_FIELD', 11, NULL, 'YES', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'SQL_MODE', 12, NULL, 'NO', 'varchar', 8192, 24576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'STARTS', 13, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'ENDS', 14, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'STATUS', 15, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'ON_COMPLETION', 16, NULL, 'NO', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'CREATED', 17, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'LAST_ALTERED', 18, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'LAST_EXECUTED', 19, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'EVENT_COMMENT', 20, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'ORIGINATOR', 21, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'CHARACTER_SET_CLIENT', 22, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'COLLATION_CONNECTION', 23, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'EVENTS', 'DATABASE_COLLATION', 24, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'FILE_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'FILE_NAME', 2, NULL, 'YES', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'FILE_TYPE', 3, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TABLESPACE_NAME', 4, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TABLE_CATALOG', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TABLE_SCHEMA', 6, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TABLE_NAME', 7, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'LOGFILE_GROUP_NAME', 8, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'LOGFILE_GROUP_NUMBER', 9, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'ENGINE', 10, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'FULLTEXT_KEYS', 11, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'DELETED_ROWS', 12, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'UPDATE_COUNT', 13, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'FREE_EXTENTS', 14, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TOTAL_EXTENTS', 15, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'EXTENT_SIZE', 16, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'INITIAL_SIZE', 17, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'MAXIMUM_SIZE', 18, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'AUTOEXTEND_SIZE', 19, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'CREATION_TIME', 20, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'LAST_UPDATE_TIME', 21, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'LAST_ACCESS_TIME', 22, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'RECOVER_TIME', 23, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TRANSACTION_COUNTER', 24, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'VERSION', 25, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'ROW_FORMAT', 26, NULL, 'YES', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'TABLE_ROWS', 27, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'AVG_ROW_LENGTH', 28, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'DATA_LENGTH', 29, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'MAX_DATA_LENGTH', 30, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'INDEX_LENGTH', 31, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'DATA_FREE', 32, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'CREATE_TIME', 33, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'UPDATE_TIME', 34, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'CHECK_TIME', 35, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'CHECKSUM', 36, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'STATUS', 37, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'FILES', 'EXTRA', 38, NULL, 'YES', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(255)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GLOBAL_STATUS', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GLOBAL_STATUS', 'VARIABLE_VALUE', 2, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GLOBAL_VARIABLES', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GLOBAL_VARIABLES', 'VARIABLE_VALUE', 2, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEYWORDS', 'WORD', 1, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'KEY_CACHE_NAME', 1, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'SEGMENTS', 2, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(3) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'SEGMENT_NUMBER', 3, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(3) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'FULL_SIZE', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'BLOCK_SIZE', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'USED_BLOCKS', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'UNUSED_BLOCKS', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'DIRTY_BLOCKS', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'READ_REQUESTS', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'READS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'WRITE_REQUESTS', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_CACHES', 'WRITES', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'CONSTRAINT_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'CONSTRAINT_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'CONSTRAINT_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'TABLE_CATALOG', 4, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'TABLE_SCHEMA', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'TABLE_NAME', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'COLUMN_NAME', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'ORDINAL_POSITION', 8, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'POSITION_IN_UNIQUE_CONSTRAINT', 9, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'REFERENCED_TABLE_SCHEMA', 10, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'REFERENCED_TABLE_NAME', 11, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'KEY_COLUMN_USAGE', 'REFERENCED_COLUMN_NAME', 12, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'OPTIMIZER_TRACE', 'QUERY', 1, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'OPTIMIZER_TRACE', 'TRACE', 2, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'OPTIMIZER_TRACE', 'MISSING_BYTES_BEYOND_MAX_MEM_SIZE', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'OPTIMIZER_TRACE', 'INSUFFICIENT_PRIVILEGES', 4, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'SPECIFIC_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'SPECIFIC_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'SPECIFIC_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'ORDINAL_POSITION', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'PARAMETER_MODE', 5, NULL, 'YES', 'varchar', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'PARAMETER_NAME', 6, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'DATA_TYPE', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'CHARACTER_MAXIMUM_LENGTH', 8, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'CHARACTER_OCTET_LENGTH', 9, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'NUMERIC_PRECISION', 10, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'NUMERIC_SCALE', 11, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'DATETIME_PRECISION', 12, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'CHARACTER_SET_NAME', 13, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'COLLATION_NAME', 14, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'DTD_IDENTIFIER', 15, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARAMETERS', 'ROUTINE_TYPE', 16, NULL, 'NO', 'varchar', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(9)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_NAME', 4, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'SUBPARTITION_NAME', 5, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_ORDINAL_POSITION', 6, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'SUBPARTITION_ORDINAL_POSITION', 7, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_METHOD', 8, NULL, 'YES', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'SUBPARTITION_METHOD', 9, NULL, 'YES', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_EXPRESSION', 10, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'SUBPARTITION_EXPRESSION', 11, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_DESCRIPTION', 12, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'TABLE_ROWS', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'AVG_ROW_LENGTH', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'DATA_LENGTH', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'MAX_DATA_LENGTH', 16, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'INDEX_LENGTH', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'DATA_FREE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'CREATE_TIME', 19, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'UPDATE_TIME', 20, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'CHECK_TIME', 21, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'CHECKSUM', 22, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'PARTITION_COMMENT', 23, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'NODEGROUP', 24, NULL, 'NO', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PARTITIONS', 'TABLESPACE_NAME', 25, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_VERSION', 2, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_STATUS', 3, NULL, 'NO', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_TYPE', 4, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_TYPE_VERSION', 5, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_LIBRARY', 6, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_LIBRARY_VERSION', 7, NULL, 'YES', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_AUTHOR', 8, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_DESCRIPTION', 9, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_LICENSE', 10, NULL, 'NO', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'LOAD_OPTION', 11, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_MATURITY', 12, NULL, 'NO', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PLUGINS', 'PLUGIN_AUTH_VERSION', 13, NULL, 'YES', 'varchar', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(80)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'USER', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'HOST', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'DB', 4, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'COMMAND', 5, NULL, 'NO', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'TIME', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'STATE', 7, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'INFO', 8, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'TIME_MS', 9, NULL, 'NO', 'decimal', NULL, NULL, 22, 3, NULL, NULL, NULL, 'decimal(22,3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'STAGE', 10, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'MAX_STAGE', 11, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'PROGRESS', 12, NULL, 'NO', 'decimal', NULL, NULL, 7, 3, NULL, NULL, NULL, 'decimal(7,3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'MEMORY_USED', 13, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'MAX_MEMORY_USED', 14, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'EXAMINED_ROWS', 15, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'QUERY_ID', 16, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'INFO_BINARY', 17, NULL, 'YES', 'blob', 65535, 65535, NULL, NULL, NULL, NULL, NULL, 'blob', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROCESSLIST', 'TID', 18, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'QUERY_ID', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'SEQ', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'STATE', 3, NULL, 'NO', 'varchar', 30, 90, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(30)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'DURATION', 4, NULL, 'NO', 'decimal', NULL, NULL, 9, 6, NULL, NULL, NULL, 'decimal(9,6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'CPU_USER', 5, NULL, 'YES', 'decimal', NULL, NULL, 9, 6, NULL, NULL, NULL, 'decimal(9,6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'CPU_SYSTEM', 6, NULL, 'YES', 'decimal', NULL, NULL, 9, 6, NULL, NULL, NULL, 'decimal(9,6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'CONTEXT_VOLUNTARY', 7, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'CONTEXT_INVOLUNTARY', 8, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'BLOCK_OPS_IN', 9, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'BLOCK_OPS_OUT', 10, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'MESSAGES_SENT', 11, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'MESSAGES_RECEIVED', 12, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'PAGE_FAULTS_MAJOR', 13, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'PAGE_FAULTS_MINOR', 14, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'SWAPS', 15, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'SOURCE_FUNCTION', 16, NULL, 'YES', 'varchar', 30, 90, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(30)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'SOURCE_FILE', 17, NULL, 'YES', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'PROFILING', 'SOURCE_LINE', 18, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(20)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'CONSTRAINT_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'CONSTRAINT_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'CONSTRAINT_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'UNIQUE_CONSTRAINT_CATALOG', 4, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'UNIQUE_CONSTRAINT_SCHEMA', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'UNIQUE_CONSTRAINT_NAME', 6, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'MATCH_OPTION', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'UPDATE_RULE', 8, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'DELETE_RULE', 9, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'TABLE_NAME', 10, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'REFERENTIAL_CONSTRAINTS', 'REFERENCED_TABLE_NAME', 11, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'SPECIFIC_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_CATALOG', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_SCHEMA', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_NAME', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_TYPE', 5, NULL, 'NO', 'varchar', 13, 39, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(13)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'DATA_TYPE', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'CHARACTER_MAXIMUM_LENGTH', 7, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'CHARACTER_OCTET_LENGTH', 8, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'NUMERIC_PRECISION', 9, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'NUMERIC_SCALE', 10, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'DATETIME_PRECISION', 11, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'CHARACTER_SET_NAME', 12, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'COLLATION_NAME', 13, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'DTD_IDENTIFIER', 14, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_BODY', 15, NULL, 'NO', 'varchar', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_DEFINITION', 16, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'EXTERNAL_NAME', 17, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'EXTERNAL_LANGUAGE', 18, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'PARAMETER_STYLE', 19, NULL, 'NO', 'varchar', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'IS_DETERMINISTIC', 20, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'SQL_DATA_ACCESS', 21, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'SQL_PATH', 22, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'SECURITY_TYPE', 23, NULL, 'NO', 'varchar', 7, 21, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'CREATED', 24, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'LAST_ALTERED', 25, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'SQL_MODE', 26, NULL, 'NO', 'varchar', 8192, 24576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'ROUTINE_COMMENT', 27, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'DEFINER', 28, NULL, 'NO', 'varchar', 189, 567, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(189)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'CHARACTER_SET_CLIENT', 29, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'COLLATION_CONNECTION', 30, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'ROUTINES', 'DATABASE_COLLATION', 31, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMATA', 'CATALOG_NAME', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMATA', 'SCHEMA_NAME', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMATA', 'DEFAULT_CHARACTER_SET_NAME', 3, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMATA', 'DEFAULT_COLLATION_NAME', 4, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMATA', 'SQL_PATH', 5, NULL, 'YES', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMA_PRIVILEGES', 'GRANTEE', 1, NULL, 'NO', 'varchar', 190, 570, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(190)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMA_PRIVILEGES', 'TABLE_CATALOG', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMA_PRIVILEGES', 'TABLE_SCHEMA', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMA_PRIVILEGES', 'PRIVILEGE_TYPE', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SCHEMA_PRIVILEGES', 'IS_GRANTABLE', 5, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SESSION_STATUS', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SESSION_STATUS', 'VARIABLE_VALUE', 2, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SESSION_VARIABLES', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SESSION_VARIABLES', 'VARIABLE_VALUE', 2, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'NON_UNIQUE', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'INDEX_SCHEMA', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'INDEX_NAME', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'SEQ_IN_INDEX', 7, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'COLUMN_NAME', 8, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'COLLATION', 9, NULL, 'YES', 'varchar', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'CARDINALITY', 10, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'SUB_PART', 11, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'PACKED', 12, NULL, 'YES', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'NULLABLE', 13, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'INDEX_TYPE', 14, NULL, 'NO', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'COMMENT', 15, NULL, 'YES', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'STATISTICS', 'INDEX_COMMENT', 16, NULL, 'NO', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SQL_FUNCTIONS', 'FUNCTION', 1, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'SESSION_VALUE', 2, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'GLOBAL_VALUE', 3, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'GLOBAL_VALUE_ORIGIN', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'DEFAULT_VALUE', 5, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'VARIABLE_SCOPE', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'VARIABLE_TYPE', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'VARIABLE_COMMENT', 8, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'NUMERIC_MIN_VALUE', 9, NULL, 'YES', 'varchar', 21, 63, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'NUMERIC_MAX_VALUE', 10, NULL, 'YES', 'varchar', 21, 63, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'NUMERIC_BLOCK_SIZE', 11, NULL, 'YES', 'varchar', 21, 63, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'ENUM_VALUE_LIST', 12, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'READ_ONLY', 13, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SYSTEM_VARIABLES', 'COMMAND_LINE_ARGUMENT', 14, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_TYPE', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'ENGINE', 5, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'VERSION', 6, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'ROW_FORMAT', 7, NULL, 'YES', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_ROWS', 8, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'AVG_ROW_LENGTH', 9, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'DATA_LENGTH', 10, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'MAX_DATA_LENGTH', 11, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'INDEX_LENGTH', 12, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'DATA_FREE', 13, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'AUTO_INCREMENT', 14, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'CREATE_TIME', 15, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'UPDATE_TIME', 16, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'CHECK_TIME', 17, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_COLLATION', 18, NULL, 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'CHECKSUM', 19, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'CREATE_OPTIONS', 20, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TABLE_COMMENT', 21, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'MAX_INDEX_LENGTH', 22, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLES', 'TEMPORARY', 23, NULL, 'YES', 'varchar', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'TABLESPACE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'ENGINE', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'TABLESPACE_TYPE', 3, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'LOGFILE_GROUP_NAME', 4, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'EXTENT_SIZE', 5, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'AUTOEXTEND_SIZE', 6, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'MAXIMUM_SIZE', 7, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'NODEGROUP_ID', 8, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLESPACES', 'TABLESPACE_COMMENT', 9, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'CONSTRAINT_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'CONSTRAINT_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'CONSTRAINT_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'TABLE_SCHEMA', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'TABLE_NAME', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_CONSTRAINTS', 'CONSTRAINT_TYPE', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'GRANTEE', 1, NULL, 'NO', 'varchar', 190, 570, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(190)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'TABLE_CATALOG', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'TABLE_SCHEMA', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'TABLE_NAME', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'PRIVILEGE_TYPE', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_PRIVILEGES', 'IS_GRANTABLE', 6, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'TRIGGER_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'TRIGGER_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'TRIGGER_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'EVENT_MANIPULATION', 4, NULL, 'NO', 'varchar', 6, 18, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'EVENT_OBJECT_CATALOG', 5, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'EVENT_OBJECT_SCHEMA', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'EVENT_OBJECT_TABLE', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_ORDER', 8, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(4)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_CONDITION', 9, NULL, 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_STATEMENT', 10, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_ORIENTATION', 11, NULL, 'NO', 'varchar', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(9)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_TIMING', 12, NULL, 'NO', 'varchar', 6, 18, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(6)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_REFERENCE_OLD_TABLE', 13, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_REFERENCE_NEW_TABLE', 14, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_REFERENCE_OLD_ROW', 15, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'ACTION_REFERENCE_NEW_ROW', 16, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'CREATED', 17, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 2, NULL, NULL, 'datetime(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'SQL_MODE', 18, NULL, 'NO', 'varchar', 8192, 24576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'DEFINER', 19, NULL, 'NO', 'varchar', 189, 567, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(189)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'CHARACTER_SET_CLIENT', 20, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'COLLATION_CONNECTION', 21, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TRIGGERS', 'DATABASE_COLLATION', 22, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_PRIVILEGES', 'GRANTEE', 1, NULL, 'NO', 'varchar', 190, 570, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(190)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_PRIVILEGES', 'TABLE_CATALOG', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_PRIVILEGES', 'PRIVILEGE_TYPE', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_PRIVILEGES', 'IS_GRANTABLE', 4, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'VIEW_DEFINITION', 4, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'CHECK_OPTION', 5, NULL, 'NO', 'varchar', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'IS_UPDATABLE', 6, NULL, 'NO', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'DEFINER', 7, NULL, 'NO', 'varchar', 189, 567, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(189)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'SECURITY_TYPE', 8, NULL, 'NO', 'varchar', 7, 21, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'CHARACTER_SET_CLIENT', 9, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'COLLATION_CONNECTION', 10, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'VIEWS', 'ALGORITHM', 11, NULL, 'NO', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'F_TABLE_CATALOG', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'F_TABLE_SCHEMA', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'F_TABLE_NAME', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'F_GEOMETRY_COLUMN', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'G_TABLE_CATALOG', 5, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'G_TABLE_SCHEMA', 6, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'G_TABLE_NAME', 7, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'G_GEOMETRY_COLUMN', 8, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'STORAGE_TYPE', 9, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'GEOMETRY_TYPE', 10, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(7)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'COORD_DIMENSION', 11, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'MAX_PPR', 12, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(2)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'GEOMETRY_COLUMNS', 'SRID', 13, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SPATIAL_REF_SYS', 'SRID', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SPATIAL_REF_SYS', 'AUTH_NAME', 2, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SPATIAL_REF_SYS', 'AUTH_SRID', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'SPATIAL_REF_SYS', 'SRTEXT', 4, NULL, 'NO', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'CLIENT', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'TOTAL_CONNECTIONS', 2, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'CONCURRENT_CONNECTIONS', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'CONNECTED_TIME', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'BUSY_TIME', 5, NULL, 'NO', 'double', NULL, NULL, 21, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'CPU_TIME', 6, NULL, 'NO', 'double', NULL, NULL, 21, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'BYTES_RECEIVED', 7, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'BYTES_SENT', 8, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'BINLOG_BYTES_WRITTEN', 9, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROWS_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROWS_SENT', 11, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROWS_DELETED', 12, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROWS_INSERTED', 13, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROWS_UPDATED', 14, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'SELECT_COMMANDS', 15, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'UPDATE_COMMANDS', 16, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'OTHER_COMMANDS', 17, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'COMMIT_TRANSACTIONS', 18, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ROLLBACK_TRANSACTIONS', 19, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'DENIED_CONNECTIONS', 20, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'LOST_CONNECTIONS', 21, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'ACCESS_DENIED', 22, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'EMPTY_QUERIES', 23, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'TOTAL_SSL_CONNECTIONS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'CLIENT_STATISTICS', 'MAX_STATEMENT_TIME_EXCEEDED', 25, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INDEX_STATISTICS', 'TABLE_SCHEMA', 1, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INDEX_STATISTICS', 'TABLE_NAME', 2, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INDEX_STATISTICS', 'INDEX_NAME', 3, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INDEX_STATISTICS', 'ROWS_READ', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_DATAFILES', 'SPACE', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_DATAFILES', 'PATH', 2, NULL, 'NO', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'USER', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'TOTAL_CONNECTIONS', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'CONCURRENT_CONNECTIONS', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'CONNECTED_TIME', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'BUSY_TIME', 5, NULL, 'NO', 'double', NULL, NULL, 21, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'CPU_TIME', 6, NULL, 'NO', 'double', NULL, NULL, 21, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'BYTES_RECEIVED', 7, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'BYTES_SENT', 8, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'BINLOG_BYTES_WRITTEN', 9, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROWS_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROWS_SENT', 11, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROWS_DELETED', 12, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROWS_INSERTED', 13, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROWS_UPDATED', 14, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'SELECT_COMMANDS', 15, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'UPDATE_COMMANDS', 16, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'OTHER_COMMANDS', 17, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'COMMIT_TRANSACTIONS', 18, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ROLLBACK_TRANSACTIONS', 19, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'DENIED_CONNECTIONS', 20, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'LOST_CONNECTIONS', 21, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'ACCESS_DENIED', 22, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'EMPTY_QUERIES', 23, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'TOTAL_SSL_CONNECTIONS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'USER_STATISTICS', 'MAX_STATEMENT_TIME_EXCEEDED', 25, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'TABLE_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'STATS_INITIALIZED', 3, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'NUM_ROWS', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'CLUST_INDEX_SIZE', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'OTHER_INDEX_SIZE', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'MODIFIED_COUNTER', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'AUTOINC', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESTATS', 'REF_COUNT', 9, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_id', 1, NULL, 'NO', 'varchar', 81, 243, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(81)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_trx_id', 2, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_mode', 3, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_type', 4, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_table', 5, NULL, 'NO', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_index', 6, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_space', 7, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_page', 8, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_rec', 9, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCKS', 'lock_data', 10, NULL, 'YES', 'varchar', 8192, 24576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(8192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_MUTEXES', 'NAME', 1, NULL, 'NO', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_MUTEXES', 'CREATE_FILE', 2, NULL, 'NO', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_MUTEXES', 'CREATE_LINE', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_MUTEXES', 'OS_WAITS', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'page_size', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'buffer_pool_instance', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'pages_used', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'pages_free', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'relocation_ops', 5, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM', 'relocation_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'database_name', 1, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'table_name', 2, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'index_name', 3, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'compress_ops', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'compress_ops_ok', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'compress_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'uncompress_ops', 7, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX', 'uncompress_time', 8, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'page_size', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'compress_ops', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'compress_ops_ok', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'compress_time', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'uncompress_ops', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP', 'uncompress_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_DELETED', 'DOC_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'page_size', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'compress_ops', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'compress_ops_ok', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'compress_time', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'uncompress_ops', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_RESET', 'uncompress_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCK_WAITS', 'requesting_trx_id', 1, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCK_WAITS', 'requested_lock_id', 2, NULL, 'NO', 'varchar', 81, 243, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(81)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCK_WAITS', 'blocking_trx_id', 3, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_LOCK_WAITS', 'blocking_lock_id', 4, NULL, 'NO', 'varchar', 81, 243, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(81)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_STATISTICS', 'TABLE_SCHEMA', 1, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_STATISTICS', 'TABLE_NAME', 2, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_STATISTICS', 'ROWS_READ', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_STATISTICS', 'ROWS_CHANGED', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'TABLE_STATISTICS', 'ROWS_CHANGED_X_INDEXES', 5, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'SPACE', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'NAME', 2, NULL, 'YES', 'varchar', 655, 1965, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(655)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'ENCRYPTION_SCHEME', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'KEYSERVER_REQUESTS', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'MIN_KEY_VERSION', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'CURRENT_KEY_VERSION', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'KEY_ROTATION_PAGE_NUMBER', 7, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'KEY_ROTATION_MAX_PAGE_NUMBER', 8, NULL, 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'CURRENT_KEY_ID', 9, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_ENCRYPTION', 'ROTATING_OR_FLUSHING', 10, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'POOL_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'LRU_POSITION', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'SPACE', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'PAGE_NUMBER', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'PAGE_TYPE', 5, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'FLUSH_TYPE', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'FIX_COUNT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'IS_HASHED', 8, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'NEWEST_MODIFICATION', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'OLDEST_MODIFICATION', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'ACCESS_TIME', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'TABLE_NAME', 12, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'INDEX_NAME', 13, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'NUMBER_RECORDS', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'DATA_SIZE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'COMPRESSED_SIZE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'COMPRESSED', 17, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'IO_FIX', 18, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'IS_OLD', 19, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE_LRU', 'FREE_PAGE_CLOCK', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FIELDS', 'INDEX_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FIELDS', 'NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FIELDS', 'POS', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'page_size', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'buffer_pool_instance', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'pages_used', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'pages_free', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'relocation_ops', 5, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMPMEM_RESET', 'relocation_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'TABLE_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'POS', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'MTYPE', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'PRTYPE', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_COLUMNS', 'LEN', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'WORD', 1, NULL, 'NO', 'varchar', 337, 1011, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(337)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'FIRST_DOC_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'LAST_DOC_ID', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'DOC_COUNT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'DOC_ID', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_TABLE', 'POSITION', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'database_name', 1, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'table_name', 2, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'index_name', 3, NULL, 'NO', 'varchar', 192, 576, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(192)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'compress_ops', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'compress_ops_ok', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'compress_time', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'uncompress_ops', 7, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_CMP_PER_INDEX_RESET', 'uncompress_time', 8, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'user_variables', 'VARIABLE_NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'user_variables', 'VARIABLE_VALUE', 2, NULL, 'YES', 'varchar', 2048, 6144, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(2048)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'user_variables', 'VARIABLE_TYPE', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'user_variables', 'CHARACTER_SET_NAME', 4, NULL, 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'WORD', 1, NULL, 'NO', 'varchar', 337, 1011, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(337)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'FIRST_DOC_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'LAST_DOC_ID', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'DOC_COUNT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'DOC_ID', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_INDEX_CACHE', 'POSITION', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN_COLS', 'ID', 1, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN_COLS', 'FOR_COL_NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN_COLS', 'REF_COL_NAME', 3, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN_COLS', 'POS', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_BEING_DELETED', 'DOC_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'POOL_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'POOL_SIZE', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'FREE_BUFFERS', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'DATABASE_PAGES', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'OLD_DATABASE_PAGES', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'MODIFIED_DATABASE_PAGES', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PENDING_DECOMPRESS', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PENDING_READS', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PENDING_FLUSH_LRU', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PENDING_FLUSH_LIST', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_MADE_YOUNG', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_NOT_MADE_YOUNG', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_MADE_YOUNG_RATE', 13, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_MADE_NOT_YOUNG_RATE', 14, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_PAGES_READ', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_PAGES_CREATED', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_PAGES_WRITTEN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_READ_RATE', 18, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_CREATE_RATE', 19, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'PAGES_WRITTEN_RATE', 20, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_PAGES_GET', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'HIT_RATE', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'YOUNG_MAKE_PER_THOUSAND_GETS', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NOT_YOUNG_MAKE_PER_THOUSAND_GETS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_PAGES_READ_AHEAD', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'NUMBER_READ_AHEAD_EVICTED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'READ_AHEAD_RATE', 27, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'READ_AHEAD_EVICTED_RATE', 28, NULL, 'NO', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'LRU_IO_TOTAL', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'LRU_IO_CURRENT', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'UNCOMPRESS_TOTAL', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_POOL_STATS', 'UNCOMPRESS_CURRENT', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_id', 1, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_state', 2, NULL, 'NO', 'varchar', 13, 39, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(13)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_started', 3, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_requested_lock_id', 4, NULL, 'YES', 'varchar', 81, 243, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(81)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_wait_started', 5, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_weight', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_mysql_thread_id', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_query', 8, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_operation_state', 9, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_tables_in_use', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_tables_locked', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_lock_structs', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_lock_memory_bytes', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_rows_locked', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_rows_modified', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_concurrency_tickets', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_isolation_level', 17, NULL, 'NO', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_unique_checks', 18, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_foreign_key_checks', 19, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_last_foreign_key_error', 20, NULL, 'YES', 'varchar', 256, 768, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(256)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_is_read_only', 21, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TRX', 'trx_autocommit_non_locking', 22, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN', 'ID', 1, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN', 'FOR_NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN', 'REF_NAME', 3, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN', 'N_COLS', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_FOREIGN', 'TYPE', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'TABLE_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'NAME', 2, NULL, 'NO', 'varchar', 655, 1965, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(655)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'FLAG', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'N_COLS', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'SPACE', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'ROW_FORMAT', 6, NULL, 'YES', 'varchar', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(12)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'ZIP_PAGE_SIZE', 7, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLES', 'SPACE_TYPE', 8, NULL, 'YES', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_DEFAULT_STOPWORD', 'value', 1, NULL, 'NO', 'varchar', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(18)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_CONFIG', 'KEY', 1, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_FT_CONFIG', 'VALUE', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'POOL_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'BLOCK_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'SPACE', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'PAGE_NUMBER', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'PAGE_TYPE', 5, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'FLUSH_TYPE', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'FIX_COUNT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'IS_HASHED', 8, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'NEWEST_MODIFICATION', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'OLDEST_MODIFICATION', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'ACCESS_TIME', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'TABLE_NAME', 12, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'INDEX_NAME', 13, NULL, 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(1024)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'NUMBER_RECORDS', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'DATA_SIZE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'COMPRESSED_SIZE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'PAGE_STATE', 17, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'IO_FIX', 18, NULL, 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'IS_OLD', 19, NULL, 'YES', 'varchar', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(3)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_BUFFER_PAGE', 'FREE_PAGE_CLOCK', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'SPACE', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'NAME', 2, NULL, 'NO', 'varchar', 655, 1965, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(655)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'FLAG', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'ROW_FORMAT', 4, NULL, 'YES', 'varchar', 22, 66, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(22)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'PAGE_SIZE', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'ZIP_PAGE_SIZE', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'SPACE_TYPE', 7, NULL, 'YES', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'FS_BLOCK_SIZE', 8, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'FILE_SIZE', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_TABLESPACES', 'ALLOCATED_SIZE', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'NAME', 1, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'SUBSYSTEM', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'COUNT', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'MAX_COUNT', 4, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'MIN_COUNT', 5, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'AVG_COUNT', 6, NULL, 'YES', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'COUNT_RESET', 7, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'MAX_COUNT_RESET', 8, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'MIN_COUNT_RESET', 9, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'AVG_COUNT_RESET', 10, NULL, 'YES', 'double', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'double', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'TIME_ENABLED', 11, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'TIME_DISABLED', 12, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'TIME_ELAPSED', 13, NULL, 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'TIME_RESET', 14, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'STATUS', 15, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'TYPE', 16, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_METRICS', 'COMMENT', 17, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'INDEX_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'NAME', 2, NULL, 'NO', 'varchar', 193, 579, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(193)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'TABLE_ID', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'TYPE', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'N_FIELDS', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'PAGE_NO', 6, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'SPACE', 7, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_INDEXES', 'MERGE_THRESHOLD', 8, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_VIRTUAL', 'TABLE_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_VIRTUAL', 'POS', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_VIRTUAL', 'BASE_POS', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'SPACE', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'NAME', 2, NULL, 'YES', 'varchar', 655, 1965, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(655)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'COMPRESSED', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'LAST_SCRUB_COMPLETED', 4, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'CURRENT_SCRUB_STARTED', 5, NULL, 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'CURRENT_SCRUB_ACTIVE_THREADS', 6, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'CURRENT_SCRUB_PAGE_NUMBER', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'CURRENT_SCRUB_MAX_PAGE_NUMBER', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_TABLESPACES_SCRUBBING', 'ON_SSD', 9, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'OBJECT_NAME', 2, NULL, 'YES', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'FILE', 3, NULL, 'YES', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'LINE', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'WAIT_TIME', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'WAIT_OBJECT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'WAIT_TYPE', 7, NULL, 'YES', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'HOLDER_THREAD_ID', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'HOLDER_FILE', 9, NULL, 'YES', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'HOLDER_LINE', 10, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'CREATED_FILE', 11, NULL, 'YES', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'CREATED_LINE', 12, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'WRITER_THREAD', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'RESERVATION_MODE', 14, NULL, 'YES', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'READERS', 15, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'WAITERS_FLAG', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'LOCK_WORD', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'LAST_WRITER_FILE', 18, NULL, 'YES', 'varchar', 4000, 12000, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(4000)', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'LAST_WRITER_LINE', 19, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'information_schema', 'INNODB_SYS_SEMAPHORE_WAITS', 'OS_WAIT_COUNT', 20, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select', '', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'title', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'poster', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime poster URL', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'season', 4, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Premiered season', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'year', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Premiered year', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'type', 6, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime type', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'rating', 7, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Age rating', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'source', 8, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime source (manga, original, etc.)', 'NEVER', NULL),
	('def', 'animelist', 'anime', 'description', 9, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Anime description', 'NEVER', NULL),
	('def', 'animelist', 'anime_genres', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_genres', 'anime_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_genres', 'genre_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_licensor', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_licensor', 'anime_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_licensor', 'licensor_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'title', 1, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'poster', 2, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime poster URL', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'season', 3, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Premiered season', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'year', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Premiered year', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'type', 5, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime type', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'rating', 6, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Age rating', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'source', 7, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime source (manga, original, etc.)', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'description', 8, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Anime description', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'genres', 9, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'studio', 10, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Studio name', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'licensor', 11, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Licensor name', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'episodes', 12, NULL, 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Number of episodes', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'from', 13, NULL, 'YES', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing from', 'NEVER', NULL),
	('def', 'animelist', 'anime_list', 'to', 14, NULL, 'YES', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing to', 'NEVER', NULL),
	('def', 'animelist', 'anime_studio', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_studio', 'anime_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'anime_studio', 'studio_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'episode', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'episode', 'anime_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'episode', 'number', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Number of episodes', 'NEVER', NULL),
	('def', 'animelist', 'episode', 'from', 4, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing from', 'NEVER', NULL),
	('def', 'animelist', 'episode', 'to', 5, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing to', 'NEVER', NULL),
	('def', 'animelist', 'episodes', 'id', 1, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'episodes', 'title', 2, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'episodes', 'number', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Number of episodes', 'NEVER', NULL),
	('def', 'animelist', 'episodes', 'from', 4, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing from', 'NEVER', NULL),
	('def', 'animelist', 'episodes', 'to', 5, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Airing to', 'NEVER', NULL),
	('def', 'animelist', 'genre', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'genre', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Genre name', 'NEVER', NULL),
	('def', 'animelist', 'genres', 'id', 1, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'genres', 'title', 2, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'genres', 'genres', 3, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'licensor', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'licensor', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Licensor name', 'NEVER', NULL),
	('def', 'animelist', 'licensors', 'id', 1, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'licensors', 'title', 2, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'licensors', 'name', 3, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Licensor name', 'NEVER', NULL),
	('def', 'animelist', 'studio', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'studio', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Studio name', 'NEVER', NULL),
	('def', 'animelist', 'studios', 'id', 1, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'studios', 'title', 2, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'studios', 'name', 3, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Studio name', 'NEVER', NULL),
	('def', 'animelist', 'users', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users', 'username', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users', 'password', 3, NULL, 'NO', 'varchar', 120, 480, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(120)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users_anime', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users_anime', 'users_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users_anime', 'users_list_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'title', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime title', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'poster', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime poster URL', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'season', 4, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Gadalaiks, kad tika publicets', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'year', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Gads, kad tika publicets', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'type', 6, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime tips', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'rating', 7, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Vecuma reitings', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'source', 8, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime avots', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'description', 9, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Anime apraksts', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'genre', 10, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime žanri', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'studios', 11, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime studijas', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'licensors', 12, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Anime licenzori', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'episodes', 13, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Anime seriju skaits', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'aired_from', 14, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Publicejas no', 'NEVER', NULL),
	('def', 'animelist', 'users_list', 'aired_to', 15, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Publicejas lidz', 'NEVER', NULL),
	('def', 'anime_db', 'anime', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'anime_db', 'anime', 'title', 2, NULL, 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(191)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'anime_db', 'anime', 'genre', 3, NULL, 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(191)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'anime_db', 'anime', 'episodes', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'anime_db', 'anime', 'description', 5, NULL, 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(191)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_commentmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_commentmeta', 'comment_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_commentmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_commentmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_post_ID', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_author', 3, NULL, 'NO', 'tinytext', 255, 255, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'tinytext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_author_email', 4, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_author_url', 5, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_author_IP', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_date', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_date_gmt', 8, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_content', 9, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_karma', 10, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_approved', 11, '\'1\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_agent', 12, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_type', 13, '\'comment\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'comment_parent', 14, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_comments', 'user_id', 15, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_url', 2, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_name', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_image', 4, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_target', 5, '\'\'', 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_description', 6, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_visible', 7, '\'Y\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_owner', 8, '1', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_rating', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_updated', 10, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_rel', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_notes', 12, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_links', 'link_rss', 13, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_options', 'option_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_options', 'option_name', 2, '\'\'', 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(191)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_options', 'option_value', 3, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_options', 'autoload', 4, '\'yes\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_postmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_postmeta', 'post_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_postmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_postmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_author', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_date', 3, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_date_gmt', 4, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_content', 5, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_title', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_excerpt', 7, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_status', 8, '\'publish\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'comment_status', 9, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'ping_status', 10, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_password', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_name', 12, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'to_ping', 13, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'pinged', 14, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_modified', 15, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_modified_gmt', 16, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_content_filtered', 17, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_parent', 18, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'guid', 19, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'menu_order', 20, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_type', 21, '\'post\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'post_mime_type', 22, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_posts', 'comment_count', 23, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_termmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_termmeta', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_termmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_termmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_terms', 'term_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_terms', 'name', 2, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_terms', 'slug', 3, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_terms', 'term_group', 4, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_relationships', 'object_id', 1, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_relationships', 'term_taxonomy_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_relationships', 'term_order', 3, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'term_taxonomy_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'taxonomy', 3, '\'\'', 'NO', 'varchar', 32, 128, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(32)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'description', 4, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'parent', 5, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_term_taxonomy', 'count', 6, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_usermeta', 'umeta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_usermeta', 'user_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_usermeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_usermeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_login', 2, '\'\'', 'NO', 'varchar', 60, 240, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(60)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_pass', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_nicename', 4, '\'\'', 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(50)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_email', 5, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_url', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_registered', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_activation_key', 8, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'user_status', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrapprakseraivis', 'wp_users', 'display_name', 10, '\'\'', 'NO', 'varchar', 250, 1000, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(250)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_commentmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_commentmeta', 'comment_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_commentmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_commentmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_post_ID', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_author', 3, NULL, 'NO', 'tinytext', 255, 255, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'tinytext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_author_email', 4, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_author_url', 5, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_author_IP', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_date', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_date_gmt', 8, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_content', 9, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_karma', 10, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_approved', 11, '\'1\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_agent', 12, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_type', 13, '\'comment\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'comment_parent', 14, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_comments', 'user_id', 15, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_url', 2, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_name', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_image', 4, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_target', 5, '\'\'', 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_description', 6, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_visible', 7, '\'Y\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_owner', 8, '1', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_rating', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_updated', 10, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_rel', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_notes', 12, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_links', 'link_rss', 13, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_options', 'option_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_options', 'option_name', 2, '\'\'', 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(191)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_options', 'option_value', 3, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_options', 'autoload', 4, '\'yes\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_postmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_postmeta', 'post_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_postmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_postmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_author', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_date', 3, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_date_gmt', 4, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_content', 5, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_title', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_excerpt', 7, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_status', 8, '\'publish\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'comment_status', 9, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'ping_status', 10, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_password', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_name', 12, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'to_ping', 13, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'pinged', 14, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_modified', 15, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_modified_gmt', 16, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_content_filtered', 17, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_parent', 18, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'guid', 19, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'menu_order', 20, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_type', 21, '\'post\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'post_mime_type', 22, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_posts', 'comment_count', 23, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_termmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_termmeta', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_termmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_termmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_terms', 'term_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_terms', 'name', 2, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_terms', 'slug', 3, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_terms', 'term_group', 4, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_relationships', 'object_id', 1, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_relationships', 'term_taxonomy_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_relationships', 'term_order', 3, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'term_taxonomy_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'taxonomy', 3, '\'\'', 'NO', 'varchar', 32, 128, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(32)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'description', 4, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'parent', 5, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_term_taxonomy', 'count', 6, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_usermeta', 'umeta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_usermeta', 'user_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_usermeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_usermeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_login', 2, '\'\'', 'NO', 'varchar', 60, 240, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(60)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_pass', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_nicename', 4, '\'\'', 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(50)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_email', 5, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_url', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_registered', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_activation_key', 8, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'user_status', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'bootstrappraksewordpress', 'wp_users', 'display_name', 10, '\'\'', 'NO', 'varchar', 250, 1000, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(250)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_commentmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_commentmeta', 'comment_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_commentmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_commentmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_post_ID', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_author', 3, NULL, 'NO', 'tinytext', 255, 255, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'tinytext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_author_email', 4, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_author_url', 5, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_author_IP', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_date', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_date_gmt', 8, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_content', 9, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_karma', 10, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_approved', 11, '\'1\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_agent', 12, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_type', 13, '\'comment\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'comment_parent', 14, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_comments', 'user_id', 15, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_url', 2, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_name', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_image', 4, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_target', 5, '\'\'', 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_description', 6, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_visible', 7, '\'Y\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_owner', 8, '1', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_rating', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_updated', 10, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_rel', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_notes', 12, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_links', 'link_rss', 13, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_options', 'option_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_options', 'option_name', 2, '\'\'', 'NO', 'varchar', 191, 764, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(191)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_options', 'option_value', 3, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_options', 'autoload', 4, '\'yes\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_postmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_postmeta', 'post_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_postmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_postmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_author', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_date', 3, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_date_gmt', 4, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_content', 5, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_title', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_excerpt', 7, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_status', 8, '\'publish\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'comment_status', 9, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'ping_status', 10, '\'open\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_password', 11, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_name', 12, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'to_ping', 13, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'pinged', 14, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_modified', 15, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_modified_gmt', 16, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_content_filtered', 17, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_parent', 18, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'guid', 19, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'menu_order', 20, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_type', 21, '\'post\'', 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(20)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'post_mime_type', 22, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_posts', 'comment_count', 23, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_termmeta', 'meta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_termmeta', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_termmeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_termmeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_terms', 'term_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_terms', 'name', 2, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_terms', 'slug', 3, '\'\'', 'NO', 'varchar', 200, 800, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(200)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_terms', 'term_group', 4, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_relationships', 'object_id', 1, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_relationships', 'term_taxonomy_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_relationships', 'term_order', 3, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'term_taxonomy_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'term_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'taxonomy', 3, '\'\'', 'NO', 'varchar', 32, 128, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(32)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'description', 4, NULL, 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'parent', 5, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_term_taxonomy', 'count', 6, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_usermeta', 'umeta_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_usermeta', 'user_id', 2, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_usermeta', 'meta_key', 3, 'NULL', 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_usermeta', 'meta_value', 4, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_login', 2, '\'\'', 'NO', 'varchar', 60, 240, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(60)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_pass', 3, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_nicename', 4, '\'\'', 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(50)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_email', 5, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_url', 6, '\'\'', 'NO', 'varchar', 100, 400, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(100)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_registered', 7, '\'0000-00-00 00:00:00\'', 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_activation_key', 8, '\'\'', 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'user_status', 9, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'database_prakse', 'wp_users', 'display_name', 10, '\'\'', 'NO', 'varchar', 250, 1000, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_unicode_520_ci', 'varchar(250)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'materialwork', 'avarijas_darbi', 'Nr. p.k.', 1, NULL, 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2) unsigned', '', '', 'select,insert,update,references', 'Otrā darbu ID (unique key)', 'NEVER', NULL),
	('def', 'materialwork', 'avarijas_darbi', 'Darba veids', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Darbu nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'avarijas_darbi', 'Mērvienība', 3, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Mērvienības nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'avarijas_darbi', 'Plānotais apjoms 48 mēn.', 4, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Darbu plānotais apjoms', 'NEVER', NULL),
	('def', 'materialwork', 'category', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Materiālu kategorijas ID (primary key)', 'NEVER', NULL),
	('def', 'materialwork', 'category', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Materiālu kategorijas nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'material', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Materiālu ID (primary key)', 'NEVER', NULL),
	('def', 'materialwork', 'material', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Materiālu nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'material', 'unit_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Mērvienības ID (foreign key)', 'NEVER', NULL),
	('def', 'materialwork', 'material', 'category_id', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Materiālu kategorijas ID (foreign key)', 'NEVER', NULL),
	('def', 'materialwork', 'material', 'amount', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Materiālu plānotais daudzums', 'NEVER', NULL),
	('def', 'materialwork', 'materiali_un_apjomi', 'Nr. p.k.', 1, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Materiālu ID (primary key)', 'NEVER', NULL),
	('def', 'materialwork', 'materiali_un_apjomi', 'Materiālu veids', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Materiālu nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'materiali_un_apjomi', 'Mērvienība', 3, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Mērvienības nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'materiali_un_apjomi', 'Plānotais apjoms 48 mēn.', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Materiālu plānotais daudzums', 'NEVER', NULL),
	('def', 'materialwork', 'remontdarbi', 'Nr. p.k.', 1, NULL, 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2) unsigned', '', '', 'select,insert,update,references', 'Otrā darbu ID (unique key)', 'NEVER', NULL),
	('def', 'materialwork', 'remontdarbi', 'Darba veids', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Darbu nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'remontdarbi', 'Mērvienība', 3, NULL, 'YES', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Mērvienības nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'remontdarbi', 'Plānotais apjoms 48 mēn.', 4, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Darbu plānotais apjoms', 'NEVER', NULL),
	('def', 'materialwork', 'unit', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Mērvienības ID (primary key)', 'NEVER', NULL),
	('def', 'materialwork', 'unit', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Mērvienības nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'wcategory', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Darba kategorijas ID (pirmary key)', 'NEVER', NULL),
	('def', 'materialwork', 'wcategory', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Darba kategorijas/nozares nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Darbu ID (primary key)', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'id2', 2, NULL, 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2) unsigned', 'UNI', '', 'select,insert,update,references', 'Otrā darbu ID (unique key)', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'name', 3, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Darbu nosaukums', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'wcategory_id', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Darba kategorijas ID (foreign key)', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'unit_id', 5, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Mērvienības ID (foreign key)', 'NEVER', NULL),
	('def', 'materialwork', 'work', 'amount', 6, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', '', '', 'select,insert,update,references', 'Darbu plānotais apjoms', 'NEVER', NULL),
	('def', 'metodes', 'fun_login', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Login ID', 'NEVER', NULL),
	('def', 'metodes', 'fun_login', 'user_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'MUL', '', 'select,insert,update,references', 'User id', 'NEVER', NULL),
	('def', 'metodes', 'fun_login', 'time', 3, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', 'Time to work', 'NEVER', NULL),
	('def', 'metodes', 'fun_person', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Person ID', 'NEVER', NULL),
	('def', 'metodes', 'fun_person', 'name', 2, NULL, 'NO', 'varchar', 50, 150, NULL, NULL, NULL, 'utf8', 'utf8_unicode_ci', 'varchar(50)', '', '', 'select,insert,update,references', 'Personas name', 'NEVER', NULL),
	('def', 'metodes', 'fun_person', 'fname', 3, NULL, 'NO', 'varchar', 50, 150, NULL, NULL, NULL, 'utf8', 'utf8_unicode_ci', 'varchar(50)', '', '', 'select,insert,update,references', 'Person fname', 'NEVER', NULL),
	('def', 'metodes', 'fun_users', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'User ID', 'NEVER', NULL),
	('def', 'metodes', 'fun_users', 'person_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'MUL', '', 'select,insert,update,references', 'Person ID', 'NEVER', NULL),
	('def', 'metodes', 'fun_users', 'name', 3, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_unicode_ci', 'varchar(20)', '', '', 'select,insert,update,references', 'User name', 'NEVER', NULL),
	('def', 'metodes', 'fun_users', 'password', 4, NULL, 'NO', 'varchar', 20, 60, NULL, NULL, NULL, 'utf8', 'utf8_unicode_ci', 'varchar(20)', '', '', 'select,insert,update,references', 'User password', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Db', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'User', 3, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Table_name', 4, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Column_name', 5, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Timestamp', 6, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'columns_priv', 'Column_priv', 7, '\'\'', 'NO', 'set', 31, 93, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'Select\',\'Insert\',\'Update\',\'References\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'db_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'table_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'column_name', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'min_value', 4, 'NULL', 'YES', 'varbinary', 255, 255, NULL, NULL, NULL, NULL, NULL, 'varbinary(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'max_value', 5, 'NULL', 'YES', 'varbinary', 255, 255, NULL, NULL, NULL, NULL, NULL, 'varbinary(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'nulls_ratio', 6, 'NULL', 'YES', 'decimal', NULL, NULL, 12, 4, NULL, NULL, NULL, 'decimal(12,4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'avg_length', 7, 'NULL', 'YES', 'decimal', NULL, NULL, 12, 4, NULL, NULL, NULL, 'decimal(12,4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'avg_frequency', 8, 'NULL', 'YES', 'decimal', NULL, NULL, 12, 4, NULL, NULL, NULL, 'decimal(12,4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'hist_size', 9, 'NULL', 'YES', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'hist_type', 10, 'NULL', 'YES', 'enum', 14, 42, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'enum(\'SINGLE_PREC_HB\',\'DOUBLE_PREC_HB\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'column_stats', 'histogram', 11, 'NULL', 'YES', 'varbinary', 255, 255, NULL, NULL, NULL, NULL, NULL, 'varbinary(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Db', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'User', 3, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Select_priv', 4, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Insert_priv', 5, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Update_priv', 6, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Delete_priv', 7, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Create_priv', 8, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Drop_priv', 9, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Grant_priv', 10, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'References_priv', 11, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Index_priv', 12, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Alter_priv', 13, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Create_tmp_table_priv', 14, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Lock_tables_priv', 15, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Create_view_priv', 16, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Show_view_priv', 17, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Create_routine_priv', 18, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Alter_routine_priv', 19, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Execute_priv', 20, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Event_priv', 21, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Trigger_priv', 22, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'db', 'Delete_history_priv', 23, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'db', 1, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'name', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'body', 3, NULL, 'NO', 'longblob', 4294967295, 4294967295, NULL, NULL, NULL, NULL, NULL, 'longblob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'definer', 4, '\'\'', 'NO', 'char', 141, 423, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(141)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'execute_at', 5, 'NULL', 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'interval_value', 6, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'interval_field', 7, 'NULL', 'YES', 'enum', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YEAR\',\'QUARTER\',\'MONTH\',\'DAY\',\'HOUR\',\'MINUTE\',\'WEEK\',\'SECOND\',\'MICROSECOND\',\'YEAR_MONTH\',\'DAY_HOUR\',\'DAY_MINUTE\',\'DAY_SECOND\',\'HOUR_MINUTE\',\'HOUR_SECOND\',\'MINUTE_SECOND\',\'DAY_MICROSECOND\',\'HOUR_MICROSECOND\',\'MINUTE_MICROSECOND\',\'SECOND_MICROSECOND\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'created', 8, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'modified', 9, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'last_executed', 10, 'NULL', 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'starts', 11, 'NULL', 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'ends', 12, 'NULL', 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'status', 13, '\'ENABLED\'', 'NO', 'enum', 18, 54, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'ENABLED\',\'DISABLED\',\'SLAVESIDE_DISABLED\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'on_completion', 14, '\'DROP\'', 'NO', 'enum', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'DROP\',\'PRESERVE\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'sql_mode', 15, '\'\'', 'NO', 'set', 561, 1683, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'REAL_AS_FLOAT\',\'PIPES_AS_CONCAT\',\'ANSI_QUOTES\',\'IGNORE_SPACE\',\'IGNORE_BAD_TABLE_OPTIONS\',\'ONLY_FULL_GROUP_BY\',\'NO_UNSIGNED_SUBTRACTION\',\'NO_DIR_IN_CREATE\',\'POSTGRESQL\',\'ORACLE\',\'MSSQL\',\'DB2\',\'MAXDB\',\'NO_KEY_OPTIONS\',\'NO_TABLE_OPTIONS\',\'NO_FIELD_OPTIONS\',\'MYSQL323\',\'MYSQL40\',\'ANSI\',\'NO_AUTO_VALUE_ON_ZERO\',\'NO_BACKSLASH_ESCAPES\',\'STRICT_TRANS_TABLES\',\'STRICT_ALL_TABLES\',\'NO_ZERO_IN_DATE\',\'NO_ZERO_DATE\',\'INVALID_DATES\',\'ERROR_FOR_DIVISION_BY_ZERO\',\'TRADITIONAL\',\'NO_AUTO_CREATE_USER\',\'HIGH_NOT_PRECEDENCE\',\'NO_ENGINE_SUBSTITUTION\',\'PAD_CHAR_TO_FULL_LENGTH\',\'EMPTY_STRING_IS_NULL\',\'SIMULTANEOUS_ASSIGNMENT\',\'TIME_ROUND_FRACTIONAL\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'comment', 16, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'originator', 17, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'time_zone', 18, '\'SYSTEM\'', 'NO', 'char', 64, 64, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'character_set_client', 19, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'collation_connection', 20, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'db_collation', 21, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'event', 'body_utf8', 22, 'NULL', 'YES', 'longblob', 4294967295, 4294967295, NULL, NULL, NULL, NULL, NULL, 'longblob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'func', 'name', 1, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'func', 'ret', 2, '0', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'func', 'dl', 3, '\'\'', 'NO', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'func', 'type', 4, NULL, 'NO', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'function\',\'aggregate\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'event_time', 1, 'current_timestamp(6)', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'timestamp(6)', '', 'on update current_timestamp(6)', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'user_host', 2, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'thread_id', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'server_id', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'command_type', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'general_log', 'argument', 6, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'global_priv', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'global_priv', 'User', 2, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'global_priv', 'Priv', 3, '\'{}\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'gtid_slave_pos', 'domain_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'gtid_slave_pos', 'sub_id', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'gtid_slave_pos', 'server_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'gtid_slave_pos', 'seq_no', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_category', 'help_category_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_category', 'name', 2, NULL, 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_category', 'parent_category_id', 3, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_category', 'url', 4, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_keyword', 'help_keyword_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_keyword', 'name', 2, NULL, 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_relation', 'help_topic_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_relation', 'help_keyword_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'help_topic_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'name', 2, NULL, 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'help_category_id', 3, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'description', 4, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'example', 5, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'help_topic', 'url', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'index_stats', 'db_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'index_stats', 'table_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'index_stats', 'index_name', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'index_stats', 'prefix_arity', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'index_stats', 'avg_frequency', 5, 'NULL', 'YES', 'decimal', NULL, NULL, 12, 4, NULL, NULL, NULL, 'decimal(12,4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'database_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'table_name', 2, NULL, 'NO', 'varchar', 199, 597, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(199)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'index_name', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'stat_name', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'stat_value', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'sample_size', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_index_stats', 'stat_description', 8, NULL, 'NO', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(1024)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'database_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'table_name', 2, NULL, 'NO', 'varchar', 199, 597, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(199)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'n_rows', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'clustered_index_size', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'innodb_table_stats', 'sum_of_other_index_sizes', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'plugin', 'name', 1, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'plugin', 'dl', 2, '\'\'', 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'db', 1, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'name', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'type', 3, NULL, 'NO', 'enum', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'FUNCTION\',\'PROCEDURE\',\'PACKAGE\',\'PACKAGE BODY\')', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'specific_name', 4, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'language', 5, '\'SQL\'', 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'SQL\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'sql_data_access', 6, '\'CONTAINS_SQL\'', 'NO', 'enum', 17, 51, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'CONTAINS_SQL\',\'NO_SQL\',\'READS_SQL_DATA\',\'MODIFIES_SQL_DATA\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'is_deterministic', 7, '\'NO\'', 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'security_type', 8, '\'DEFINER\'', 'NO', 'enum', 7, 21, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'INVOKER\',\'DEFINER\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'param_list', 9, NULL, 'NO', 'blob', 65535, 65535, NULL, NULL, NULL, NULL, NULL, 'blob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'returns', 10, NULL, 'NO', 'longblob', 4294967295, 4294967295, NULL, NULL, NULL, NULL, NULL, 'longblob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'body', 11, NULL, 'NO', 'longblob', 4294967295, 4294967295, NULL, NULL, NULL, NULL, NULL, 'longblob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'definer', 12, '\'\'', 'NO', 'char', 141, 423, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(141)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'created', 13, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'modified', 14, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'sql_mode', 15, '\'\'', 'NO', 'set', 561, 1683, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'REAL_AS_FLOAT\',\'PIPES_AS_CONCAT\',\'ANSI_QUOTES\',\'IGNORE_SPACE\',\'IGNORE_BAD_TABLE_OPTIONS\',\'ONLY_FULL_GROUP_BY\',\'NO_UNSIGNED_SUBTRACTION\',\'NO_DIR_IN_CREATE\',\'POSTGRESQL\',\'ORACLE\',\'MSSQL\',\'DB2\',\'MAXDB\',\'NO_KEY_OPTIONS\',\'NO_TABLE_OPTIONS\',\'NO_FIELD_OPTIONS\',\'MYSQL323\',\'MYSQL40\',\'ANSI\',\'NO_AUTO_VALUE_ON_ZERO\',\'NO_BACKSLASH_ESCAPES\',\'STRICT_TRANS_TABLES\',\'STRICT_ALL_TABLES\',\'NO_ZERO_IN_DATE\',\'NO_ZERO_DATE\',\'INVALID_DATES\',\'ERROR_FOR_DIVISION_BY_ZERO\',\'TRADITIONAL\',\'NO_AUTO_CREATE_USER\',\'HIGH_NOT_PRECEDENCE\',\'NO_ENGINE_SUBSTITUTION\',\'PAD_CHAR_TO_FULL_LENGTH\',\'EMPTY_STRING_IS_NULL\',\'SIMULTANEOUS_ASSIGNMENT\',\'TIME_ROUND_FRACTIONAL\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'comment', 16, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'character_set_client', 17, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'collation_connection', 18, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'db_collation', 19, 'NULL', 'YES', 'char', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(32)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'body_utf8', 20, 'NULL', 'YES', 'longblob', 4294967295, 4294967295, NULL, NULL, NULL, NULL, NULL, 'longblob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proc', 'aggregate', 21, '\'NONE\'', 'NO', 'enum', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'NONE\',\'GROUP\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Db', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'User', 3, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Routine_name', 4, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Routine_type', 5, NULL, 'NO', 'enum', 12, 36, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'enum(\'FUNCTION\',\'PROCEDURE\',\'PACKAGE\',\'PACKAGE BODY\')', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Grantor', 6, '\'\'', 'NO', 'char', 141, 423, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(141)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Proc_priv', 7, '\'\'', 'NO', 'set', 27, 81, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'Execute\',\'Alter Routine\',\'Grant\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'procs_priv', 'Timestamp', 8, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'User', 2, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'Proxied_host', 3, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'Proxied_user', 4, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'With_grant', 5, '0', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'Grantor', 6, '\'\'', 'NO', 'char', 141, 423, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(141)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'proxies_priv', 'Timestamp', 7, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'roles_mapping', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'roles_mapping', 'User', 2, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'roles_mapping', 'Role', 3, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'roles_mapping', 'Admin_option', 4, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'N\',\'Y\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Server_name', 1, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Host', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Db', 3, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Username', 4, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(80)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Password', 5, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Port', 6, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Socket', 7, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Wrapper', 8, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'servers', 'Owner', 9, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'start_time', 1, 'current_timestamp(6)', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'timestamp(6)', '', 'on update current_timestamp(6)', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'user_host', 2, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'query_time', 3, NULL, 'NO', 'time', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'time(6)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'lock_time', 4, NULL, 'NO', 'time', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'time(6)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'rows_sent', 5, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'rows_examined', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'db', 7, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'last_insert_id', 8, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'insert_id', 9, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'server_id', 10, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'sql_text', 11, NULL, 'NO', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'thread_id', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'slow_log', 'rows_affected', 13, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Db', 2, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'User', 3, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Table_name', 4, '\'\'', 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Grantor', 5, '\'\'', 'NO', 'char', 141, 423, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(141)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Timestamp', 6, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Table_priv', 7, '\'\'', 'NO', 'set', 121, 363, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'Select\',\'Insert\',\'Update\',\'Delete\',\'Create\',\'Drop\',\'Grant\',\'References\',\'Index\',\'Alter\',\'Create View\',\'Show view\',\'Trigger\',\'Delete versioning rows\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'tables_priv', 'Column_priv', 8, '\'\'', 'NO', 'set', 31, 93, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'set(\'Select\',\'Insert\',\'Update\',\'References\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'table_stats', 'db_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'table_stats', 'table_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'table_stats', 'cardinality', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(21) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone', 'Time_zone_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone', 'Use_leap_seconds', 2, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'Y\',\'N\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_leap_second', 'Transition_time', 1, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_leap_second', 'Correction', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_name', 'Name', 1, NULL, 'NO', 'char', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_name', 'Time_zone_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition', 'Time_zone_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition', 'Transition_time', 2, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition', 'Transition_type_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition_type', 'Time_zone_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition_type', 'Transition_type_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition_type', 'Offset', 3, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition_type', 'Is_DST', 4, '0', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'time_zone_transition_type', 'Abbreviation', 5, '\'\'', 'NO', 'char', 8, 24, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'char(8)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'transaction_registry', 'transaction_id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'transaction_registry', 'commit_id', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'transaction_registry', 'begin_timestamp', 3, '\'0000-00-00 00:00:00.000000\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'timestamp(6)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'transaction_registry', 'commit_timestamp', 4, '\'0000-00-00 00:00:00.000000\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 6, NULL, NULL, 'timestamp(6)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'transaction_registry', 'isolation_level', 5, NULL, 'NO', 'enum', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'enum(\'READ-UNCOMMITTED\',\'READ-COMMITTED\',\'REPEATABLE-READ\',\'SERIALIZABLE\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Host', 1, '\'\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'User', 2, '\'\'', 'NO', 'char', 80, 240, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(80)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Password', 3, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Select_priv', 4, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Insert_priv', 5, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Update_priv', 6, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Delete_priv', 7, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_priv', 8, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Drop_priv', 9, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Reload_priv', 10, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Shutdown_priv', 11, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Process_priv', 12, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'File_priv', 13, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Grant_priv', 14, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'References_priv', 15, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Index_priv', 16, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Alter_priv', 17, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Show_db_priv', 18, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Super_priv', 19, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_tmp_table_priv', 20, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Lock_tables_priv', 21, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Execute_priv', 22, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Repl_slave_priv', 23, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Repl_client_priv', 24, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_view_priv', 25, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Show_view_priv', 26, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_routine_priv', 27, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Alter_routine_priv', 28, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_user_priv', 29, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Event_priv', 30, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Trigger_priv', 31, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Create_tablespace_priv', 32, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'Delete_history_priv', 33, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'ssl_type', 34, 'NULL', 'YES', 'varchar', 9, 9, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(9)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'ssl_cipher', 35, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'x509_issuer', 36, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'x509_subject', 37, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'max_questions', 38, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'max_updates', 39, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'max_connections', 40, '0', 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'max_user_connections', 41, '0', 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(21)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'plugin', 42, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'authentication_string', 43, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'password_expired', 44, '\'\'', 'NO', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'is_role', 45, 'NULL', 'YES', 'varchar', 1, 1, NULL, NULL, NULL, 'latin1', 'latin1_swedish_ci', 'varchar(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'default_role', 46, '\'\'', 'NO', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'mysql', 'user', 'max_statement_time', 47, '0.000000', 'NO', 'decimal', NULL, NULL, 12, 6, NULL, NULL, NULL, 'decimal(12,6)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'notepad', 'categories', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Publicētā faila kategorijas id', 'NEVER', NULL),
	('def', 'notepad', 'categories', 'name', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', 'Publicētā faila kategorijas nosaukums', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Publicētā faila komentāra id', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'published_file_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Publicētā faila id', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'user_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Lietotāja id', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'text', 4, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Komentāra saturs', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'date', 5, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Komentāra publicēšanas datums', 'NEVER', NULL),
	('def', 'notepad', 'comments', 'time', 6, NULL, 'NO', 'time', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'time', '', '', 'select,insert,update,references', 'Komentāra publicēšanas laiks', 'NEVER', NULL),
	('def', 'notepad', 'favourites', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Lietotāja iemīļotākie publicētie faili id', 'NEVER', NULL),
	('def', 'notepad', 'favourites', 'published_file_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Publicēto faila id', 'NEVER', NULL),
	('def', 'notepad', 'favourites', 'user_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Lietotāja id', 'NEVER', NULL),
	('def', 'notepad', 'files', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Faila id', 'NEVER', NULL),
	('def', 'notepad', 'files', 'name', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Faila nosaukums', 'NEVER', NULL),
	('def', 'notepad', 'files', 'text', 3, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Faila teksts, kuru lietotājs bija sarakstījis', 'NEVER', NULL),
	('def', 'notepad', 'files', 'description', 4, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Faila apraksts, kuru lietotājs var pievienot vēlāk savā failu sarakstā', 'NEVER', NULL),
	('def', 'notepad', 'files', 'image', 5, NULL, 'NO', 'mediumblob', 16777215, 16777215, NULL, NULL, NULL, NULL, NULL, 'mediumblob', '', '', 'select,insert,update,references', 'Faila attēls, kuru lietotājs var pievienot vēlāk savā failu sarakstā', 'NEVER', NULL),
	('def', 'notepad', 'files', 'date', 6, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Datums, kad fails tika izveidots', 'NEVER', NULL),
	('def', 'notepad', 'files', 'time', 7, NULL, 'NO', 'time', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'time', '', '', 'select,insert,update,references', 'Laiks, kad fails tika izveidots', 'NEVER', NULL),
	('def', 'notepad', 'file_likes', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Lietotāja patīk vai nepatīk faila id', 'NEVER', NULL),
	('def', 'notepad', 'file_likes', 'published_file_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Publicētā faila id', 'NEVER', NULL),
	('def', 'notepad', 'file_likes', 'user_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Lietotāja id', 'NEVER', NULL),
	('def', 'notepad', 'file_likes', 'is_like', 4, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1) unsigned', '', '', 'select,insert,update,references', '1=patīk, 0=nepatīk fails', 'NEVER', NULL),
	('def', 'notepad', 'file_users', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Sasaistīto lietotāju un failu id', 'NEVER', NULL),
	('def', 'notepad', 'file_users', 'files_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Failu id', 'NEVER', NULL),
	('def', 'notepad', 'file_users', 'users_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Lietotāju id', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Publicētā faila id', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'file_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Failu id', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'user_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Lietotāju id', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'title', 4, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', 'Publicētā faila nosaukums', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'description', 5, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Publicētā faila apraksts', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'text', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', 'Lietotāja izvēlētā faila teksts', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'thumbnail', 7, NULL, 'NO', 'mediumblob', 16777215, 16777215, NULL, NULL, NULL, NULL, NULL, 'mediumblob', '', '', 'select,insert,update,references', 'Publicētā faila bilde', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'date', 8, NULL, 'NO', 'date', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'date', '', '', 'select,insert,update,references', 'Publicētā faila publicēšanās datums', 'NEVER', NULL),
	('def', 'notepad', 'published_files', 'time', 9, NULL, 'NO', 'time', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'time', '', '', 'select,insert,update,references', 'Publicētā faila publicēšanās laiks', 'NEVER', NULL),
	('def', 'notepad', 'published_file_categories', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Publicētā faila sasaistes ar categorijām id', 'NEVER', NULL),
	('def', 'notepad', 'published_file_categories', 'published_file_id', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Publicētā faila id', 'NEVER', NULL),
	('def', 'notepad', 'published_file_categories', 'category_id', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'MUL', '', 'select,insert,update,references', 'Kategoriju id', 'NEVER', NULL),
	('def', 'notepad', 'users', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', 'Lietotāja id', 'NEVER', NULL),
	('def', 'notepad', 'users', 'username', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', 'Lietotāju vārds', 'NEVER', NULL),
	('def', 'notepad', 'users', 'email', 3, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', 'Lietotāju e-pasts', 'NEVER', NULL),
	('def', 'notepad', 'users', 'password', 4, NULL, 'NO', 'varchar', 120, 480, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(120)', '', '', 'select,insert,update,references', 'Lietotāju parole', 'NEVER', NULL),
	('def', 'performance_schema', 'cond_instances', 'NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Client user name for the connection, or NULL if an internal thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'cond_instances', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the instrumented condition.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'SPINS', 9, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Number of spin rounds for a mutex, or NULL if spin rounds are not used, or spinning is not instrumented.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'OBJECT_SCHEMA', 10, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the schema that contains the table for table I/O objects, otherwise NULL for file I/O and synchronization objects.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'OBJECT_NAME', 11, 'NULL', 'YES', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', 'File name for file I/O objects, table name for table I/O objects, the socket\'s IP:PORT value for a socket object or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'INDEX_NAME', 12, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the index, PRIMARY for the primary key, or NULL for no index used.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'OBJECT_TYPE', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'FILE for a file object, TABLE or TEMPORARY TABLE for a table object, or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'OBJECT_INSTANCE_BEGIN', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'NESTING_EVENT_ID', 15, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'NESTING_EVENT_TYPE', 16, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'OPERATION', 17, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Operation type, for example read, write or lock', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'NUMBER_OF_BYTES', 18, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of bytes that the operation read or wrote, or NULL for table I/O waits.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_current', 'FLAGS', 19, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Reserved for use in the future.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'SPINS', 9, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Number of spin rounds for a mutex, or NULL if spin rounds are not used, or spinning is not instrumented.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'OBJECT_SCHEMA', 10, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the schema that contains the table for table I/O objects, otherwise NULL for file I/O and synchronization objects.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'OBJECT_NAME', 11, 'NULL', 'YES', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', 'File name for file I/O objects, table name for table I/O objects, the socket\'s IP:PORT value for a socket object or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'INDEX_NAME', 12, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the index, PRIMARY for the primary key, or NULL for no index used.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'OBJECT_TYPE', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'FILE for a file object, TABLE or TEMPORARY TABLE for a table object, or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'OBJECT_INSTANCE_BEGIN', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'NESTING_EVENT_ID', 15, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'NESTING_EVENT_TYPE', 16, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'OPERATION', 17, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Operation type, for example read, write or lock', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'NUMBER_OF_BYTES', 18, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of bytes that the operation read or wrote, or NULL for table I/O waits.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history', 'FLAGS', 19, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Reserved for use in the future.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'SPINS', 9, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Number of spin rounds for a mutex, or NULL if spin rounds are not used, or spinning is not instrumented.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'OBJECT_SCHEMA', 10, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the schema that contains the table for table I/O objects, otherwise NULL for file I/O and synchronization objects.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'OBJECT_NAME', 11, 'NULL', 'YES', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', 'File name for file I/O objects, table name for table I/O objects, the socket\'s IP:PORT value for a socket object or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'INDEX_NAME', 12, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the index, PRIMARY for the primary key, or NULL for no index used.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'OBJECT_TYPE', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'FILE for a file object, TABLE or TEMPORARY TABLE for a table object, or NULL for a synchronization object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'OBJECT_INSTANCE_BEGIN', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'NESTING_EVENT_ID', 15, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'NESTING_EVENT_TYPE', 16, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'OPERATION', 17, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Operation type, for example read, write or lock', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'NUMBER_OF_BYTES', 18, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of bytes that the operation read or wrote, or NULL for table I/O waits.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_history_long', 'FLAGS', 19, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Reserved for use in the future.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'HOST', 1, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER and HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_host_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with OBJECT_INSTANCE_BEGIN for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'If an instrument creates multiple instances, each instance has a unique OBJECT_INSTANCE_BEGIN value to allow for grouping by instance.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_instance', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_NAME uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with THREAD_ID for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_thread_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_user_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with HOST and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'HOST', 2, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with USER and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'EVENT_NAME', 3, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER and HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_by_account_by_event_name', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'COUNT_STAR', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'SUM_TIMER_WAIT', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'MIN_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'AVG_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_waits_summary_global_by_event_name', 'MAX_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_instances', 'FILE_NAME', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', 'File name.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_instances', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Instrument name associated with the file.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_instances', 'OPEN_COUNT', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Open handles on the file. A value of greater than zero means that the file is currently open.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'COUNT_STAR', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_TIMER_WAIT', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MIN_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'AVG_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MAX_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'COUNT_READ', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, including FGETS, FGETC, FREAD, and READ.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_TIMER_READ', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MIN_TIMER_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'AVG_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MAX_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_NUMBER_OF_BYTES_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Bytes read by read operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'COUNT_WRITE', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, including FPUTS, FPUTC, FPRINTF, VFPRINTF, FWRITE, and PWRITE.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_TIMER_WRITE', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MIN_TIMER_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'AVG_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MAX_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_NUMBER_OF_BYTES_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Bytes written by write operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'COUNT_MISC', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all miscellaneous operations not counted above, including CREATE, DELETE, OPEN, CLOSE, STREAM_OPEN, STREAM_CLOSE, SEEK, TELL, FLUSH, STAT, FSTAT, CHSIZE, RENAME, and SYNC.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'SUM_TIMER_MISC', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MIN_TIMER_MISC', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'AVG_TIMER_MISC', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_event_name', 'MAX_TIMER_MISC', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'FILE_NAME', 1, NULL, 'NO', 'varchar', 512, 1536, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(512)', '', '', 'select,insert,update,references', 'File name.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'OBJECT_INSTANCE_BEGIN', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory. Together with FILE_NAME and EVENT_NAME uniquely identifies a row.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'COUNT_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, including FGETS, FGETC, FREAD, and READ.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MIN_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'AVG_TIMER_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MAX_TIMER_READ', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_NUMBER_OF_BYTES_READ', 14, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Bytes read by read operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'COUNT_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, including FPUTS, FPUTC, FPRINTF, VFPRINTF, FWRITE, and PWRITE.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MIN_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'AVG_TIMER_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MAX_TIMER_WRITE', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_NUMBER_OF_BYTES_WRITE', 20, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Bytes written by write operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'COUNT_MISC', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all miscellaneous operations not counted above, including CREATE, DELETE, OPEN, CLOSE, STREAM_OPEN, STREAM_CLOSE, SEEK, TELL, FLUSH, STAT, FSTAT, CHSIZE, RENAME, and SYNC.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'SUM_TIMER_MISC', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MIN_TIMER_MISC', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'AVG_TIMER_MISC', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'file_summary_by_instance', 'MAX_TIMER_MISC', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'IP', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Client IP address.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'HOST', 2, 'NULL', 'YES', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', 'IP\'s resolved DNS host name, or NULL if unknown.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'HOST_VALIDATED', 3, NULL, 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'YES if the IP-to-host DNS lookup was successful, and the HOST column can be used to avoid DNS calls, or NO if unsuccessful, in which case DNS lookup is performed for each connect until either successful or a permanent error.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'SUM_CONNECT_ERRORS', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of connection errors. Counts only protocol handshake errors for hosts that passed validation. These errors count towards max_connect_errors.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_HOST_BLOCKED_ERRORS', 5, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of blocked connections because SUM_CONNECT_ERRORS exceeded the max_connect_errors system variable.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_NAMEINFO_TRANSIENT_ERRORS', 6, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of transient errors during IP-to-host DNS lookups.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_NAMEINFO_PERMANENT_ERRORS', 7, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of permanent errors during IP-to-host DNS lookups.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_FORMAT_ERRORS', 8, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of host name format errors, for example a numeric host column.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_ADDRINFO_TRANSIENT_ERRORS', 9, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of transient errors during host-to-IP reverse DNS lookups.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_ADDRINFO_PERMANENT_ERRORS', 10, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of permanent errors during host-to-IP reverse DNS lookups.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_FCRDNS_ERRORS', 11, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of forward-confirmed reverse DNS errors, which occur when IP-to-host DNS lookup does not match the originating IP address.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_HOST_ACL_ERRORS', 12, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors occurring because no user from the host is permitted to log in. These attempts return error code 1130 ER_HOST_NOT_PRIVILEGED and do not proceed to username and password authentication.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_NO_AUTH_PLUGIN_ERRORS', 13, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to requesting an authentication plugin that was not available. This can be due to the plugin never having been loaded, or the load attempt failing.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_AUTH_PLUGIN_ERRORS', 14, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors reported by an authentication plugin. Plugins can increment COUNT_AUTHENTICATION_ERRORS or COUNT_HANDSHAKE_ERRORS instead, but, if specified or the error is unknown, this column is incremented.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_HANDSHAKE_ERRORS', 15, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors detected at the wire protocol level.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_PROXY_USER_ERRORS', 16, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors detected when a proxy user is proxied to a user that does not exist.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_PROXY_USER_ACL_ERRORS', 17, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors detected when a proxy user is proxied to a user that exists, but the proxy user doesn\'t have the PROXY privilege.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_AUTHENTICATION_ERRORS', 18, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors where authentication failed.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_SSL_ERRORS', 19, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to TLS problems.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_MAX_USER_CONNECTIONS_ERRORS', 20, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to the per-user quota being exceeded.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_MAX_USER_CONNECTIONS_PER_HOUR_ERRORS', 21, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to the per-hour quota being exceeded.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_DEFAULT_DATABASE_ERRORS', 22, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to the user not having permission to access the specified default database, or it not existing.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_INIT_CONNECT_ERRORS', 23, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of errors due to statements in the init_connect system variable.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_LOCAL_ERRORS', 24, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of local server errors, such as out-of-memory errors, unrelated to network, authentication, or authorization.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'COUNT_UNKNOWN_ERRORS', 25, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of unknown errors that cannot be allocated to another column.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'FIRST_SEEN', 26, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Timestamp of the first connection attempt by the IP.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'LAST_SEEN', 27, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Timestamp of the most recent connection attempt by the IP.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'FIRST_ERROR_SEEN', 28, '\'0000-00-00 00:00:00\'', 'YES', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Timestamp of the first error seen from the IP.', 'NEVER', NULL),
	('def', 'performance_schema', 'host_cache', 'LAST_ERROR_SEEN', 29, '\'0000-00-00 00:00:00\'', 'YES', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Timestamp of the most recent error seen from the IP.', 'NEVER', NULL),
	('def', 'performance_schema', 'mutex_instances', 'NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Instrument name associated with the mutex.', 'NEVER', NULL),
	('def', 'performance_schema', 'mutex_instances', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Memory address of the instrumented mutex.', 'NEVER', NULL),
	('def', 'performance_schema', 'mutex_instances', 'LOCKED_BY_THREAD_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'The THREAD_ID of the locking thread if a thread has a mutex locked, otherwise NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'OBJECT_TYPE', 1, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Groups records together with OBJECT_SCHEMA and OBJECT_NAME.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'OBJECT_SCHEMA', 2, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Groups records together with OBJECT_TYPE and OBJECT_NAME.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'OBJECT_NAME', 3, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Groups records together with OBJECT_SCHEMA and OBJECT_TYPE.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'objects_summary_global_by_type', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'performance_timers', 'TIMER_NAME', 1, NULL, 'NO', 'enum', 11, 33, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'CYCLE\',\'NANOSECOND\',\'MICROSECOND\',\'MILLISECOND\',\'TICK\')', '', '', 'select,insert,update,references', 'Time name, used in the setup_timers table.', 'NEVER', NULL),
	('def', 'performance_schema', 'performance_timers', 'TIMER_FREQUENCY', 2, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of timer units per second. Dependent on the processor speed.', 'NEVER', NULL),
	('def', 'performance_schema', 'performance_timers', 'TIMER_RESOLUTION', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Number of timer units by which timed values increase each time.', 'NEVER', NULL),
	('def', 'performance_schema', 'performance_timers', 'TIMER_OVERHEAD', 4, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Minimum timer overhead, determined during initialization by calling the timer 20 times and selecting the smallest value. Total overhead will be at least double this, as the timer is called at the beginning and end of each timed event.', 'NEVER', NULL),
	('def', 'performance_schema', 'rwlock_instances', 'NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Instrument name associated with the read write lock', 'NEVER', NULL),
	('def', 'performance_schema', 'rwlock_instances', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the instrumented lock', 'NEVER', NULL),
	('def', 'performance_schema', 'rwlock_instances', 'WRITE_LOCKED_BY_THREAD_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'THREAD_ID of the locking thread if locked in write (exclusive) mode, otherwise NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'rwlock_instances', 'READ_LOCKED_BY_COUNT', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', '', '', 'select,insert,update,references', 'Count of current read locks held', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_actors', 'HOST', 1, '\'%\'', 'NO', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host name, either a literal, or the % wildcard representing any host.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_actors', 'USER', 2, '\'%\'', 'NO', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User name, either a literal or the % wildcard representing any name.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_actors', 'ROLE', 3, '\'%\'', 'NO', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'Unused', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_consumers', 'NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Consumer name', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_consumers', 'ENABLED', 2, NULL, 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'YES or NO for whether or not the consumer is enabled. You can modify this column to ensure that event information is added, or is not added.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_instruments', 'NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Instrument name', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_instruments', 'ENABLED', 2, NULL, 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'Whether or not the instrument is enabled. It can be disabled, and the instrument will produce no events.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_instruments', 'TIMED', 3, NULL, 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'Whether or not the instrument is timed. It can be set, but if disabled, events produced by the instrument will have NULL values for the corresponding TIMER_START, TIMER_END, and TIMER_WAIT values.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_objects', 'OBJECT_TYPE', 1, '\'TABLE\'', 'NO', 'enum', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'TABLE\')', '', '', 'select,insert,update,references', 'Type of object to instrument. Currently, only TABLE, for base table.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_objects', 'OBJECT_SCHEMA', 2, '\'%\'', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Schema containing the object, either the literal or % for any schema.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_objects', 'OBJECT_NAME', 3, '\'%\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name of the instrumented object, either the literal or % for any object.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_objects', 'ENABLED', 4, '\'YES\'', 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'Whether the object\'s events are instrumented or not. Can be disabled, in which case monitoring is not enabled for those objects.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_objects', 'TIMED', 5, '\'YES\'', 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'Whether the object\'s events are timed or not. Can be modified.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_timers', 'NAME', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Type of instrument the timer is used for.', 'NEVER', NULL),
	('def', 'performance_schema', 'setup_timers', 'TIMER_NAME', 2, NULL, 'NO', 'enum', 11, 33, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'CYCLE\',\'NANOSECOND\',\'MICROSECOND\',\'MILLISECOND\',\'TICK\')', '', '', 'select,insert,update,references', 'Timer applying to the instrument type. Can be modified.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'OBJECT_TYPE', 1, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'TABLE in the case of all indexes.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'OBJECT_SCHEMA', 2, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Schema name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'OBJECT_NAME', 3, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Table name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'INDEX_NAME', 4, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Index name, or PRIMARY for the primary index, NULL for no index (inserts are counted in this case).', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_STAR', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events and the sum of the x_READ and x_WRITE columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_WAIT', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, and the sum of the equivalent x_FETCH columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_READ', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_READ', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, and the sum of the equivalent x_INSERT, x_UPDATE and x_DELETE columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_WRITE', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_FETCH', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all fetch operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_FETCH', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_FETCH', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_FETCH', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_FETCH', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_INSERT', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all insert operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_INSERT', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_INSERT', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_INSERT', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_INSERT', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_UPDATE', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all update operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_UPDATE', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_UPDATE', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_UPDATE', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_UPDATE', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'COUNT_DELETE', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all delete operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'SUM_TIMER_DELETE', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MIN_TIMER_DELETE', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'AVG_TIMER_DELETE', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_index_usage', 'MAX_TIMER_DELETE', 39, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'OBJECT_TYPE', 1, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Since this table records waits by table, always set to TABLE.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'OBJECT_SCHEMA', 2, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Schema name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'OBJECT_NAME', 3, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Table name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events and the sum of the x_READ and x_WRITE columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, and the sum of the equivalent x_FETCH columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_READ', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_WRITE', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, and the sum of the equivalent x_INSERT, x_UPDATE and x_DELETE columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_FETCH', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all fetch operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_FETCH', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_FETCH', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_FETCH', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_FETCH', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all fetch operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_INSERT', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all insert operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_INSERT', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_INSERT', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_INSERT', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_INSERT', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all insert operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_UPDATE', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all update operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_UPDATE', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_UPDATE', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_UPDATE', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_UPDATE', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all update operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'COUNT_DELETE', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all delete operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'SUM_TIMER_DELETE', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MIN_TIMER_DELETE', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'AVG_TIMER_DELETE', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_io_waits_summary_by_table', 'MAX_TIMER_DELETE', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all delete operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'OBJECT_TYPE', 1, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Since this table records waits by table, always set to TABLE.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'OBJECT_SCHEMA', 2, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Schema name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'OBJECT_NAME', 3, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Table name.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events and the sum of the x_READ and x_WRITE columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, and the sum of the equivalent x_READ_NORMAL, x_READ_WITH_SHARED_LOCKS, x_READ_HIGH_PRIORITY and x_READ_NO_INSERT columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, and the sum of the equivalent x_WRITE_ALLOW_WRITE, x_WRITE_CONCURRENT_INSERT, x_WRITE_DELAYED, x_WRITE_LOW_PRIORITY and x_WRITE_NORMAL columns.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ_NORMAL', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal read normal locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ_NORMAL', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal read normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ_NORMAL', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal read normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ_NORMAL', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal read normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ_NORMAL', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal read normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ_WITH_SHARED_LOCKS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal read with shared locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ_WITH_SHARED_LOCKS', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal read with shared locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ_WITH_SHARED_LOCKS', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal read with shared locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ_WITH_SHARED_LOCKS', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal read with shared locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ_WITH_SHARED_LOCKS', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal read with shared locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ_HIGH_PRIORITY', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal read high priority locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ_HIGH_PRIORITY', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal read high priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ_HIGH_PRIORITY', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal read high priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ_HIGH_PRIORITY', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal read high priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ_HIGH_PRIORITY', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal read high priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ_NO_INSERT', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal read no insert locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ_NO_INSERT', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal read no insert locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ_NO_INSERT', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal read no insert locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ_NO_INSERT', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal read no insert locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ_NO_INSERT', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal read no insert locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_READ_EXTERNAL', 39, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all external read locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_READ_EXTERNAL', 40, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all external read locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_READ_EXTERNAL', 41, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all external read locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_READ_EXTERNAL', 42, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all external read locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_READ_EXTERNAL', 43, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all external read locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_ALLOW_WRITE', 44, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal read normal locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_ALLOW_WRITE', 45, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal write allow write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_ALLOW_WRITE', 46, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal write allow write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_ALLOW_WRITE', 47, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal write allow write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_ALLOW_WRITE', 48, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal write allow write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_CONCURRENT_INSERT', 49, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal concurrent insert write locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_CONCURRENT_INSERT', 50, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal concurrent insert write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_CONCURRENT_INSERT', 51, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal concurrent insert write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_CONCURRENT_INSERT', 52, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal concurrent insert write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_CONCURRENT_INSERT', 53, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal concurrent insert write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_DELAYED', 54, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal write delayed locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_DELAYED', 55, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal write delayed locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_DELAYED', 56, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal write delayed locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_DELAYED', 57, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal write delayed locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_DELAYED', 58, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal write delayed locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_LOW_PRIORITY', 59, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal write low priority locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_LOW_PRIORITY', 60, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal write low priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_LOW_PRIORITY', 61, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal write low priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_LOW_PRIORITY', 62, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal write low priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_LOW_PRIORITY', 63, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal write low priority locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_NORMAL', 64, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all internal write normal locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_NORMAL', 65, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all internal write normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_NORMAL', 66, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all internal write normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_NORMAL', 67, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all internal write normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_NORMAL', 68, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all internal write normal locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'COUNT_WRITE_EXTERNAL', 69, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all external write locks.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'SUM_TIMER_WRITE_EXTERNAL', 70, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all external write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MIN_TIMER_WRITE_EXTERNAL', 71, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all external write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'AVG_TIMER_WRITE_EXTERNAL', 72, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all external write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'table_lock_waits_summary_by_table', 'MAX_TIMER_WRITE_EXTERNAL', 73, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all external write locks that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'A unique thread identifier.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Name associated with the server\'s thread instrumentation code, for example thread/sql/main for the server\'s main() function, and thread/sql/one_connection for a user connection.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'TYPE', 3, NULL, 'NO', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', 'FOREGROUND or BACKGROUND, depending on the thread type. User connection threads are FOREGROUND, internal server threads are BACKGROUND.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_ID', 4, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'The PROCESSLIST.ID value for threads displayed in the INFORMATION_SCHEMA.PROCESSLIST table, or 0 for background threads. Also corresponds with the CONNECTION_ID() return value for the thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_USER', 5, 'NULL', 'YES', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Foreground thread user, or NULL for a background thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_HOST', 6, 'NULL', 'YES', 'varchar', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(60)', '', '', 'select,insert,update,references', 'Foreground thread host, or NULL for a background thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_DB', 7, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Thread\'s default database, or NULL if none exists.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_COMMAND', 8, 'NULL', 'YES', 'varchar', 16, 48, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(16)', '', '', 'select,insert,update,references', 'Type of command executed by the thread. These correspond to the the COM_xxx client/server protocol commands, and the Com_xxx status variables. See Thread Command Values.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_TIME', 9, 'NULL', 'YES', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Time in seconds the thread has been in its current state.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_STATE', 10, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Action, event or state indicating what the thread is doing.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PROCESSLIST_INFO', 11, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'Statement being executed by the thread, or NULL if a statement is not being executed. If a statement results in calling other statements, such as for a stored procedure, the innermost statement from the stored procedure is shown here.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'PARENT_THREAD_ID', 12, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'THREAD_ID of the parent thread, if any. Subthreads can for example be spawned as a result of INSERT DELAYED statements.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'ROLE', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Unused.', 'NEVER', NULL),
	('def', 'performance_schema', 'threads', 'INSTRUMENTED', 14, NULL, 'NO', 'enum', 3, 9, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'YES\',\'NO\')', '', '', 'select,insert,update,references', 'YES or NO for Whether the thread is instrumented or not. For foreground threads, the initial value is determined by whether there\'s a user/host match in the setup_actors table. Subthreads are again matched, while for background threads, this will be set to YES by default. To monitor events that the thread executes, INSTRUMENTED must be YES and the thread_instrumentation consumer in the setup_consumers table must also be YES.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'NESTING_EVENT_ID', 9, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_current', 'NESTING_EVENT_TYPE', 10, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'NESTING_EVENT_ID', 9, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history', 'NESTING_EVENT_TYPE', 10, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'NESTING_EVENT_ID', 9, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'EVENT_ID of event within which this event nests.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_history_long', 'NESTING_EVENT_TYPE', 10, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Nesting event type. Either statement, stage or wait.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_NAME uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with THREAD_ID for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events, which includes all timed and untimed events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_thread_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with HOST and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'HOST', 2, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with USER and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'EVENT_NAME', 3, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER and HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events, which includes all timed and untimed events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_account_by_event_name', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events, which includes all timed and untimed events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_user_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'HOST', 1, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events, which includes all timed and untimed events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_by_host_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'COUNT_STAR', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events, which includes all timed and untimed events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'SUM_TIMER_WAIT', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'MIN_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'AVG_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_stages_summary_global_by_event_name', 'MAX_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the timed summarized events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'LOCK_TIME', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Time in picoseconds spent waiting for locks. The time is calculated in microseconds but stored in picoseconds for compatibility with other timings.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SQL_TEXT', 10, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'The SQL statement, or NULL if the command is not associated with an SQL statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'DIGEST', 11, 'NULL', 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Statement digest.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'DIGEST_TEXT', 12, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'Statement digest text.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'CURRENT_SCHEMA', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Statement\'s default database for the statement, or NULL if there was none.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'OBJECT_TYPE', 14, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'OBJECT_SCHEMA', 15, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'OBJECT_NAME', 16, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'OBJECT_INSTANCE_BEGIN', 17, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the statement object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'MYSQL_ERRNO', 18, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Error code. See MariaDB Error Codes for a full list.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'RETURNED_SQLSTATE', 19, 'NULL', 'YES', 'varchar', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(5)', '', '', 'select,insert,update,references', 'The SQLSTATE value.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'MESSAGE_TEXT', 20, 'NULL', 'YES', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Statement error message. See MariaDB Error Codes.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'ERRORS', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if SQLSTATE signifies completion (starting with 00) or warning (01), otherwise 1.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'WARNINGS', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of warnings from the diagnostics area.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'ROWS_AFFECTED', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows affected the statement affected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'ROWS_SENT', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows returned.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'ROWS_EXAMINED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows read during the statement\'s execution.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'CREATED_TMP_DISK_TABLES', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of on-disk temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'CREATED_TMP_TABLES', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SELECT_FULL_JOIN', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which did not use an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SELECT_FULL_RANGE_JOIN', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range search of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SELECT_RANGE', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SELECT_RANGE_CHECK', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins without keys performed by the statement that check for key usage after each row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SELECT_SCAN', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a full scan of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SORT_MERGE_PASSES', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of merge passes by the sort algorithm performed by the statement. If too high, you may need to increase the sort_buffer_size.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SORT_RANGE', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a range.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SORT_ROWS', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows sorted by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'SORT_SCAN', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a full table scan.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'NO_INDEX_USED', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if the statement performed a table scan with an index, 1 if without an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'NO_GOOD_INDEX_USED', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if a good index was found for the statement, 1 if no good index was found. See the Range checked for each record description in the EXPLAIN article.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'NESTING_EVENT_ID', 39, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_current', 'NESTING_EVENT_TYPE', 40, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'LOCK_TIME', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Time in picoseconds spent waiting for locks. The time is calculated in microseconds but stored in picoseconds for compatibility with other timings.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SQL_TEXT', 10, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'The SQL statement, or NULL if the command is not associated with an SQL statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'DIGEST', 11, 'NULL', 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Statement digest.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'DIGEST_TEXT', 12, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'Statement digest text.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'CURRENT_SCHEMA', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Statement\'s default database for the statement, or NULL if there was none.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'OBJECT_TYPE', 14, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'OBJECT_SCHEMA', 15, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'OBJECT_NAME', 16, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'OBJECT_INSTANCE_BEGIN', 17, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the statement object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'MYSQL_ERRNO', 18, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Error code. See MariaDB Error Codes for a full list.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'RETURNED_SQLSTATE', 19, 'NULL', 'YES', 'varchar', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(5)', '', '', 'select,insert,update,references', 'The SQLSTATE value.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'MESSAGE_TEXT', 20, 'NULL', 'YES', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Statement error message. See MariaDB Error Codes.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'ERRORS', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if SQLSTATE signifies completion (starting with 00) or warning (01), otherwise 1.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'WARNINGS', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of warnings from the diagnostics area.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'ROWS_AFFECTED', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows affected the statement affected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'ROWS_SENT', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows returned.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'ROWS_EXAMINED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows read during the statement\'s execution.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'CREATED_TMP_DISK_TABLES', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of on-disk temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'CREATED_TMP_TABLES', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SELECT_FULL_JOIN', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which did not use an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SELECT_FULL_RANGE_JOIN', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range search of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SELECT_RANGE', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SELECT_RANGE_CHECK', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins without keys performed by the statement that check for key usage after each row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SELECT_SCAN', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a full scan of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SORT_MERGE_PASSES', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of merge passes by the sort algorithm performed by the statement. If too high, you may need to increase the sort_buffer_size.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SORT_RANGE', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a range.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SORT_ROWS', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows sorted by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'SORT_SCAN', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a full table scan.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'NO_INDEX_USED', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if the statement performed a table scan with an index, 1 if without an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'NO_GOOD_INDEX_USED', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if a good index was found for the statement, 1 if no good index was found. See the Range checked for each record description in the EXPLAIN article.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'NESTING_EVENT_ID', 39, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history', 'NESTING_EVENT_TYPE', 40, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'EVENT_ID', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread\'s current event number at the start of the event. Together with THREAD_ID uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'END_EVENT_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'NULL when the event starts, set to the thread\'s current event number at the end of the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'EVENT_NAME', 4, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event instrument name and a NAME from the setup_instruments table', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SOURCE', 5, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Name and line number of the source file containing the instrumented code that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'TIMER_START', 6, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing started or NULL if timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'TIMER_END', 7, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds when the event timing ended, or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'TIMER_WAIT', 8, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Value in picoseconds of the event\'s duration or NULL if the event has not ended or timing is not collected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'LOCK_TIME', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Time in picoseconds spent waiting for locks. The time is calculated in microseconds but stored in picoseconds for compatibility with other timings.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SQL_TEXT', 10, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'The SQL statement, or NULL if the command is not associated with an SQL statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'DIGEST', 11, 'NULL', 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Statement digest.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'DIGEST_TEXT', 12, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'Statement digest text.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'CURRENT_SCHEMA', 13, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Statement\'s default database for the statement, or NULL if there was none.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'OBJECT_TYPE', 14, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'OBJECT_SCHEMA', 15, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'OBJECT_NAME', 16, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Reserved, currently NULL', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'OBJECT_INSTANCE_BEGIN', 17, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory of the statement object.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'MYSQL_ERRNO', 18, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Error code. See MariaDB Error Codes for a full list.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'RETURNED_SQLSTATE', 19, 'NULL', 'YES', 'varchar', 5, 15, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(5)', '', '', 'select,insert,update,references', 'The SQLSTATE value.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'MESSAGE_TEXT', 20, 'NULL', 'YES', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Statement error message. See MariaDB Error Codes.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'ERRORS', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if SQLSTATE signifies completion (starting with 00) or warning (01), otherwise 1.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'WARNINGS', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of warnings from the diagnostics area.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'ROWS_AFFECTED', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows affected the statement affected.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'ROWS_SENT', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows returned.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'ROWS_EXAMINED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows read during the statement\'s execution.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'CREATED_TMP_DISK_TABLES', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of on-disk temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'CREATED_TMP_TABLES', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of temp tables created by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SELECT_FULL_JOIN', 28, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which did not use an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SELECT_FULL_RANGE_JOIN', 29, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range search of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SELECT_RANGE', 30, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a range of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SELECT_RANGE_CHECK', 31, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins without keys performed by the statement that check for key usage after each row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SELECT_SCAN', 32, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of joins performed by the statement which used a full scan of the first table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SORT_MERGE_PASSES', 33, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of merge passes by the sort algorithm performed by the statement. If too high, you may need to increase the sort_buffer_size.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SORT_RANGE', 34, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a range.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SORT_ROWS', 35, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of rows sorted by the statement.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'SORT_SCAN', 36, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of sorts performed by the statement which used a full table scan.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'NO_INDEX_USED', 37, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if the statement performed a table scan with an index, 1 if without an index.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'NO_GOOD_INDEX_USED', 38, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', '0 if a good index was found for the statement, 1 if no good index was found. See the Range checked for each record description in the EXPLAIN article.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'NESTING_EVENT_ID', 39, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_history_long', 'NESTING_EVENT_TYPE', 40, 'NULL', 'YES', 'enum', 9, 27, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'STATEMENT\',\'STAGE\',\'WAIT\')', '', '', 'select,insert,update,references', 'Reserved, currently NULL.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'THREAD_ID', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread associated with the event. Together with EVENT_NAME uniquely identifies the row.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with THREAD_ID for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_LOCK_TIME', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_ERRORS', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_WARNINGS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_ROWS_AFFECTED', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_ROWS_SENT', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_ROWS_EXAMINED', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_CREATED_TMP_DISK_TABLES', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_CREATED_TMP_TABLES', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SELECT_FULL_JOIN', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SELECT_FULL_RANGE_JOIN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SELECT_RANGE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SELECT_RANGE_CHECK', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SELECT_SCAN', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SORT_MERGE_PASSES', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SORT_RANGE', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SORT_ROWS', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_SORT_SCAN', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_NO_INDEX_USED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_thread_by_event_name', 'SUM_NO_GOOD_INDEX_USED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with HOST and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'HOST', 2, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with USER and EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'EVENT_NAME', 3, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER and HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_LOCK_TIME', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_ERRORS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_WARNINGS', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_ROWS_AFFECTED', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_ROWS_SENT', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_ROWS_EXAMINED', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_CREATED_TMP_DISK_TABLES', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_CREATED_TMP_TABLES', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SELECT_FULL_JOIN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SELECT_FULL_RANGE_JOIN', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SELECT_RANGE', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SELECT_RANGE_CHECK', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SELECT_SCAN', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SORT_MERGE_PASSES', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SORT_RANGE', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SORT_ROWS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_SORT_SCAN', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_NO_INDEX_USED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_account_by_event_name', 'SUM_NO_GOOD_INDEX_USED', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'User. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with USER for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_LOCK_TIME', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_ERRORS', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_WARNINGS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_ROWS_AFFECTED', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_ROWS_SENT', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_ROWS_EXAMINED', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_CREATED_TMP_DISK_TABLES', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_CREATED_TMP_TABLES', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SELECT_FULL_JOIN', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SELECT_FULL_RANGE_JOIN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SELECT_RANGE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SELECT_RANGE_CHECK', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SELECT_SCAN', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SORT_MERGE_PASSES', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SORT_RANGE', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SORT_ROWS', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_SORT_SCAN', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_NO_INDEX_USED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_user_by_event_name', 'SUM_NO_GOOD_INDEX_USED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'HOST', 1, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host. Used together with EVENT_NAME for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'EVENT_NAME', 2, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name. Used together with HOST for grouping events.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_LOCK_TIME', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_currentd table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_ERRORS', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_WARNINGS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_ROWS_AFFECTED', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_ROWS_SENT', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_ROWS_EXAMINED', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_CREATED_TMP_DISK_TABLES', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_CREATED_TMP_TABLES', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SELECT_FULL_JOIN', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SELECT_FULL_RANGE_JOIN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOINW column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SELECT_RANGE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SELECT_RANGE_CHECK', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SELECT_SCAN', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SORT_MERGE_PASSES', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SORT_RANGE', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SORT_ROWS', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_SORT_SCAN', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_NO_INDEX_USED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_host_by_event_name', 'SUM_NO_GOOD_INDEX_USED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Event name.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'COUNT_STAR', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_TIMER_WAIT', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'MIN_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'AVG_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'MAX_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_LOCK_TIME', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_ERRORS', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_WARNINGS', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_ROWS_AFFECTED', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_ROWS_SENT', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_ROWS_EXAMINED', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_CREATED_TMP_DISK_TABLES', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_CREATED_TMP_TABLES', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SELECT_FULL_JOIN', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SELECT_FULL_RANGE_JOIN', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SELECT_RANGE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SELECT_RANGE_CHECK', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SELECT_SCAN', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SORT_MERGE_PASSES', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SORT_RANGE', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SORT_ROWS', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_SORT_SCAN', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_NO_INDEX_USED', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_global_by_event_name', 'SUM_NO_GOOD_INDEX_USED', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SCHEMA_NAME', 1, 'NULL', 'YES', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Database name. Records are summarised together with DIGEST.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'DIGEST', 2, 'NULL', 'YES', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(32)', '', '', 'select,insert,update,references', 'Performance Schema digest. Records are summarised together with SCHEMA NAME.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'DIGEST_TEXT', 3, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'longtext', '', '', 'select,insert,update,references', 'The unhashed form of the digest.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'COUNT_STAR', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'MIN_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'AVG_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'MAX_TIMER_WAIT', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_LOCK_TIME', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the LOCK_TIME column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_ERRORS', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ERRORS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_WARNINGS', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the WARNINGS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_ROWS_AFFECTED', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_AFFECTED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_ROWS_SENT', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_SENT column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_ROWS_EXAMINED', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the ROWS_EXAMINED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_CREATED_TMP_DISK_TABLES', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_DISK_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_CREATED_TMP_TABLES', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the CREATED_TMP_TABLES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SELECT_FULL_JOIN', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SELECT_FULL_RANGE_JOIN', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_FULL_RANGE_JOIN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SELECT_RANGE', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SELECT_RANGE_CHECK', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_RANGE_CHECK column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SELECT_SCAN', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SELECT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SORT_MERGE_PASSES', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_MERGE_PASSES column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SORT_RANGE', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_RANGE column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SORT_ROWS', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_ROWS column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_SORT_SCAN', 25, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the SORT_SCAN column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_NO_INDEX_USED', 26, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'SUM_NO_GOOD_INDEX_USED', 27, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Sum of the NO_GOOD_INDEX_USED column in the events_statements_current table.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'FIRST_SEEN', 28, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Time at which the digest was first seen.', 'NEVER', NULL),
	('def', 'performance_schema', 'events_statements_summary_by_digest', 'LAST_SEEN', 29, '\'0000-00-00 00:00:00\'', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', 'Time at which the digest was most recently seen.', 'NEVER', NULL),
	('def', 'performance_schema', 'users', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'The connection\'s client user name for the connection, or NULL if an internal thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'users', 'CURRENT_CONNECTIONS', 2, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Current connections for the user.', 'NEVER', NULL),
	('def', 'performance_schema', 'users', 'TOTAL_CONNECTIONS', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Total connections for the user.', 'NEVER', NULL),
	('def', 'performance_schema', 'accounts', 'USER', 1, 'NULL', 'YES', 'char', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(128)', '', '', 'select,insert,update,references', 'The connection\'s client user name for the connection, or NULL if an internal thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'accounts', 'HOST', 2, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'The connection client\'s host name, or NULL if an internal thread.', 'NEVER', NULL),
	('def', 'performance_schema', 'accounts', 'CURRENT_CONNECTIONS', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Current connections for the account.', 'NEVER', NULL),
	('def', 'performance_schema', 'accounts', 'TOTAL_CONNECTIONS', 4, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Total connections for the account.', 'NEVER', NULL),
	('def', 'performance_schema', 'hosts', 'HOST', 1, 'NULL', 'YES', 'char', 60, 180, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'char(60)', '', '', 'select,insert,update,references', 'Host name used by the client to connect, NULL for internal threads or user sessions that failed to authenticate.', 'NEVER', NULL),
	('def', 'performance_schema', 'hosts', 'CURRENT_CONNECTIONS', 2, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Current number of the host\'s connections.', 'NEVER', NULL),
	('def', 'performance_schema', 'hosts', 'TOTAL_CONNECTIONS', 3, NULL, 'NO', 'bigint', NULL, NULL, 19, 0, NULL, NULL, NULL, 'bigint(20)', '', '', 'select,insert,update,references', 'Total number of the host\'s connections', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'NAME from the setup_instruments table, and the name of the wait/io/socket/* instrument that produced the event.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Memory address of the object.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'THREAD_ID', 3, 'NULL', 'YES', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Thread identifier that the server assigns to each socket.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'SOCKET_ID', 4, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'The socket\'s internal file handle.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'IP', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(64)', '', '', 'select,insert,update,references', 'Client IP address. Blank for Unix socket file, otherwise an IPv4 or IPv6 address. Together with the PORT identifies the connection.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'PORT', 6, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'TCP/IP port number, from 0 to 65535. Together with the IP identifies the connection.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_instances', 'STATE', 7, NULL, 'NO', 'enum', 6, 18, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'enum(\'IDLE\',\'ACTIVE\')', '', '', 'select,insert,update,references', 'Socket status, either IDLE if waiting to receive a request from a client, or ACTIVE', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Socket instrument.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'OBJECT_INSTANCE_BEGIN', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Address in memory.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'COUNT_STAR', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MIN_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'AVG_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MAX_TIMER_WAIT', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'COUNT_READ', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, including RECV, RECVFROM, and RECVMSG.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_TIMER_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MIN_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'AVG_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MAX_TIMER_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_NUMBER_OF_BYTES_READ', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Bytes read by read operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'COUNT_WRITE', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, including SEND, SENDTO, and SENDMSG.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_TIMER_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MIN_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'AVG_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MAX_TIMER_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_NUMBER_OF_BYTES_WRITE', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Bytes written by write operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'COUNT_MISC', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all miscellaneous operations not counted above, including CONNECT, LISTEN, ACCEPT, CLOSE, and SHUTDOWN.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'SUM_TIMER_MISC', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MIN_TIMER_MISC', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'AVG_TIMER_MISC', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_instance', 'MAX_TIMER_MISC', 24, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'EVENT_NAME', 1, NULL, 'NO', 'varchar', 128, 384, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', 'Socket instrument.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'COUNT_STAR', 2, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of summarized events', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_TIMER_WAIT', 3, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MIN_TIMER_WAIT', 4, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'AVG_TIMER_WAIT', 5, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MAX_TIMER_WAIT', 6, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of the summarized events that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'COUNT_READ', 7, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all read operations, including RECV, RECVFROM, and RECVMSG.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_TIMER_READ', 8, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MIN_TIMER_READ', 9, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'AVG_TIMER_READ', 10, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MAX_TIMER_READ', 11, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all read operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_NUMBER_OF_BYTES_READ', 12, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Bytes read by read operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'COUNT_WRITE', 13, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all write operations, including SEND, SENDTO, and SENDMSG.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_TIMER_WRITE', 14, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MIN_TIMER_WRITE', 15, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'AVG_TIMER_WRITE', 16, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MAX_TIMER_WRITE', 17, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all write operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_NUMBER_OF_BYTES_WRITE', 18, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Bytes written by write operations.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'COUNT_MISC', 19, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Number of all miscellaneous operations not counted above, including CONNECT, LISTEN, ACCEPT, CLOSE, and SHUTDOWN.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'SUM_TIMER_MISC', 20, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Total wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MIN_TIMER_MISC', 21, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Minimum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'AVG_TIMER_MISC', 22, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Average wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'socket_summary_by_event_name', 'MAX_TIMER_MISC', 23, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', '', '', 'select,insert,update,references', 'Maximum wait time of all miscellaneous operations that are timed.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_connect_attrs', 'PROCESSLIST_ID', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Session connection identifier.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_connect_attrs', 'ATTR_NAME', 2, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(32)', '', '', 'select,insert,update,references', 'Attribute name.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_connect_attrs', 'ATTR_VALUE', 3, 'NULL', 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(1024)', '', '', 'select,insert,update,references', 'Attribute value.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_connect_attrs', 'ORDINAL_POSITION', 4, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Order in which attribute was added to the connection attributes.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_account_connect_attrs', 'PROCESSLIST_ID', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Session connection identifier.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_account_connect_attrs', 'ATTR_NAME', 2, NULL, 'NO', 'varchar', 32, 96, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(32)', '', '', 'select,insert,update,references', 'Attribute name.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_account_connect_attrs', 'ATTR_VALUE', 3, 'NULL', 'YES', 'varchar', 1024, 3072, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(1024)', '', '', 'select,insert,update,references', 'Attribute value.', 'NEVER', NULL),
	('def', 'performance_schema', 'session_account_connect_attrs', 'ORDINAL_POSITION', 4, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', '', '', 'select,insert,update,references', 'Order in which attribute was added to the connection attributes.', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__bookmark', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__bookmark', 'dbase', 2, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__bookmark', 'user', 3, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__bookmark', 'label', 4, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__bookmark', 'query', 5, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'db_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_type', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_length', 4, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_collation', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_isNull', 6, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_extra', 7, '\'\'', 'YES', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__central_columns', 'col_default', 8, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'db_name', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'table_name', 3, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'column_name', 4, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'comment', 5, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'mimetype', 6, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'transformation', 7, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'transformation_options', 8, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'input_transformation', 9, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__column_info', 'input_transformation_options', 10, '\'\'', 'NO', 'varchar', 255, 765, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(255)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__designer_settings', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__designer_settings', 'settings_data', 2, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__export_templates', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__export_templates', 'username', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__export_templates', 'export_type', 3, NULL, 'NO', 'varchar', 10, 30, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__export_templates', 'template_name', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__export_templates', 'template_data', 5, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__favorite', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__favorite', 'tables', 2, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'id', 1, NULL, 'NO', 'bigint', NULL, NULL, 20, 0, NULL, NULL, NULL, 'bigint(20) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'username', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'db', 3, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'table', 4, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'timevalue', 5, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__history', 'sqlquery', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__navigationhiding', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__navigationhiding', 'item_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__navigationhiding', 'item_type', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__navigationhiding', 'db_name', 4, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__navigationhiding', 'table_name', 5, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__pdf_pages', 'db_name', 1, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__pdf_pages', 'page_nr', 2, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__pdf_pages', 'page_descr', 3, '\'\'', 'NO', 'varchar', 50, 150, NULL, NULL, NULL, 'utf8', 'utf8_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__recent', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__recent', 'tables', 2, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'master_db', 1, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'master_table', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'master_field', 3, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'foreign_db', 4, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'foreign_table', 5, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__relation', 'foreign_field', 6, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__savedsearches', 'id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__savedsearches', 'username', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__savedsearches', 'db_name', 3, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__savedsearches', 'search_name', 4, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__savedsearches', 'search_data', 5, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_coords', 'db_name', 1, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_coords', 'table_name', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_coords', 'pdf_page_number', 3, '0', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_coords', 'x', 4, '0', 'NO', 'float', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'float unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_coords', 'y', 5, '0', 'NO', 'float', NULL, NULL, 12, NULL, NULL, NULL, NULL, 'float unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_info', 'db_name', 1, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_info', 'table_name', 2, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_info', 'display_field', 3, '\'\'', 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_uiprefs', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_uiprefs', 'db_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_uiprefs', 'table_name', 3, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_uiprefs', 'prefs', 4, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__table_uiprefs', 'last_update', 5, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'db_name', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'table_name', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'version', 3, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(10) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'date_created', 4, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'date_updated', 5, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'schema_snapshot', 6, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'schema_sql', 7, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'data_sql', 8, 'NULL', 'YES', 'longtext', 4294967295, 4294967295, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'longtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'tracking', 9, 'NULL', 'YES', 'set', 188, 564, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'set(\'UPDATE\',\'REPLACE\',\'INSERT\',\'DELETE\',\'TRUNCATE\',\'CREATE DATABASE\',\'ALTER DATABASE\',\'DROP DATABASE\',\'CREATE TABLE\',\'ALTER TABLE\',\'RENAME TABLE\',\'DROP TABLE\',\'CREATE INDEX\',\'DROP INDEX\',\'CREATE VIEW\',\'ALTER VIEW\',\'DROP VIEW\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__tracking', 'tracking_active', 10, '1', 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(1) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__userconfig', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__userconfig', 'timevalue', 2, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__userconfig', 'config_data', 3, NULL, 'NO', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__usergroups', 'usergroup', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__usergroups', 'tab', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__usergroups', 'allowed', 3, '\'N\'', 'NO', 'enum', 1, 3, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'enum(\'Y\',\'N\')', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__users', 'username', 1, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'phpmyadmin', 'pma__users', 'usergroup', 2, NULL, 'NO', 'varchar', 64, 192, NULL, NULL, NULL, 'utf8', 'utf8_bin', 'varchar(64)', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor', 'actor_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor', 'first_name', 2, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor', 'last_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor_info', 'actor_id', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor_info', 'first_name', 2, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor_info', 'last_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'actor_info', 'film_info', 4, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'address_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'address', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'address2', 3, 'NULL', 'YES', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'district', 4, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'city_id', 5, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'postal_code', 6, 'NULL', 'YES', 'varchar', 10, 40, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'phone', 7, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'address', 'last_update', 8, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'category', 'category_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'category', 'name', 2, NULL, 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'category', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'city', 'city_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'city', 'city', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'city', 'country_id', 3, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'city', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'country', 'country_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'country', 'country', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'country', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'customer_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'store_id', 2, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'first_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'last_name', 4, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'email', 5, 'NULL', 'YES', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'address_id', 6, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'active', 7, '1', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'create_date', 8, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer', 'last_update', 9, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'ID', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'name', 2, '\'\'', 'NO', 'varchar', 91, 364, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(91)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'address', 3, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'zip code', 4, 'NULL', 'YES', 'varchar', 10, 40, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'phone', 5, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'city', 6, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'country', 7, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'notes', 8, '\'\'', 'NO', 'varchar', 6, 24, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(6)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'customer_list', 'SID', 9, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'title', 2, NULL, 'NO', 'varchar', 128, 512, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(128)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'release_year', 4, 'NULL', 'YES', 'year', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'year(4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'language_id', 5, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'original_language_id', 6, 'NULL', 'YES', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'rental_duration', 7, '3', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'rental_rate', 8, '4.99', 'NO', 'decimal', NULL, NULL, 4, 2, NULL, NULL, NULL, 'decimal(4,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'length', 9, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'replacement_cost', 10, '19.99', 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'rating', 11, '\'G\'', 'YES', 'enum', 5, 20, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'enum(\'G\',\'PG\',\'PG-13\',\'R\',\'NC-17\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'special_features', 12, 'NULL', 'YES', 'set', 54, 216, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'set(\'Trailers\',\'Commentaries\',\'Deleted Scenes\',\'Behind the Scenes\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film', 'last_update', 13, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_actor', 'actor_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_actor', 'film_id', 2, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_actor', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_category', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_category', 'category_id', 2, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_category', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'FID', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'title', 2, NULL, 'NO', 'varchar', 128, 512, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'category', 4, NULL, 'YES', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'price', 5, '4.99', 'NO', 'decimal', NULL, NULL, 4, 2, NULL, NULL, NULL, 'decimal(4,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'length', 6, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'rating', 7, '\'G\'', 'YES', 'enum', 5, 20, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'enum(\'G\',\'PG\',\'PG-13\',\'R\',\'NC-17\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_list', 'actors', 8, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_text', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_text', 'title', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'film_text', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'inventory', 'inventory_id', 1, NULL, 'NO', 'mediumint', NULL, NULL, 8, 0, NULL, NULL, NULL, 'mediumint(8) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'inventory', 'film_id', 2, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'inventory', 'store_id', 3, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'inventory', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'language', 'language_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'language', 'name', 2, NULL, 'NO', 'char', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'char(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'language', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'FID', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'title', 2, NULL, 'NO', 'varchar', 128, 512, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'category', 4, NULL, 'YES', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'price', 5, '4.99', 'NO', 'decimal', NULL, NULL, 4, 2, NULL, NULL, NULL, 'decimal(4,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'length', 6, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'rating', 7, '\'G\'', 'YES', 'enum', 5, 20, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'enum(\'G\',\'PG\',\'PG-13\',\'R\',\'NC-17\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'nicer_but_slower_film_list', 'actors', 8, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'payment_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'customer_id', 2, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'staff_id', 3, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'rental_id', 4, 'NULL', 'YES', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'amount', 5, NULL, 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'payment_date', 6, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'payment', 'last_update', 7, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'rental_id', 1, NULL, 'NO', 'int', NULL, NULL, 10, 0, NULL, NULL, NULL, 'int(11)', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'rental_date', 2, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'inventory_id', 3, NULL, 'NO', 'mediumint', NULL, NULL, 8, 0, NULL, NULL, NULL, 'mediumint(8) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'customer_id', 4, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'return_date', 5, 'NULL', 'YES', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'staff_id', 6, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'rental', 'last_update', 7, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'sales_by_film_category', 'category', 1, NULL, 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'sales_by_film_category', 'total_sales', 2, 'NULL', 'YES', 'decimal', NULL, NULL, 27, 2, NULL, NULL, NULL, 'decimal(27,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'sales_by_store', 'store', 1, '\'\'', 'NO', 'varchar', 101, 404, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(101)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'sales_by_store', 'manager', 2, '\'\'', 'NO', 'varchar', 91, 364, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(91)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'sales_by_store', 'total_sales', 3, 'NULL', 'YES', 'decimal', NULL, NULL, 27, 2, NULL, NULL, NULL, 'decimal(27,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'staff_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'first_name', 2, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'last_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'address_id', 4, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'picture', 5, 'NULL', 'YES', 'blob', 65535, 65535, NULL, NULL, NULL, NULL, NULL, 'blob', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'email', 6, 'NULL', 'YES', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'store_id', 7, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'active', 8, '1', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'username', 9, NULL, 'NO', 'varchar', 16, 64, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(16)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'password', 10, 'NULL', 'YES', 'varchar', 40, 160, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_bin', 'varchar(40)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff', 'last_update', 11, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'ID', 1, '0', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'name', 2, '\'\'', 'NO', 'varchar', 91, 364, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(91)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'address', 3, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'zip code', 4, 'NULL', 'YES', 'varchar', 10, 40, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'phone', 5, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'city', 6, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'country', 7, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'staff_list', 'SID', 8, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'store', 'store_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'store', 'manager_staff_id', 2, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'UNI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'store', 'address_id', 3, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'raivis', 'store', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor', 'actor_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor', 'first_name', 2, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor', 'last_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor_info', 'actor_id', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor_info', 'first_name', 2, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor_info', 'last_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'actor_info', 'film_info', 4, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'address_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'address', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'address2', 3, 'NULL', 'YES', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'district', 4, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'city_id', 5, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'postal_code', 6, 'NULL', 'YES', 'varchar', 10, 40, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'phone', 7, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'address', 'last_update', 8, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'category', 'category_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'category', 'name', 2, NULL, 'NO', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'category', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'city', 'city_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'city', 'city', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'city', 'country_id', 3, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'city', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'country', 'country_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'country', 'country', 2, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'country', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'customer_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'store_id', 2, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'first_name', 3, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'last_name', 4, NULL, 'NO', 'varchar', 45, 180, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(45)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'email', 5, 'NULL', 'YES', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'address_id', 6, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'active', 7, '1', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(1)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'create_date', 8, NULL, 'NO', 'datetime', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'datetime', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer', 'last_update', 9, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'ID', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'name', 2, '\'\'', 'NO', 'varchar', 91, 364, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(91)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'address', 3, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'zip code', 4, 'NULL', 'YES', 'varchar', 10, 40, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(10)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'phone', 5, NULL, 'NO', 'varchar', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'city', 6, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'country', 7, NULL, 'NO', 'varchar', 50, 200, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(50)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'notes', 8, '\'\'', 'NO', 'varchar', 6, 24, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(6)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'customer_list', 'SID', 9, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'title', 2, NULL, 'NO', 'varchar', 128, 512, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(128)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'release_year', 4, 'NULL', 'YES', 'year', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'year(4)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'language_id', 5, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'original_language_id', 6, 'NULL', 'YES', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'rental_duration', 7, '3', 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'rental_rate', 8, '4.99', 'NO', 'decimal', NULL, NULL, 4, 2, NULL, NULL, NULL, 'decimal(4,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'length', 9, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'replacement_cost', 10, '19.99', 'NO', 'decimal', NULL, NULL, 5, 2, NULL, NULL, NULL, 'decimal(5,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'rating', 11, '\'G\'', 'YES', 'enum', 5, 20, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'enum(\'G\',\'PG\',\'PG-13\',\'R\',\'NC-17\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'special_features', 12, 'NULL', 'YES', 'set', 54, 216, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'set(\'Trailers\',\'Commentaries\',\'Deleted Scenes\',\'Behind the Scenes\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film', 'last_update', 13, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_actor', 'actor_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_actor', 'film_id', 2, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_actor', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_category', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_category', 'category_id', 2, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_category', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'FID', 1, '0', 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'title', 2, NULL, 'NO', 'varchar', 128, 512, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(128)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'category', 4, NULL, 'YES', 'varchar', 25, 100, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(25)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'price', 5, '4.99', 'NO', 'decimal', NULL, NULL, 4, 2, NULL, NULL, NULL, 'decimal(4,2)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'length', 6, 'NULL', 'YES', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'rating', 7, '\'G\'', 'YES', 'enum', 5, 20, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'enum(\'G\',\'PG\',\'PG-13\',\'R\',\'NC-17\')', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_list', 'actors', 8, 'NULL', 'YES', 'mediumtext', 16777215, 16777215, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'mediumtext', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_text', 'film_id', 1, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'PRI', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_text', 'title', 2, NULL, 'NO', 'varchar', 255, 1020, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'varchar(255)', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'film_text', 'description', 3, 'NULL', 'YES', 'text', 65535, 65535, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'text', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'inventory', 'inventory_id', 1, NULL, 'NO', 'mediumint', NULL, NULL, 8, 0, NULL, NULL, NULL, 'mediumint(8) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'inventory', 'film_id', 2, NULL, 'NO', 'smallint', NULL, NULL, 5, 0, NULL, NULL, NULL, 'smallint(5) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'inventory', 'store_id', 3, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'MUL', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'inventory', 'last_update', 4, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'on update current_timestamp()', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'language', 'language_id', 1, NULL, 'NO', 'tinyint', NULL, NULL, 3, 0, NULL, NULL, NULL, 'tinyint(3) unsigned', 'PRI', 'auto_increment', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'language', 'name', 2, NULL, 'NO', 'char', 20, 80, NULL, NULL, NULL, 'utf8mb4', 'utf8mb4_general_ci', 'char(20)', '', '', 'select,insert,update,references', '', 'NEVER', NULL),
	('def', 'sakila', 'language', 'last_update', 3, 'current_timestamp()', 'NO', 'timestamp', NULL, NULL, NULL, NULL, 0, NULL, NULL, 'timestamp', '', 'o