-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.8.0.6908
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for gramatas
CREATE DATABASE IF NOT EXISTS `gramatas` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `gramatas`;

-- Dumping structure for table gramatas.books
CREATE TABLE IF NOT EXISTS `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `genre` varchar(100) DEFAULT NULL,
  `publication_year` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `cover_image_path` varchar(255) DEFAULT NULL,
  `audiobook_path` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table gramatas.books: ~1 rows (approximately)
DELETE FROM `books`;
INSERT INTO `books` (`id`, `title`, `author`, `genre`, `publication_year`, `description`, `cover_image_path`, `audiobook_path`, `created_at`) VALUES
	(7, 'asd2', 'asdasd', NULL, NULL, 'asdsad', 'Screenshot (1).png', '6.mp3', '2024-12-18 19:10:02');

-- Dumping structure for procedure gramatas.GetUserById
DELIMITER //
CREATE PROCEDURE `GetUserById`(
	IN `userId` INT
)
BEGIN
    SELECT email, is_editor 
    FROM users
    WHERE id = userId;
END//
DELIMITER ;

-- Dumping structure for procedure gramatas.get_all_books
DELIMITER //
CREATE PROCEDURE `get_all_books`()
BEGIN
    SELECT id, title, author, genre, publication_year, cover_image_path, audiobook_path, description 
  FROM books;
END//
DELIMITER ;

-- Dumping structure for procedure gramatas.get_book_by_id
DELIMITER //
CREATE PROCEDURE `get_book_by_id`(IN book_id INT)
BEGIN
  SELECT id, title, author, genre, publication_year, cover_image_path, audiobook_path, description 
  FROM books 
  WHERE id = book_id;
END//
DELIMITER ;

-- Dumping structure for table gramatas.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Lietotāja id',
  `email` varchar(20) NOT NULL COMMENT 'Lietotāja E-pasts',
  `parole` varchar(20) NOT NULL COMMENT 'Lietotāja parole',
  `is_editor` tinyint(1) DEFAULT 0 COMMENT 'Redaktors',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci;

-- Dumping data for table gramatas.users: ~9 rows (approximately)
DELETE FROM `users`;
INSERT INTO `users` (`id`, `email`, `parole`, `is_editor`) VALUES
	(61, '1@gmail.com', '$2y$10$P2Pi7CtO.8d1i', 0),
	(62, '2@gmail.com', '1', 0),
	(64, 'kuna@gmail.com', '1', 0),
	(65, '3@gmail.com', '1', 0),
	(66, '4@gmail.com', '5', 0),
	(67, 'R@P', '12345678', 0),
	(68, '6@gmail.com', 'asdasdasdasdĀ', 1),
	(69, '7@gmail.com', '7Ā77777777', 0),
	(70, 'rinaldspoliters@gmai', 'kys123456', 0);

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
