<?php
include "php/conn.php";

function getBookById($conn, $id) {
    $stmt = mysqli_prepare($conn, "CALL get_book_by_id(?)"); 
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
  
    if ($result && mysqli_num_rows($result) > 0) {
      return mysqli_fetch_assoc($result);
    } else {
      return null;
    }
  }

if (isset($_GET['id'])) {
  $id = mysqli_real_escape_string($conn, $_GET['id']);
  $book = getBookById($conn, $id);

  if ($book) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <script src="js/script.js" defer></script>
    <script src="js/pogas.js" defer></script>
    <title>Grāmatas informācija - <?php echo $row['title']; ?></title>
</head>
<body class="bg-gray-100">
    <?php include "php/header.php"; ?>

    <section class="container mx-auto mt-8 px-6">
        <div class="flex flex-col md:flex-row items-center md:items-start bg-white rounded-lg shadow-lg p-6">
            <div class="md:w-1/3 mb-6 md:mb-0">
                <img src="php/uploads/<?php echo $book['cover_image_path']; ?>" class="w-full h-auto rounded-lg shadow-md" alt="Book Cover">
            </div>

            <div class="md:w-2/3 md:pl-8">
                <h1 class="text-3xl font-bold text-gray-900 mb-3"><?php echo $book['title']; ?></h1>
                <p class="text-lg text-gray-700 mb-2"><strong>Autors:</strong> <?php echo $book['author']; ?></p>
                <p class="text-lg text-gray-700 mb-2"><strong>Žanrs:</strong> <?php echo $book['genre']; ?></p>
                <p class="text-lg text-gray-700 mb-2"><strong>Izlaišanas gads:</strong> <?php echo $book['publication_year']; ?></p>

                <div class="text-lg text-gray-700 mb-4">
                    <strong>Description:</strong>
                    <p><?php echo nl2br($book['description']); ?></p>
                </div>

                <div class="mt-4">
                    <audio controls class="w-full bg-gray-200 p-4 rounded-lg">
                        <source src="php/uploads/<?php echo $book['audiobook_path']; ?>" type="audio/mpeg">
                        Jūsu pārlūkprogramma neatbalsta audio elementu.
                    </audio>
                </div>
            </div>
        </div>
    </section>

    <?php include "footer.html"; ?>

</body>
</html>
<?php
  } else {
    echo "<p class='text-center text-red-500'>Kļūda: Grāmata ar šādu ID nav atrasta.</p>";
  }
} else {
  echo "<p class='text-center text-red-500'>Kļūda: Nav grāmatas ID.</p>";
}

mysqli_close($conn);
?>