<?php
include 'conn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['reg-username'];
    $password1 = $_POST['password1'];
    $password2 = $_POST['password2'];

    // Check if any field is empty
    if (empty($username) || empty($password1) || empty($password2)) {
        $error_message = "Both username and password are required.";
    } elseif ($password1 !== $password2) {
        // Check if passwords match
        $error_message = "Paroles nesakrīt.";
    } else {
        // Proceed with registration
        $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $error_message = "Jūsu ievadītais e-pasts jau eksistē!";
        } else {
            $stmt = $conn->prepare("INSERT INTO users (email, parole) VALUES (?, ?)");
            $stmt->bind_param("ss", $username, $password1);

            if ($stmt->execute()) {
                $user_id = $stmt->insert_id; // Get the inserted user's ID
                $response = array(
                    'success' => true,
                    'user_id' => $user_id, // Include user_id in response
                    'message' => 'Reģistrācija veiksmīga!'
                );
            } else {
                $error_message = "Kaut kas nogāja greizi...";
            }
        }
        $stmt->close();
    }

    // Prepare the response
    if (!empty($error_message)) {
        $response = array(
            'success' => false,
            'message' => $error_message
        );
    }

    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
