<?php
session_start();
include 'conn.php';

// Default response structure
$response = [
    'success' => false,
    'message' => 'An unknown error occurred.',
    'user_id' => null,
];

try {
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $entered_email = $_POST['username'] ?? '';
        $entered_password = $_POST['password'] ?? '';

        // Check for empty fields
        if (empty($entered_email) || empty($entered_password)) {
            throw new Exception("Jāievada gan lietotājs, gan parole.");
        }

        // Prepare the SQL statement
        $stmt = $conn->prepare("SELECT id, parole FROMusers WHERE email = ?");
        $stmt->bind_param("s", $entered_email);
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if user exists
        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();

            // Verify password
            if ($entered_password === (string) $user['parole']) {
                $_SESSION['logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];

                // Redirect upon successful login
                header("Location: ../index.php");
                exit;
            } else {
                throw new Exception("Jūsu ievadītais lietotājs un/vai parole neeksistē!");
            }
        } else {
            throw new Exception("Jūsu ievadītais lietotājs un/vai parole neeksistē!");
        }

        $stmt->close();
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
}

// Close database connection
$conn->close();

// Output JSON response for failed login
if (!$response['success']) {
    header('Content-Type: application/json');
    echo json_encode($response);
}
?>
