<?php
// Check if a session is not already active
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include database connection
include 'php/conn.php';

// Initialize user's email and editor status variables
$userEmail = '';
$isEditor = false;  // Default to false, will be updated based on the DB query

// Check if user is logged in
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in']) {
    // Fetch user's email and editor status from the database
    $userId = $_SESSION['user_id'];
    $query = "SELECT email, is_editor FROM users WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $stmt->bind_result($userEmail, $isEditor); // Fetch both email and editor status
    $stmt->fetch();
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="author" content="Rainers Purins">
    <meta name="created" content="20.02.2024">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grāmatu Saraksts</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-800">
<header class="bg-white shadow-md py-4">
    <div class="container mx-auto px-4 flex justify-between items-center">
        <h1 class="text-2xl font-bold text-gray-900">Grāmatu Saraksts</h1>
        <div class="relative">
            <!-- Burger menu button -->
            <button 
                class="flex flex-col items-center space-y-1 px-4 py-2 bg-gray-200 rounded hover:bg-gray-300 focus:outline-none focus:ring focus:ring-gray-400" 
                id="menu"
                aria-label="Toggle Menu">
                <span class="w-6 h-1 bg-gray-800"></span>
                <span class="w-6 h-1 bg-gray-800"></span>
                <span class="w-6 h-1 bg-gray-800"></span>
            </button>
            <!-- Dropdown menu -->
            <div 
                id="dropdownContent" 
                class="absolute right-0 mt-2 w-48 bg-white shadow-lg rounded-md hidden">
                <?php if (isset($_SESSION['logged_in']) && $_SESSION['logged_in']): ?>
                    <div class="px-4 py-2">
                        <p class="text-sm text-gray-600"><b>Profils:</b> (<?php echo htmlspecialchars($userEmail); ?>)</p>
                        <!-- Show "Redaktora Panelis" only if the user is an editor -->
                        <?php if ($isEditor): ?>
                            <button class="block w-full text-left px-4 py-2 mt-2 text-sm bg-blue-500 text-white rounded hover:bg-blue-600" id="redaktorsPanelis">⤷ Redaktora Panelis</button>
                        <?php endif; ?>
                        <button class="block w-full text-left px-4 py-2 mt-2 text-sm bg-red-500 text-white rounded hover:bg-red-600" id="iziet">⤷ Iziet</button>
                    </div>
                <?php else: ?>
                    <div class="px-4 py-2">
                        <p class="text-sm text-gray-600"><b>Profils:</b></p>
                        <button class="block w-full text-left px-4 py-2 mt-2 text-sm bg-green-500 text-white rounded hover:bg-green-600" id="ieiet">⤷ Ieiet</button>
                    </div>
                <?php endif; ?>
                <div class="px-4 py-2 border-t">
                    <button class="block w-full text-left px-4 py-2 text-sm bg-gray-200 rounded hover:bg-gray-300" id="sakums">⤷ Sākums</button>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
    // Dropdown Toggle Logic
    document.getElementById('menu').addEventListener('click', function () {
        const dropdownContent = document.getElementById('dropdownContent');
        dropdownContent.classList.toggle('hidden');
    });
</script>
</body>
</html>
