<?php
session_start();
include 'conn.php';

if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bookId = $_POST['bookId'];
    $bookTitle = $_POST['bookTitle'];
    $bookAuthor = $_POST['bookAuthor'];
    $bookGenre = $_POST['bookGenre'];
    $pubYear = $_POST['pubYear'];
    $bookDescription = $_POST['bookDescription'];

    // Optionally handle file uploads and updates here

    // Update the book in the database
    $query = "UPDATE books SET title = ?, author = ?, genre = ?, publication_year = ?, description = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sssssi", $bookTitle, $bookAuthor, $bookGenre, $pubYear, $bookDescription, $bookId);
    $stmt->execute();
    $stmt->close();

    header('Location: ../editor_panel.php');
    exit();
}
?>
