<?php
session_start();
include 'conn.php';

// Check if the user is logged in
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $bookId = $_POST['bookId'];

    // Query to get the current book's data (cover image, audiobook path)
    $query = "SELECT cover_image_path, audiobook_path FROM books WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $bookId);
    $stmt->execute();
    $stmt->bind_result($coverImagePath, $audiobookPath);
    $stmt->fetch();
    $stmt->close();

    // Delete the book from the database
    $deleteQuery = "DELETE FROM books WHERE id = ?";
    $stmt = $conn->prepare($deleteQuery);
    $stmt->bind_param("i", $bookId);
    $stmt->execute();
    $stmt->close();

    // Delete the book's cover image and audiobook if they exist
    if ($coverImagePath && file_exists('uploads/' . $coverImagePath)) {
        unlink('uploads/' . $coverImagePath);
    }

    if ($audiobookPath && file_exists('uploads/' . $audiobookPath)) {
        unlink('uploads/' . $audiobookPath);
    }

    // Redirect back to the book management page
    header('Location: ../editor_panel.php');
    exit();
}
?>
