document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const genreFilter = document.getElementById('genreFilter');
    const yearFilter = document.getElementById('yearFilter');
    const bookItems = document.querySelectorAll('.book-item');

    if (searchInput) {
        searchInput.addEventListener('input', function() {
            filterBooks();
        });
    }

    if (genreFilter) {
        genreFilter.addEventListener('change', function() {
            filterBooks();
        });
    }

    if (yearFilter) {
        yearFilter.addEventListener('change', function() {
            filterBooks();
        });
    }

    function filterBooks() {
        const searchTerm = searchInput.value.toLowerCase();
        const selectedGenre = genreFilter.value.toLowerCase();
        const selectedYear = yearFilter.value;

        bookItems.forEach(function(book) {
            const title = book.getAttribute('data-title');
            const author = book.getAttribute('data-author');
            const genre = book.getAttribute('data-genre');
            const year = book.getAttribute('data-year');

            const matchesSearch = title.includes(searchTerm) || author.includes(searchTerm);
            const matchesGenre = selectedGenre ? genre.includes(selectedGenre) : true;
            const matchesYear = selectedYear ? year == selectedYear : true;

            if (matchesSearch && matchesGenre && matchesYear) {
                book.style.display = '';
            } else {
                book.style.display = 'none';
            }
        });
    }
});