function toggleForm(formType) {
    const loginForm = document.getElementById('login-form');
    const registerForm = document.getElementById('register-form');
    const loginBtn = document.getElementById('login-btn');
    const registerBtn = document.getElementById('register-btn');

    if (formType === 'login') {
        loginForm.classList.remove('hidden');
        registerForm.classList.add('hidden');
        loginBtn.classList.add('border-blue-500');
        registerBtn.classList.remove('border-blue-500');
    } else {
        registerForm.classList.remove('hidden');
        loginForm.classList.add('hidden');
        registerBtn.classList.add('border-blue-500');
        loginBtn.classList.remove('border-blue-500');
    }
}

function togglePasswordVisibility(id) {
    const input = document.getElementById(id);
    const icon = input.nextElementSibling.firstChild;
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

document.getElementById('login-form').addEventListener('submit', function(event) {
    event.preventDefault();
    
    var form = this;
    var formData = new FormData(form);

    fetch(form.action, {
        method: form.method,
        body: formData
    })
    .then(response => {
        // Handle non-JSON responses
        if (response.ok) {
            const contentType = response.headers.get('content-type');
            if (contentType && contentType.includes('application/json')) {
                return response.json();
            } else {
                throw new Error('Unexpected response format');
            }
        } else {
            throw new Error(`Error ${response.status}: ${response.statusText}`);
        }
    })
    .then(data => {
        if (!data.success) {
            document.getElementById('error-message').innerHTML = data.message;
            document.getElementById('error-message').style.display = 'block';
        } else {
            window.location.href = 'index.php';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('error-message').innerHTML = 'Server error. Please try again.';
        document.getElementById('error-message').style.display = 'block';
    });
});


document.getElementById('register-form').addEventListener('submit', function(event) {
    event.preventDefault();
    
    var form = this;
    var formData = new FormData(form);
    
    fetch(form.action, {
        method: form.method,
        body: formData
    })
    .then(response => {
        if (response.ok) {
            return response.json();
        } else {
            return Promise.reject('Error: Unable to register');
        }
    })
    .then(data => {
        if (!data.success) {
			document.getElementById('reg-error-message').innerHTML = data.message;
			document.getElementById('reg-error-message').style.display = 'block';			
        } else {
            window.location.href = 'index.php';
        }
    })
    .catch(error => {
        console.error('Error:', error);
    });
});


