<?php  function getBookById($conn, $id) {
    $stmt = mysqli_prepare($conn, "CALL get_book_by_id(?)"); 
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
  
    if ($result && mysqli_num_rows($result) > 0) {
      return mysqli_fetch_assoc($result);
    } else {
      return null;
    }
  }
  ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <title>Grāmatu Saraksts</title>
  <script src="js/script.js" defer></script>
  <script src="js/pogas.js" defer></script>
  <script src="js/search.js" defer></script>
</head>
<body class="bg-gray-100">
  <?php include "php/header.php"; ?>

  <section class="container mx-auto mt-8 mb-4">
    <div class="flex justify-between mb-4">
      <div class="relative max-w-xs">
        <input 
          type="text" 
          id="searchInput" 
          class="form-control w-full p-3 border rounded-md shadow-sm" 
          placeholder="Meklēt grāmatu">
        <span class="absolute inset-y-0 right-0 flex items-center pr-3">
          <i class="fas fa-search text-gray-500"></i>
        </span>
      </div>
      
      <div class="flex space-x-4">
        <select id="genreFilter" class="form-control w-32 p-3 border rounded-md shadow-sm">
          <option value="" disabled selected hidden>Visi žanri</option>
          <?php
          $genreQuery = "SELECT DISTINCT genre FROM books";
          $genreResult = mysqli_query($conn, $genreQuery);
          if ($genreResult && mysqli_num_rows($genreResult) > 0) {
            while ($genreRow = mysqli_fetch_assoc($genreResult)) {
              echo "<option value='" . $genreRow['genre'] . "'>" . $genreRow['genre'] . "</option>";
            }
          }
          ?>
        </select>

        <select id="yearFilter" class="form-control w-32 p-3 border rounded-md shadow-sm">
          <option value="" disabled selected hidden>Visi gadi</option>
          <?php
          $yearQuery = "SELECT DISTINCT publication_year FROM books ORDER BY publication_year DESC";
          $yearResult = mysqli_query($conn, $yearQuery);
          if ($yearResult && mysqli_num_rows($yearResult) > 0) {
            while ($yearRow = mysqli_fetch_assoc($yearResult)) {
              echo "<option value='" . $yearRow['publication_year'] . "'>" . $yearRow['publication_year'] . "</option>";
            }
          }
          ?>
        </select>
      </div>
    </div>
  </section>

  <section class="container mx-auto mt-8">
    <h1 class="text-4xl font-bold text-center text-gray-800 mb-6">Saraksts</h1>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6" id="bookList">
      <?php
      $booksQuery = "SELECT id FROM books";
      $booksResult = mysqli_query($conn, $booksQuery);

      if ($booksResult && mysqli_num_rows($booksResult) > 0) {
        while ($bookRow = mysqli_fetch_assoc($booksResult)) {
          $bookId = $bookRow['id'];
          $bookData = getBookById($conn, $bookId);

          if ($bookData) {
            ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden flex flex-col sm:flex-row hover:shadow-lg transition-shadow duration-200 book-item" 
              data-title="<?php echo strtolower($bookData['title']); ?>"
              data-author="<?php echo strtolower($bookData['author']); ?>"
              data-genre="<?php echo strtolower($bookData['genre']); ?>"
              data-year="<?php echo $bookData['publication_year']; ?>">
              <div class="w-full sm:w-1/3 h-48 sm:h-auto">
                <img 
                  src="php/uploads/<?php echo $bookData['cover_image_path']; ?>" 
                  alt="Book Cover" 
                  class="w-full h-full object-cover">
              </div>
              <div class="p-4 sm:w-2/3 flex flex-col justify-between">
                <h2 class="text-xl font-bold text-gray-800 truncate card-title"><?php echo $bookData['title']; ?></h2>
                <p class="text-gray-600 mt-2 card-text"><strong>Autors:</strong> <?php echo $bookData['author']; ?></p>
                <p class="text-gray-600"><strong>Žanrs:</strong> <?php echo $bookData['genre']; ?></p>
                <p class="text-gray-600"><strong>Izlaišanas gads:</strong> <?php echo $bookData['publication_year']; ?></p>
                <div class="mt-4 flex flex-col gap-2">
                  <a href="view.php?id=<?php echo $bookId; ?>" 
                     class="inline-block text-center bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                     Vairāk informācijas
                  </a>
                  <audio controls class="w-full mt-2">
                    <source src="php/uploads/<?php echo $bookData['audiobook_path']; ?>" type="audio/mpeg">
                    Jūsu pārlūkprogramma neatbalsta audio elementu.
                  </audio>
                </div>
              </div>
            </div>
            <?php
          }
        }
        mysqli_free_result($booksResult);
      } else {
        echo "<p class='text-center text-gray-700'>No books found.</p>";
      }
      mysqli_close($conn);
      ?>
    </div>
  </section>
  <?php include "footer.html"; ?>
</body>
</html>