<?php
session_start();
include 'php/conn.php';

if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: login.php');
    exit();
}

$userId = $_SESSION['user_id'];
$query = "CALL GetUserById(?)";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $userId);
$stmt->execute();
$stmt->bind_result($userEmail, $isEditor);
$stmt->fetch();
$stmt->close();

function getAllBooks($conn) {
  $stmt = mysqli_prepare($conn, "CALL get_all_books()");
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);

  $books = [];
  if ($result && mysqli_num_rows($result) > 0) {
      while ($book = mysqli_fetch_assoc($result)) {
          $books[] = $book;
      }
  }
  return $books;
}

$books = getAllBooks($conn);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Grāmatu saraksts</title>
  <link rel="stylesheet" href="css/style.css">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet">
  <script src="js/script.js"></script>
  <script src="js/pogas.js"></script>
</head>
<body>
  <?php include "php/header.php"; ?>

  <div class="container mx-auto px-4 py-8">
    <?php if ($isEditor): ?>
      <div class="text-center mb-6">
        <h1 class="text-3xl font-bold">Panelis</h1>
      </div>

      <div id="addBook" class="tab-content">
        <form id="addBookForm" action="php/add_book.php" method="POST" enctype="multipart/form-data" class="space-y-4">
          <div class="flex space-x-4">
            <div class="w-1/2">
              <label for="bookTitle" class="block font-medium">Nosaukums</label>
              <input type="text" id="bookTitle" name="bookTitle" class="w-full p-2 border rounded-md" required>
            </div>
            <div class="w-1/2">
              <label for="bookAuthor" class="block font-medium">Autors</label>
              <input type="text" id="bookAuthor" name="bookAuthor" class="w-full p-2 border rounded-md" required>
            </div>
          </div>

          <div class="flex space-x-4">
            <div class="w-1/2">
              <label for="bookGenre" class="block font-medium">Žanrs</label>
              <select id="bookGenre" name="bookGenre" class="w-full p-2 border rounded-md" required>
                <option value="" disabled selected hidden>Izvēlēties žanru</option>
                <option value="Fiction">Daiļliteratūra</option>
                <option value="Non-fiction">Dokumentālā literatūra</option>
                <option value="Mystery">Mīklas</option>
                <option value="Fantasy">Fantāzija</option>
                <option value="Science Fiction">Zinātniskā fantastika</option>
                <option value="Romance">Romāni</option>
                <option value="Thriller">Trilleri</option>
                <option value="Historical">Vēsturiskā literatūra</option>
                <option value="Biography">Biogrāfija</option>
                <option value="Self-help">Pašpalīdzība</option>
                <option value="Horror">Šausmas</option>
                <option value="Poetry">Dzeja</option>
                <option value="Children's">Bērnu literatūra</option>
              </select>
            </div>
            <div class="w-1/2">
              <label for="pubYear" class="block font-medium">Izlaišanas gads</label>
              <input type="number" id="pubYear" name="pubYear" class="w-full p-2 border rounded-md" min="1450" max="2025" required>
            </div>
          </div>

          <div>
            <label for="bookDescription" class="block font-medium">Grāmatas apraksts</label>
            <textarea id="bookDescription" name="bookDescription" class="w-full p-2 border rounded-md" rows="5" required></textarea>
          </div>

          <div class="flex space-x-4">
            <div class="w-1/2">
              <label for="bookCover" class="block font-medium">Bilde</label>
              <input type="file" id="bookCover" name="bookCover" class="w-full p-2 border rounded-md" accept="image/*" required>
            </div>
            <div class="w-1/2">
              <label for="audioBook" class="block font-medium">Audiogrāmata</label>
              <input type="file" id="audioBook" name="audioBook" class="w-full p-2 border rounded-md" accept="audio/*">
            </div>
          </div>

          <div class="text-center">
            <button type="submit" class="bg-blue-500 text-white px-6 py-2 rounded-md">Pievienot</button>
          </div>
        </form>
      </div>

      <div id="editBook" class="tab-content mt-4">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
          <?php foreach ($books as $book): ?>
            <div class="p-4 bg-white border rounded-lg shadow-lg">
              <img src="php/uploads/<?php echo $book['cover_image_path']; ?>" alt="Book Cover" class="w-full h-48 object-cover rounded-md">
              <h5 class="text-lg font-semibold mt-2"><?php echo htmlspecialchars($book['title']); ?></h5>
              <p class="text-sm text-gray-600">By <?php echo htmlspecialchars($book['author']); ?></p>
              <button onclick="openModal('editModal<?php echo $book['id']; ?>')" class="bg-yellow-500 text-white px-4 py-2 rounded-md mt-3">Rediģēt</button>
            <button onclick="openDeleteModal('deleteModal<?php echo $book['id']; ?>')" class="bg-red-500 text-white px-4 py-2 rounded-md mt-3">Dzēst</button>

            <div id="editModal<?php echo $book['id']; ?>" class="modal hidden fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center">
                <div class="modal-content bg-white p-6 rounded-lg w-full sm:w-3/4 md:w-1/2 lg:w-1/3 relative">
                    <h3 class="font-bold text-xl">Rediģēt grāmatu: <?php echo htmlspecialchars($book['title']); ?></h3>
                    <form action="php/edit_book.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="bookId" value="<?php echo $book['id']; ?>">

                        <label for="bookTitle" class="block mt-4">Nosaukums</label>
                        <input type="text" class="w-full p-2 border rounded-md" name="bookTitle" value="<?php echo htmlspecialchars($book['title']); ?>" required>

                        <label for="bookAuthor" class="block mt-4">Autors</label>
                        <input type="text" class="w-full p-2 border rounded-md" name="bookAuthor" value="<?php echo htmlspecialchars($book['author']); ?>" required>

                        <label for="bookDescription" class="block mt-4">Apraksts</label>
                        <textarea class="w-full p-2 border rounded-md" name="bookDescription"><?php echo htmlspecialchars($book['description']); ?></textarea>

                        <div class="mt-4">
                            <label for="bookCover" class="block">Jaunā bilde (pēc izvēles)</label>
                            <input type="file" name="bookCover" class="w-full p-2 border rounded-md" accept="image/*">
                            <img src="php/uploads/<?php echo $book['cover_image_path']; ?>" alt="Current Cover" class="mt-2 w-32">
                        </div>

                        <div class="mt-4">
                            <label for="audioBook" class="block">Jaunā audiogrāmata (pēc izvēles)</label>
                            <input type="file" name="audioBook" class="w-full p-2 border rounded-md" accept="audio/*">
                            <?php if ($book['audiobook_path']): ?>
                                <p class="mt-2 text-sm text-gray-600">Esošā audiogrāmata: <?php echo htmlspecialchars($book['audiobook_path']); ?></p>
                            <?php endif; ?>
                        </div>

                        <div class="flex justify-end mt-4">
                            <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-md">Saglabāt</button>
                        </div>
                    </form>

                    <button onclick="closeModal('editModal<?php echo $book['id']; ?>')" class="absolute top-4 right-4 text-black text-2xl">
                ×
                    </button>

                </div>
            </div>

            <div id="deleteModal<?php echo $book['id']; ?>" class="modal hidden fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center">
    <div class="modal-content bg-white p-6 rounded-lg w-full sm:w-3/4 md:w-1/2 lg:w-1/3">
        <h3 class="font-bold text-xl text-center text-red-500">Are you sure you want to delete this book?</h3>
        <form action="php/delete_book.php" method="POST" class="mt-4">
            <input type="hidden" name="bookId" value="<?php echo $book['id']; ?>">
            <div class="flex justify-end space-x-4">
                <button type="submit" class="bg-red-500 text-white px-6 py-2 rounded-md">Yes, Delete</button>
                <button type="button" onclick="closeModal('deleteModal<?php echo $book['id']; ?>')" class="bg-gray-500 text-white px-6 py-2 rounded-md">Cancel</button>
            </div>
        </form>
        <button onclick="closeModal('deleteModal<?php echo $book['id']; ?>')" class="absolute top-4 right-4 text-black text-2xl">&times;</button>
    </div>
</div>


        </div>
        <?php endforeach; ?>
      </div>

    <?php else: ?>
      <div class="text-center my-4">
        <h1 class="text-3xl font-bold">Piekļuve Liegta</h1>
        <p>Jums nav atļauju.</p>
      </div>
    <?php endif; ?>
    </div>
</body>
</html>
