-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               10.4.32-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.6.0.6765
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for work-planner
CREATE DATABASE IF NOT EXISTS `work-planner` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */;
USE `work-planner`;

-- Dumping structure for table work-planner.calendars
CREATE TABLE IF NOT EXISTS `calendars` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identifikators',
  `title` varchar(50) DEFAULT NULL COMMENT 'Kalendāra nosaukums (pēc noklusējuma - "{user}''s Calendar"',
  `type` varchar(50) DEFAULT NULL COMMENT 'Kalendāra tips (personālais vai darba)',
  `user_id` int(11) DEFAULT NULL COMMENT 'Lietotāja ID, kam šis kalendārs oriģināli pieder',
  `status` varchar(50) DEFAULT 'default' COMMENT 'Kalendāra status (t.i., vai tas tiks attēlots līdz ko lietotājs būs pieslēdzies sistēmā)',
  `color` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Tabula, kurā tiks saglabāti pamata dati par lietotāju veidotajiem kalendāriem';

-- Dumping data for table work-planner.calendars: ~3 rows (approximately)
INSERT INTO `calendars` (`ID`, `title`, `type`, `user_id`, `status`, `color`) VALUES
	(1, 'test', 'work', 1, 'basic', '#3788d8'),
	(2, 'hello', 'personal', 1, 'basic', '#7bba56'),
	(3, 'Hello World', 'personal', 2, 'basic', '#b9d23e');

-- Dumping structure for table work-planner.shared
CREATE TABLE IF NOT EXISTS `shared` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identifikators',
  `calendar_id` int(11) DEFAULT NULL COMMENT 'Kalendāra ID',
  `owner_id` int(11) DEFAULT NULL COMMENT 'Kalendāra autora ID',
  `user_id` int(11) DEFAULT NULL COMMENT 'Lietotāja ID, kuram dota pieeja kalendāram',
  `rights` varchar(50) DEFAULT '"viewer"' COMMENT 'Lietotājam pieejamās tiesības darbā ar pieejamo kalendāru',
  PRIMARY KEY (`ID`),
  KEY `owner_id` (`owner_id`),
  KEY `calendar` (`calendar_id`),
  KEY `user` (`user_id`),
  CONSTRAINT `calendar` FOREIGN KEY (`calendar_id`) REFERENCES `calendars` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `owner_id` FOREIGN KEY (`owner_id`) REFERENCES `calendars` (`user_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `user` FOREIGN KEY (`user_id`) REFERENCES `users` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Tabula, kurā tiek saglabāta informācija par kalendāriem, kas ir pieejami vairākiem lietotājiem.';

-- Dumping data for table work-planner.shared: ~0 rows (approximately)

-- Dumping structure for table work-planner.tasks
CREATE TABLE IF NOT EXISTS `tasks` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identifikators',
  `title` varchar(50) DEFAULT NULL COMMENT 'Uzdevuma nosaukums',
  `calendar_id` int(11) DEFAULT NULL COMMENT 'Kalendārs, kam uzdevums piesaistīts',
  `work_date` date DEFAULT NULL COMMENT 'Datums, kurā jāizpilda uzdevums',
  `start_time` time DEFAULT NULL COMMENT 'Uzdevuma sākuma laiks',
  `end_time` time DEFAULT NULL COMMENT 'Uzdevuma beigu laiks',
  `type` varchar(50) DEFAULT NULL COMMENT 'Uzdevuma tips (in-person vai online)',
  PRIMARY KEY (`ID`),
  KEY `calendar_id` (`calendar_id`),
  CONSTRAINT `calendar_id` FOREIGN KEY (`calendar_id`) REFERENCES `calendars` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Tabula, kurā tiks saglabāti lietotāju veidotie uzdevumi.';

-- Dumping data for table work-planner.tasks: ~0 rows (approximately)

-- Dumping structure for table work-planner.users
CREATE TABLE IF NOT EXISTS `users` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identifikators',
  `username` varchar(50) DEFAULT NULL COMMENT 'Lietotāja lietotājvārds',
  `passw` varchar(50) DEFAULT NULL COMMENT 'Lietotāja parole',
  `email` varchar(50) DEFAULT NULL COMMENT 'Lietotāja e-pasts',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Tabula, kurā tiek saglabāti lietotāja konta dati';

-- Dumping data for table work-planner.users: ~2 rows (approximately)
INSERT INTO `users` (`ID`, `username`, `passw`, `email`) VALUES
	(1, 'testing', 'hubaBUBA', 'hellow@inbox.lv'),
	(2, 'hellow', 'hubaBUBA1', 'worldhate@inbox.lv');

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
