<?php
include 'db_conn.php';	// Tiek iekļauts datu bāzes savienojuma fails
header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
	case 'GET':		// Šajā sadaļā tiek iegūti kalendāra darbi
		if (!isset($_GET['calendar_id'])) {
			http_response_code(400);
			echo json_encode(['error' => 'calendar_id is required']);
			exit;
		}
		$calendar_id = intval($_GET['calendar_id']);
		$stmt = $conn->prepare("SELECT * FROM tasks WHERE calendar_id = ?");
		$stmt->bind_param("i", $calendar_id);
		$stmt->execute();
		$result = $stmt->get_result();
		$tasks = [];
		while ($row = $result->fetch_assoc()) {
			$tasks[] = $row;
		}
		echo json_encode($tasks);
		break;

	case 'POST':		// Šajā sadaļā tiek apstrādāti iegūti darbu moduļa datis
		$data = json_decode(file_get_contents("php://input"), true);
		$id = isset($data['id']) ? intval($data['id']) : 0;
		$title = $data['title'] ?? '';
		$work_date = $data['work_date'] ?? '';
		$start_time = $data['start_time'] ?? '';
		$end_time = $data['end_time'] ?? '';
		$type = $data['type'] ?? '';
		$calendar_id = intval($data['calendar_id'] ?? 0);

		if ($id > 0) {
			// Ja JS sniedz darba ID, tad šis darbs tiek atjaunināts datu bāzē
			$stmt = $conn->prepare("UPDATE tasks SET title = ?, work_date = ?, start_time = ?, end_time = ?, type = ?, calendar_id = ? WHERE id = ?");
			$stmt->bind_param("ssssssi", $title, $work_date, $start_time, $end_time, $type, $calendar_id, $id);
		} else {
			// Citādi tiek pievienots jauns darbs datu bāzes tabulā
			$stmt = $conn->prepare("INSERT INTO tasks (title, work_date, start_time, end_time, type, calendar_id) VALUES (?, ?, ?, ?, ?, ?)");
			$stmt->bind_param("sssssi", $title, $work_date, $start_time, $end_time, $type, $calendar_id);
		}

		if ($stmt->execute()) {
			echo json_encode(['success' => true]);
		} else {
			http_response_code(500);
			echo json_encode(['error' => $stmt->error]);
		}
		break;

		case 'DELETE':		// Šajā sadaļā tiek apstrādāta darbu dzēšana
			$data = json_decode(file_get_contents("php://input"), true);
			$id = intval($data['id'] ?? 0);
			if (!$id) {
				http_response_code(400);
				echo json_encode(['error' => 'Missing task ID']);
				exit;
			}
			$stmt = $conn->prepare("DELETE FROM tasks WHERE id = ?");
			$stmt->bind_param("i", $id);
			if ($stmt->execute()) {
				echo json_encode(['success' => true]);
			} else {
				http_response_code(500);
				echo json_encode(['error' => $stmt->error]);
			}
			break;

		default:
			http_response_code(405);
			echo json_encode(['error' => 'Method Not Allowed']);
			break;
}

$conn->close();
?>
