<?php
header('Content-Type: application/json');
include 'db_conn.php';		// Tiek iekļauts datu bāzes savienojuma fails

$method = $_SERVER['REQUEST_METHOD'];

// Šajā sadaļa tiek iegūti lietotājam piederošie kalendāri
if ($method === 'GET' && isset($_GET['user_id'])) {
    $userId = intval($_GET['user_id']);

    $stmt = $conn->prepare("SELECT * FROM calendars WHERE user_id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        echo json_encode($result->fetch_all(MYSQLI_ASSOC));
    } else {
        echo json_encode(['error' => 'Failed to prepare statement']);
    }
}

// Šajā sadaļa tiek pievienots jauns kalendārs datu bāzes tabulā
elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $title = isset($input['title']) ? trim($input['title']) : '';
    $type = isset($input['type']) ? trim($input['type']) : '';
    $color = isset($input['color']) ? trim($input['color']) : '';
    $userId = isset($input['user_id']) ? intval($input['user_id']) : 0;
    $status = 'basic';

    if (!$title || !$type || !$color || !$userId) {
        echo json_encode(['error' => 'Missing required fields']);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO calendars (title, type, color, user_id, status) VALUES (?, ?, ?, ?, ?)");
    if ($stmt) {
        $stmt->bind_param("sssds", $title, $type, $color, $userId, $status);
        $stmt->execute();

        $newId = $conn->insert_id;
        $stmt = $conn->prepare("SELECT * FROM calendars WHERE id = ?");
        $stmt->bind_param("i", $newId);
        $stmt->execute();
        $result = $stmt->get_result();
        echo json_encode($result->fetch_assoc());
    } else {
        echo json_encode(['error' => 'Failed to insert calendar']);
    }
}

$conn->close();
?>

